/****************************************
*  Computer Algebra System SINGULAR     *
****************************************/

// syntax table for Singular
//
// - search for an exact match of the argument types
// - otherwise search for the first possibility
//   with converted types of the arguments
// - otherwise report an error
//
// operation: ++ (identifier)  ->  nothing
// operation: -- (identifier)  ->  nothing
// operation: - (int)  ->  int
// operation: - (number)  ->  number
// operation: - (poly)  ->  poly
// operation: - (vector)  ->  vector
// operation: - (matrix)  ->  matrix
// operation: - (intvec)  ->  intvec
// operation: - (intmat)  ->  intmat
// operation: ( (proc)  ->  any_type
// operation: ( (string)  ->  nothing
// operation: attrib (def)  ->  nothing
// operation: bareiss (module)  ->  list
// operation: betti (list)  ->  intmat
// operation: betti (resolution)  ->  intmat
// operation: char (ring)  ->  int
// operation: char (qring)  ->  int
// operation: char_series (ideal)  ->  matrix
// operation: charstr (ring)  ->  string
// operation: charstr (qring)  ->  string
// operation: close (link)  ->  nothing
// operation: ncols (matrix)  ->  int
// operation: ncols (ideal)  ->  int
// operation: ncols (module)  ->  int
// operation: ncols (intmat)  ->  int
// DUMMY // operation: ncols (intvec)  ->  $INVALID$
// operation: cleardenom (poly)  ->  poly
// operation: cleardenom (vector)  ->  vector
// operation: size (number)  ->  int
// operation: size (resolution)  ->  int
// operation: size (string)  ->  int
// operation: size (poly)  ->  int
// operation: size (vector)  ->  int
// operation: size (ideal)  ->  int
// operation: size (module)  ->  int
// operation: size (matrix)  ->  int
// operation: size (intvec)  ->  int
// operation: size (intmat)  ->  int
// operation: size (list)  ->  int
// operation: size (ring)  ->  int
// operation: def (int)  ->  def
// DUMMY // operation: def (any_type)  ->  $INVALID$
// operation: deg (poly)  ->  int
// operation: deg (vector)  ->  int
// operation: degree (ideal)  ->  nothing
// operation: degree (module)  ->  nothing
// operation: defined (def)  ->  int
// operation: det (intmat)  ->  int
// operation: det (matrix)  ->  poly
// operation: det (module)  ->  poly
// operation: dim (ideal)  ->  int
// operation: dim (module)  ->  int
// operation: dim (resolution)  ->  int
// operation: dump (link)  ->  nothing
// operation: gen (int)  ->  vector
// operation: execute (string)  ->  nothing
// operation: ERROR (string)  ->  nothing
// operation: factorize (poly)  ->  list
// operation: finduni (ideal)  ->  ideal
// operation: freemodule (int)  ->  module
// operation: facstd (ideal)  ->  list
// operation: getdump (link)  ->  nothing
// operation: highcorner (ideal)  ->  poly
// operation: highcorner (module)  ->  vector
// operation: hilb (ideal)  ->  nothing
// operation: hilb (module)  ->  nothing
// operation: hilb (intvec)  ->  intvec
// operation: homog (ideal)  ->  int
// operation: homog (module)  ->  int
// operation: ideal (vector)  ->  ideal
// operation: ideal (matrix)  ->  ideal
// operation: ideal (qring)  ->  ideal
// operation: ideal (ring)  ->  ideal
// operation: ideal (map)  ->  ideal
// operation: ideal (ideal)  ->  ideal
// operation: impart (number)  ->  number
// operation: indepSet (ideal)  ->  intvec
// operation: int (int)  ->  int
// operation: int (number)  ->  int
// operation: int (poly)  ->  int
// operation: interred (ideal)  ->  ideal
// operation: interred (module)  ->  module
// operation: intmat (intmat)  ->  intmat
// operation: intvec (intmat)  ->  intvec
// operation: intvec (intvec)  ->  intvec
// operation: rvar (poly)  ->  int
// operation: rvar (string)  ->  int
// operation: rvar (any_type)  ->  int
// operation: jacob (poly)  ->  ideal
// operation: jacob (ideal)  ->  matrix
// operation: kbase (ideal)  ->  ideal
// operation: kbase (module)  ->  module
// operation: killattrib (identifier)  ->  nothing
// operation: lead (poly)  ->  poly
// operation: lead (ideal)  ->  ideal
// operation: lead (vector)  ->  vector
// operation: lead (module)  ->  module
// operation: leadcoef (poly)  ->  number
// operation: leadcoef (vector)  ->  number
// operation: leadexp (poly)  ->  intvec
// operation: leadexp (vector)  ->  intvec
// operation: leadmonom (poly)  ->  poly
// operation: leadmonom (vector)  ->  vector
// operation: LIB (string)  ->  nothing
// operation: link (link)  ->  link
// operation: list (def)  ->  list
// DUMMY // operation: map (any_type)  ->  $INVALID$
// operation: matrix (matrix)  ->  matrix
// operation: maxideal (int)  ->  ideal
// operation: memory (int)  ->  int
// operation: minbase (ideal)  ->  ideal
// operation: minbase (module)  ->  module
// operation: minres (list)  ->  list
// operation: minres (resolution)  ->  resolution
// operation: module (module)  ->  module
// operation: monitor (string)  ->  nothing
// operation: mult (ideal)  ->  int
// operation: mult (module)  ->  int
// operation: mstd (ideal)  ->  list
// operation: mstd (module)  ->  list
// operation: nameof (any_type)  ->  string
// operation: names (package)  ->  list
// operation: names (ring)  ->  list
// operation: names (qring)  ->  list
// operation: number (number)  ->  number
// operation: number (poly)  ->  number
// operation: npars (ring)  ->  int
// operation: npars (qring)  ->  int
// operation: nvars (ring)  ->  int
// operation: nvars (qring)  ->  int
// operation: open (link)  ->  nothing
// operation: ord (poly)  ->  int
// operation: ord (vector)  ->  int
// operation: ordstr (ring)  ->  string
// operation: ordstr (qring)  ->  string
// operation: par (int)  ->  number
// operation: pardeg (number)  ->  int
// operation: parstr (int)  ->  string
// operation: parstr (ring)  ->  string
// operation: parstr (qring)  ->  string
// operation: poly (poly)  ->  poly
// operation: preimage (map)  ->  ring
// operation: prime (int)  ->  int
// operation: print (list)  ->  nothing
// operation: print (def)  ->  nothing
// operation: prune (module)  ->  module
// operation: qhweight (ideal)  ->  intvec
// operation: qhweight (module)  ->  intvec
// DUMMY // operation: qring (any_type)  ->  $INVALID$
// operation: read (link)  ->  string
// operation: regularity (list)  ->  int
// operation: repart (number)  ->  number
// operation: reservedName (string)  ->  int
// operation: resolution (list)  ->  resolution
// operation: resolution (resolution)  ->  resolution
// operation: ring (ring)  ->  ring
// operation: nrows (vector)  ->  int
// operation: nrows (module)  ->  int
// operation: nrows (matrix)  ->  int
// operation: nrows (intmat)  ->  int
// operation: nrows (intvec)  ->  int
// operation: sortvec (ideal)  ->  intvec
// operation: sortvec (module)  ->  intvec
// operation: std (ideal)  ->  ideal
// operation: std (module)  ->  module
// operation: string (string)  ->  string
// operation: system (string)  ->  nothing
// operation: syz (ideal)  ->  module
// operation: syz (module)  ->  module
// DUMMY // operation: trace (intvec)  ->  $INVALID$
// DUMMY // operation: trace (ideal)  ->  $INVALID$
// operation: trace (intmat)  ->  int
// operation: trace (matrix)  ->  poly
// operation: transpose (intvec)  ->  intmat
// operation: transpose (intmat)  ->  intmat
// operation: transpose (matrix)  ->  matrix
// operation: transpose (module)  ->  module
// operation: typeof (any_type)  ->  string
// operation: vector (vector)  ->  vector
// operation: vdim (ideal)  ->  int
// operation: vdim (module)  ->  int
// operation: var (int)  ->  poly
// operation: varstr (int)  ->  string
// operation: varstr (ring)  ->  string
// operation: varstr (qring)  ->  string
// operation: weight (ideal)  ->  intvec
// operation: weight (module)  ->  intvec
// operation: load (string)  ->  nothing
// operation: convhull (ideal)  ->  ideal
/*---------------------------------------------*/
// operation: :: (def, def)  ->  any_type
// operation: + (int, int)  ->  int
// operation: + (number, number)  ->  number
// operation: + (poly, poly)  ->  poly
// operation: + (vector, vector)  ->  vector
// operation: + (ideal, ideal)  ->  ideal
// operation: + (module, module)  ->  module
// operation: + (poly, matrix)  ->  matrix
// operation: + (matrix, poly)  ->  matrix
// operation: + (matrix, matrix)  ->  matrix
// operation: + (string, string)  ->  string
// operation: + (intvec, int)  ->  intvec
// operation: + (int, intvec)  ->  intvec
// operation: + (intmat, int)  ->  intmat
// operation: + (int, intmat)  ->  intmat
// operation: + (intvec, intvec)  ->  intvec
// operation: + (intmat, intmat)  ->  intmat
// operation: + (list, list)  ->  list
// operation: + (ring, ring)  ->  ring
// operation: - (int, int)  ->  int
// operation: - (number, number)  ->  number
// operation: - (poly, poly)  ->  poly
// operation: - (vector, vector)  ->  vector
// operation: - (matrix, poly)  ->  matrix
// operation: - (matrix, matrix)  ->  matrix
// operation: - (intvec, int)  ->  intvec
// operation: - (intmat, int)  ->  intmat
// operation: - (intvec, intvec)  ->  intvec
// operation: - (intmat, intmat)  ->  intmat
// operation: * (int, int)  ->  int
// operation: * (number, number)  ->  number
// operation: * (poly, poly)  ->  poly
// operation: * (poly, vector)  ->  vector
// operation: * (vector, poly)  ->  vector
// operation: * (ideal, poly)  ->  ideal
// operation: * (poly, ideal)  ->  ideal
// operation: * (ideal, ideal)  ->  ideal
// operation: * (ideal, vector)  ->  module
// operation: * (vector, ideal)  ->  module
// operation: * (ideal, module)  ->  module
// operation: * (module, ideal)  ->  module
// operation: * (matrix, poly)  ->  matrix
// operation: * (poly, matrix)  ->  matrix
// operation: * (matrix, number)  ->  matrix
// operation: * (number, matrix)  ->  matrix
// operation: * (matrix, int)  ->  matrix
// operation: * (int, matrix)  ->  matrix
// operation: * (matrix, matrix)  ->  matrix
// operation: * (intvec, int)  ->  intvec
// operation: * (int, intvec)  ->  intvec
// operation: * (intmat, int)  ->  intmat
// operation: * (int, intmat)  ->  intmat
// operation: * (intmat, intvec)  ->  intvec
// operation: * (intmat, intmat)  ->  intmat
// operation: * (intvec, intmat)  ->  intmat
// operation: / (number, number)  ->  number
// operation: / (poly, poly)  ->  poly
// operation: / (vector, poly)  ->  vector
// operation: / (matrix, poly)  ->  matrix
// operation: / (int, int)  ->  int
// operation: / (intvec, int)  ->  intvec
// operation: / (intmat, int)  ->  intmat
// operation: div (int, int)  ->  int
// operation: div (intvec, int)  ->  intvec
// operation: div (intmat, int)  ->  intmat
// operation: % (int, int)  ->  int
// operation: % (intvec, int)  ->  intvec
// operation: % (intmat, int)  ->  intmat
// operation: mod (int, int)  ->  int
// operation: mod (intvec, int)  ->  intvec
// operation: mod (intmat, int)  ->  intmat
// operation: ^ (int, int)  ->  int
// operation: ^ (number, int)  ->  number
// operation: ^ (poly, int)  ->  poly
// operation: ^ (ideal, int)  ->  ideal
// operation: <= (int, int)  ->  int
// operation: <= (number, number)  ->  int
// operation: <= (string, string)  ->  int
// operation: <= (intvec, int)  ->  int
// operation: <= (intvec, intvec)  ->  int
// operation: <= (poly, poly)  ->  int
// operation: <= (vector, vector)  ->  int
// operation: < (int, int)  ->  int
// operation: < (number, number)  ->  int
// operation: < (intvec, int)  ->  int
// operation: < (intvec, intvec)  ->  int
// operation: < (string, string)  ->  int
// operation: < (poly, poly)  ->  int
// operation: < (vector, vector)  ->  int
// operation: >= (int, int)  ->  int
// operation: >= (number, number)  ->  int
// operation: >= (string, string)  ->  int
// operation: >= (intvec, int)  ->  int
// operation: >= (intvec, intvec)  ->  int
// operation: >= (poly, poly)  ->  int
// operation: >= (vector, vector)  ->  int
// operation: > (int, int)  ->  int
// operation: > (number, number)  ->  int
// operation: > (string, string)  ->  int
// operation: > (intvec, int)  ->  int
// operation: > (intvec, intvec)  ->  int
// operation: > (poly, poly)  ->  int
// operation: > (vector, vector)  ->  int
// operation: and (int, int)  ->  int
// operation: or (int, int)  ->  int
// operation: == (int, int)  ->  int
// operation: == (number, number)  ->  int
// operation: == (string, string)  ->  int
// operation: == (poly, poly)  ->  int
// operation: == (vector, vector)  ->  int
// operation: == (intvec, int)  ->  int
// operation: == (intvec, intvec)  ->  int
// operation: == (intmat, intmat)  ->  int
// operation: == (matrix, matrix)  ->  int
// DUMMY // operation: == (ideal, ideal)  ->  $INVALID$
// DUMMY // operation: == (module, module)  ->  $INVALID$
// DUMMY // operation: == (ideal, module)  ->  $INVALID$
// DUMMY // operation: == (module, ideal)  ->  $INVALID$
// operation: <> (int, int)  ->  int
// operation: <> (number, number)  ->  int
// operation: <> (string, string)  ->  int
// operation: <> (poly, poly)  ->  int
// operation: <> (vector, vector)  ->  int
// operation: <> (intvec, intvec)  ->  int
// operation: <> (intmat, intmat)  ->  int
// operation: <> (matrix, matrix)  ->  int
// DUMMY // operation: <> (ideal, ideal)  ->  $INVALID$
// DUMMY // operation: <> (module, module)  ->  $INVALID$
// DUMMY // operation: <> (ideal, module)  ->  $INVALID$
// DUMMY // operation: <> (module, ideal)  ->  $INVALID$
// operation: .. (int, int)  ->  intvec
// operation: [ (intvec, int)  ->  int
// operation: [ (intvec, intvec)  ->  int
// operation: [ (ideal, int)  ->  poly
// operation: [ (map, int)  ->  poly
// operation: [ (ideal, intvec)  ->  poly
// operation: [ (module, int)  ->  vector
// operation: [ (module, intvec)  ->  vector
// operation: [ (string, int)  ->  string
// operation: [ (string, intvec)  ->  string
// operation: [ (list, int)  ->  any_type
// operation: [ (list, intvec)  ->  any_type
// operation: [ (poly, int)  ->  poly
// operation: [ (poly, intvec)  ->  poly
// operation: [ (vector, int)  ->  poly
// operation: [ (vector, intvec)  ->  vector
// operation: ( (proc, def)  ->  any_type
// operation: ( (map, def)  ->  any_type
// operation: ( (any_type, int)  ->  any_type
// operation: ( (any_type, intvec)  ->  any_type
// operation: attrib (def, string)  ->  nothing
// DUMMY // operation: bareiss (def, def)  ->  $INVALID$
// operation: betti (resolution, int)  ->  intmat
// operation: coef (poly, poly)  ->  matrix
// operation: coeffs (ideal, poly)  ->  matrix
// operation: coeffs (module, poly)  ->  matrix
// operation: coeffs (ideal, ideal)  ->  matrix
// operation: coeffs (module, module)  ->  matrix
// operation: contract (ideal, ideal)  ->  matrix
// operation: deg (poly, intvec)  ->  int
// operation: delete (list, int)  ->  list
// operation: diff (poly, poly)  ->  poly
// operation: diff (vector, poly)  ->  vector
// operation: diff (ideal, poly)  ->  ideal
// operation: diff (ideal, ideal)  ->  matrix
// operation: diff (module, poly)  ->  module
// operation: diff (matrix, poly)  ->  matrix
// operation: dim (ideal, ideal)  ->  int
// operation: dim (module, ideal)  ->  int
// operation: division (ideal, ideal)  ->  list
// operation: division (module, module)  ->  list
// operation: eliminate (ideal, poly)  ->  ideal
// operation: eliminate (module, poly)  ->  module
// operation: extgcd (int, int)  ->  list
// operation: extgcd (poly, poly)  ->  list
// operation: factorize (poly, int)  ->  ideal
// operation: facstd (ideal, ideal)  ->  list
// operation: fetch (ring, any_type)  ->  any_type
// operation: fetch (qring, any_type)  ->  any_type
// operation: fglm (ring, def)  ->  ideal
// operation: fglm (qring, def)  ->  ideal
// operation: fglmquot (ideal, poly)  ->  ideal
// operation: find (string, string)  ->  int
// operation: gcd (int, int)  ->  int
// operation: gcd (poly, poly)  ->  poly
// operation: gcd (number, number)  ->  number
// operation: hilb (ideal, int)  ->  intvec
// operation: hilb (module, int)  ->  intvec
// operation: homog (poly, poly)  ->  poly
// operation: homog (vector, poly)  ->  vector
// operation: homog (ideal, poly)  ->  ideal
// operation: homog (module, poly)  ->  module
// operation: hres (ideal, int)  ->  resolution
// operation: ideal (def, def)  ->  ideal
// operation: imap (ring, any_type)  ->  any_type
// operation: imap (qring, any_type)  ->  any_type
// operation: indepSet (ideal, int)  ->  list
// operation: insert (list, def)  ->  list
// operation: intersect (ideal, ideal)  ->  ideal
// operation: intersect (module, module)  ->  module
// operation: jet (poly, int)  ->  poly
// operation: jet (ideal, int)  ->  ideal
// operation: jet (vector, int)  ->  vector
// operation: jet (module, int)  ->  module
// operation: jet (matrix, int)  ->  matrix
// operation: kbase (ideal, int)  ->  ideal
// operation: kbase (module, int)  ->  module
// operation: killattrib (identifier, string)  ->  nothing
// operation: koszul (int, int)  ->  matrix
// operation: koszul (int, ideal)  ->  matrix
// operation: kres (ideal, int)  ->  resolution
// operation: lift (ideal, ideal)  ->  matrix
// operation: lift (module, module)  ->  matrix
// operation: liftstd (ideal, matrix)  ->  ideal
// operation: liftstd (module, matrix)  ->  module
// operation: list (def, def)  ->  list
// operation: lres (ideal, int)  ->  resolution
// operation: minor (matrix, int)  ->  ideal
// operation: module (def, def)  ->  module
// operation: modulo (ideal, ideal)  ->  module
// operation: modulo (module, module)  ->  module
// operation: monitor (string, string)  ->  nothing
// operation: mres (ideal, int)  ->  resolution
// operation: mres (module, int)  ->  resolution
// operation: parstr (ring, int)  ->  string
// operation: parstr (qring, int)  ->  string
// operation: print (def, string)  ->  any_type
// operation: quotient (ideal, ideal)  ->  ideal
// operation: quotient (module, ideal)  ->  module
// operation: quotient (module, module)  ->  ideal
// operation: random (int, int)  ->  int
// operation: read (link, string)  ->  string
// operation: reduce (poly, ideal)  ->  poly
// operation: reduce (vector, ideal)  ->  vector
// operation: reduce (vector, module)  ->  vector
// operation: reduce (ideal, ideal)  ->  ideal
// operation: reduce (module, module)  ->  module
// operation: reduce (module, ideal)  ->  module
// operation: nres (ideal, int)  ->  resolution
// operation: nres (module, int)  ->  resolution
// operation: status (link, string)  ->  string
// operation: simplify (poly, int)  ->  poly
// operation: simplify (vector, int)  ->  vector
// operation: simplify (ideal, int)  ->  ideal
// operation: simplify (module, int)  ->  module
// operation: sres (ideal, int)  ->  resolution
// operation: sres (module, int)  ->  resolution
// operation: system (string, def)  ->  any_type
// operation: std (ideal, poly)  ->  ideal
// operation: std (module, vector)  ->  module
// operation: std (ideal, intvec)  ->  ideal
// operation: std (module, intvec)  ->  module
// operation: varstr (ring, int)  ->  string
// operation: varstr (qring, int)  ->  string
// operation: wedge (matrix, int)  ->  matrix
// operation: load (string, string)  ->  nothing
// operation: mpresmat (ideal, int)  ->  module
/*---------------------------------------------*/
// operation: [ (string, int, int)  ->  string
// operation: [ (intmat, int, int)  ->  int
// operation: [ (intmat, int, intvec)  ->  int
// operation: [ (intmat, intvec, int)  ->  int
// operation: [ (intmat, intvec, intvec)  ->  int
// operation: [ (matrix, int, int)  ->  poly
// operation: [ (matrix, int, intvec)  ->  poly
// operation: [ (matrix, intvec, int)  ->  poly
// operation: [ (matrix, intvec, intvec)  ->  poly
// operation: ( (proc, def, def)  ->  any_type
// operation: attrib (identifier, string, def)  ->  nothing
// operation: bareiss (module, int, int)  ->  list
// operation: coeffs (poly, poly, matrix)  ->  matrix
// operation: coeffs (vector, poly, matrix)  ->  matrix
// operation: coeffs (ideal, poly, matrix)  ->  matrix
// operation: coeffs (module, poly, matrix)  ->  matrix
// operation: coeffs (ideal, ideal, poly)  ->  matrix
// operation: coeffs (module, module, poly)  ->  matrix
// operation: eliminate (ideal, poly, intvec)  ->  ideal
// operation: find (string, string, int)  ->  int
// operation: hilb (ideal, int, intvec)  ->  intvec
// operation: hilb (module, int, intvec)  ->  intvec
// operation: ideal (def, def, def)  ->  ideal
// operation: insert (list, def, int)  ->  list
// operation: intmat (intmat, int, int)  ->  intmat
// operation: intvec (def, def, def)  ->  intvec
// operation: jet (poly, int, intvec)  ->  poly
// operation: jet (ideal, int, intvec)  ->  ideal
// operation: jet (vector, int, intvec)  ->  vector
// operation: jet (module, int, intvec)  ->  module
// operation: jet (poly, int, poly)  ->  poly
// operation: jet (vector, int, poly)  ->  vector
// operation: jet (ideal, int, matrix)  ->  ideal
// operation: jet (module, int, matrix)  ->  module
// DUMMY // operation: jet (poly, int, int)  ->  poly
// operation: koszul (int, int, ideal)  ->  matrix
// operation: list (def, def, def)  ->  list
// operation: matrix (ideal, int, int)  ->  matrix
// operation: matrix (module, int, int)  ->  matrix
// operation: matrix (matrix, int, int)  ->  matrix
// operation: minor (matrix, int, ideal)  ->  ideal
// operation: module (def, def, def)  ->  module
// operation: lift (ideal, ideal, matrix)  ->  matrix
// operation: lift (module, module, matrix)  ->  matrix
// operation: preimage (ring, any_type, any_type)  ->  ideal
// operation: preimage (qring, any_type, any_type)  ->  ideal
// operation: random (int, int, int)  ->  intmat
// operation: reduce (poly, ideal, int)  ->  poly
// operation: reduce (vector, ideal, int)  ->  vector
// operation: reduce (vector, module, int)  ->  vector
// operation: reduce (ideal, ideal, int)  ->  ideal
// operation: reduce (module, module, int)  ->  module
// operation: reduce (module, ideal, int)  ->  module
// operation: reduce (poly, ideal, poly)  ->  poly
// operation: reduce (vector, module, poly)  ->  vector
// operation: reduce (ideal, ideal, matrix)  ->  ideal
// operation: reduce (module, module, matrix)  ->  module
// operation: resultant (poly, poly, poly)  ->  poly
// operation: ring (def, def, def)  ->  ring
// operation: status (link, string, string)  ->  int
// operation: std (ideal, intvec, intvec)  ->  ideal
// operation: std (module, intvec, intvec)  ->  module
// operation: subst (poly, number, poly)  ->  poly
// operation: subst (poly, poly, poly)  ->  poly
// operation: subst (poly, poly, poly)  ->  poly
// operation: subst (vector, poly, poly)  ->  vector
// operation: subst (ideal, poly, poly)  ->  ideal
// operation: subst (module, poly, poly)  ->  module
// operation: subst (matrix, poly, poly)  ->  matrix
// operation: subst (matrix, poly, int)  ->  matrix
// operation: subst (matrix, poly, number)  ->  matrix
// operation: system (string, def, def)  ->  nothing
// operation: laguerre (poly, int, int)  ->  list
// operation: vandermonde (ideal, ideal, int)  ->  poly
/*---------------------------------------------*/
// operation: ( (...)  ->  any_type ( number of arguments >0 )
// operation: breakpoint (...)  ->  nothing ( 0 arguments )
// operation: breakpoint (...)  ->  nothing ( number of arguments >0 )
// operation: coef (...)  ->  matrix ( 2 arguments )
// operation: coef (...)  ->  nothing ( 4 arguments )
// operation: dbprint (...)  ->  nothing ( number of arguments >0 )
// operation: ideal (...)  ->  ideal ( 1 arguments )
// operation: ideal (...)  ->  ideal ( any number of arguments )
// operation: intersect (...)  ->  ideal ( 2 arguments )
// operation: intersect (...)  ->  ideal ( number of arguments >0 )
// operation: intvec (...)  ->  intvec ( 1 arguments )
// operation: intvec (...)  ->  intvec ( number of arguments >0 )
// operation: list (...)  ->  list ( any number of arguments )
// operation: module (...)  ->  module ( 1 arguments )
// operation: module (...)  ->  module ( any number of arguments )
// operation: names (...)  ->  list ( 1 arguments )
// operation: names (...)  ->  list ( 0 arguments )
// operation: option (...)  ->  string ( any number of arguments )
// operation: reduce (...)  ->  ideal ( 2 arguments )
// operation: reduce (...)  ->  ideal ( 3 arguments )
// operation: reduce (...)  ->  ideal ( 4 arguments )
// operation: reduce (...)  ->  ideal ( 5 arguments )
// operation: reservedName (...)  ->  int ( 1 arguments )
// operation: reservedName (...)  ->  nothing ( 0 arguments )
// operation: string (...)  ->  string ( any number of arguments )
// operation: subst (...)  ->  nothing ( 3 arguments )
// operation: subst (...)  ->  nothing ( number of arguments >0 )
// operation: system (...)  ->  nothing ( number of arguments >0 )
// operation: test (...)  ->  nothing ( number of arguments >0 )
// operation: write (...)  ->  nothing ( number of arguments >0 )
// operation: status (...)  ->  string ( 2 arguments )
// operation: status (...)  ->  int ( 3 arguments )
// operation: status (...)  ->  int ( 4 arguments )
// operation: simplex (...)  ->  list ( 6 arguments )
// operation: uressolve (...)  ->  list ( 4 arguments )
/*---------------------------------------------*/
// assign: ideal =  ideal
// assign: ideal =  matrix
// assign: resolution =  resolution
// assign: int =  int
// assign: matrix =  matrix
// assign: map =  ideal
// assign: map =  map
// assign: module =  module
// assign: module =  poly
// assign: poly =  poly
// assign: poly =  matrix
// assign: qring =  ideal
// assign: ring =  ring
// assign: qring =  qring
// assign: string =  string
// assign: proc =  string
// assign: proc =  proc
// assign: vector =  vector
// assign: intvec =  intvec
// assign: intmat =  intmat
// assign: number =  number
// assign: list =  resolution
// assign: list =  list
// assign: link =  string
// assign: link =  link
// assign: package =  package
/*---------------------------------------------*/
// convert intvec -> intmat
// convert poly -> ideal
// convert int -> ideal
// convert intmat -> matrix
// convert ideal -> matrix
// convert module -> matrix
// convert number -> matrix
// convert poly -> matrix
// convert vector -> matrix
// convert int -> matrix
// convert intvec -> matrix
// convert ideal -> module
// convert matrix -> module
// convert vector -> module
// convert int -> number
// convert number -> poly
// convert int -> poly
// convert list -> resolution
// convert poly -> vector
// convert int -> vector
// convert int -> intvec
// convert string -> link
// convert resolution -> list
/*---------------------------------------------*/
// token 61 : =
// token 62 : >
// token 60 : <
// token 43 : +
// token 42 : *
// token 47 : /
// token 91 : [
// token 46 : .
// token 94 : ^
// token 44 : ,
// token 37 : %
// token 40 : (
// token 59 : ;
// token 257 : ..
// token 258 : ==
// token 259 : >=
// token 260 : <=
// token 261 : --
// token 262 : not
// token 263 : <>
// token 264 : ++
// token 265 : ::
// token 267 : intmat
// token 268 : proc
// token 269 : ring
// token 271 : ideal
// token 272 : map
// token 273 : matrix
// token 274 : module
// token 275 : number
// token 276 : poly
// token 277 : resolution
// token 278 : vector
// token 279 : betti
// token 280 : coeffs
// token 281 : coef
// token 282 : contract
// token 283 : degree
// token 284 : deg
// token 285 : diff
// token 286 : dim
// token 287 : division
// token 288 : eliminate
// token 289 : gen
// token 290 : fetch
// token 291 : freemodule
// token 292 : keepring
// token 293 : hilb
// token 294 : homog
// token 295 : imap
// token 296 : indepSet
// token 297 : interred
// token 298 : intersect
// token 299 : jacob
// token 300 : jet
// token 301 : kbase
// token 302 : koszul
// token 303 : leadcoef
// token 304 : leadexp
// token 305 : lead
// token 306 : leadmonom
// token 307 : liftstd
// token 308 : lift
// token 309 : maxideal
// token 310 : minbase
// token 311 : minor
// token 312 : minres
// token 313 : modulo
// token 314 : mres
// token 315 : mult
// token 316 : ord
// token 317 : par
// token 318 : pardeg
// token 319 : preimage
// token 320 : quotient
// token 321 : qhweight
// token 322 : reduce
// token 323 : regularity
// token 324 : nres
// token 325 : simplify
// token 326 : sortvec
// token 327 : sres
// token 328 : std
// token 329 : subst
// token 330 : syz
// token 331 : var
// token 332 : vdim
// token 333 : wedge
// token 334 : weight
// token 335 : alternating
// token 336 : degBound
// token 337 : multBound
// token 338 : noether
// token 339 : minpoly
// token 340 : nothing
// token 352 : example
// token 353 : export
// token 357 : kill
// token 358 : LIB
// token 359 : listvar
// token 360 : setring
// token 361 : type
// token 368 : break
// token 369 : continue
// token 370 : else
// token 371 : eval
// token 372 : quote
// token 374 : forif
// token 377 : return
// token 378 : parameter
// token 383 : any_type
// token 384 : identifier
// token 396 : attrib
// token 397 : bareiss
// token 398 : breakpoint
// token 399 : char
// token 400 : charstr
// token 401 : char_series
// token 402 : close
// token 403 : ncols
// token 404 : cleardenom
// token 405 : size
// token 406 : dbprint
// token 407 : def
// token 408 : defined
// token 409 : delete
// token 410 : det
// token 411 : dump
// token 412 : RETURN
// token 413 : ERROR
// token 414 : execute
// token 415 : extgcd
// token 416 : factorize
// token 417 : find
// token 418 : facstd
// token 419 : fglm
// token 420 : fglmquot
// token 421 : finduni
// token 422 : gcd
// token 423 : getdump
// token 424 : highcorner
// token 425 : hres
// token 426 : impart
// token 427 : insert
// token 428 : int
// token 429 : div
// token 430 : mod
// token 431 : intvec
// token 432 : rvar
// token 433 : killattrib
// token 434 : kres
// token 435 : laguerre
// token 436 : link
// token 437 : list
// token 438 : load
// token 439 : lres
// token 440 : memory
// token 441 : monitor
// token 442 : mpresmat
// token 443 : mstd
// token 444 : nameof
// token 445 : names
// token 446 : convhull
// token 447 : npars
// token 448 : nvars
// token 449 : open
// token 450 : option
// token 451 : ordstr
// token 452 : package
// token 453 : parstr
// token 455 : prime
// token 456 : print
// token 457 : prune
// token 458 : qring
// token 459 : random
// token 460 : read
// token 461 : repart
// token 462 : reservedName
// token 463 : resultant
// token 464 : nrows
// token 465 : simplex
// token 467 : status
// token 468 : string
// token 469 : system
// token 470 : test
// token 471 : transpose
// token 472 : trace
// token 473 : typeof
// token 475 : uressolve
// token 476 : vandermonde
// token 477 : varstr
// token 478 : write
// token 479 : echo
// token 480 : pagelength
// token 481 : pagewidth
// token 482 : timer
// token 483 : rtimer
// token 484 : TRACE
// token 485 : voice
// token 486 : short
// token 487 : printlevel
/*--max. token: 488, gr: 380 --*/
/*---------------------------------------------*/
struct sValCmdTab dArithTab1[]=
{
 { 40,9 },
 { 45,2 },
 { 261,1 },
 { 264,0 },
 { 267,82 },
 { 269,155 },
 { 271,69 },
 { 272,106 },
 { 273,107 },
 { 274,114 },
 { 275,124 },
 { 276,140 },
 { 277,153 },
 { 278,178 },
 { 279,13 },
 { 283,44 },
 { 284,42 },
 { 286,50 },
 { 289,54 },
 { 291,59 },
 { 293,64 },
 { 294,67 },
 { 296,76 },
 { 297,80 },
 { 299,88 },
 { 301,90 },
 { 303,97 },
 { 304,99 },
 { 305,93 },
 { 306,101 },
 { 309,108 },
 { 310,110 },
 { 312,112 },
 { 315,116 },
 { 316,131 },
 { 317,135 },
 { 318,136 },
 { 319,141 },
 { 321,146 },
 { 323,150 },
 { 326,161 },
 { 328,163 },
 { 330,167 },
 { 331,181 },
 { 332,179 },
 { 334,185 },
 { 358,103 },
 { 396,11 },
 { 397,12 },
 { 399,15 },
 { 400,18 },
 { 401,17 },
 { 402,20 },
 { 403,21 },
 { 404,26 },
 { 405,28 },
 { 407,40 },
 { 408,46 },
 { 410,47 },
 { 411,53 },
 { 413,56 },
 { 414,55 },
 { 416,57 },
 { 418,60 },
 { 421,58 },
 { 423,61 },
 { 424,62 },
 { 426,75 },
 { 428,77 },
 { 431,83 },
 { 432,85 },
 { 433,92 },
 { 436,104 },
 { 437,105 },
 { 438,187 },
 { 440,109 },
 { 441,115 },
 { 443,118 },
 { 444,120 },
 { 445,121 },
 { 446,188 },
 { 447,126 },
 { 448,128 },
 { 449,130 },
 { 451,133 },
 { 453,137 },
 { 455,142 },
 { 456,143 },
 { 457,145 },
 { 458,148 },
 { 460,149 },
 { 461,151 },
 { 462,152 },
 { 464,156 },
 { 468,165 },
 { 469,166 },
 { 471,173 },
 { 472,169 },
 { 473,177 },
 { 477,182 },
 { 10000,0 }
};
#define JJTAB1LEN 100
struct sValCmdTab dArithTab2[]=
{
 { 37,65 },
 { 38,103 },
 { 40,146 },
 { 42,29 },
 { 43,1 },
 { 45,19 },
 { 47,55 },
 { 60,82 },
 { 62,96 },
 { 91,131 },
 { 94,71 },
 { 124,104 },
 { 257,130 },
 { 258,105 },
 { 259,89 },
 { 260,75 },
 { 263,118 },
 { 265,0 },
 { 271,193 },
 { 274,218 },
 { 279,152 },
 { 280,154 },
 { 281,153 },
 { 282,158 },
 { 284,159 },
 { 285,161 },
 { 286,167 },
 { 287,169 },
 { 288,171 },
 { 290,177 },
 { 293,186 },
 { 294,188 },
 { 295,194 },
 { 296,196 },
 { 298,198 },
 { 300,200 },
 { 301,205 },
 { 302,208 },
 { 307,213 },
 { 308,211 },
 { 311,217 },
 { 313,219 },
 { 314,222 },
 { 320,227 },
 { 322,232 },
 { 324,238 },
 { 325,241 },
 { 327,245 },
 { 328,248 },
 { 333,254 },
 { 396,150 },
 { 397,151 },
 { 409,160 },
 { 415,173 },
 { 416,175 },
 { 417,182 },
 { 418,176 },
 { 419,179 },
 { 420,181 },
 { 422,183 },
 { 425,192 },
 { 427,197 },
 { 429,62 },
 { 430,68 },
 { 433,207 },
 { 434,210 },
 { 437,215 },
 { 438,255 },
 { 439,216 },
 { 441,221 },
 { 442,256 },
 { 453,224 },
 { 456,226 },
 { 459,230 },
 { 460,231 },
 { 467,240 },
 { 469,247 },
 { 477,252 },
 { 10000,0 }
};
#define JJTAB2LEN 78
/****************************************
*  Computer Algebra System SINGULAR     *
****************************************/

// identifier table for Singular
//
cmdnames cmds[] =
{  // name-string     alias  tokval toktype
{ "$INVALID$",            0,  -1, 0},
  {"ERROR",               0, 413, CMD_1 },
  {"EXTGCD",              2, 415, CMD_2 },
  {"GCD",                 2, 422, CMD_2 },
  {"IN",                  1, 305, CMD_1 },
  {"LIB",                 0, 358, SYSVAR },
  {"NF",                  1, 322, CMD_M },
  {"RETURN",              0, 412, 377 },
  {"TRACE",               0, 484, SYSVAR },
  {"alternating",         0, 335, SYSVAR },
  {"and",                 0,  38, '&' },
  {"attrib",              0, 396, CMD_123 },
  {"bareiss",             0, 397, CMD_123 },
  {"betti",               0, 279, CMD_12 },
  {"break",               0, 368, 368 },
  {"breakpoint",          0, 398, CMD_M },
  {"char",                0, 399, CMD_1 },
  {"char_series",         0, 401, CMD_1 },
  {"charstr",             0, 400, CMD_1 },
  {"cleardenom",          0, 404, CMD_1 },
  {"close",               0, 402, CMD_1 },
  {"coef",                0, 281, CMD_M },
  {"coeffs",              0, 280, CMD_23 },
  {"continue",            0, 369, 369 },
  {"contract",            0, 282, CMD_2 },
  {"convhull",            0, 446, CMD_1 },
  {"dbprint",             0, 406, CMD_M },
  {"def",                 0, 407, ROOT_DECL },
  {"defined",             0, 408, CMD_1 },
  {"deg",                 0, 284, CMD_12 },
  {"degBound",            0, 336, SYSVAR },
  {"degree",              0, 283, CMD_1 },
  {"delete",              0, 409, CMD_2 },
  {"det",                 0, 410, CMD_1 },
  {"diff",                0, 285, CMD_2 },
  {"dim",                 0, 286, CMD_1 },
  {"div",                 0, 429, '/' },
  {"division",            0, 287, CMD_2 },
  {"dump",                0, 411, CMD_1 },
  {"echo",                0, 479, SYSVAR },
  {"eliminate",           0, 288, CMD_23 },
  {"else",                0, 370, 370 },
  {"eval",                0, 371, 371 },
  {"example",             0, 352, 352 },
  {"execute",             0, 414, CMD_1 },
  {"export",              0, 353, 353 },
  {"extgcd",              0, 415, CMD_2 },
  {"facstd",              0, 418, CMD_12 },
  {"factorize",           0, 416, CMD_12 },
  {"fetch",               0, 290, CMD_2 },
  {"fglm",                0, 419, CMD_2 },
  {"fglmquot",            0, 420, CMD_2 },
  {"find",                0, 417, CMD_23 },
  {"finduni",             0, 421, CMD_1 },
  {"forif",               0, 374, 374 },
  {"freemodule",          0, 291, CMD_1 },
  {"gcd",                 0, 422, CMD_2 },
  {"gen",                 0, 289, CMD_1 },
  {"getdump",             0, 423, CMD_1 },
  {"highcorner",          0, 424, CMD_1 },
  {"hilb",                0, 293, CMD_123 },
  {"homog",               0, 294, CMD_12 },
  {"hres",                0, 425, CMD_2 },
  {"ideal",               0, 271, 271 },
  {"if",                  0, 374, 374 },
  {"imap",                0, 295, CMD_2 },
  {"impart",              0, 426, CMD_1 },
  {"indepSet",            0, 296, CMD_12 },
  {"insert",              0, 427, CMD_23 },
  {"int",                 0, 428, ROOT_DECL },
  {"interred",            0, 297, CMD_1 },
  {"intersect",           0, 298, CMD_M },
  {"intmat",              0, 267, 267 },
  {"intvec",              0, 431, ROOT_DECL_LIST },
  {"jacob",               0, 299, CMD_1 },
  {"jet",                 0, 300, CMD_23 },
  {"kbase",               0, 301, CMD_12 },
  {"keepring",            0, 292, 292 },
  {"kill",                0, 357, 357 },
  {"killattrib",          0, 433, CMD_12 },
  {"koszul",              0, 302, CMD_23 },
  {"kres",                0, 434, CMD_2 },
  {"laguerre",            0, 435, CMD_3 },
  {"lead",                0, 305, CMD_1 },
  {"leadcoef",            0, 303, CMD_1 },
  {"leadexp",             0, 304, CMD_1 },
  {"leadmonom",           0, 306, CMD_1 },
  {"lift",                0, 308, CMD_23 },
  {"liftstd",             0, 307, CMD_2 },
  {"link",                0, 436, ROOT_DECL },
  {"list",                0, 437, ROOT_DECL_LIST },
  {"listvar",             0, 359, 359 },
  {"load",                0, 438, CMD_12 },
  {"lres",                0, 439, CMD_2 },
  {"map",                 0, 272, RING_DECL },
  {"matrix",              0, 273, 273 },
  {"maxideal",            0, 309, CMD_1 },
  {"memory",              0, 440, CMD_1 },
  {"minbase",             0, 310, CMD_1 },
  {"minor",               0, 311, CMD_23 },
  {"minpoly",             0, 339, SYSVAR },
  {"minres",              0, 312, CMD_1 },
  {"mod",                 0, 430, '/' },
  {"module",              0, 274, 274 },
  {"modulo",              0, 313, CMD_2 },
  {"monitor",             0, 441, CMD_12 },
  {"mpresmat",            0, 442, CMD_2 },
  {"mres",                0, 314, CMD_2 },
  {"mstd",                0, 443, CMD_1 },
  {"mult",                0, 315, CMD_1 },
  {"multBound",           0, 337, SYSVAR },
  {"multiplicity",        1, 315, CMD_1 },
  {"nameof",              0, 444, CMD_1 },
  {"names",               0, 445, CMD_M },
  {"ncols",               0, 403, CMD_1 },
  {"noether",             0, 338, SYSVAR },
  {"not",                 0, 262, 262 },
  {"npars",               0, 447, CMD_1 },
  {"nres",                0, 324, CMD_2 },
  {"nrows",               0, 464, CMD_1 },
  {"number",              0, 275, RING_DECL },
  {"nvars",               0, 448, CMD_1 },
  {"open",                0, 449, CMD_1 },
  {"option",              0, 450, CMD_M },
  {"or",                  0, 124, '&' },
  {"ord",                 0, 316, CMD_1 },
  {"ordstr",              0, 451, CMD_1 },
  {"package",             0, 452, ROOT_DECL },
  {"pagelength",          0, 480, SYSVAR },
  {"pagewidth",           0, 481, SYSVAR },
  {"par",                 0, 317, CMD_1 },
  {"parameter",           0, 378, 378 },
  {"pardeg",              0, 318, CMD_1 },
  {"parstr",              0, 453, CMD_12 },
  {"poly",                0, 276, RING_DECL },
  {"preimage",            0, 319, 345 },
  {"prime",               0, 455, CMD_1 },
  {"print",               0, 456, CMD_12 },
  {"printlevel",          0, 487, SYSVAR },
  {"proc",                0, 268, 268 },
  {"prune",               0, 457, CMD_1 },
  {"qhweight",            0, 321, CMD_1 },
  {"qring",               0, 458, ROOT_DECL },
  {"quote",               0, 372, 372 },
  {"quotient",            0, 320, CMD_2 },
  {"random",              0, 459, CMD_23 },
  {"read",                0, 460, CMD_12 },
  {"reduce",              0, 322, CMD_M },
  {"regularity",          0, 323, CMD_1 },
  {"repart",              0, 461, CMD_1 },
  {"reservedName",        0, 462, CMD_M },
  {"resolution",          0, 277, RING_DECL },
  {"resultant",           0, 463, CMD_3 },
  {"return",              0, 377, 377 },
  {"ring",                0, 269, 269 },
#ifdef HAVE_RTIMER
  {"rtimer",              0, 483, SYSVAR },
#endif
  {"rvar",                0, 432, CMD_1 },
  {"setring",             0, 360, 360 },
  {"short",               0, 486, SYSVAR },
  {"simplex",             0, 465, CMD_M },
  {"simplify",            0, 325, CMD_2 },
  {"size",                0, 405, CMD_1 },
  {"sortvec",             0, 326, CMD_1 },
  {"sres",                0, 327, CMD_2 },
  {"status",              0, 467, CMD_M },
  {"std",                 0, 328, CMD_123 },
  {"string",              0, 468, ROOT_DECL_LIST },
  {"subst",               0, 329, CMD_M },
  {"system",              0, 469, CMD_M },
  {"syz",                 0, 330, CMD_1 },
  {"test",                0, 470, CMD_M },
  {"timer",               0, 482, SYSVAR },
  {"trace",               0, 472, CMD_1 },
  {"transpose",           0, 471, CMD_1 },
  {"type",                0, 361, 361 },
  {"typeof",              0, 473, CMD_1 },
  {"uressolve",           0, 475, CMD_M },
  {"vandermonde",         0, 476, CMD_3 },
  {"var",                 0, 331, CMD_1 },
  {"varstr",              0, 477, CMD_12 },
  {"vdim",                0, 332, CMD_1 },
  {"vector",              0, 278, RING_DECL },
  {"verbose",             2, 450, CMD_M },
  {"voice",               0, 485, SYSVAR },
  {"wedge",               0, 333, CMD_2 },
  {"weight",              0, 334, CMD_1 },
  {"whileif",             0, 374, 374 },
  {"write",               0, 478, CMD_M },
/* list of scanner identifiers/only for feread/reservedName */
  {"exit",                0,  -1, 0 },
  {"for",                 0,  -1, 0 },
  {"help",                0,  -1, 0 },
  {"newline",             0,  -1, 0 },
  {"pause",               0,  -1, 0 },
  {"quit",                0,  -1, 0 },
  {"while",               0,  -1, 0 },
/* end of list marker */
  { NULL, 0, 0, 0}
};
#ifdef HAVE_RTIMER
#define LAST_IDENTIFIER 187
#else
#define LAST_IDENTIFIER 186
#endif
