/*
    acltool, a GTK editor for AFS ACLs
    Copyright (C) 2000  Nohup AB

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/ioctl.h>
#include <kafs.h>

#include <stdio.h>		/* FILENAME_MAX */
#include <unistd.h>		/* getcwd() */
#include <stdlib.h>		/* exit() */
#include <string.h>		/* strcpy() */

#include <gtk/gtk.h>

#include "interface.h"
#include "callbacks.h"
#include "support.h"

int
main (int argc, char *argv[])
{
  GtkWidget *window;
  GtkEntry *directory;
  GtkCList *groups;
  char path[FILENAME_MAX];

  if(!k_hasafs())
   {
    g_printerr("No AFS found!\n");
    exit(1);
   }
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  window = create_window ();

  directory = GTK_ENTRY(lookup_widget(window, "directory"));
  switch(argc)
   {
   case 2:
    strcpy(path, argv[1]);
    break;
   default:
    getcwd(path, sizeof(path));
   }
  gtk_entry_set_text(directory, path);
  gtk_widget_show (window);
  do_reread(GTK_WIDGET(directory), NULL);
  groups = GTK_CLIST(lookup_widget(window, "groups"));
  gtk_clist_column_titles_passive(groups);

  gtk_main ();
  return 0;
}

