.\" t
.\" @(#)Scroll.1	02/07/00
.TH Scroll 1.8 "Feb 7 2000" Scroll
.UC
.SH NAME
\fBScroll\fP \- the AfterStep scroll-bar module

.SH SYNOPSIS
\fBScroll\fP [\-f \fIconfig_file\fP] [\-v | \--version] [\-h | \--help]
[x y]
.sp
Although \fBScroll\fP can be run from the command line, it is normally 
spawned by afterstep from within an afterstep menu file by 'Scroll':
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Scroll"
	Module "Scroll" Scroll
	MiniPixmap "mini-as.xpm"
.fi

.SH DESCRIPTION
The Scroll module prompts the user to select a target window, if
the module was not launched from within a window context in AfterStep.
After that, it adds scroll bars to the selected window, to reduce the
total desktop space consumed by the window.

Scroll should not be used with windows which move or resize themselves, nor
should it be used with windows which set the WM_COLORMAP_WINDOWS property.
Operation is fine with windows that have a private colormap.

.SH OPTIONS
.IP "\-f \fIconfig_file\fP"
Use \fIconfig_file\fP instead of the default configuration file.

.IP "\-h | \--help"
Print a usage message and exit successfully.

.IP "\-v | \--version"
Print version information and exit successfully.

.SH INITIALIZATION
During initialization, \fIScroll\fP will search for a configuration 
file which describes the colors to use.  This file will be the one 
specified by the \fI\-f\fP option (if given).  Else, the 
~/GNUstep/Library/AfterStep/pager file will be used if it exists.  
Else, /usr/local/share/afterstep/pager will be used.

If the \fBScroll\fP executable is linked to another name, ie 'ln -s
Scroll OtherScroll, then another module called OtherScroll can be
started, with a completely different configuration than Scroll,
simply by changing the keyword \fI*Scroll\fP to \fI*MoreScroll\fP.  This way
multiple Scrolling modules can be used.

.SH INVOCATION
\fBScroll\fP can be invoked from a menu item as shown in the Synopsis
section above, or from binding "Module Scroll [\fIx y\fP]" to a key-stroke
in a \fIfeel\fP file, where the parameter x and y are integers, which
describe the horizontal and vertical window size reduction.

AfterStep will search through the directories specified in the
\fIModulePath\fP configuration in the \fIbase.#bpp\fP (where # is your
colordepth) to attempt to locate Scroll.

.SH CONFIGURATION OPTIONS
\fBScroll\fP reads the \fIscroll\fP file when it starts up and looks for
it's configuration options:

.IP "*ScrollFore \fIcolor\fP"
Tells the module to use \fIcolor\fP instead of grey for scroll bars 
themselves.

.IP "*ScrollBack \fIcolor\fP"
Tells the module to use \fIcolor\fP instead of black for the window
background.

.SH BUGS
When the scroll bars are removed by clicking on the button in the
lower right corner, the window does not restore its location
correctly.

.SH AUTHOR
Robert Nation
.nf
David Mihm <dmihm@swbell.net> [Man page]

.SH SEE ALSO
.BR afterstep (1)
