/*
 *
 *  (c) COPYRIGHT MIT and INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/*
 * the colorname database, the biggest the best ...
 * Needed to interpret colornames received.
 */

typedef struct ColornameElem
  {
     CHAR_T*             name;
     unsigned short      red;
     unsigned short      green;
     unsigned short      blue;
  }
ColornameElem;

static ColornameElem ColornameTable[] =
{
					     /* values recommended in the CSS draft *//* red ,green, blue */
   {TEXT("aqua"), /* #00ffff, */ 0, 255, 255},
   {TEXT("black"), /* #000000, */ 0, 0, 0},
   {TEXT("blue"), /* #0000ff, */ 0, 0, 255},
   {TEXT("fuchsia"), /* #ff00ff, */ 255, 0, 255},
   {TEXT("gray"), /* #808080, */ 128, 128, 128},
   {TEXT("green"), /* #008000, */ 0, 128, 0},
   {TEXT("lime"), /* #00ff00, */ 0, 255, 0},
   {TEXT("maroon"), /* #800000, */ 128, 0, 0},
   {TEXT("navy"), /* #000080, */ 0, 0, 128},
   {TEXT("olive"), /* #808000, */ 128, 128, 0},
   {TEXT("purple"), /* #800080 */ 128, 0, 128},
   {TEXT("red"), /* #ff0000, */ 255, 0, 0},
   {TEXT("silver"), /* #c0c0c0, */ 192, 192, 192},
   {TEXT("teal"), /* #008080, */ 0, 128, 128},
   {TEXT("white"), /* #ffffff, */ 255, 255, 255},
   {TEXT("yellow"), /* #ffff00, */ 255, 255, 0},

/* values recommended in the CSS draft old ones */
   {TEXT("cyan"), /* #00ffff, */ 0, 255, 255},
   {TEXT("magenta"), /* #ff00ff, */ 255, 0, 255},
   {TEXT("pink"), /* #ffc0cb, */ 255, 192, 203},
   {TEXT("brown"), /* #a52a2a, */ 165, 42, 42},
   {TEXT("gray"), /* #bebebe, */ 190, 190, 190},
   {TEXT("orange"), /* #ffa500, */ 255, 165, 0},
   {TEXT("purple"), /* #a020f0, */ 160, 32, 240},
   {TEXT("turquoise"), /* #40e0d0, */ 64, 224, 208},
   {TEXT("violet"), /* #ee82ee, */ 238, 130, 238},

/* other less commonly used values */
   {TEXT("AliceBlue"), /* #f0f8ff, */ 240, 248, 255},
   {TEXT("AntiqueWhite"), /* #faebd7, */ 250, 235, 215},
   {TEXT("AntiqueWhite1"), /* #ffefdb, */ 255, 239, 219},
   {TEXT("AntiqueWhite2"), /* #eedfcc, */ 238, 223, 204},
   {TEXT("AntiqueWhite3"), /* #cdc0b0, */ 205, 192, 176},
   {TEXT("AntiqueWhite4"), /* #8b8378, */ 139, 131, 120},
   {TEXT("aquamarine1"), /* #7fffd4, */ 127, 255, 212},
   {TEXT("aquamarine2"), /* #76eec6, */ 118, 238, 198},
   {TEXT("aquamarine4"), /* #458b74, */ 69, 139, 116},
   {TEXT("azure1"), /* #f0ffff, */ 240, 255, 255},
   {TEXT("azure2"), /* #e0eeee, */ 224, 238, 238},
   {TEXT("azure3"), /* #c1cdcd, */ 193, 205, 205},
   {TEXT("azure4"), /* #838b8b, */ 131, 139, 139},
   {TEXT("beige"), /* #f5f5dc, */ 245, 245, 220},
   {TEXT("bisque1"), /* #ffe4c4, */ 255, 228, 196},
   {TEXT("bisque2"), /* #eed5b7, */ 238, 213, 183},
   {TEXT("bisque3"), /* #cdb79e, */ 205, 183, 158},
   {TEXT("bisque4"), /* #8b7d6b, */ 139, 125, 107},
   {TEXT("BlanchedAlmond"), /* #ffebcd, */ 255, 235, 205},
   {TEXT("blue1"), /* #0000ff, */ 0, 0, 255},
   {TEXT("blue2"), /* #0000ee, */ 0, 0, 238},
   {TEXT("blue4"), /* #00008b, */ 0, 0, 139},
   {TEXT("BlueViolet"), /* #8a2be2, */ 138, 43, 226},
   {TEXT("brown1"), /* #ff4040, */ 255, 64, 64},
   {TEXT("brown2"), /* #ee3b3b, */ 238, 59, 59},
   {TEXT("brown3"), /* #cd3333, */ 205, 51, 51},
   {TEXT("brown4"), /* #8b2323, */ 139, 35, 35},
   {TEXT("burlywood"), /* #deb887, */ 222, 184, 135},
   {TEXT("burlywood1"), /* #ffd39b, */ 255, 211, 155},
   {TEXT("burlywood2"), /* #eec591, */ 238, 197, 145},
   {TEXT("burlywood3"), /* #cdaa7d, */ 205, 170, 125},
   {TEXT("burlywood4"), /* #8b7355, */ 139, 115, 85},
   {TEXT("CadetBlue"), /* #5f9ea0, */ 95, 158, 160},
   {TEXT("CadetBlue1"), /* #98f5ff, */ 152, 245, 255},
   {TEXT("CadetBlue2"), /* #8ee5ee, */ 142, 229, 238},
   {TEXT("CadetBlue3"), /* #7ac5cd, */ 122, 197, 205},
   {TEXT("CadetBlue4"), /* #53868b, */ 83, 134, 139},
   {TEXT("chartreuse1"), /* #7fff00, */ 127, 255, 0},
   {TEXT("chartreuse2"), /* #76ee00, */ 118, 238, 0},
   {TEXT("chartreuse3"), /* #66cd00, */ 102, 205, 0},
   {TEXT("chartreuse4"), /* #458b00, */ 69, 139, 0},
   {TEXT("chocolate"), /* #d2691e, */ 210, 105, 30},
   {TEXT("chocolate1"), /* #ff7f24, */ 255, 127, 36},
   {TEXT("chocolate2"), /* #ee7621, */ 238, 118, 33},
   {TEXT("chocolate3"), /* #cd661d, */ 205, 102, 29},
   {TEXT("coral"), /* #ff7f50, */ 255, 127, 80},
   {TEXT("coral1"), /* #ff7256, */ 255, 114, 86},
   {TEXT("coral2"), /* #ee6a50, */ 238, 106, 80},
   {TEXT("coral3"), /* #cd5b45, */ 205, 91, 69},
   {TEXT("coral4"), /* #8b3e2f, */ 139, 62, 47},
   {TEXT("CornflowerBlue"), /* #6495ed, */ 100, 149, 237},
   {TEXT("cornsilk1"), /* #fff8dc, */ 255, 248, 220},
   {TEXT("cornsilk2"), /* #eee8cd, */ 238, 232, 205},
   {TEXT("cornsilk3"), /* #cdc8b1, */ 205, 200, 177},
   {TEXT("cornsilk4"), /* #8b8878, */ 139, 136, 120},
   {TEXT("cyan1"), /* #00ffff, */ 0, 255, 255},
   {TEXT("cyan2"), /* #00eeee, */ 0, 238, 238},
   {TEXT("cyan3"), /* #00cdcd, */ 0, 205, 205},
   {TEXT("cyan4"), /* #008b8b, */ 0, 139, 139},
   {TEXT("DarkGoldenrod"), /* #b8860b, */ 184, 134, 11},
   {TEXT("DarkGoldenrod1"), /* #ffb90f, */ 255, 185, 15},
   {TEXT("DarkGoldenrod2"), /* #eead0e, */ 238, 173, 14},
   {TEXT("DarkGoldenrod3"), /* #cd950c, */ 205, 149, 12},
   {TEXT("DarkGoldenrod4"), /* #8b6508, */ 139, 101, 8},
   {TEXT("DarkGreen"), /* #006400, */ 0, 100, 0},
   {TEXT("DarkKhaki"), /* #bdb76b, */ 189, 183, 107},
   {TEXT("DarkOliveGreen"), /* #556b2f, */ 85, 107, 47},
   {TEXT("DarkOliveGreen1"), /* #caff70, */ 202, 255, 112},
   {TEXT("DarkOliveGreen2"), /* #bcee68, */ 188, 238, 104},
   {TEXT("DarkOliveGreen3"), /* #a2cd5a, */ 162, 205, 90},
   {TEXT("DarkOliveGreen4"), /* #6e8b3d, */ 110, 139, 61},
   {TEXT("DarkOrange"), /* #ff8c00, */ 255, 140, 0},
   {TEXT("DarkOrange1"), /* #ff7f00, */ 255, 127, 0},
   {TEXT("DarkOrange2"), /* #ee7600, */ 238, 118, 0},
   {TEXT("DarkOrange3"), /* #cd6600, */ 205, 102, 0},
   {TEXT("DarkOrange4"), /* #8b4500, */ 139, 69, 0},
   {TEXT("DarkOrchid"), /* #9932cc, */ 153, 50, 204},
   {TEXT("DarkOrchid1"), /* #bf3eff, */ 191, 62, 255},
   {TEXT("DarkOrchid2"), /* #b23aee, */ 178, 58, 238},
   {TEXT("DarkOrchid3"), /* #9a32cd, */ 154, 50, 205},
   {TEXT("DarkOrchid4"), /* #68228b, */ 104, 34, 139},
   {TEXT("DarkSalmon"), /* #e9967a, */ 233, 150, 122},
   {TEXT("DarkSeaGreen"), /* #8fbc8f, */ 143, 188, 143},
   {TEXT("DarkSeaGreen1"), /* #c1ffc1, */ 193, 255, 193},
   {TEXT("DarkSeaGreen2"), /* #b4eeb4, */ 180, 238, 180},
   {TEXT("DarkSeaGreen3"), /* #9bcd9b, */ 155, 205, 155},
   {TEXT("DarkSeaGreen4"), /* #698b69, */ 105, 139, 105},
   {TEXT("DarkSlateBlue"), /* #483d8b, */ 72, 61, 139},
   {TEXT("DarkSlateGray"), /* #2f4f4f, */ 47, 79, 79},
   {TEXT("DarkSlateGray1"), /* #97ffff, */ 151, 255, 255},
   {TEXT("DarkSlateGray2"), /* #8deeee, */ 141, 238, 238},
   {TEXT("DarkSlateGray3"), /* #79cdcd, */ 121, 205, 205},
   {TEXT("DarkSlateGray4"), /* #528b8b, */ 82, 139, 139},
   {TEXT("DarkTurquoise"), /* #00ced1, */ 0, 206, 209},
   {TEXT("DarkViolet"), /* #9400d3, */ 148, 0, 211},
   {TEXT("DeepPink1"), /* #ff1493, */ 255, 20, 147},
   {TEXT("DeepPink2"), /* #ee1289, */ 238, 18, 137},
   {TEXT("DeepPink3"), /* #cd1076, */ 205, 16, 118},
   {TEXT("DeepPink4"), /* #8b0a50, */ 139, 10, 80},
   {TEXT("DeepSkyBlue1"), /* #00bfff, */ 0, 191, 255},
   {TEXT("DeepSkyBlue2"), /* #00b2ee, */ 0, 178, 238},
   {TEXT("DeepSkyBlue3"), /* #009acd, */ 0, 154, 205},
   {TEXT("DeepSkyBlue4"), /* #00688b, */ 0, 104, 139},
   {TEXT("DimGray"), /* #696969, */ 105, 105, 105},
   {TEXT("DodgerBlue1"), /* #1e90ff, */ 30, 144, 255},
   {TEXT("DodgerBlue2"), /* #1c86ee, */ 28, 134, 238},
   {TEXT("DodgerBlue3"), /* #1874cd, */ 24, 116, 205},
   {TEXT("DodgerBlue4"), /* #104e8b, */ 16, 78, 139},
   {TEXT("firebrick"), /* #b22222, */ 178, 34, 34},
   {TEXT("firebrick1"), /* #ff3030, */ 255, 48, 48},
   {TEXT("firebrick2"), /* #ee2c2c, */ 238, 44, 44},
   {TEXT("firebrick3"), /* #cd2626, */ 205, 38, 38},
   {TEXT("firebrick4"), /* #8b1a1a, */ 139, 26, 26},
   {TEXT("FloralWhite"), /* #fffaf0, */ 255, 250, 240},
   {TEXT("ForestGreen"), /* #228b22, */ 34, 139, 34},
   {TEXT("gainsboro"), /* #dcdcdc, */ 220, 220, 220},
   {TEXT("GhostWhite"), /* #f8f8ff, */ 248, 248, 255},
   {TEXT("gold1"), /* #ffd700, */ 255, 215, 0},
   {TEXT("gold2"), /* #eec900, */ 238, 201, 0},
   {TEXT("gold3"), /* #cdad00, */ 205, 173, 0},
   {TEXT("gold4"), /* #8b7500, */ 139, 117, 0},
   {TEXT("goldenrod"), /* #daa520, */ 218, 165, 32},
   {TEXT("goldenrod1"), /* #ffc125, */ 255, 193, 37},
   {TEXT("goldenrod2"), /* #eeb422, */ 238, 180, 34},
   {TEXT("goldenrod3"), /* #cd9b1d, */ 205, 155, 29},
   {TEXT("goldenrod4"), /* #8b6914, */ 139, 105, 20},
   {TEXT("gray1"), /* #030303, */ 3, 3, 3},
   {TEXT("gray10"), /* #1a1a1a, */ 26, 26, 26},
   {TEXT("gray11"), /* #1c1c1c, */ 28, 28, 28},
   {TEXT("gray12"), /* #1f1f1f, */ 31, 31, 31},
   {TEXT("gray13"), /* #212121, */ 33, 33, 33},
   {TEXT("gray14"), /* #242424, */ 36, 36, 36},
   {TEXT("gray15"), /* #262626, */ 38, 38, 38},
   {TEXT("gray16"), /* #292929, */ 41, 41, 41},
   {TEXT("gray17"), /* #2b2b2b, */ 43, 43, 43},
   {TEXT("gray18"), /* #2e2e2e, */ 46, 46, 46},
   {TEXT("gray19"), /* #303030, */ 48, 48, 48},
   {TEXT("gray2"), /* #050505, */ 5, 5, 5},
   {TEXT("gray20"), /* #333333, */ 51, 51, 51},
   {TEXT("gray21"), /* #363636, */ 54, 54, 54},
   {TEXT("gray22"), /* #383838, */ 56, 56, 56},
   {TEXT("gray23"), /* #3b3b3b, */ 59, 59, 59},
   {TEXT("gray24"), /* #3d3d3d, */ 61, 61, 61},
   {TEXT("gray25"), /* #404040, */ 64, 64, 64},
   {TEXT("gray26"), /* #424242, */ 66, 66, 66},
   {TEXT("gray27"), /* #454545, */ 69, 69, 69},
   {TEXT("gray28"), /* #474747, */ 71, 71, 71},
   {TEXT("gray29"), /* #4a4a4a, */ 74, 74, 74},
   {TEXT("gray3"), /* #080808, */ 8, 8, 8},
   {TEXT("gray30"), /* #4d4d4d, */ 77, 77, 77},
   {TEXT("gray31"), /* #4f4f4f, */ 79, 79, 79},
   {TEXT("gray32"), /* #525252, */ 82, 82, 82},
   {TEXT("gray33"), /* #545454, */ 84, 84, 84},
   {TEXT("gray34"), /* #575757, */ 87, 87, 87},
   {TEXT("gray35"), /* #595959, */ 89, 89, 89},
   {TEXT("gray36"), /* #5c5c5c, */ 92, 92, 92},
   {TEXT("gray37"), /* #5e5e5e, */ 94, 94, 94},
   {TEXT("gray38"), /* #616161, */ 97, 97, 97},
   {TEXT("gray39"), /* #636363, */ 99, 99, 99},
   {TEXT("gray4"), /* #0a0a0a, */ 10, 10, 10},
   {TEXT("gray40"), /* #666666, */ 102, 102, 102},
   {TEXT("gray41"), /* #696969, */ 105, 105, 105},
   {TEXT("gray42"), /* #6b6b6b, */ 107, 107, 107},
   {TEXT("gray43"), /* #6e6e6e, */ 110, 110, 110},
   {TEXT("gray44"), /* #707070, */ 112, 112, 112},
   {TEXT("gray45"), /* #737373, */ 115, 115, 115},
   {TEXT("gray46"), /* #757575, */ 117, 117, 117},
   {TEXT("gray47"), /* #787878, */ 120, 120, 120},
   {TEXT("gray48"), /* #7a7a7a, */ 122, 122, 122},
   {TEXT("gray49"), /* #7d7d7d, */ 125, 125, 125},
   {TEXT("gray5"), /* #0d0d0d, */ 13, 13, 13},
   {TEXT("gray50"), /* #7f7f7f, */ 127, 127, 127},
   {TEXT("gray51"), /* #828282, */ 130, 130, 130},
   {TEXT("gray52"), /* #858585, */ 133, 133, 133},
   {TEXT("gray53"), /* #878787, */ 135, 135, 135},
   {TEXT("gray54"), /* #8a8a8a, */ 138, 138, 138},
   {TEXT("gray55"), /* #8c8c8c, */ 140, 140, 140},
   {TEXT("gray56"), /* #8f8f8f, */ 143, 143, 143},
   {TEXT("gray57"), /* #919191, */ 145, 145, 145},
   {TEXT("gray58"), /* #949494, */ 148, 148, 148},
   {TEXT("gray59"), /* #969696, */ 150, 150, 150},
   {TEXT("gray6"), /* #0f0f0f, */ 15, 15, 15},
   {TEXT("gray60"), /* #999999, */ 153, 153, 153},
   {TEXT("gray61"), /* #9c9c9c, */ 156, 156, 156},
   {TEXT("gray62"), /* #9e9e9e, */ 158, 158, 158},
   {TEXT("gray63"), /* #a1a1a1, */ 161, 161, 161},
   {TEXT("gray64"), /* #a3a3a3, */ 163, 163, 163},
   {TEXT("gray65"), /* #a6a6a6, */ 166, 166, 166},
   {TEXT("gray66"), /* #a8a8a8, */ 168, 168, 168},
   {TEXT("gray67"), /* #ababab, */ 171, 171, 171},
   {TEXT("gray68"), /* #adadad, */ 173, 173, 173},
   {TEXT("gray69"), /* #b0b0b0, */ 176, 176, 176},
   {TEXT("gray7"), /* #121212, */ 18, 18, 18},
   {TEXT("gray70"), /* #b3b3b3, */ 179, 179, 179},
   {TEXT("gray71"), /* #b5b5b5, */ 181, 181, 181},
   {TEXT("gray72"), /* #b8b8b8, */ 184, 184, 184},
   {TEXT("gray73"), /* #bababa, */ 186, 186, 186},
   {TEXT("gray74"), /* #bdbdbd, */ 189, 189, 189},
   {TEXT("gray75"), /* #bfbfbf, */ 191, 191, 191},
   {TEXT("gray76"), /* #c2c2c2, */ 194, 194, 194},
   {TEXT("gray77"), /* #c4c4c4, */ 196, 196, 196},
   {TEXT("gray78"), /* #c7c7c7, */ 199, 199, 199},
   {TEXT("gray79"), /* #c9c9c9, */ 201, 201, 201},
   {TEXT("gray8"), /* #141414, */ 20, 20, 20},
   {TEXT("gray80"), /* #cccccc, */ 204, 204, 204},
   {TEXT("gray81"), /* #cfcfcf, */ 207, 207, 207},
   {TEXT("gray82"), /* #d1d1d1, */ 209, 209, 209},
   {TEXT("gray83"), /* #d4d4d4, */ 212, 212, 212},
   {TEXT("gray84"), /* #d6d6d6, */ 214, 214, 214},
   {TEXT("gray85"), /* #d9d9d9, */ 217, 217, 217},
   {TEXT("gray86"), /* #dbdbdb, */ 219, 219, 219},
   {TEXT("gray87"), /* #dedede, */ 222, 222, 222},
   {TEXT("gray88"), /* #e0e0e0, */ 224, 224, 224},
   {TEXT("gray89"), /* #e3e3e3, */ 227, 227, 227},
   {TEXT("gray9"), /* #171717, */ 23, 23, 23},
   {TEXT("gray90"), /* #e5e5e5, */ 229, 229, 229},
   {TEXT("gray91"), /* #e8e8e8, */ 232, 232, 232},
   {TEXT("gray92"), /* #ebebeb, */ 235, 235, 235},
   {TEXT("gray93"), /* #ededed, */ 237, 237, 237},
   {TEXT("gray94"), /* #f0f0f0, */ 240, 240, 240},
   {TEXT("gray95"), /* #f2f2f2, */ 242, 242, 242},
   {TEXT("gray97"), /* #f7f7f7, */ 247, 247, 247},
   {TEXT("gray98"), /* #fafafa, */ 250, 250, 250},
   {TEXT("gray99"), /* #fcfcfc, */ 252, 252, 252},
   {TEXT("green1"), /* #00ff00, */ 0, 255, 0},
   {TEXT("green2"), /* #00ee00, */ 0, 238, 0},
   {TEXT("green3"), /* #00cd00, */ 0, 205, 0},
   {TEXT("green4"), /* #008b00, */ 0, 139, 0},
   {TEXT("GreenYellow"), /* #adff2f, */ 173, 255, 47},
   {TEXT("honeydew1"), /* #f0fff0, */ 240, 255, 240},
   {TEXT("honeydew2"), /* #e0eee0, */ 224, 238, 224},
   {TEXT("honeydew3"), /* #c1cdc1, */ 193, 205, 193},
   {TEXT("honeydew4"), /* #838b83, */ 131, 139, 131},
   {TEXT("HotPink"), /* #ff69b4, */ 255, 105, 180},
   {TEXT("HotPink1"), /* #ff6eb4, */ 255, 110, 180},
   {TEXT("HotPink2"), /* #ee6aa7, */ 238, 106, 167},
   {TEXT("HotPink3"), /* #cd6090, */ 205, 96, 144},
   {TEXT("HotPink4"), /* #8b3a62, */ 139, 58, 98},
   {TEXT("IndianRed"), /* #cd5c5c, */ 205, 92, 92},
   {TEXT("IndianRed1"), /* #ff6a6a, */ 255, 106, 106},
   {TEXT("IndianRed2"), /* #ee6363, */ 238, 99, 99},
   {TEXT("IndianRed3"), /* #cd5555, */ 205, 85, 85},
   {TEXT("IndianRed4"), /* #8b3a3a, */ 139, 58, 58},
   {TEXT("ivory1"), /* #fffff0, */ 255, 255, 240},
   {TEXT("ivory2"), /* #eeeee0, */ 238, 238, 224},
   {TEXT("ivory3"), /* #cdcdc1, */ 205, 205, 193},
   {TEXT("ivory4"), /* #8b8b83, */ 139, 139, 131},
   {TEXT("khaki"), /* #f0e68c, */ 240, 230, 140},
   {TEXT("khaki1"), /* #fff68f, */ 255, 246, 143},
   {TEXT("khaki2"), /* #eee685, */ 238, 230, 133},
   {TEXT("khaki3"), /* #cdc673, */ 205, 198, 115},
   {TEXT("khaki4"), /* #8b864e, */ 139, 134, 78},
   {TEXT("lavender"), /* #e6e6fa, */ 230, 230, 250},
   {TEXT("LavenderBlush1"), /* #fff0f5, */ 255, 240, 245},
   {TEXT("LavenderBlush2"), /* #eee0e5, */ 238, 224, 229},
   {TEXT("LavenderBlush3"), /* #cdc1c5, */ 205, 193, 197},
   {TEXT("LavenderBlush4"), /* #8b8386, */ 139, 131, 134},
   {TEXT("LawnGreen"), /* #7cfc00, */ 124, 252, 0},
   {TEXT("LemonChiffon1"), /* #fffacd, */ 255, 250, 205},
   {TEXT("LemonChiffon2"), /* #eee9bf, */ 238, 233, 191},
   {TEXT("LemonChiffon3"), /* #cdc9a5, */ 205, 201, 165},
   {TEXT("LemonChiffon4"), /* #8b8970, */ 139, 137, 112},
   {TEXT("light"), /* #eedd82, */ 238, 221, 130},
   {TEXT("LightBlue"), /* #add8e6, */ 173, 216, 230},
   {TEXT("LightBlue1"), /* #bfefff, */ 191, 239, 255},
   {TEXT("LightBlue2"), /* #b2dfee, */ 178, 223, 238},
   {TEXT("LightBlue3"), /* #9ac0cd, */ 154, 192, 205},
   {TEXT("LightBlue4"), /* #68838b, */ 104, 131, 139},
   {TEXT("LightCoral"), /* #f08080, */ 240, 128, 128},
   {TEXT("LightCyan1"), /* #e0ffff, */ 224, 255, 255},
   {TEXT("LightCyan2"), /* #d1eeee, */ 209, 238, 238},
   {TEXT("LightCyan3"), /* #b4cdcd, */ 180, 205, 205},
   {TEXT("LightCyan4"), /* #7a8b8b, */ 122, 139, 139},
   {TEXT("LightGoldenrod1"), /* #ffec8b, */ 255, 236, 139},
   {TEXT("LightGoldenrod2"), /* #eedc82, */ 238, 220, 130},
   {TEXT("LightGoldenrod3"), /* #cdbe70, */ 205, 190, 112},
   {TEXT("LightGoldenrod4"), /* #8b814c, */ 139, 129, 76},
   {TEXT("LightGoldenrodYellow"), /* #fafad2, */ 250, 250, 210},
   {TEXT("LightGray"), /* #d3d3d3, */ 211, 211, 211},
   {TEXT("LightPink"), /* #ffb6c1, */ 255, 182, 193},
   {TEXT("LightPink1"), /* #ffaeb9, */ 255, 174, 185},
   {TEXT("LightPink2"), /* #eea2ad, */ 238, 162, 173},
   {TEXT("LightPink3"), /* #cd8c95, */ 205, 140, 149},
   {TEXT("LightPink4"), /* #8b5f65, */ 139, 95, 101},
   {TEXT("LightSalmon1"), /* #ffa07a, */ 255, 160, 122},
   {TEXT("LightSalmon2"), /* #ee9572, */ 238, 149, 114},
   {TEXT("LightSalmon3"), /* #cd8162, */ 205, 129, 98},
   {TEXT("LightSalmon4"), /* #8b5742, */ 139, 87, 66},
   {TEXT("LightSeaGreen"), /* #20b2aa, */ 32, 178, 170},
   {TEXT("LightSkyBlue"), /* #87cefa, */ 135, 206, 250},
   {TEXT("LightSkyBlue1"), /* #b0e2ff, */ 176, 226, 255},
   {TEXT("LightSkyBlue2"), /* #a4d3ee, */ 164, 211, 238},
   {TEXT("LightSkyBlue3"), /* #8db6cd, */ 141, 182, 205},
   {TEXT("LightSkyBlue4"), /* #607b8b, */ 96, 123, 139},
   {TEXT("LightSlateBlue"), /* #8470ff, */ 132, 112, 255},
   {TEXT("LightSlateGray"), /* #778899, */ 119, 136, 153},
   {TEXT("LightSteelBlue"), /* #b0c4de, */ 176, 196, 222},
   {TEXT("LightSteelBlue1"), /* #cae1ff, */ 202, 225, 255},
   {TEXT("LightSteelBlue2"), /* #bcd2ee, */ 188, 210, 238},
   {TEXT("LightSteelBlue3"), /* #a2b5cd, */ 162, 181, 205},
   {TEXT("LightSteelBlue4"), /* #6e7b8b, */ 110, 123, 139},
   {TEXT("LightYellow1"), /* #ffffe0, */ 255, 255, 224},
   {TEXT("LightYellow2"), /* #eeeed1, */ 238, 238, 209},
   {TEXT("LightYellow3"), /* #cdcdb4, */ 205, 205, 180},
   {TEXT("LightYellow4"), /* #8b8b7a, */ 139, 139, 122},
   {TEXT("LimeGreen"), /* #32cd32, */ 50, 205, 50},
   {TEXT("linen"), /* #faf0e6, */ 250, 240, 230},
   {TEXT("magenta"), /* #ff00ff, */ 255, 0, 255},
   {TEXT("magenta2"), /* #ee00ee, */ 238, 0, 238},
   {TEXT("magenta3"), /* #cd00cd, */ 205, 0, 205},
   {TEXT("magenta4"), /* #8b008b, */ 139, 0, 139},
   {TEXT("maroon"), /* #b03060, */ 176, 48, 96},
   {TEXT("maroon1"), /* #ff34b3, */ 255, 52, 179},
   {TEXT("maroon2"), /* #ee30a7, */ 238, 48, 167},
   {TEXT("maroon3"), /* #cd2990, */ 205, 41, 144},
   {TEXT("maroon4"), /* #8b1c62, */ 139, 28, 98},
   {TEXT("medium"), /* #66cdaa, */ 102, 205, 170},
   {TEXT("MediumAquamarine"), /* #66cdaa, */ 102, 205, 170},
   {TEXT("MediumBlue"), /* #0000cd, */ 0, 0, 205},
   {TEXT("MediumOrchid"), /* #ba55d3, */ 186, 85, 211},
   {TEXT("MediumOrchid1"), /* #e066ff, */ 224, 102, 255},
   {TEXT("MediumOrchid2"), /* #d15fee, */ 209, 95, 238},
   {TEXT("MediumOrchid3"), /* #b452cd, */ 180, 82, 205},
   {TEXT("MediumOrchid4"), /* #7a378b, */ 122, 55, 139},
   {TEXT("MediumPurple"), /* #9370db, */ 147, 112, 219},
   {TEXT("MediumPurple1"), /* #ab82ff, */ 171, 130, 255},
   {TEXT("MediumPurple2"), /* #9f79ee, */ 159, 121, 238},
   {TEXT("MediumPurple3"), /* #8968cd, */ 137, 104, 205},
   {TEXT("MediumPurple4"), /* #5d478b, */ 93, 71, 139},
   {TEXT("MediumSeaGreen"), /* #3cb371, */ 60, 179, 113},
   {TEXT("MediumSlateBlue"), /* #7b68ee, */ 123, 104, 238},
   {TEXT("MediumSpringGreen"), /* #00fa9a, */ 0, 250, 154},
   {TEXT("MediumTurquoise"), /* #48d1cc, */ 72, 209, 204},
   {TEXT("MediumVioletRed"), /* #c71585, */ 199, 21, 133},
   {TEXT("MidnightBlue"), /* #191970, */ 25, 25, 112},
   {TEXT("MintCream"), /* #f5fffa, */ 245, 255, 250},
   {TEXT("MistyRose1"), /* #ffe4e1, */ 255, 228, 225},
   {TEXT("MistyRose2"), /* #eed5d2, */ 238, 213, 210},
   {TEXT("MistyRose3"), /* #cdb7b5, */ 205, 183, 181},
   {TEXT("MistyRose4"), /* #8b7d7b, */ 139, 125, 123},
   {TEXT("moccasin"), /* #ffe4b5, */ 255, 228, 181},
   {TEXT("NavajoWhite1"), /* #ffdead, */ 255, 222, 173},
   {TEXT("NavajoWhite2"), /* #eecfa1, */ 238, 207, 161},
   {TEXT("NavajoWhite3"), /* #cdb38b, */ 205, 179, 139},
   {TEXT("NavajoWhite4"), /* #8b795e, */ 139, 121, 94},
   {TEXT("NavyBlue"), /* #000080, */ 0, 0, 128},
   {TEXT("OldLace"), /* #fdf5e6, */ 253, 245, 230},
   {TEXT("OliveDrab"), /* #6b8e23, */ 107, 142, 35},
   {TEXT("OliveDrab1"), /* #c0ff3e, */ 192, 255, 62},
   {TEXT("OliveDrab2"), /* #b3ee3a, */ 179, 238, 58},
   {TEXT("OliveDrab4"), /* #698b22, */ 105, 139, 34},
   {TEXT("orange1"), /* #ffa500, */ 255, 165, 0},
   {TEXT("orange2"), /* #ee9a00, */ 238, 154, 0},
   {TEXT("orange3"), /* #cd8500, */ 205, 133, 0},
   {TEXT("orange4"), /* #8b5a00, */ 139, 90, 0},
   {TEXT("OrangeRed1"), /* #ff4500, */ 255, 69, 0},
   {TEXT("OrangeRed2"), /* #ee4000, */ 238, 64, 0},
   {TEXT("OrangeRed3"), /* #cd3700, */ 205, 55, 0},
   {TEXT("OrangeRed4"), /* #8b2500, */ 139, 37, 0},
   {TEXT("orchid"), /* #da70d6, */ 218, 112, 214},
   {TEXT("orchid1"), /* #ff83fa, */ 255, 131, 250},
   {TEXT("orchid2"), /* #ee7ae9, */ 238, 122, 233},
   {TEXT("orchid3"), /* #cd69c9, */ 205, 105, 201},
   {TEXT("orchid4"), /* #8b4789, */ 139, 71, 137},
   {TEXT("pale"), /* #db7093, */ 219, 112, 147},
   {TEXT("PaleGoldenrod"), /* #eee8aa, */ 238, 232, 170},
   {TEXT("PaleGreen"), /* #98fb98, */ 152, 251, 152},
   {TEXT("PaleGreen1"), /* #9aff9a, */ 154, 255, 154},
   {TEXT("PaleGreen2"), /* #90ee90, */ 144, 238, 144},
   {TEXT("PaleGreen3"), /* #7ccd7c, */ 124, 205, 124},
   {TEXT("PaleGreen4"), /* #548b54, */ 84, 139, 84},
   {TEXT("PaleTurquoise"), /* #afeeee, */ 175, 238, 238},
   {TEXT("PaleTurquoise1"), /* #bbffff, */ 187, 255, 255},
   {TEXT("PaleTurquoise2"), /* #aeeeee, */ 174, 238, 238},
   {TEXT("PaleTurquoise3"), /* #96cdcd, */ 150, 205, 205},
   {TEXT("PaleTurquoise4"), /* #668b8b, */ 102, 139, 139},
   {TEXT("PaleVioletRed"), /* #db7093, */ 219, 112, 147},
   {TEXT("PaleVioletRed1"), /* #ff82ab, */ 255, 130, 171},
   {TEXT("PaleVioletRed2"), /* #ee799f, */ 238, 121, 159},
   {TEXT("PaleVioletRed3"), /* #cd6889, */ 205, 104, 137},
   {TEXT("PaleVioletRed4"), /* #8b475d, */ 139, 71, 93},
   {TEXT("PapayaWhip"), /* #ffefd5, */ 255, 239, 213},
   {TEXT("PeachPuff1"), /* #ffdab9, */ 255, 218, 185},
   {TEXT("PeachPuff2"), /* #eecbad, */ 238, 203, 173},
   {TEXT("PeachPuff3"), /* #cdaf95, */ 205, 175, 149},
   {TEXT("PeachPuff4"), /* #8b7765, */ 139, 119, 101},
   {TEXT("pink1"), /* #ffb5c5, */ 255, 181, 197},
   {TEXT("pink2"), /* #eea9b8, */ 238, 169, 184},
   {TEXT("pink3"), /* #cd919e, */ 205, 145, 158},
   {TEXT("pink4"), /* #8b636c, */ 139, 99, 108},
   {TEXT("plum"), /* #dda0dd, */ 221, 160, 221},
   {TEXT("plum1"), /* #ffbbff, */ 255, 187, 255},
   {TEXT("plum2"), /* #eeaeee, */ 238, 174, 238},
   {TEXT("plum3"), /* #cd96cd, */ 205, 150, 205},
   {TEXT("plum4"), /* #8b668b, */ 139, 102, 139},
   {TEXT("PowderBlue"), /* #b0e0e6, */ 176, 224, 230},
   {TEXT("purple1"), /* #9b30ff, */ 155, 48, 255},
   {TEXT("purple2"), /* #912cee, */ 145, 44, 238},
   {TEXT("purple3"), /* #7d26cd, */ 125, 38, 205},
   {TEXT("purple4"), /* #551a8b, */ 85, 26, 139},
   {TEXT("red1"), /* #ff0000, */ 255, 0, 0},
   {TEXT("red2"), /* #ee0000, */ 238, 0, 0},
   {TEXT("red3"), /* #cd0000, */ 205, 0, 0},
   {TEXT("red4"), /* #8b0000, */ 139, 0, 0},
   {TEXT("RosyBrown"), /* #bc8f8f, */ 188, 143, 143},
   {TEXT("RosyBrown1"), /* #ffc1c1, */ 255, 193, 193},
   {TEXT("RosyBrown2"), /* #eeb4b4, */ 238, 180, 180},
   {TEXT("RosyBrown3"), /* #cd9b9b, */ 205, 155, 155},
   {TEXT("RosyBrown4"), /* #8b6969, */ 139, 105, 105},
   {TEXT("RoyalBlue"), /* #4169e1, */ 65, 105, 225},
   {TEXT("RoyalBlue1"), /* #4876ff, */ 72, 118, 255},
   {TEXT("RoyalBlue2"), /* #436eee, */ 67, 110, 238},
   {TEXT("RoyalBlue3"), /* #3a5fcd, */ 58, 95, 205},
   {TEXT("RoyalBlue4"), /* #27408b, */ 39, 64, 139},
   {TEXT("SaddleBrown"), /* #8b4513, */ 139, 69, 19},
   {TEXT("salmon"), /* #fa8072, */ 250, 128, 114},
   {TEXT("salmon1"), /* #ff8c69, */ 255, 140, 105},
   {TEXT("salmon2"), /* #ee8262, */ 238, 130, 98},
   {TEXT("salmon3"), /* #cd7054, */ 205, 112, 84},
   {TEXT("salmon4"), /* #8b4c39, */ 139, 76, 57},
   {TEXT("SandyBrown"), /* #f4a460, */ 244, 164, 96},
   {TEXT("SeaGreen1"), /* #54ff9f, */ 84, 255, 159},
   {TEXT("SeaGreen2"), /* #4eee94, */ 78, 238, 148},
   {TEXT("SeaGreen3"), /* #43cd80, */ 67, 205, 128},
   {TEXT("SeaGreen4"), /* #2e8b57, */ 46, 139, 87},
   {TEXT("seashell1"), /* #fff5ee, */ 255, 245, 238},
   {TEXT("seashell2"), /* #eee5de, */ 238, 229, 222},
   {TEXT("seashell3"), /* #cdc5bf, */ 205, 197, 191},
   {TEXT("seashell4"), /* #8b8682, */ 139, 134, 130},
   {TEXT("sienna"), /* #a0522d, */ 160, 82, 45},
   {TEXT("sienna1"), /* #ff8247, */ 255, 130, 71},
   {TEXT("sienna2"), /* #ee7942, */ 238, 121, 66},
   {TEXT("sienna3"), /* #cd6839, */ 205, 104, 57},
   {TEXT("sienna4"), /* #8b4726, */ 139, 71, 38},
   {TEXT("SkyBlue"), /* #87ceeb, */ 135, 206, 235},
   {TEXT("SkyBlue1"), /* #87ceff, */ 135, 206, 255},
   {TEXT("SkyBlue2"), /* #7ec0ee, */ 126, 192, 238},
   {TEXT("SkyBlue3"), /* #6ca6cd, */ 108, 166, 205},
   {TEXT("SkyBlue4"), /* #4a708b, */ 74, 112, 139},
   {TEXT("SlateBlue"), /* #6a5acd, */ 106, 90, 205},
   {TEXT("SlateBlue1"), /* #836fff, */ 131, 111, 255},
   {TEXT("SlateBlue2"), /* #7a67ee, */ 122, 103, 238},
   {TEXT("SlateBlue3"), /* #6959cd, */ 105, 89, 205},
   {TEXT("SlateBlue4"), /* #473c8b, */ 71, 60, 139},
   {TEXT("SlateGray"), /* #708090, */ 112, 128, 144},
   {TEXT("SlateGray1"), /* #c6e2ff, */ 198, 226, 255},
   {TEXT("SlateGray2"), /* #b9d3ee, */ 185, 211, 238},
   {TEXT("SlateGray3"), /* #9fb6cd, */ 159, 182, 205},
   {TEXT("SlateGray4"), /* #6c7b8b, */ 108, 123, 139},
   {TEXT("snow1"), /* #fffafa, */ 255, 250, 250},
   {TEXT("snow2"), /* #eee9e9, */ 238, 233, 233},
   {TEXT("snow3"), /* #cdc9c9, */ 205, 201, 201},
   {TEXT("snow4"), /* #8b8989, */ 139, 137, 137},
   {TEXT("SpringGreen1"), /* #00ff7f, */ 0, 255, 127},
   {TEXT("SpringGreen2"), /* #00ee76, */ 0, 238, 118},
   {TEXT("SpringGreen3"), /* #00cd66, */ 0, 205, 102},
   {TEXT("SpringGreen4"), /* #008b45, */ 0, 139, 69},
   {TEXT("SteelBlue"), /* #4682b4, */ 70, 130, 180},
   {TEXT("SteelBlue1"), /* #63b8ff, */ 99, 184, 255},
   {TEXT("SteelBlue2"), /* #5cacee, */ 92, 172, 238},
   {TEXT("SteelBlue3"), /* #4f94cd, */ 79, 148, 205},
   {TEXT("SteelBlue4"), /* #36648b, */ 54, 100, 139},
   {TEXT("tan"), /* #d2b48c, */ 210, 180, 140},
   {TEXT("tan1"), /* #ffa54f, */ 255, 165, 79},
   {TEXT("tan2"), /* #ee9a49, */ 238, 154, 73},
   {TEXT("tan3"), /* #cd853f, */ 205, 133, 63},
   {TEXT("tan4"), /* #8b5a2b, */ 139, 90, 43},
   {TEXT("thistle"), /* #d8bfd8, */ 216, 191, 216},
   {TEXT("thistle1"), /* #ffe1ff, */ 255, 225, 255},
   {TEXT("thistle2"), /* #eed2ee, */ 238, 210, 238},
   {TEXT("thistle3"), /* #cdb5cd, */ 205, 181, 205},
   {TEXT("thistle4"), /* #8b7b8b, */ 139, 123, 139},
   {TEXT("tomato1"), /* #ff6347, */ 255, 99, 71},
   {TEXT("tomato2"), /* #ee5c42, */ 238, 92, 66},
   {TEXT("tomato3"), /* #cd4f39, */ 205, 79, 57},
   {TEXT("tomato4"), /* #8b3626, */ 139, 54, 38},
   {TEXT("turquoise1"), /* #00f5ff, */ 0, 245, 255},
   {TEXT("turquoise2"), /* #00e5ee, */ 0, 229, 238},
   {TEXT("turquoise3"), /* #00c5cd, */ 0, 197, 205},
   {TEXT("turquoise4"), /* #00868b, */ 0, 134, 139},
   {TEXT("VioletRed"), /* #d02090, */ 208, 32, 144},
   {TEXT("VioletRed1"), /* #ff3e96, */ 255, 62, 150},
   {TEXT("VioletRed2"), /* #ee3a8c, */ 238, 58, 140},
   {TEXT("VioletRed3"), /* #cd3278, */ 205, 50, 120},
   {TEXT("VioletRed4"), /* #8b2252, */ 139, 34, 82},
   {TEXT("wheat"), /* #f5deb3, */ 245, 222, 179},
   {TEXT("wheat1"), /* #ffe7ba, */ 255, 231, 186},
   {TEXT("wheat2"), /* #eed8ae, */ 238, 216, 174},
   {TEXT("wheat3"), /* #cdba96, */ 205, 186, 150},
   {TEXT("wheat4"), /* #8b7e66, */ 139, 126, 102},
   {TEXT("WhiteSmoke"), /* #f5f5f5, */ 245, 245, 245},
   {TEXT("yellow1"), /* #ffff00, */ 255, 255, 0},
   {TEXT("yellow2"), /* #eeee00, */ 238, 238, 0},
   {TEXT("yellow3"), /* #cdcd00, */ 205, 205, 0},
   {TEXT("yellow4"), /* #8b8b00, */ 139, 139, 0},
   {TEXT("YellowGreen"), /* #9acd32, */ 154, 205, 50}
};

#define NBCOLORNAME (sizeof(ColornameTable)/sizeof(ColornameTable[0]))
