<?xml version="1.0" encoding="iso-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <title>Anotaciones en Amaya</title>
  <meta name="GENERATOR" content="amaya 5.2" />
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
</head>

<body xml:lang="es" lang="es">

<table border="0" summary="toc">
  <tbody>
    <tr>
      <td><img alt="W3C" src="../images/w3c_home" /> <img alt="Amaya"
        src="../images/amaya.gif" /></td>
      <td><p><a href="MakeBook.html" accesskey="p"><img alt="previa"
        src="../images/left.gif" /></a> <a href="Manual.html"
        accesskey="t"><img alt="arriba" src="../images/up.gif" /></a> <a
        href="Configure.html" accesskey="n"><img alt="siguiente"
        src="../images/right.gif" /></a></p>
      </td>
    </tr>
  </tbody>
</table>
<ul>
  <li><a href="#What">Qu es una Anotacin?</a></li>
  <li><a href="#Local">Anotaciones Locales y Remotas</a></li>
  <li><a href="#Annotation">El Men Anotaciones</a></li>
  <li><a href="#Configurat">Preparando la Configuracin para las
    Anotaciones</a></li>
  <li><a href="#Creating1">Creando una Anotacin</a></li>
  <li><a href="#Deleting">Borrando una Anotacin</a></li>
  <li><a href="#Loading">Cargando y Presentando Anotaciones</a></li>
  <li><a href="#Navigating">Navegando entre Anotaciones</a></li>
  <li><a href="#Moving">Moviendo Anotaciones</a></li>
  <li><a href="#Issues1">Problemas con Anotaciones y Documentos
    Modificados</a></li>
</ul>

<div id="Annotations">
<h2>Anotaciones en Amaya</h2>

<h3><a name="What">Qu es una Anotacin?</a></h3>

<p>La anotaciones son comentarios, notas, explicaciones, u otro tipo de
observaciones que pueden adjuntarse a un documento Web o a una parte
seleccionada del documento. Como son externas es posible anotar cualquier
documento Web de manera independiente, sin necesidad de editar ese documento.
Desde el punto de vista tcnico, las anotaciones normalmente son vistas como
<b>metadatos</b>, ya que dan informacin adicional sobre una porcin
existente de datos. En este proyecto, para describir las anotaciones usamos
un <strong><a href="http://www.w3.org/RDF/">RDF</a></strong> <a
href="http://www.w3.org/2000/10/annotation-ns">annotation schema</a>
especial.</p>

<p>Las anotaciones pueden guardarse localmente o en uno o ms <b>servidores
de anotaciones</b>. Cuando un documento es hojeado, Amaya llama a cada uno de
esos servidores, solicitando las anotaciones relacionadas con el documento.
Actualmente Amaya presenta las anotaciones con los iconos de anotacin ( <img
src="../images/annot.png" alt="Icono lpiz de anotacin" /> ) que estn
visualmente incrustados en el documento, como se muestra en la figura de
abajo. Si el usuario hace un nico clic sobre un icono de anotacin, el texto
que ha sido anotado se resalta. Si el usuario hace doble clic sobre este
icono, el texto de la anotacin y otros metadatos se presentan en una ventana
aparte.</p>

<p style="text-align: center"><img src="../images/annotationicon-es.png"
alt="icono de anotacin (= lpiz)" /></p>

<p>Una anotacin tiene muchas propiedades, incluyendo:</p>
<ul>
  <li>Localizacin fsica: La anotacin est almacenada en un archivo local
    o en una servidor de anotaciones?</li>
  <li>Alcance: Est la anotacin asociada a todo el documento o slo a un
    fragmento de ese documento?</li>
  <li>Tipo de anotacin: '<i xml:lang="en" lang="en">Anotacin</i>', '<i
    xml:lang="en" lang="en">Comentario</i>', '<i xml:lang="en"
    lang="en">Consulta</i>', ...</li>
</ul>

<h3 id="Local">Anotaciones locales y remotas</h3>

<p>Amaya puede guardar datos de anotaciones en un sistema de archivo local
(llamado "anotaciones locales") o en la Web (llamado "anotaciones remotas").
<b>Anotaciones remotas</b> son las almacenadas en servidores de anotaciones y
pueden ser descargadas y almacenadas por cualquiera que tenga los apropiados
derechos de acceso, tal como en el caso de otros documentos <acronym
title="HyperText Markup Language" xml:lang="en" lang="en">HTML</acronym>.
Tambin nos referimos a anotaciones remotas como <b>anotaciones pblicas o
compartidas</b>, ya que pueden ser vistas por otras personas. Si deseas
instalar tu propio servidor de anotaciones, por favor, ve a <a
href="http://www.w3.org/1999/02/26-modules/User/Annotations-HOWTO.html">Annotation-Server-HOWTO</a>.</p>

<p>El usuario no necesita un servidor para hacer una <b>anotacin local</b>.
Las anotaciones locales se almacenan en el <a
href="/home/kahan/Amaya/doc/amaya/Configure.html">directorio de preferencias
de usuario</a>, en un directorio especial llamado "<code>annotations</code>",
y slo puede ser visto por el dueo (de acuerdo a cmo est organizado el
sistema de derechos de acceso). Este directorio est conformado por tres
tipos de ficheros:</p>
<dl>
  <dt><strong>annot.index</strong></dt>
    <dd>asocia <acronym title="Uniform Resource Locator" xml:lang="en"
      lang="en">URLs</acronym> con los archivos en los que se almacenan los
      metadatos de las anotaciones.</dd>
  <dt><strong>index + random suffix</strong></dt>
    <dd>un fichero que almacena el metadato de las anotaciones relacionadas
      con una <acronym title="Uniform Resource Locator" xml:lang="en"
      lang="en">URL</acronym> dada. El metadato se especifica con RDF.</dd>
  <dt><strong>annot + random suffix.html</strong></dt>
    <dd>contiene el cuerpo de una anotacin, almacenado como <acronym
      title="EXtensible HTML" xml:lang="en" lang="en">XHTML</acronym>.</dd>
</dl>

<p>Un usuario puede, en cualquier momento, convertir una anotacin local en
una compartida usando la opcin de men <strong>Anotaciones/Post
anotacin</strong>. Si esta operacin tiene xito, la anotacin local ser
borrada ya que ser movida a un servidor de anotacion. La siguiente seccin
describe cmo indicar el nombre del servidor en el que deberan colocarse las
anotaciones.</p>

<h3 id="Annotation">Men Anotaciones</h3>

<p>La mayora de los comandos necesarios para manejar anotaciones se
encuentran en el men Anotaciones mostrado abajo. Los comandos se explican
ms adelante en este documento, en el contexto de las metas del usuario
cuando maneja anotaciones.</p>

<p style="text-align: center"><img src="../images/annotationsmenu-es.png"
alt="Men Anotaciones" /></p>

<h3 id="Configurat">Preparando la Configuracin para las Anotaciones</h3>

<p>El men de configuracin de anotaciones se encuentra bajo la opcin de
men <strong>Anotaciones/Configurar</strong>. La siguiente figura muestra la
versin Windows de este men. La versin Unix tiene una interfaz de usuario
un tanto diferente, pero las mismas funcionalidades.</p>

<p style="text-align: center"><img src="../images/configurebox-es.png"
alt="cuadro de dilogo de configuracin" /></p>

<p></p>
<dl>
  <dt><strong>Anotacin de usuario</strong></dt>
    <dd>Un campo que est asociado con cada nueva anotacin como el
      <b>autor</b> de la anotacin. Amaya utiliza, por defecto, el
      identificador de usuario de la persona, cuando crea el campo de
      metadato autor. La seleccin de la anotacin de usuario le permite a un
      usuario cambiar este nombre por uno ms significativo, por ejemplo, en
      vez de <code>u1723242</code> (que hace felz a mi administrador de
      sistema) <code>marja</code> (que es el que usan otras personas
      normalmente cuando hablan conmigo).</dd>
  <dt><strong>Servidores de Anotaciones</strong></dt>
    <dd>Este campo le dice a Amaya qu servidores debe contactar cuando
      busque anotaciones. Se pueden especificar uno o ms servidores. Hemos
      reservado el nombre de servidor localhost para decirle a Amaya que
      queremos buscar anotaciones locales. Esto no significa que estemos
      poniendo en marcha un servidor local de anotaciones. Si este fuera el
      caso, necesitaramos indicar la <acronym
      title="Uniform Resource Locator" xml:lang="en" lang="en">URL</acronym>
      completa. Bajo Unix, los servidores de anotacin se especifican como
      una lista separada por espacios. Bajo Windows, son aadidos uno tras
      otro tecleando sus nombres directamente en el cuadro de dilogo,
      utilizando la tecla <code>Enter</code> para aadir uno nuevo. Por
      defecto, el campo para servidores de anotaciones indica un
      <code>localhost</code>. 
      <p><em>Truco</em>: Si quieres deshabilitar temporalmente un servidor de
      anotacin, aade el carcter "-" antes de su <acronym
      title="Uniform Resource Locator" xml:lang="en" lang="en">URL</acronym>.
      Amaya lo ignorar.</p>
    </dd>
  <dt><strong>Autocargar anotaciones locales/Autocargar anotaciones
  remotas</strong></dt>
    <dd>Esta opcin le dice a Amaya si solicita o no anotaciones,
      automticamente (esto es, consultar a los servidores de anotaciones)
      cada vez que una <acronym title="Uniform Resource Locator"
      xml:lang="en" lang="en">URL</acronym> es navegada. Si no est
      seleccionada, entonces el usuario tiene que invocar manualmente la
      funcin <b>Cargar anotaciones</b> desde el men <b>Anotaciones</b>.
      Ntese que si se selecciona la opcin <code>autocargar anotaciones
      remotas</code>, puede haber un retraso mientras Amaya resuelve el
      nombre de DNS de los servidores de anotacin. Por defecto ambas
      opciones aparecen sin seleccionar.</dd>
  <dt><strong>Deshabilitar autocarga remota en cada inicio</strong></dt>
    <dd>Si esta opcin est seleccionada, Amaya restablecer la opcin
      <code>autocargar anotaciones remotas</code> cada vez que se inicie.
      Esta opcin puede ser til si ests trabajando desconectado a ratos,
      pero seguir queriendo autocargar las anotaciones locales, y las
      remotas de vez en cuando, por ejemplo, cuando te conectas durante un
      rato.</dd>
  <dt><strong>Servidor de publicacin</strong></dt>
    <dd><p>Este campo define el servidor en el que sern publicadas las
      anotaciones. Las anotaciones locales se guardan siempre en una base de
      datos local, independientemente del valor de este campo. Por defecto
      este campo est vaco. Advierte que el servidor de publicacin no est
      incluido automticamente en la lista de servidores a ser consultados,
      se debe indicar el nombre del servidor de publicacin en ambos campos,
      en cualquier orden que t elijas.</p>
    </dd>
</dl>

<h3 id="Creating">Creando una anotacin</h3>

<p>Esta versin de Amaya soporta dos tipos de anotaciones: anotaciones que se
refieren a un documento completo y anotaciones que se refieren a un punto
especfico o seleccin en un documento.</p>

<p>Para anotar un documento completo, tan solo selecciona la opcin de
men</p>

<h2></h2>

<p><b>Anotaciones/Anotar documento</b>. Para anotar un punto, pon el cursor
en cualquier punto en el documento y selecciona la opcin de men
<b>Anotaciones/Seleccionar anotacin</b>. Para anotar una seleccin,
selecciona algo en el documento, y luego usa la opcin de men
<b>Anotaciones/Anotar seleccin</b>. En todos estos casos aparecer una
ventana de anotacin (ver la figura siguiente). El contenido de esta ventana
muestra el metadato de la anotacin, dentro de un recuadro, y el cuerpo de la
anotacin.</p>

<p style="text-align: center"><img src="../images/annotationwindow-es.png"
alt="cuadro de dilogo de configuracin de anotaciones" /></p>

<p></p>

<p>Normalmente, el metadato consiste en el <b>nombre del autor</b>, el
<b>ttulo del documento anotado</b>, el <b>tipo de anotacin</b>, la <b>fecha
de creacin</b>, y la <b>fecha de ltima modificacin</b>. Algunos de los
campos de metadatos tienen propiedades especiales. El campo <b>documento
fuente</b> es tambin un enlace que apunta de vuelta al texto anotado. Si el
usuario hace doble clic sobre l, al igual que se sigue cualquier otro enlace
en Amaya, el documento anotado ser obtenido y el texto anotado aparecer
resaltado. El campo <b>tipos de anotacin</b> permite al usuario clasificar
la anotacin y cambiar su tipo. Haz doble clic sobre el texto "tipo de
anotacin" para ver la lista de tipos disponibles. Describiremos ms abajo
cmo pueden los usuarios definir tambin, sus propios tipos de anotaciones.
Finalmente, el campo <b>ltima modificacin</b> se actualiza automticamente
cada vez que se guarda una anotacin.</p>

<p>Debajo, el rea principal es el <b>rea del cuerpo de anotacin</b>.
Muestra el contenido actual y puede ser editada como si estuviramos editando
cualquier otro documento <acronym title="HyperText Markup Language"
xml:lang="en" lang="en">HTML</acronym>, .N.B., aunque todava no se pueden
incluir imgenes en el cuerpo. Algunas de las caractersticas pueden no estar
listas en la versin inicial, tales como la vista Estructura.</p>

<p>Guardar una anotacin es equivalente a guardar cualquier otro documento en
Amaya. El usuario slo necesita seleccionar el comando <b>Archivo/Guardar</b>
(o utilizar su equivalente atajo de teclado o botn del men). Las
anotaciones locales se guardan en el directorio "<span xml:lang="en"
lang="en">annotations</span>" y las anotaciones remotas se guardan en el
servidor de publicacin de anotaciones donde son almacenadas si el usuario ha
escrito el acceso. Para convertir una anotacin local en una compartida, el
usuario necesita usar el comando <b>Anotaciones/Publicar anotacin</b> y la
anotacin ser guardada en el <b>Servidor de publicacin</b> que est
definido en el men de configuracin. Si esta operacin tiene xito, la
anotacin local ser borrada y las futuras operaciones de guardado irn
directamente al servidor de anotaciones. En la versin inicial, Amaya no
soporta una operacin de guardado de una copia de una anotacin remota en el
directorio local de anotaciones.</p>

<p>Algunos comandos aplicados al documento en la <b>ventana Documento
Amaya</b> se aplicarn al documento de anotacin en la <b>ventana
Anotacin</b>. Por ejemplo, el cuerpo de una anotacin puede imprimirse con
el comando <b>Archivo/Imprimir</b> o recargado con el comando
<b>Archivo/Recargar documento</b>. (Nota: Algunas de estas caractersticas
pueden no estar includas an).</p>

<h3 id="Deleting">Borrando una Anotacin</h3>

<p>El comando del men Anotaciones/Borrar anotacin permite borrar una
anotacin. Se puede invocar este comando desde una ventana de anotacin
abierta. Tambin se puede borrar una anotacin desde el documento anotado
seleccionando primero la anotacin, haciendo un nico clic sobre el icono de
anotacin, y luego llamando a este comando de men.</p>

<h3 id="Loading">Cargando y Presentando Anotaciones</h3>

<p>El comando Cargar Anotaciones le dice a Amaya que cargue las anotaciones
asociadas a la <acronym title="Uniform Resource Locator" xml:lang="en"
lang="en">URL</acronym> del documento que est siendo navegado en esa
ventana. Amaya consultar al servidor de anotaciones, que est indicado en el
cuadro de dilogo Anotaciones/Configurar, pidindole cualquier anotacin
relevante.</p>

<p>Las anotaciones pueden descargarse tambin automticamente siempre que se
carga una nueva pgina seleccionando la casilla de verificacin <b>Autocargar
anotaciones</b> en el cuadro de dilogo <b>Anotaciones/Configurar</b>.</p>

<p>Notese que en esta versin de Amaya, al interrogar a un servidor de
anotaciones devolver <i>todas</i> las anotaciones que estn asociadas a un
documento. En una versin futura ser posible usar un men personalizado para
refinar la cadena de interrogantes que se enva a los servidores.</p>

<p>El men <b>Anotaciones/Filtro</b> local permite al usuario mostrar o
esconder los iconos de anotacin desde la vista de documento, por ejemplo,
para concentrarse en aquello que realmente le interesan o para hacer ms
fcil la lectura de un documento lleno de anotaciones. El usuario puede
mostrar o esconder anotaciones por tres tipos de metadatos: por el nombre de
<b>autor</b> de la anotacin, por el <b>tipo</b> de anotacin, y por el
nombre de <b>servidor de anotacin</b>. Para aplicar uno de estos filtros,
necesitas hacer clic en el botn de opcin para seleccionar un tipo de
anotacin dado y, luego en el correspondiente botn de accin. Los comandos
<b>Mostrar todo</b> y <b>Esconder todo</b> se aplican a todas las
anotaciones. Un pequeo e incmodo caracter a modo de prefijo seala el
estado de una entrada dada. Este caracter puede ser tanto un espacio (' '),
un asterisco ('*') o un guin ('-') para declarar que esas anotaciones que
pertenecen a esa entrada dada estn todas visibles, todas escondidas,o
parcialmente visibles, respectivamente.</p>

<p>Ten en cuenta que el men filtro slo muestra las anotaciones que conoce
que existen en el momento de su invocacin. Si aades nuevas anotaciones
entretanto, tendrs que destruir este men e invocarlo de nuevo para
verlas.</p>

<p>Advierte que para cada anotacin, el usuario de anotacin se muestra
concatenando el nombre del autor con el nombre del servidor de anotacin en
el que est almacenada la anotacin, tal como se muestra en la siguiente
figura.</p>

<p></p>

<p style="text-align: center"><img src="../images/localfilter-es.png"
alt="cuadro de dilogo del filtro local" /></p>

<h3 id="Navigating">Navegando entre Anotaciones</h3>

<p>La anotaciones aparecen como enlaces en la <b>ventana Enlaces</b> que
puede abrirse mediante el comando <b>Vistas/Mostrar enlaces</b>. En esta
ventana las anotaciones aparecen marcadas con el mismo icono del lpiz, usado
en las anotaciones en la ventana de documento. La ventana Enlace muestra
todas las anotaciones, sin tener en cuenta si han sido escondidas con el men
<b>Filtro Local <span
style="font-weight: normal; font-family: times">de</span> Anotaciones</b>. Al
igual que en la ventana de documento, un nico clic sobre la anotacin
seleccionar el texto anotado en la ventana de documento y un doble clic
abrir la anotacin. Este es un ejemplo de cmo navegar de un enlace de
anotacin a otro, incluso si la anotacin no pude ser vista por el usuario
debido a su discapacidad o debido a las caractersticas del dispositivo
usado.</p>

<p></p>

<p style="text-align: center"><img src="../images/linkwindow-es.png"
alt="La vista enlaces muestra las anotaciones" /></p>

<h3 id="Moving">Moviendo anotaciones</h3>

<p>Amaya tambin te permite mover una anotacin a cualquier otra parte del
mismo documento. Esto es interesante, por ejemplo, para manejar <a
href="#Issues1">anotaciones hurfanas y corruptas</a>. Se puede mover una
anotacin a la seleccin actual o tambin a el valor de un XPointer
almacenado. Por el momento slo es posible mover anotaciones en el mismo
documento en el que han sido creadas.</p>

<p>Para mover una anotacin a la seleccin actual, primero hay que abrir la
ventana de anotacin. Entonces hay que hacer clic en el documento anotado y
seleccionar algo en l. Luego, en la Ventana Anotacin, invocar el men
<b>Anotaciones/Mover a seleccin</b>. Amaya mover entonces el icono de
anotacin al texto seleccionado y marcar el documento de anotacin como
modificado. Para conseguir que este cambio se efectivo hay que guardar la
anotacin, de otra manera se perdern los cambios. Al igual que en la
creacin de anotaciones se puede mover una anotacin a la posicin actual del
cursor, sin tener que hacer una seleccin.</p>

<p>Tambin se puede memorizar la posicin a la que se quiere mover la
anotacin y, entonces, moverla ah. Esto es til, por ejemplo, si se quieren
mover varias anotaciones a la misma posicin o si se quiere desplazarse a
cualquier parte del documento antes de moverlas. Para hacer esto, haz una
seleccin (o slo posiciona el cursor) en el lugar en el que quieres mover la
anotacin. Entonces utiliza el men <b>Enlace/Almacenar enlace como
XPointer</b> para almacenar internamente un XPointer que represente la
seleccin. Finalmente, en la ventana Anotaciones, utiliza el men
<b>Anotaciones/Mover para almacenar XPointer</b> para mover la anotacin a su
nueva localizacin. Al igual que antes debers guardar la anotacin para
hacer efectivo el cambio.</p>
</div>

<div id="Issues">
<h3 id="Issues1">Problemas con Anotaciones y Documentos Modificados</h3>

<p>Si se est usando anotaciones con documentos en vivo (documentos cuyos
contenidos pueden ser modificados) puedes encontrar dos tipos de problemas:
<b>anotaciones hurfanas</b> y <b>anotaciones corruptas</b>. Djanos antes
describir un poco ms en detalle cmo Amaya aade anotaciones a los
documentos.</p>

<p>Amaya utiliza <strong><a
href="http://www.w3.org/XML/Linking">XPointer</a></strong> para describir
dnde debe aadirse una anotacin a un documento. XPointer est basado en la
estructura del documento. Para construir un XPointer, por ejemplo para una
seleccin, comenzamos desde el primer punto de la seleccin y vamos
regresando a travs de la estructura del documento hasta encontrar la ruta
del documento. Si un elemento tiene un atributo ID, paramos de construir el
XPointer y consideramos que el comienzo de ese XPointer es el elemento que
tiene ese valor de atributo ID. Por ejemplo, si miras el cdigo <acronym
title="HyperText Markup Language" xml:lang="en" lang="en">HTML</acronym> de
este documento, notars que esta seccin (Problemas con anotaciones...) est
incluida dentro de un elemento DIV que tiene un atributo ID con el valor
"Issues". Aqu hay un extracto del cdigo fuente:</p>
<pre>  &lt;div id="Issues"&gt;
  &lt;h3&gt;Problemas con ....&lt;/h3&gt;
  &lt;p&gt;Si se est usando...&lt;/p&gt;
  &lt;p&gt;Amaya utiliza &lt;strong&gt;XPointer&lt;/strong&gt;...&lt;/p&gt;
  ...
  &lt;/div&gt;</pre>

<p>Y aqu el XPointer que apunta al segundo prrafo:</p>

<p style="text-align: center"><code>xpointer(id("Issues")/p[2])</code></p>

<p>El XPointer de arriba apunta al segundo elemento p, desde el elemento
padre que tiene un atributo ID con el valor "Issues". (Para seleccionar un
prrafo completo, ponemos el cursor en el prrafo y presionamos la tecla
escape [Unix] o F2 [Windows]). Ntese que el uso del atributo ID permite al
autor del documento mover la seleccin completa, donde quiera en el
documento, sin necesidad de actualizar el XPointer. El XPointer no depende
del elemento que precede ese particular elemento DIV.</p>

<p>Decimos que una anotacin se queda <b>hurfana</b> cuando ya no puede ser
aadida a un documento, esto es, cuando el XPointer no determina nunca ms
ningn elemento en la estructura. Esto pasa cuando una estructura de
documento se modifica. Por ejemplo, el XPointer de arriba no podra
determinar nunca ms si eliminamos el atributo ID "Issues". Amaya te
advertir si detecta cualquier anotacin hurfana mientras descarga una serie
de anotaciones desde un servidor de anotaciones. Todas las anotaciones
hurfanas son visibles desde la vista Enlaces y estn asociadas con un icono
que muestra un signo de interrogacin superpuesto al lpiz de anotaciones
<img src="../images/annotorp.png" alt="icono de anotaciones hurfanas" />.</p>

<p>Decimos que una anotacin es <b>corrupta</b> cuando apunta a una pieza de
informacin errnea. Volviendo a nuestro ejemplo, podemos crear una anotacin
corrupta si intercambiamos el primer y segundo prrafo. El XPointer
continuar apuntando al segundo prrafo, a pesar de que nos gustara que
apuntara al primer prrafo. Este problema se hace incluso ms comn cuando
anotas una porcin de texto que puede cambiar. En la primera versin, Amaya
no advierte al usuario si una anotacin est corrupta. Una futura versin
puede avisar al usuario de la posibilidad de que una anotacin pueda llegar a
ser corrupta.</p>

<p>Cmo puedes protegerte a ti mismo?</p>

<p>Si eres el autor de un documento, intenta usar el atributo ID en lugares
estratgicos, por ejemplo, en los elementos DIV. Amaya te permite asociar
automticamente o eliminar un atributo ID a/desde una serie de elementos por
medio del comando de men Especial/Crear/Suprimir atributos ID. En el ejemplo
de arriba, nosotros podramos haber evitado el problema de las anotaciones
corruptas si hubisemos aadido un atributo ID al segundo prrafo:</p>
<pre>  &lt;p id="Amaya"&gt;Amaya utiliza...&lt;/p&gt;</pre>

<p>Un XPointer que apunta a este prrafo es:</p>

<p style="text-align: center"><code>xpointer(id("Amaya"))</code></p>

<p>De esta manera, el XPointer apuntar al mismo prrafo, independientemente
de su posicin en la estructura del documento.</p>
</div>

<p><a href="MakeBook.html"><img alt="previa" src="../images/left.gif" /></a>
<a href="Manual.html"><img alt="arriba" src="../images/up.gif" /></a> <a
href="Configure.html"><img alt="siguiente" src="../images/right.gif"
/></a></p>
<hr />
</body>
</html>
