
#ifndef _OPENGLFONTS_H_
#define _OPENGLFONTS_H_

#ifdef _WINDOWS
#include <windows.h>
#endif /*_WINDOWS*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <GL/gl.h>

#ifdef GL_MESA_window_pos
#define MESA
#endif

#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_GLYPH_H
#include FT_TRUETYPE_IDS_H

typedef struct _GL_glyph
{
  FT_BBox bbox;
  FT_Vector pos;
  FT_Vector dimension;  
  float advance;
  void *data;
} GL_glyph;

typedef struct _GL_font
{
  FT_Face   *face;
  int       kerning;
  GL_glyph  **glyphList;
  int		Cache_index;
} GL_font;


typedef struct F_VECTOR {
        float x;
		float y;
} FLOAT_VECTOR;


typedef struct F_Slot {
        char     *name;
		GL_font  *font;
		int      size;
		int      ref;
} Font_Slot;


static GL_font       *FontOpen (const char* fontname);
static void          FontClose (GL_font *font);
static int           FontAscender (GL_font *font);
static int           FontDescender (GL_font *font);
static int           FontFaceSize (GL_font *font, const unsigned int size, const unsigned int res );
static int           FontCharMap (GL_font *font, FT_Encoding encoding, char alphabet);
static void          FontBBox (GL_font *font,
			       wchar_t* string,
			       int length,
			       float *llx, float *lly, 
			       float *llz, float *urx, 
			       float  *ury, float *urz);
static void          FreeGlyphList (GL_font *font);

/*
  static float         FontAdvance (GL_font *font, const char* string);
*/

/* Font handling internals */
static int           FTLibraryInit ();
void                 FTLibraryFree ();


static float          FaceKernAdvance (FT_Face face, 
				       unsigned int index1, 
				       unsigned int index2);
static GL_glyph      *MakeBitmapGlyph (GL_font *font, unsigned int g);

#ifndef PADDING
#define PADDING 1
#endif 

#ifndef TRUE
#define TRUE 1
#endif 

#ifndef FALSE
#define FALSE 0
#endif 

#endif



