/***             analog 4.13             http://www.analog.cx/             ***/
/*** This program is copyright (c) Stephen R. E. Turner 1995 - 2000 except as
 *** stated otherwise. Distribution, usage and modification of this program is
 *** subject to the conditions of the Licence which you should have received
 *** with it. This program comes with no warranty, expressed or implied.   ***/

/*** anlghea2.h: second header file ***/

/*** This file is a convenient place to store defaults for various options.
 *** You can redefine them if you want, but you probably don't want to because
 *** it's easier to change them at run-time. See anlghead.h for the options you
 *** are likely to want to change. ***/

#ifndef ANLGHEAD2
#define ANLGHEAD2

#ifndef ANLGHEAD
#include "anlghead.h"  /* defines ANALOGDIR, among other things */
#endif

/*** The first few options are compiled into the program. They can't be
     changed without re-compiling the program. ***/

#define BLOCKSIZE (32768)
/* Analog allocates memory in blocks of this many bytes. Also any logfile
   lines this long or longer will be rejected. */

#define MAX_CONFIGS (50)
/* The maximum number of configuration files that are allowed. */

#define MAXPAGEWIDTH (240)
/* the maximum allowed value of the PAGEWIDTH variable */

#ifndef ALIGNMENT
#define ALIGNMENT (8)
/* All objects can align on boundaries that are multiples of this. This
   is system-dependent, but I expect 8 to be big enough for almost everyone. */
#endif

/*** The rest of the options can be overridden when the program is run. ***/

#ifndef CACHEOUTFILE
#define CACHEOUTFILE "none"
/* The default file for cache output. Use "none" for no cache file. */
#endif

#ifndef CACHEFILE
#define CACHEFILE "none"
/* The file for cache input. Again, can be "none". */
#endif

#ifndef LANGDIR
#define LANGDIR ANALOGDIR"lang/"
/* Directory where the language files live. */
#endif

#ifndef NODNS
#define DNSFILE ANALOGDIR"dnscache"
/* where to store resolved addresses so we don't have to look them up next
   time */

#define DNSLOCKFILE ANALOGDIR"dnslock"
/* A lock file to stop two processes trying to write the DNSFILE at once */ 

#define DNS (DNS_NONE)
/* level of DNS activity. Can be DNS_NONE, DNS_READ, DNS_LOOKUP or
   DNS_WRITE. */

#define DNSGOODHOURS (672)
/* How many hours lookups stay fresh for before we have to look them
   up again. */

#define DNSBADHOURS (168)
/* After how many hours to retry failed lookups. */
#endif

#define DIRSUFFIX "index.html"
/* the default filename tried if a directory is requested. The program
   combines statistics from /dir/ and /dir/DIRSUFFIX. If you don't wish
   this combining to occur, define DIRSUFFIX to be "". The usual value
   is "index.html". */

#define CASE_INSENSITIVE (TRUE)
#ifdef UNIX
#undef CASE_INSENSITIVE
#define CASE_INSENSITIVE (FALSE)
#endif
#ifdef BEOS
#undef CASE_INSENSITIVE
#define CASE_INSENSITIVE (FALSE)
#endif
#ifdef NEXTSTEP
#undef CASE_INSENSITIVE
#define CASE_INSENSITIVE (FALSE)
#endif
/* Do you have a case sensitive or case insensitive file system? */

#define USERCASE_INSENSITIVE (TRUE)
/* The same for user names */

#define SEARCHCHARCONVERT (TRUE)
/* Whether to convert %nm's from the top half of the character set in the
   search reports */

#define REPORTORDER "xmWDdHh45oZSuJkKfsNnBbpvcPztiEIr"
/* A string like "xmWDdHh45oZSuJkKfsNnBbpvcPztiEIr" giving the order in which
   the reports will be output. You should include each of the above letters
   exactly once. See docs/output.html for which report has which code letter.*/

/* whether we want each of the reports by default */
#define GENERAL (TRUE)      /* General Summary */
#define MONTHLY (TRUE)      /* Monthly Report */
#define DAILY (TRUE)        /* Daily Summary */
#define FULLDAILY (FALSE)   /* Daily Report */
#define WEEKLY (FALSE)      /* Weekly Report */
#define HOURLY (TRUE)       /* Hourly Summary */
#define FULLHOURLY (FALSE)  /* Hourly Report */
#define QUARTER (FALSE)     /* Quarter-Hour Report */
#define FIVE (FALSE)        /* Five-Minute Report */
#define DOMAINREP (TRUE)    /* Domain Report */
/* Not called DOMAIN because would clash with math.h on some systems */
#define ORGANISATION (TRUE) /* Organisation Report */
#define DIRECTORY (TRUE)    /* Directory Report */
#define FILETYPE (TRUE)     /* File Type Report */
#define REQUEST (TRUE)      /* Request Report */
#define REDIRREP (FALSE)    /* Redirection Report */
#define FAILREP (FALSE)     /* Failure Report */
#define SIZEREP (TRUE)      /* File Size Report */
#define PROCTIME (FALSE)    /* Processing Time Report */
#define HOST (FALSE)        /* Host Report */
#define REFERRER (FALSE)    /* Referrer Report */
#define REFSITE (FALSE)     /* Referring Site Report */
#define REDIRREF (FALSE)    /* Redirected Referrer Report */
#define FAILREF (FALSE)     /* Failed Referrer Report */
#define VHOST (FALSE)       /* Virtual Host Report */
#define USER (FALSE)        /* User Report */
#define FAILUSER (FALSE)    /* Failed User Report */
#define SEARCHQUERY (FALSE) /* Search Engine Query Report */
#define SEARCHWORD (TRUE)   /* Search Engine Word Report */
#define BROWSER (FALSE)     /* Browser Summary */
#define FULLBROWSER (FALSE) /* Browser Report */
#define OSREP (TRUE)        /* Operating System Report */
#define STATUS (TRUE)       /* Status Code Report */

#define GOTOS (TRUE)        /* "Go To" lines: TRUE, FALSE or FEW */
#define RUNTIME (TRUE)      /* "Running time" line: TRUE or FALSE */

#define DOMCOLS "Rb"
/* Which columns we want to appear in the domain report, and in which order.
   The string can contain any of the following letters:
   R   Number of requests from each domain
   r   Percentage of the requests from each domain
   P   Number of requests for pages from each domain
   p   Percentage of the requests for pages from each domain
   B   Total number of bytes transferred to each domain
   b   The percentage of traffic to each domain
   d   Date of last access from each domain
   D   Date and time of last access
   N   Number in list */
/* And the same for the other reports */
#define ORGCOLS "Rb"
#define HOSTCOLS "Rb"
#define DIRCOLS "Rb"
#define TYPECOLS "Rb"
#define REQCOLS "RbD"
#define REDIRCOLS "R"
#define FAILCOLS "R"
#define MONTHCOLS "RP"
#define DAYCOLS "RP"
#define FULLDAYCOLS "RP"
#define WEEKCOLS "RP"
#define HOURCOLS "RP"
#define FULLHOURCOLS "RP"
#define QUARTERCOLS "RP"
#define FIVECOLS "RP"
#define REFCOLS "R"
#define REFSITECOLS "R"
#define REDIRREFCOLS "R"
#define FAILREFCOLS "R"
#define BROWCOLS "R"
#define FULLBROWCOLS "R"
#define OSCOLS "NR"
#define SIZECOLS "Rb"
#define PROCTIMECOLS "R"
#define VHOSTCOLS "Rb"
#define USERCOLS "Rb"
#define FAILUSERCOLS "R"
#define SEARCHQUERYCOLS "R"
#define SEARCHWORDCOLS "R"
#define STATUSCOLS "R"

/* Should the time graphs be calculated by requests 'R', bytes 'B' or
   pages 'P': or use 'r', 'b', 'p' for gif-free barcharts. */
#define MONTHGRAPH 'P'
#define DAYGRAPH 'P'
#define FULLDAYGRAPH 'P'
#define HOURGRAPH 'P'
#define FULLHOURGRAPH 'P'
#define WEEKGRAPH 'P'
#define QUARTERGRAPH 'P'
#define FIVEGRAPH 'P'

/* Should they go forwards (oldest entries at top) or backwards? */
#define MONTHBACK (FALSE)
#define FULLDAYBACK (FALSE)
#define FULLHOURBACK (FALSE)
#define WEEKBACK (FALSE)
#define QUARTERBACK (FALSE)
#define FIVEBACK (FALSE)

/* The maximum number of rows in each (0 for "show all time") */
#define MONTHROWS (0)
#define WEEKROWS (0)
#define FULLDAYROWS (42)
#define FULLHOURROWS (72)
#define QUARTERROWS (96)
#define FIVEROWS (288)

/* The "floor" for each report. See docs/othreps.html for the possible formats
   for these strings. */
#define REQFLOOR "20r"
#define REQARGSFLOOR "10r"
#define REDIRFLOOR "-30r"
#define REDIRARGSFLOOR "10r"
#define FAILFLOOR "-30r"
#define FAILARGSFLOOR "10r"
#define DOMFLOOR "0b"
#define SUBDOMFLOOR "0.5%b"
#define ORGFLOOR "-20r"
#define SUBORGFLOOR "0.5%r"
#define DIRFLOOR "0.01%b"
#define SUBDIRFLOOR "0.01%b"
#define TYPEFLOOR "0.1%b"
#define SUBTYPEFLOOR "0.1%b"
#define HOSTFLOOR "100r"
#define REFFLOOR "20r"
#define REFARGSFLOOR "10r"
#define REFSITEFLOOR "-30r"
#define REFDIRFLOOR "50r"
#define REDIRREFFLOOR "-30r"
#define REDIRREFARGSFLOOR "10r"
#define FAILREFFLOOR "-30r"
#define FAILREFARGSFLOOR "10r"
#define BROWFLOOR "-20r"
#define FULLBROWFLOOR "-40r"
#define OSFLOOR "0r"
#define SUBOSFLOOR "0r"
#define VHOSTFLOOR "-20b"
#define USERFLOOR "-100r"
#define FAILUSERFLOOR "-20r"
#define SEARCHQUERYFLOOR "-20r"
#define SEARCHWORDFLOOR "-20r"
#define STATUSFLOOR "0r"

/* How to sort each report: REQUESTS, PAGES, BYTES, ALPHABETICAL, DATESORT or
   RANDOM */
#define REQSORTBY (REQUESTS)
#define REDIRSORTBY (REQUESTS)
#define FAILSORTBY (REQUESTS)
#define DOMSORTBY (BYTES)
#define ORGSORTBY (REQUESTS)
#define DIRSORTBY (BYTES)
#define TYPESORTBY (BYTES)
#define HOSTSORTBY (ALPHABETICAL)
#define REFSORTBY (REQUESTS)
#define REFSITESORTBY (REQUESTS)
#define REDIRREFSORTBY (REQUESTS)
#define FAILREFSORTBY (REQUESTS)
#define BROWSORTBY (REQUESTS)
#define FULLBROWSORTBY (REQUESTS)
#define OSSORTBY (REQUESTS)
#define VHOSTSORTBY (BYTES)
#define USERSORTBY (REQUESTS)
#define FAILUSERSORTBY (REQUESTS)
#define SEARCHQUERYSORTBY (REQUESTS)
#define SEARCHWORDSORTBY (REQUESTS)
#define STATUSSORTBY (ALPHABETICAL)

#define WEEKBEGINSON (SUNDAY)
/* The 1st day of the week. I think it's SUNDAY, but you can choose any day. */

#define LASTSEVEN (TRUE)
/* Whether to include statistics for the last seven days */

#define SEPCHAR ','
/* The character to separate the thousands in a long number. I prefer ',',
   but some people prefer ' ' or '.'. Use '\0' for no separator. Use '9' if
   you really want to inflate your statistics! :) */

#define REPSEPCHAR '\0'
/* The same for long numbers within the detailed output */

#define DECPOINT '.'
/* Character to use as the decimal point. */

#define COMPSEP "\t"
/* A separator string between fields in "computer" output style */

#define RAWBYTES (FALSE)
/* whether bytes should be quoted in full (e.g., 1,021,453) as opposed to
   in kilobytes, megabytes etc. (e.g., 998k). */

#define NOROBOTS (TRUE)
/* Exclude SOME robots from indexing the output page or following its links. */

#define HEADERFILE "none"
/* an extra file (with HTML markup if desired) placed between the page title
   and the start of the statistics. Use "none" for none. */

#define FOOTERFILE "none"
/* And one placed at the bottom of the page */

#define OUTPUT (HTML)
/* Default output type: HTML, PLAIN, ASCII, COMPUTER or CACHE */

#ifndef LANGUAGE
#define LANGUAGE (ENGLISH)
/* Default language for the output page:
   ARMENIAN, BOSNIAN, BULGARIAN, CATALAN, SIMP_CHINESE (GB2312),
   TRAD_CHINESE (Big5), CROATIAN, CZECH, DANISH, DUTCH, ENGLISH, US_ENGLISH,
   FINNISH, FRENCH, GERMAN, GREEK, HUNGARIAN, ICELANDIC, ITALIAN, JAPANESE,
   KOREAN, NORWEGIAN (Bokmal), NYNORSK, POLISH, PORTUGUESE, BR_PORTUGUESE,
   ROMANIAN, RUSSIAN, SERBIAN, SLOVAK, SLOVENE, SPANISH, SWEDISH, TURKISH or
   UKRAINIAN.
   *
   NB The other languages that were available in version 3 have language
   files in the lang directory: but they are incomplete, and so can't be
   specified here. I hope that they will be translated for version 4 soon.
   They will be added to the analog home page as they are translated. */
#endif

#define MARKCHAR '+'
/* a character for the graphical displays */

#define BARSTYLE 'b'
/* The default bar style for the displays -- 'a' to 'h' */

#define HTMLPAGEWIDTH (65)
#define PLAINPAGEWIDTH (76)
/* The width of the output for HTML and non-HTML */

#define MINGRAPHWIDTH (15)
/* bar charts must be at least this many characters wide */

#define ERRLINELENGTH (78)
#define STDERRWIDTH (ERRLINELENGTH)
/* the maximum width for error and warning messages */

#endif  /* anlghea2.h not previously included */
