/***             analog 4.13             http://www.analog.cx/             ***/
/*** This program is copyright (c) Stephen R. E. Turner 1995 - 2000 except as
 *** stated otherwise. Distribution, usage and modification of this program is
 *** subject to the conditions of the Licence which you should have received
 *** with it. This program comes with no warranty, expressed or implied.   ***/

/*** anlghea4.h: fourth header file ***/

/*** Just function declarations: these are not user-definable; user-definable
 *** options can be found in anlghead.h ***/

#ifndef ANLGHEAD4
#define ANLGHEAD4

/* in alias.c */
extern choice do_alias(char *name, Memman *mp, Alias *aliashead,
  char *dirsuffix, unsigned int dirsufflength, logical usercase_insensitive,
  unsigned char convfloor, choice type);
extern void do_aliasx(char *name, Alias *aliashead);
extern logical do_aliasr(char *name, char *dirsuffix,
  unsigned int dirsufflength);
extern logical do_aliasS(char *name);
extern logical do_aliasf(char *name);
extern logical do_aliasB(char *name);
extern logical do_aliasu(char *name, logical case_insensitive);
extern logical do_aliasv(char *name);
extern logical do_aliasN(char *name, unsigned char convfloor);
extern logical do_aliasn(char *name, unsigned char convfloor);
extern logical do_aliasb(char *name);
#ifndef NODNS
extern logical dnsresolve(char *name, choice level);
void do_dns(char *name, char *alias, choice level);
#endif
extern void wildalias(char *name, AliasTo *to, ptrdiff_t pmatch[]);
extern choice prealias(Memman *mm, Memman *mmv, Hashentry *vhost, Memman *mmq,
  logical case_insensitive, char *prefix, size_t prefixlen, int pvpos,
  Include *argshead);
extern void prealiasS(Memman *mm, Memman *mms);
extern void reverseonename(Hashindex *p);
extern void reversenames(Hashindex *ans);

/* in analog.c -- only main() */

/* in cache.c */
extern void outputcache(char *outfile, Hashindex **gooditems, Dateman *dman,
  Arraydata **arraydata, unsigned long *data, double bys, char **monthname,
  char **dayname);
extern void hashbuild(unsigned int code, unsigned long *data, double bys,
  Memman *mm, Hashtable **hash, Include *wanthead, Include *ispagehead,
  Alias *aliashead, Dateman *dman, Tree **tree, Derv **derv, choice *alltrees,
  choice *alldervs, choice lowmem, char *dirsuffix, unsigned int dirsufflength,
  logical usercase_insensitive, unsigned char convfloor);
extern void corruptcacheline(char *line, choice *rc, choice type);
extern logical parsecacheline(char *linestart, char *parsestart,
  unsigned int *code, unsigned int maxcode, int no_items, unsigned long *data,
  double *bys, Memman *mm);
extern void readoldcache(Filelist *cachefilep, FILE *lf, Dateman *dman,
  choice type, unsigned int granularity);
extern void readcache(Filelist *cachefilep, FILE *lf, Hashtable **hash,
  Arraydata **arraydata, Include **wanthead, Include *ispagehead,
  Alias **aliashead, Dateman *dman, Tree **tree, Derv **derv, choice *alltrees,
  choice *alldervs, choice *lowmem, char *dirsuffix,
  unsigned int dirsufflength, logical usercase_insensitive,
  unsigned char convfloor, unsigned int granularity);

/* in dates.c */
extern void code2date(datecode_t code, unsigned int *date, unsigned int *month,
  unsigned int *year);
extern time_t shifttime(time_t timer, int diff);
extern choice parsedate(time_t starttime, char *s, timecode_t *date,
  logical from, logical unixtime);
extern choice wantdate(timecode_t *timecode, Dateman *dman, unsigned int hr,
  unsigned int min, unsigned int date, unsigned int month, unsigned int year,
  int tz);
extern choice wantunixtime(timecode_t *timecode, Dateman *dman,
  unsigned long unixtime, int tz);
extern Daysdata *newday(unsigned int granularity);
extern void dmaninit(Dateman *dman, datecode_t datecode,
  unsigned int granularity);
extern void datehash(timecode_t timecode, Dateman *dman, unsigned long reqs,
  unsigned long pages, double bytes, unsigned int granularity);

/* in globals.c */
extern void globals(char *comnane);
extern void defaults(Options *op);

/* in hash.c */
extern Hashtable *rehash(Hashtable *old, unsigned long size,
  Memman *treespace);
extern Hashindex *hashfind(Memman *mp, Hashtable **table, Include *wanthead,
  choice ispage, Include *ispagehead, Alias *aliashead, char *dirsuffix,
  unsigned int dirsufflength, logical usercase_insensitive,
  unsigned char convfloor, choice type, logical aliased);
extern Hashentry *newhashentry(logical ispage);
extern void hashscore(Hashentry *ep, choice outcome, logical last7,
  logical ispage, timecode_t timecode, double bytes);
extern void unhash(Hashtable *hash, Hashindex **gooditems,
  Hashindex **baditems);
extern void unhashall(Hashtable **hash, Hashindex ***gooditems,
  Hashindex ***baditems);

/* in init.c */
extern void initialise(int argc, char *argv[], Options *op);
extern void confline(Options *op, char *cmd, char *arg1, char *arg2, int rc);
extern choice config(char *filename, Options *op);
extern void settings(Options *op, int argc, char *argv[]);
extern Inputformatlist *correctlogfmt(Filelist *lp, Include **wanthead,
  choice *code2type, Dateman *dman);
extern void correct(Options *op);
extern void finalinit(Options *op);
extern choice strtoinfmt(Inputformat **ans, char *s, choice *count);
extern char *apachelogfmt(char *fmt);
extern void clconfline(Options *op, char *s);
extern void clgenrep(Options *op, choice rep, char *arg);
extern void cldebug(char **s, char *arg);
extern void clargs(Options *op, int argc, char *argv[]);

/* in init2.c */
extern void shortwarn(char *cmd, char *arg1, int rc);
extern void longwarn(char *cmd, char *arg1, char *arg2, int rc);
extern void badwarn(char *cmd, choice domess, char *arg1, char *arg2, int rc);
extern void unknownwarn(char *cmd, char *arg1, char *arg2);
extern void configcall(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configcols(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallcols(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configsortby(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configdebug(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configonoff(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configall(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallback(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configgotos(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configcase(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configweekday(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configoutstyle(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
#ifndef NODNS
extern void configdns(void *opt, char *cmd, char *arg1, char *arg2, int rc);
#endif
extern void configlang(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void selectlang(char *country, Outchoices *op);
extern void configlogfmt(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configapachelogfmt(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configrepord(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configstr(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configstrlist(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configerrfile(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
#ifndef NODIRENT
extern void configwildlogs(void *opt, char *arg1, char *arg2, int rc);
#endif
extern void configlogfile(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configcachefile(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configchar(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configbarstyle(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configgraph(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallgraph(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configfloor(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configtree(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configulong(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configuint(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configoffset(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configlowmem(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern int aliastocount(char *s);
extern AliasTo *configaliasto(char *s, logical is_regex);
extern void configalias(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configstrpair(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configstrpairlist(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configstrpair2list(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configdomlevel(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configinex(void *opt, char *cmd, char *arg1, char *arg2, int rc,
  logical in);
extern void configinc(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexc(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configincd(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexcd(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configincs(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexcs(void *opt, char *cmd, char *arg1, char *arg2, int rc);
void configscinex(void *opt, char *cmd, char *arg1, char *arg2, int rc,
  logical in);
extern void configscinc(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configscexc(void *opt, char *cmd, char *arg1, char *arg2, int rc);

/* in input.c */
extern FILE *my_lfopen(Filelist *p, char *logtype);
extern FILE *my_fopen(char *name, char *logtype);
extern int my_lfclose(FILE *f, Filelist *p, Filelist *allc, Filelist *allp,
  char *filetype, Dateman *dman, unsigned long *totdata, double *bys,
  double *bys7, char **monthname, unsigned int monthlen);
extern int my_fclose(FILE *f, char *name, char *filetype);
extern FILE *logfile_init(Filelist *logfilep);
extern choice getmoredata(FILE *f, char *start, size_t length);
extern choice getnextline(FILE *f, char *start, size_t used);
extern void shunt_data(FILE *f);
extern int strtomonth(char *month);
extern choice parsemonth(FILE *f, void *arg, char c);
extern choice parseuint2(FILE *f, void *arg, char c);
extern choice parsenmonth(FILE *f, void *arg, char c);
extern choice parseulong(FILE *f, void *arg, char c);
extern choice parseproctime(FILE *f, void *arg, char c);
extern choice parseuint2strict(FILE *f, void *arg, char c);
extern choice parsescode(FILE *f, void *arg, char c);
extern choice parseuint4strict(FILE *f, void *arg, char c);
extern choice parseudint(FILE *f, void *arg, char c);
extern choice parseyear(FILE *f, void *arg, char c);
extern choice parseam(FILE *f, void *arg, char c);
extern choice parsecode(FILE *f, void *arg, char c);
extern choice parsejunk(FILE *f, void *arg, char c);
extern choice parsespace(FILE *f, void *arg, char c);
extern choice parseoptspace(FILE *f, void *arg, char c);
extern choice parsenewline(FILE *f, void *arg, char c);
extern void parsenonnewline(FILE *f);
extern choice parsestring(FILE *f, void *arg, char c);
extern choice parsemsbrow(FILE *f, void *arg, char c);
extern choice parseref(FILE *f, void *arg, char c);
extern choice checkchar(FILE *f, void *arg, char c);
extern void resolveconflicts(unsigned int n, char *delims, ...);
extern choice parselogfmt(FILE *f, void *arg, char c);
extern choice parsenextrecord(FILE *f, Inputformat *format);
extern int parseconfline(char *s, char **cmd, char **arg1, char **arg2);
extern int nextconfline(FILE *f, char **cmd, char **arg1, char **arg2);
extern char *nextlngstr(FILE *f, char *name, logical want);
extern choice nextdnsline(FILE *f, timecode_t *timec, char **name,
  char **alias);
extern void process_domainsfile(FILE *f, Options *op);

/* in macstuff.c (See also macdir.h) */
#ifdef MAC_EVENTS
extern void MacInit(int *argc, char **argv[]);
extern void MacFini(void);
extern void MacIdle(void);
#endif
#ifdef MACDIRENT
extern void CToPCpy(unsigned char *pstr, const char *cstr);
#endif
#ifdef MAC
#ifndef NODNS
extern long OpenNetwork(void);
extern int IpAddr2Name(char *hostname);
extern void ResolverCleanup(void);
extern pascal void SvcNotifyProc(void *dataPtr, OTEventCode code,
  OTResult result, void *cookie);
extern pascal void MacTCPDNRResultProc(struct hostInfo *hInfoPtr,
  char *userDataPtr);
#endif
#endif

/* in output.c */
extern void gensum(FILE *outf, choice outstyle, logical last7,
  unsigned long *data, double bys, double bys7, Hashindex **gooditems,
  Hashindex **baditems, Dateman *dman, logical rawbytes, char sepchar,
  char decpt, char *compsep, char **monthname, char **dayname,
  unsigned int monthlen, unsigned int daylen, char **lngstr);
extern void genrep(FILE *outf, choice rep, choice outstyle, logical multibyte,
  Hashindex **gooditems, Hashindex **baditems, Alias *aliashead,
  Include *wanthead, choice requests, choice date, Floor *floor, choice sortby,
  logical alphaback, unsigned int pagewidth, char sepchar, char repsepchar,
  char decpt, char *compsep, logical rawbytes, choice *cols, char *colhead,
  char *colheadp, char *gens, char *genp, char gender, logical *html,
  timecode_t firsttime, char **monthname, char **dayname,
  unsigned int monthlen, unsigned int daylen, unsigned int plainmonthlen,
  unsigned int plaindaylen, char **lngstr);
extern void subdayrep(FILE *outf, choice rep, Daysdata *firstdp,
  Daysdata *lastdp, datecode_t firstdate, datecode_t lastdate,
  choice outstyle, unsigned int granularity, unsigned int repgran,
  unsigned int pagewidth, unsigned int mingraphwidth, logical back,
  logical rawbytes, choice *cols, unsigned int rows, char graphby,
  char barstyle, char markchar, char sepchar, char repsepchar, char decpt,
  char *compsep, choice weekbeginson, char *imagedir, logical *html,
  char **monthname, char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen, char **lngstr,
  char *datefmt, char *colhead, char *busystr);
extern void superdayrep(FILE *outf, choice rep, Daysdata *firstdp,
  Daysdata *lastdp, datecode_t firstdate, datecode_t lastdate,
  choice outstyle, unsigned int granularity, unsigned int pagewidth,
  unsigned int mingraphwidth, logical back, logical rawbytes, choice *cols,
  unsigned int rows, char graphby, char barstyle, char markchar, char sepchar,
  char repsepchar, char decpt, char *compsep, choice weekbeginson,
  char *imagedir, logical *html, char **monthname, unsigned int monthlen,
  unsigned int plainmonthlen, char **lngstr, char *datefmt, char *colhead,
  char *busystr);
extern void daysum(FILE *outf, Daysdata *firstdp, datecode_t firstdate,
  datecode_t lastdate, choice outstyle, unsigned int granularity,
  choice weekbeginson, unsigned int pagewidth, unsigned int mingraphwidth,
  logical rawbytes, choice *cols, char graphby, char barstyle, char markchar,
  char sepchar, char repsepchar, char decpt, char *compsep, char *imagedir,
  logical *html, char *colhead, char **dayname, unsigned int daylen,
  char **lngstr);
extern void hoursum(FILE *outf, Daysdata *firstdp, Daysdata *lastdp,
  choice outstyle, unsigned int granularity, unsigned int pagewidth,
  unsigned int mingraphwidth, logical rawbytes, choice *cols, char graphby,
  char barstyle, char markchar, char sepchar, char repsepchar, char decpt,
  char *compsep, char *imagedir, logical *html, char *colhead, char **lngstr);
extern void printtree(FILE *outf, choice rep, choice outstyle,
  logical multibyte, Hashtable *tree,
  choice requests, choice date, Hashentry *badp, unsigned long badn,
  unsigned int level, Strlist *partname, Alias *aliashead, Include *linkhead,
  char *baseurl, unsigned long totr, unsigned long totp, double totb,
  unsigned int width[], unsigned int bmult, double unit, char sepchar,
  char repsepchar, char decpt, char *compsep, logical rawbytes, choice *cols,
  char *colhead, char *colheadp, char gender, logical *html, char **monthname,
  char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen, char **lngstr);
extern void treerep(FILE *outf, choice rep, choice outstyle, logical multibyte,
  Tree *treex, Hashindex *gooditems, Hashindex *baditems, Alias *aliashead,
  Include *wanthead, Include *linkhead, char *baseurl, choice *alltrees,
  choice requests, choice date, Floor *floor, choice sortby, Floor *subfloor,
  choice subsortby, logical alphaback, unsigned int pagewidth, char sepchar,
  char repsepchar, char decpt, char *compsep, logical rawbytes, choice *cols,
  char *colhead, char *colheadp, char *gens, char *genp, char gender,
  logical *html, timecode_t firsttime, char **monthname, char **dayname,
  unsigned int monthlen, unsigned int daylen, unsigned int plainmonthlen,
  unsigned int plaindaylen, char **lngstr);
extern void dervrep(FILE *outf, choice rep, choice outstyle, logical multibyte,
  Derv *derv, Hashindex *gooditems, Hashindex *baditems, Include *wanthead,
  choice *alldervs, Floor *floor, choice sortby, unsigned int pagewidth,
  char sepchar, char repsepchar, char decpt, char *compsep, logical rawbytes,
  unsigned char convfloor, choice *cols, char *colhead, char *colheadp,
  char *gens, char *genp, char gender, logical *html, timecode_t firsttime,
  char **monthname, char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen, char **lngstr);
extern void dervtreerep(FILE *outf, choice rep, choice outstyle,
  logical multibyte, Derv *derv,
  Tree *treex, Hashindex *gooditems, Hashindex *baditems, Alias *aliashead,
  Include *wanthead, choice *alltrees, choice *alldervs, Floor *floor,
  choice sortby, Floor *subfloor, choice subsortby, unsigned int pagewidth,
  char sepchar, char repsepchar, char decpt, char *compsep, logical rawbytes,
  unsigned char convfloor, choice *cols, char *colhead, char *colheadp,
  char *gens, char *genp, char gender, logical *html, timecode_t firsttime,
  char **monthname, char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen, char **lngstr);
extern void arrayrep(FILE *outf, choice rep, choice outstyle,
  logical multibyte,
  Arraydata *array, Floor *floor, choice sortby, unsigned int pagewidth,
  char sepchar, char repsepchar, char decpt, char *compsep, logical rawbytes,
  choice *cols, char *colhead, char *colheadp, char *gens, char *genp,
  char gender, logical *html, timecode_t firsttime, char **monthname,
  char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen, char **lngstr);
extern void output(Outchoices *od, Hashindex **gooditems, Hashindex **baditems,
  Dateman *dman, Arraydata **arraydata, unsigned long *sumdata,
  double totbytes, double totbytes7, unsigned int granularity);

/* in output2.c */
extern void pagetop(FILE *outf, Outchoices *od, Dateman *dman);
extern void pagebot(FILE *outf, Outchoices *od);
extern void gotos(FILE *outf, int code, logical *repq, char **lngstr,
  choice *reporder);
extern void report_title(FILE *outf, char *name, int code, choice gotoq,
  logical *repq, char **lngstr, choice *reporder, choice outstyle);
extern size_t htmlstrlen(char *s, choice outstyle);
extern void matchlength(FILE *outf, choice outstyle, char *s, char c);
extern void myputc(FILE *outf, char c, choice outstyle);
extern void htmlfprintf(FILE *outf, choice outstyle, logical multibyte,
  char *s, logical *html, logical userinput);
extern void escfprintf(FILE *outf, char *name);
extern void hrule(FILE *outf, choice outstyle, unsigned int pagewidth);
extern void include_file(FILE *outf, choice outstyle, char *name, char type,
  unsigned int pagewidth, logical *html);
extern unsigned int datefmtlen(char *fmt, unsigned int monthlen,
  unsigned int daylen, char *compsep, logical allowmonth);
extern char *datesprintf(char *ans, char *fmt, choice outstyle,
  datecode_t date, unsigned int hr, unsigned int min, unsigned int newhr,
  unsigned int newmin, char **monthname, char **dayname, unsigned int monthlen,
  unsigned int daylen, char *compsep, logical allowmonth);
extern int f3printf(FILE *outf, choice outstyle, double x, unsigned int width,
  char sepchar);
extern void printbytes(FILE *outf, choice outstyle, double bytes,
  unsigned int bmult, unsigned int width, char sepchar, char decpt);
extern void doublemprintf(FILE *outf, choice outstyle, unsigned int pagewidth,
  double x, char decpt);
extern double findunit(double n, unsigned int pagewidth, unsigned int width[],
  unsigned int mingraphwidth, choice *cols);
extern void calcsizes(choice outstyle, unsigned int width[],
  unsigned int *bmult, double *unit, unsigned long maxr, unsigned long maxp,
  double maxb, unsigned long howmany, unsigned int pagewidth,
  unsigned int mingraphwidth, char graphby, char repsepchar, logical rawbytes,
  choice *cols, unsigned int monthlen, unsigned int daylen, char **lngstr);
extern unsigned int alphatreewidth(Hashtable *tree, choice outstyle);
extern void declareunit(FILE *outf, choice outstyle, unsigned int pagewidth,
  char graphby, double unit, unsigned int bmult, char barstyle, char markchar,
  char sepchar, char decpt, char *imagedir, char **lngstr);
extern void whatincluded(FILE *outf, choice rep, choice outstyle,
  unsigned long n, unsigned int pagewidth, Floor *floor, choice sortby,
  char decpt, char *compsep, char *gens, char *genp, char gender,
  choice requests, choice date, timecode_t firsttime, char **monthname,
  char **dayname, unsigned int monthlen, unsigned int daylen, char **lngstr);
extern void busyprintf(FILE *outf, choice outstyle, char *datefmt,
  unsigned long reqs, unsigned long pages, double bys, datecode_t date,
  unsigned int hr, unsigned int min, unsigned int newhr, unsigned int newmin,
  char graphby,	char sepchar, char decpt, logical rawbytes, char **lngstr,
  char **monthname, char **dayname, unsigned int monthlen, unsigned int daylen,
  char *busystr);
extern void pccol(FILE *outf, choice outstyle, double n, double tot,
  unsigned int width, char decpt);
extern void barchart(FILE *outf, choice outstyle, char graphby,
  unsigned long reqs, unsigned long pages, double bys, double unit,
  char barstyle, char markchar, char *imagedir);
extern void colheads(FILE *outf, choice *cols, choice outstyle,
  unsigned int width[], unsigned int bmult, char *name, logical name1st,
  char **lngstr);
extern void printcols(FILE *outf, choice rep, choice *cols, choice outstyle,
  logical multibyte,
  unsigned long reqs, unsigned long pages, double bys, long index, int level,
  unsigned long totr, unsigned long totp, double totb, unsigned int width[],
  unsigned int bmult, char graphby, double unit, char barstyle, char markchar,
  char repsepchar, char decpt, char *compsep, logical name1st,
  logical timegraph, char *imagedir, logical *html, char *name, logical ispage,
  unsigned int spaces, Alias *aliashead, Include *linkhead, char *baseurl,
  char *datefmt, char *timefmt, datecode_t date, unsigned int hr,
  unsigned int min, unsigned int newhr, unsigned int newmin, char **monthname,
  char **dayname, unsigned int monthlen, unsigned int daylen,
  unsigned int plainmonthlen, unsigned int plaindaylen);
extern void lastseven(FILE *outf, choice outstyle, timecode_t last7to,
  char *compsep, char **monthname, char **dayname, unsigned int monthlen,
  unsigned int daylen, char **lngstr);
extern void distcount(Hashindex *gooditems, Hashindex *baditems,
  unsigned long *tot, unsigned long *tot7);
extern void gensumline(FILE *outf, choice outstyle, int namecode,
  unsigned long x, unsigned long x7, char sepchar, char *compsep, logical p,
  char **lngstr);
extern void gensumlineb(FILE *outf, choice outstyle, int namecode, double x,
  double x7, logical rawbytes, char sepchar, char decpt, char *compsep,
  char **lngstr);
extern logical checkonerep(Hashindex *gp, choice requests);
extern logical checksearchrep(Hashindex *gp, choice requests, Strpair *list);
extern logical checktreerep(Hashtable *tp, choice requests);
extern logical checkarrayrep(Arraydata *array);
extern void checkreps(Outchoices *od, logical *repq, Dateman *dman,
  choice *alltrees, choice *alldervs, Hashindex **gooditems, Tree **trees,
  Derv **dervs, Arraydata **arraydata);

/* in process.c */
extern void process_data(Filelist *logfilep, FILE *lf, Hashtable **hash,
  Arraydata **arraydata, choice *count, choice *code2type, Include **wanthead,
  Include *ispagehead, Alias **aliashead, Include *argshead,
  Include *refargshead, Dateman *dman, Tree **tree, Derv **derv,
  choice *alltrees, choice *alldervs, choice *lowmem, logical case_insensitive,
  logical usercase_insensitive, unsigned char convfloor, char *dirsuffix,
  unsigned int dirsufflength, unsigned int granularity);
extern void corrupt_line(FILE *lf, Filelist *logfilep, char *message,
  ptrdiff_t n);
extern void arrayscore(Arraydata *array, double amount, unsigned long reqs,
  unsigned long pages, double bytes, timecode_t timecode);

/* in settings.c */
extern void report_vbles(Options *op);
extern void report_compile(void);
extern void report_debug(char *type, char *arg);
extern void report_conffiles(Strlist *list);
extern void report_logfiles(Filelist *logfile, logical cache);
extern void report_logformat(FILE *outf, Inputformatlist *format,
  logical inwarn);
extern void report_fromto(Dateman *dman);
extern void report_want(Include *wanthead, char *type, char *indent);
extern void report_scwant(choice *code2type);
extern void report_alias(Alias *aliashead, char *type, char *indent);
#ifndef NOPIPES
extern void report_uncompress(void);
#endif
extern void report_lowmem(choice lowmem[ITEM_NUMBER]);
#ifndef NODNS
extern void report_dns(void);
#endif
extern void report_outopts(Outchoices *od);
extern void report_sep(char c, char *type);
extern void report_daterep(Outchoices *od, choice j);
extern void report_genrep(Outchoices *od, choice j);
extern void report_cols(choice *cols);
extern void report_sortby(choice sortby, logical sub);
extern void report_floor(Floor *floor, logical sub);
extern void check_file(char *name);

/* in sort.c */
extern void my_sort(Hashindex **gooditems, Hashindex **baditems,
  Strlist *partname, Strlist **newpn, Strlist *space, size_t need, choice rep,
  Floor *floor, choice sortby, logical alphaback, Include *wanthead,
  choice requests, choice date, unsigned long totr, unsigned long totp,
  double totb, unsigned long maxr, unsigned long maxp, double maxb);
extern Hashindex *my_mergesort(Hashindex *list, unsigned long length,
  choice sortby, mergefnp mergefn);
extern Hashindex *merge(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);
extern Hashindex *mergea(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);
extern Hashindex *mergeb(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);

/* in tree.c */
extern Hashindex *treefind(char *name, char *nameend, Hashtable **tree,
  Hashindex *item, cutfnp cutfn, logical build, logical transient,
  logical reuse, Memman *space);
extern void graft(Hashtable **new, Hashtable *old, Memman *space);
extern void allgraft(Hashtable *t, Memman *space);
extern Hashindex *newtreeentry(char *name, char *nameend, Hashindex *item,
  logical transient, logical reuse, Memman *space);
extern Hashentry *newtreedata(Hashentry *from, Memman *space);
extern void treescore(Hashentry *to, Hashentry *from);
extern Hashindex *sorttree(Hashtable *tree, choice rep, Floor *floor,
  choice sortby, Floor *subfloor, choice subsortby, logical alphaback,
  unsigned int level, Strlist *partname, Include *wanthead, Alias *notcorrupt,
  choice requests, choice date, unsigned long totr, unsigned long totp,
  double totb, unsigned long maxr, unsigned long maxp, double maxb,
  Hashentry **badp, unsigned long *badn, Memman *space);
extern void maketree(Tree *treex, Hashindex *gooditems, Hashindex *baditems);
extern void makederived(Derv *derv, Hashindex *gooditems, Hashindex *baditems,
  unsigned char convfloor, choice rep);
extern char *maketreename(Strlist *pn, Hashindex *p, Strlist **newpn,
  Strlist *space, size_t need, choice rep, logical delims);
extern logical sublevels(Hashtable *tree);
extern logical genstreq(char *a, char *b, char *t);
extern void rnextname(char **name, char **nameend, char *whole, logical build);
extern void inextname(char **name, char **nameend, char *whole, logical build);
extern void onextname(char **name, char **nameend, char *whole, logical build);
extern void tnextname(char **name, char **nameend, char *whole, logical build);
extern void snextname(char **name, char **nameend, char *whole, logical build);
extern void Znextname(char **name, char **nameend, char *whole, logical build);
extern void bnextname(char **name, char **nameend, char *whole, logical build);
extern void pnextname(char **name, char **nameend, char *whole, logical build);
extern void Bnextname(char **name, char **nameend, char *whole, Strpair *list);
extern void Pnextname(char **name, char **nameend, char *whole, Strpair *list);
extern void Nnextname(char **name, char **nameend, char *whole, Strpair *list);
extern void nnextname(char **name, char **nameend, char *whole, Strpair *list);

/* in utils.c */
extern void my_exit(int status);
extern void sighandler(int sig);
extern logical substrcaseeq(char *s, char *t);
extern char *strtoupper(char *n);
extern void strtolowerx(char *n);
extern void toloweralias(Alias *ap, logical both);
extern void tolowerinc(Include *ip);
extern void reversealias(Alias **head);
extern logical strcaseeq(char *s, char *t);
#ifdef NEED_STRCMP
extern int my_strcmp(char *s, char *t);
#endif
extern unsigned int chrn(char *s, char c);
extern unsigned int chrdistn(char *s, char c);
extern unsigned int log10i(unsigned long i);
extern unsigned int log10x(double d);
extern unsigned int findbmult(double d);
extern unsigned long arraymaxl(unsigned long *x, unsigned int size);
extern double arraymaxd(double *x, unsigned int size);
extern size_t arraymaxlen(char **s, unsigned int size, choice outstyle);
extern void prettyprintf(FILE *outf, unsigned int pagewidth, char *s,
  va_list ap);
extern void mprintf(FILE *outf, unsigned int pagewidth, char *s, ...);
extern void print_progversion(FILE *f);
extern void warn(char c, choice domess, char *s, ...);
extern void error(char *s, ...);
extern void debug(char c, char *s, ...);
extern char *delimit(char *s);
extern void *xmalloc(size_t size);
extern void *xrealloc(void *ptr, size_t size);
extern void *submalloc(Memman *m, size_t size);
extern void freemm(Memman *m);
#ifdef NEED_MEMMOVE
extern void *memmove(void *dst0, const void *src0, size_t length);
#endif
extern logical wildmatch(char *s, char *p, char *whole, int nmatch,
  ptrdiff_t *pmatch);
extern logical matchq(char *s, void *p, logical is_regex, ptrdiff_t *pmatch);
extern logical genwildmatch(char *s, char *s2, char *p);
extern logical headmatch(char *s, char *p);
extern logical headcasematch(char *s, char *p);
extern logical included(char *name, logical ispage, Include *listhead);
extern logical pageq(char *name, Include *ispagehead, choice type);

/* in win32.c */
#ifdef WIN32
extern void Win32Init(void);
extern void Win32Cleanup(void);
#endif  /* WIN32 */

#endif  /* anlghea4.h not previously included */
