/***             analog 4.13             http://www.analog.cx/             ***/
/*** This program is copyright (c) Stephen R. E. Turner 1995 - 2000 except as
 *** stated otherwise. Distribution, usage and modification of this program is
 *** subject to the conditions of the Licence which you should have received
 *** with it. This program comes with no warranty, expressed or implied.   ***/

/*** anlghead.h: first header file ***/

/*** This file contains the user-definable options which you are most likely to
 *** want to change. Edit any of the #define lines according to your desires.
 *** However, all of them except MANDATORYCONFIGFILE can be changed at run
 *** time as well. ***/ 

/*** These settings are overridden by any in your configuration file. ***/

/*** DON'T REMOVE THE #'S -- THEY'RE NOT COMMENTS! ***/

#ifndef ANLGHEAD
#define ANLGHEAD

#ifndef HOSTNAME
#define HOSTNAME "[my organisation]"
/* the name of your organisation or WWW host. This is used for printing
   at the top of the output */
#endif

#ifndef HOSTURL
#define HOSTURL "none"
/* the URL of your host's home page, for linking to at the top of the
   output; use "none" for no linking. */
#endif

#ifndef ANALOGDIR
#define ANALOGDIR "/usr/local/analog-4.13/"
#endif
/* The directory where your analog stuff lives (or will live). You need to
   get this right otherwise analog won't be able to find any of its auxiliary
   files.
     This is just used in this file and anlghea2.h to build up other filenames.
   For example, we will have #define DEFAULTCONFIGFILE ANALOGDIR"analog.cfg"
   which means the file analog.cfg within the ANALOGDIR. */

#ifndef LOGFILE
#define LOGFILE "/usr/local/apache/logs/access_log"
/* The name of the default logfile. Can be a list, separated by commas
   (but no spaces), and can include wild cards. */
#endif

#ifndef OUTFILE
#define OUTFILE "stdout"
/* The default file for output. Use "stdout" for stdout. */
#endif

#ifndef IMAGEDIR
#define IMAGEDIR "images/"
/* URL of the directory where the images for the graphical reports live.
   The URL can be absolute, or relative to the output page: e.g., just the
   empty string "" for the same directory as the output page. */
#endif

#ifndef LOGO
#define LOGO "analogo.gif"
/* the file where the analog logo lives: within the IMAGEDIR unless it
   starts with / or contains :// . You can put another logo in here (your
   organisation's logo, for example). Use "none" for no logo. */
#endif

#ifndef STYLESHEET
#define STYLESHEET "none"
/* The URL of your style sheet. Use "none" for no style sheet. */
#endif

#ifndef DEFAULTCONFIGFILE
#define DEFAULTCONFIGFILE ANALOGDIR"analog.cfg"
/* the name of the default configuration file; see README.html for a
   description of this file. Use "none" (NOT ANALOGDIR"none"!) for no
   configuration file. */
#endif

#ifndef MANDATORYCONFIGFILE
#define MANDATORYCONFIGFILE "none"
/* A mandatory configuration file; read after all other arguments so
   overrides everything. Program exits if it is not found. Use "none"
   for none. */
#endif

#include "anlghea2.h"
/* You can edit anlghea2.h as well. But the options in there are ones which
   you're unlikely to want to change now. */

#endif  /* anlghead.h not previously included */
