$! Make Analog under OpenVMS
$!
$! In case of problems with the install you might contact me at
$! zinser@decus.de (preferred) or zinser@sysdev.exchange.de
$!
$! Change history (major changes only):
$!
$! Cast: RLD  Rick Dyson (rick-dyson@uiowa.edu)
$!       MPJZ Martin Zinser
$! Date      Who   What
$! ========  ====  =============================================================
$! 19991201  RLD   Updated for Analog v4.0
$! 19991210  MPJZ  Clue "Make" that it has be called via build_analog
$! 20000320  RLD   Added in new routines for v4.1
$! 20000403  MPJZ  Streamline build, and generate analog.opt automatically
$! 20001010  RLD   Added /Define qualifier for v4.12
$!
$ target_found = 0
$ deb_flag     = 0
$!
$! Check for MMK/MMS
$!
$ Make = ""
$ If F$Search ("Sys$System:MMS.EXE") .nes. "" Then Make = "MMS"
$ If F$Type (MMK) .eqs. "STRING" Then Make = "MMK"
$!
$! Setup standard Compile & Link options
$!
$ cflags = "/Define = HAVE_ADDR_T /Name = As_Is "
$ lopts = ""
$!
$! Look for the compiler used
$!
$ If (F$GetSyi ("HW_MODEL") .ge. 1024)
$   Then
$       cflags = "/Prefix = All " + "''cflags'"
$   Else
$       If (F$Search ("Sys$System:DECC$Compiler.exe") .nes. "")
$           Then
$               cflags = "/DECC /Prefix = All " + "''cflags'"
$       EndIf
$ EndIf
$!
$! Check if we want to build a Debug image
$!
$ If (P1 .eqs. "DEBUG" .or. P2 .eqs. "DEBUG")
$   Then
$       cflags = cflags + "/NoOptimize /Debug "
$       lopts = lopts + "/Debug "
$       deb_flag = 1
$ EndIf
$
$ target = F$Edit (P1, "upcase")
$ target = F$Edit (P2, "upcase")
$ If (P1 .eqs. "" .and. P2 .eqs. "") .or. -
     ((P1 .eqs. "" .or. P2 .eqs. "") .and. deb_flag) Then GoSub COMPILE
$ If (P1 .eqs. "INSTALL" .or. P2 .eqs. "INSTALL") Then GoSub INSTALL
$ If (P1 .eqs. "CLEAN" .or. P2 .eqs. "CLEAN") Then GoSub CLEAN
$ If (P1 .eqs. "CLOBBER" .or. P2 .eqs. "CLOBBER") Then GoSub CLOBBER
$
$ If (.not. target_found)
$   Then
$       Write Sys$Output "Error processing parameters ''P1' ''P2'."
$       Write Sys$Output "No action found to process."
$       Write Sys$Output "Supported values:"
$       Write Sys$Output """""      - Build analog"
$       Write Sys$Output "Install - copy analog.exe to www_system" 
$       Write Sys$Output "Clean   - purge intermediary files"
$       Write Sys$Output "Clobber - Delete intermediary files; purge sources"
$ EndIf
$
$ Exit
$
$COMPILE:
$!
$ target_found = 1
$ SRC = "analog,cache,globals,init,init2,hash,utils,dates,tree,alias,input," + -
        "output,output2,process,sort,settings,pcre"
$!
$! Build option file
$!
$ open/write optf analog.opt
$ num = 0
$OPTF_LOOP:
$ module = f$element(num,",",src)
$ if module .eqs. "," then goto build
$ write optf "''module'.obj"
$ num = num + 1
$ goto optf_loop 
$BUILD:
$ write optf "Identification=""Analog"""
$ close optf
$ If (Make .eqs. "")
$   Then
$       Set File anlghea3.h /NoExpire
$       num = 0
$CC_LOOP:
$       module = f$element(num,",",src)
$       if module .eqs. "," then goto lnk
$       CC 'cflags' 'module'.c
$       num = num + 1
$       goto cc_loop
$LNK:
$       Link 'lopts' analog/option
$   Else
$       'Make' /Macro = ("compflags=''cflags' $(CFLAGS)", "lflags=$(LINKFLAGS) ''lopts'", CALLED=1)
$ EndIf
$
$ Return
$
$INSTALL:
$
$ target_found = 1
$ If (Make .eqs. "")
$   Then
$       Copy analog.exe WWW_System:
$   Else
$       'Make' /Macro = ("compflags=''cflags' $(CFLAGS)", "lflags=$(LINKFLAGS) ''lopts'", CALLED=1) install
$ EndIf
$
$ Return
$
$CLEAN:
$
$ target_found = 1
$ If (Make .eqs. "")
$   Then
$       Purge /NoConfirm *.obj,*.exe,*.opt
$   Else
$       'Make' /Macro = (CALLED=1) clean
$ EndIf
$
$ Return
$
$CLOBBER:
$
$ target_found = 1
$ If (Make .eqs. "")
$   Then
$       GoSub clean
$       Purge /NoConfirm *.h, *.c, *.mms, *.com
$       Delete /NoConfirm *.obj;,*.exe;,*.opt;
$   Else
$       'Make' /Macro = (CALLED=1) clobber
$ EndIf
$
$ Return
