/***             analog 4.13             http://www.analog.cx/             ***/
/*** This program is copyright (c) Stephen R. E. Turner 1995 - 2000 except as
 *** stated otherwise. Distribution, usage and modification of this program is
 *** subject to the conditions of the Licence which you should have received
 *** with it. This program comes with no warranty, expressed or implied.   ***/

/*** globals.c; declaration and initialisation of globals, and defaults ***/
/* See also init.c and init2.c */

#include "anlghea3.h"

/* Program time */
time_t origstarttime, starttime;
timecode_t starttimec, starttimeuxc;

/* What to read from input lines */
unsigned int year, month, date, hr, min, code;
unsigned long unixtime, proctime;
double bytes;
char am;

/* Input processing */
char *block_start, *block_end, *block_bell, *record_start, *pos;
logical termchar[256];

/* Memory allocation */
Memman *xmemman, *amemman, mm[ITEM_NUMBER], mmq, mms;
char *workspace;

/* DNS lookups: externs so that no worries about whether to pass them around */
#ifndef NODNS
choice dnslevel;
char *dnsfile, *dnslockfile;
FILE *dnsfilep = NULL, *dnslock = NULL;
Hashtable *dnstable;
unsigned int dnsgoodhrs, dnsbadhrs;
#endif

/* Signal entries for unwanted hash entries (NULL is already used for unset) */
Hashentry *unwanted_entry, *blank_entry;
Hashindex *dummy_item;

/* Translating reports to other arrays */
choice *rep2type, *rep2reqs, *rep2date;
unsigned int *rep2gran, *rep2lng, *rep2datefmt, *rep2colhead, *rep2busystr;
unsigned int *col2colhead, *method2sing, *method2pl, *method2date;
unsigned int *method2pc, *method2relpc, *method2sort;
char byteprefix[] = {' ', 'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};

/* Domain levels; making this global is messy but easiest */
Strpair **domlevels;

/* Log formats */
Inputformatlist *logformat = NULL, *deflogformat;
logical newloglist = TRUE;
int tz = 0, stz = 0;
choice wantitem[INPUT_NUMBER];
#ifndef NOPIPES
Strpair *uncompresshead = NULL;
#endif

/* Debugging, warnings, pretty printing */
FILE *errfile;
char *commandname;
char *debug_args, *warn_args;
logical anywarns = FALSE, errmess = FALSE, vblesonly = FALSE;
unsigned int errwidth = ERRLINELENGTH;
unsigned long progressfreq = 0;
unsigned int ppcol = 0;

/* Names for things, always in order of enums in anlghea3.h */
char *item_type[] = {"virtual hosts", "files", "users", "referrers",
		       "browsers", "hosts"};
/* In methodname, we don't need them all, because some only occur internally */
char *methodname[] = {"requests", "pages", "", "", "date", "", "", "bytes",
			"alphabetical", "random"};
/* Filenames for each language, in order of enum in anlghea3.h */
char *country[] = {"am", "ba", "bg", "cat", "cns", "cnt", "hr", "cz", "dk",
		   "nl", "uk", "us", "fi", "fr", "de", "gr", "hu", "is", "it",
		   "jp", "kr", "no", "no2", "pl", "pt", "br", "ro", "ru", "yu",
		   "sk", "si", "es", "se", "tr", "ua"};
/* Report code letters in order of enum in anlghea3.h */
char repcodes[] = "mWDdHh45xrEItiSofskKBvuJZNnbpzcP";
/* Names for the anchors within the report, in the same order */
char *anchorname[] = {"Month", "Week", "DayRep", "DaySum", "HourRep",
		      "HourSum", "Quarter", "Five", "GenSum", "Req", "Redir",
		      "Fail", "Type", "Dir", "Host", "Dom", "Ref", "RefSite",
		      "RedirRef", "FailRef", "BrowRep", "VHost", "User",
		      "FailUser", "Org", "SearchQuery", "SearchWord",
		      "BrowSum", "OS", "Size", "Code", "ProcTime"};
/* These report names are in English, so not the same as in langfile */
/* In order of enum in anlghea3.h */
char *repname[] = {"Monthly Report", "Weekly Report", "Daily Report",
		   "Daily Summary", "Hourly Report", "Hourly Summary",
		   "Quarter-Hour Report", "Five-Minute Report",
		   "General Summary", "Request Report", "Redirection Report",
		   "Failure Report", "File Type Report", "Directory Report",
		   "Host Report", "Domain Report", "Referrer Report",
		   "Referring Site Report", "Redirected Referrer Report",
		   "Failed Referrer Report", "Browser Report",
		   "Virtual Host Report", "User Report", "User Failure Report",
		   "Organisation Report", "Search Query Report",
		   "Search Word Report", "Browser Summary",
		   "Operating System Report", "File Size Report",
		   "Status Code Report", "Processing Time Report"};

/* EBCDIC character set */
/* This character set was contributed to analog by
   Martin Kraemer (Martin.Kraemer@Mch.SNI.De) and
   Holger Schranz (schranz@munich.crosswinds.net). It was originally
   developed by the Apache Group for use in the Apache HTTP server project
   (http://www.apache.org/).
   Copyright (c) 1998 The Apache Group.  All rights reserved. */
#ifdef EBCDIC
const unsigned char os_toebcdic[256] = {
  /*00*/  0x00, 0x01, 0x02, 0x03, 0x37, 0x2d, 0x2e, 0x2f,
	  0x16, 0x05, 0x15, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,  /*................*/
  /*10*/  0x10, 0x11, 0x12, 0x13, 0x3c, 0x3d, 0x32, 0x26,
	  0x18, 0x19, 0x3f, 0x27, 0x1c, 0x1d, 0x1e, 0x1f,  /*................*/
  /*20*/  0x40, 0x5a, 0x7f, 0x7b, 0x5b, 0x6c, 0x50, 0x7d,
	  0x4d, 0x5d, 0x5c, 0x4e, 0x6b, 0x60, 0x4b, 0x61,  /*!"#$%&'()*+,-./ */
  /*30*/  0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	  0xf8, 0xf9, 0x7a, 0x5e, 0x4c, 0x7e, 0x6e, 0x6f,  /*0123456789:;<=>?*/
  /*40*/  0x7c, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	  0xc8, 0xc9, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6,  /*@ABCDEFGHIJKLMNO*/
  /*50*/  0xd7, 0xd8, 0xd9, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6,
	  0xe7, 0xe8, 0xe9, 0xbb, 0xbc, 0xbd, 0x6a, 0x6d,  /*PQRSTUVWXYZ[\]^_*/
  /*60*/  0x4a, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	  0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,  /*`abcdefghijklmno*/
  /*70*/  0x97, 0x98, 0x99, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6,
	  0xa7, 0xa8, 0xa9, 0xfb, 0x4f, 0xfd, 0xff, 0x07,  /*pqrstuvwxyz{|}~.*/
  /*80*/  0x20, 0x21, 0x22, 0x23, 0x24, 0x04, 0x06, 0x08,
	  0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x09, 0x0a, 0x14,  /*................*/
  /*90*/  0x30, 0x31, 0x25, 0x33, 0x34, 0x35, 0x36, 0x17,
	  0x38, 0x39, 0x3a, 0x3b, 0x1a, 0x1b, 0x3e, 0x5f,  /*................*/
  /*a0*/  0x41, 0xaa, 0xb0, 0xb1, 0x9f, 0xb2, 0xd0, 0xb5,
	  0x79, 0xb4, 0x9a, 0x8a, 0xba, 0xca, 0xaf, 0xa1,  /*................*/
  /*b0*/  0x90, 0x8f, 0xea, 0xfa, 0xbe, 0xa0, 0xb6, 0xb3,
	  0x9d, 0xda, 0x9b, 0x8b, 0xb7, 0xb8, 0xb9, 0xab,  /*................*/
  /*c0*/  0x64, 0x65, 0x62, 0x66, 0x63, 0x67, 0x9e, 0x68,
	  0x74, 0x71, 0x72, 0x73, 0x78, 0x75, 0x76, 0x77,  /*................*/
  /*d0*/  0xac, 0x69, 0xed, 0xee, 0xeb, 0xef, 0xec, 0xbf,
	  0x80, 0xe0, 0xfe, 0xdd, 0xfc, 0xad, 0xae, 0x59,  /*................*/
  /*e0*/  0x44, 0x45, 0x42, 0x46, 0x43, 0x47, 0x9c, 0x48,
	  0x54, 0x51, 0x52, 0x53, 0x58, 0x55, 0x56, 0x57,  /*................*/
  /*f0*/  0x8c, 0x49, 0xcd, 0xce, 0xcb, 0xcf, 0xcc, 0xe1,
	  0x70, 0xc0, 0xde, 0xdb, 0xdc, 0x8d, 0x8e, 0xdf   /*................*/
};

const unsigned char os_toascii_strictly[256] = {
/*00*/ 0x00, 0x01, 0x02, 0x03, 0x85, 0x09, 0x86, 0x7f,
       0x87, 0x8d, 0x8e, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, /*................*/
/*10*/ 0x10, 0x11, 0x12, 0x13, 0x8f, 0x0a, 0x08, 0x97,
       0x18, 0x19, 0x9c, 0x9d, 0x1c, 0x1d, 0x1e, 0x1f, /*................*/
/*20*/ 0x80, 0x81, 0x82, 0x83, 0x84, 0x92, 0x17, 0x1b,
       0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x05, 0x06, 0x07, /*................*/
/*30*/ 0x90, 0x91, 0x16, 0x93, 0x94, 0x95, 0x96, 0x04,
       0x98, 0x99, 0x9a, 0x9b, 0x14, 0x15, 0x9e, 0x1a, /*................*/
/*40*/ 0x20, 0xa0, 0xe2, 0xe4, 0xe0, 0xe1, 0xe3, 0xe5,
       0xe7, 0xf1, 0x60, 0x2e, 0x3c, 0x28, 0x2b, 0x7c, /* .........`.<(+|*/
/*50*/ 0x26, 0xe9, 0xea, 0xeb, 0xe8, 0xed, 0xee, 0xef,
       0xec, 0xdf, 0x21, 0x24, 0x2a, 0x29, 0x3b, 0x9f, /*&.........!$*);.*/
/*60*/ 0x2d, 0x2f, 0xc2, 0xc4, 0xc0, 0xc1, 0xc3, 0xc5,
       0xc7, 0xd1, 0x5e, 0x2c, 0x25, 0x5f, 0x3e, 0x3f, /*-/........^,%_>?*/
/*70*/ 0xf8, 0xc9, 0xca, 0xcb, 0xc8, 0xcd, 0xce, 0xcf,
       0xcc, 0xa8, 0x3a, 0x23, 0x40, 0x27, 0x3d, 0x22, /*..........:#@'="*/
/*80*/ 0xd8, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
       0x68, 0x69, 0xab, 0xbb, 0xf0, 0xfd, 0xfe, 0xb1, /*.abcdefghi......*/
/*90*/ 0xb0, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
       0x71, 0x72, 0xaa, 0xba, 0xe6, 0xb8, 0xc6, 0xa4, /*.jklmnopqr......*/
/*a0*/ 0xb5, 0xaf, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
       0x79, 0x7a, 0xa1, 0xbf, 0xd0, 0xdd, 0xde, 0xae, /*..stuvwxyz......*/
/*b0*/ 0xa2, 0xa3, 0xa5, 0xb7, 0xa9, 0xa7, 0xb6, 0xbc,
       0xbd, 0xbe, 0xac, 0x5b, 0x5c, 0x5d, 0xb4, 0xd7, /*...........[\]..*/
/*c0*/ 0xf9, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
       0x48, 0x49, 0xad, 0xf4, 0xf6, 0xf2, 0xf3, 0xf5, /*.ABCDEFGHI......*/
/*d0*/ 0xa6, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
       0x51, 0x52, 0xb9, 0xfb, 0xfc, 0xdb, 0xfa, 0xff, /*.JKLMNOPQR......*/
/*e0*/ 0xd9, 0xf7, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
       0x59, 0x5a, 0xb2, 0xd4, 0xd6, 0xd2, 0xd3, 0xd5, /*..STUVWXYZ......*/
/*f0*/ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
       0x38, 0x39, 0xb3, 0x7b, 0xdc, 0x7d, 0xda, 0x7e  /*0123456789.{.}.~*/
};
#endif

logical convertchar[256] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 00 - 0F */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 10 - 1F */
  1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,   /* 20 - 2F */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,   /* 30 - 3F */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   /* 40 - 4F */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   /* 50 - 5F */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   /* 60 - 6F */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,   /* 70 - 7F */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 80 - 8F */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 90 - 9F */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* A0 - AF */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* B0 - BF */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* C0 - CF */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* D0 - DF */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* E0 - EF */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};  /* F0 - FF */
/* %nm escapes to convert in do_alias(r|f). We convert all ASCII printable
   characters (0x20 - 0x7E) with the exception of % (0x25) [to distinguish
   %25ab from %ab]; and ? (0x3f) and & (0x26) [to split query strings up
   correctly]. Could argue for + (0x2b) in query strings, but messes search
   reports up if we do this. */

Inputfns inpfns[] = { /* first the ITEM fns in any order */
  /* See also ITEMFNS_NUMBER in anlghea3.c */
  {'v', ITEM_VHOST, &parsestring, &mm[ITEM_VHOST]},
  {'r', ITEM_FILE, &parsestring, &mm[ITEM_FILE]},
  {'u', ITEM_USER, &parsestring, &mm[ITEM_USER]},
  {'f', ITEM_REFERRER, &parsestring, &mm[ITEM_REFERRER]},
  {'B', ITEM_BROWSER, &parsestring, &mm[ITEM_BROWSER]},
  {'S', ITEM_HOST, &parsestring, &mm[ITEM_HOST]},
  {'F', ITEM_REFERRER, &parseref, &mm[ITEM_REFERRER]},
  {'A', ITEM_BROWSER, &parsemsbrow, &mm[ITEM_BROWSER]},
  {'q', INP_QUERY, &parsestring, &mmq},
  {'s', INP_IP, &parsestring, &mms},
  {'n', INP_MIN, &parseuint2strict, (void *)&min},
  {'h', INP_HOUR, &parseuint2, (void *)&hr},
  {'a', INP_AM, &parseam, (void *)&am},
  {'d', INP_DATE, &parseuint2, (void *)&date},
  {'m', INP_MONTH, &parsenmonth, (void *)&month},
  {'M', INP_MONTH, &parsemonth, (void *)&month},
  {'y', INP_YEAR, &parseyear, (void *)&year},
  {'Y', INP_YEAR, &parseuint4strict, (void *)&year},
  {'U', INP_UNIXTIME, &parseulong, (void *)&unixtime},
  {'T', INP_PROCTIME, &parseulong, (void *)&proctime},
  {'t', INP_PROCTIME, &parseproctime, (void *)&proctime},
  {'c', INP_CODE, &parsescode, (void *)&code},
  {'C', INP_CODE, &parsecode, (void *)&code},
  {'b', INP_BYTES, &parseudint, (void *)&bytes},
  {'w', UNSET, &parsespace, NULL},
  {'W', UNSET, &parseoptspace, NULL},
  {'j', UNSET, &parsejunk, NULL},
  {'x', UNSET, &parselogfmt, NULL},
  {'\0', UNSET, &checkchar, NULL}  /* this one must be last as marker */
};
Inputfns pnlinpfn = {'\n', UNSET, &parsenewline, NULL};
Inputfns ccinpfn = {'\0', UNSET, &checkchar, NULL};
Inputfns pjinpfn = {'j', UNSET, &parsejunk, NULL};

Options opts;
/* So that in future we can have several sets of options, and yet still
   declare cf[] neatly as below, we shunt them in and out of opts */
Configfns cf[] = {
  {"TIMECOLS", &configallcols, (void *)(opts.outopts.cols)},
  {"MONTHCOLS", &configcols, (void *)(opts.outopts.cols[REP_MONTH])},
  {"WEEKCOLS", &configcols, (void *)(opts.outopts.cols[REP_WEEK])},
  {"FULLDAYCOLS", &configcols, (void *)(opts.outopts.cols[REP_DAYREP])},
  {"DAYCOLS", &configcols, (void *)(opts.outopts.cols[REP_DAYSUM])},
  {"FULLHOURCOLS", &configcols, (void *)(opts.outopts.cols[REP_HOURREP])},
  {"HOURCOLS", &configcols, (void *)(opts.outopts.cols[REP_HOURSUM])},
  {"QUARTERCOLS", &configcols, (void *)(opts.outopts.cols[REP_QUARTER])},
  {"FIVECOLS", &configcols, (void *)(opts.outopts.cols[REP_FIVE])},
  {"REQCOLS", &configcols, (void *)(opts.outopts.cols[REP_REQ])},
  {"REDIRCOLS", &configcols, (void *)(opts.outopts.cols[REP_REDIR])},
  {"FAILCOLS", &configcols, (void *)(opts.outopts.cols[REP_FAIL])},
  {"TYPECOLS", &configcols, (void *)(opts.outopts.cols[REP_TYPE])},
  {"SIZECOLS", &configcols, (void *)(opts.outopts.cols[REP_SIZE])},
  {"PROCTIMECOLS", &configcols, (void *)(opts.outopts.cols[REP_PROCTIME])},
  {"DIRCOLS", &configcols, (void *)(opts.outopts.cols[REP_DIR])},
  {"HOSTCOLS", &configcols, (void *)(opts.outopts.cols[REP_HOST])},
  {"DOMCOLS", &configcols, (void *)(opts.outopts.cols[REP_DOM])},
  {"ORGCOLS", &configcols, (void *)(opts.outopts.cols[REP_ORG])},
  {"REFCOLS", &configcols, (void *)(opts.outopts.cols[REP_REF])},
  {"REFSITECOLS", &configcols, (void *)(opts.outopts.cols[REP_REFSITE])},
  {"REDIRREFCOLS", &configcols, (void *)(opts.outopts.cols[REP_REDIRREF])},
  {"FAILREFCOLS", &configcols, (void *)(opts.outopts.cols[REP_FAILREF])},
  {"FULLBROWCOLS", &configcols, (void *)(opts.outopts.cols[REP_BROWREP])},
  {"BROWCOLS", &configcols, (void *)(opts.outopts.cols[REP_BROWSUM])},
  {"OSCOLS", &configcols, (void *)(opts.outopts.cols[REP_OS])},
  {"VHOSTCOLS", &configcols, (void *)(opts.outopts.cols[REP_VHOST])},
  {"USERCOLS", &configcols, (void *)(opts.outopts.cols[REP_USER])},
  {"FAILUSERCOLS", &configcols, (void *)(opts.outopts.cols[REP_FAILUSER])},
  {"SEARCHQUERYCOLS", &configcols, (void *)(opts.outopts.cols[REP_SEARCHREP])},
  {"SEARCHWORDCOLS", &configcols, (void *)(opts.outopts.cols[REP_SEARCHSUM])},
  {"STATUSCOLS", &configcols, (void *)(opts.outopts.cols[REP_CODE])},
  {"MONTHGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_MONTH])},
  {"WEEKGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_WEEK])},
  {"FULLDAYGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_DAYREP])},
  {"DAYGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_DAYSUM])},
  {"FULLHOURGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_HOURREP])},
  {"HOURGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_HOURSUM])},
  {"QUARTERGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_QUARTER])},
  {"FIVEGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_FIVE])},
  {"ALLGRAPH", &configallgraph, (void *)(opts.outopts.graph)},
  {"BARSTYLE", &configbarstyle, (void *)&(opts.outopts.barstyle)},
  {"COMPSEP", &configstr, (void *)&(opts.outopts.compsep)},
  {"PRESEP", &configstr, (void *)&(opts.outopts.compsep)},
  {"HOSTNAME", &configstr, (void *)&(opts.outopts.hostname)},
  {"HOSTURL", &configstr, (void *)&(opts.outopts.hosturl)},
  {"LOGO", &configstr, (void *)&(opts.outopts.logo)},
  {"STYLESHEET", &configstr, (void *)&(opts.outopts.stylesheet)},
  {"BASEURL", &configstr, (void *)&(opts.outopts.baseurl)},
  {"LOGFORMAT", &configlogfmt, (void *)&logformat},
  {"DEFAULTLOGFORMAT", &configlogfmt, (void *)&deflogformat},
  {"APACHELOGFORMAT", &configapachelogfmt, (void *)&logformat},
  {"APACHEDEFAULTLOGFORMAT", &configapachelogfmt, (void *)&deflogformat},
  {"TIMEOFFSET", &configoffset, (void *)&stz},
  {"LOGTIMEOFFSET", &configoffset, (void *)&tz},
  {"LOGFILE", &configlogfile, (void *)&(opts.miscopts.logfile)},
  {"CACHEFILE", &configcachefile, (void *)&(opts.miscopts.cachefile)},
  {"IMAGEDIR", &configstr, (void *)&(opts.outopts.imagedir)},
  {"HEADERFILE", &configstr, (void *)&(opts.outopts.headerfile)},
  {"FOOTERFILE", &configstr, (void *)&(opts.outopts.footerfile)},
  {"LANGUAGE", &configlang, (void *)&(opts.outopts.lang)},
  {"LANGFILE", &configstr, (void *)&(opts.outopts.lang.file)},
  {"OUTFILE", &configstr, (void *)&(opts.outopts.outfile)},
  {"CACHEOUTFILE", &configstr, (void *)&(opts.outopts.cacheoutfile)},
  {"ERRFILE", &configerrfile, (void *)&errfile},
  {"DOMAINSFILE", &configstr, (void *)&(opts.outopts.domainsfile)},
  {"DIRSUFFIX", &configstr, (void *)&(opts.miscopts.dirsuffix)},
  {"SEPCHAR", &configchar, (void *)&(opts.outopts.sepchar)},
  {"REPSEPCHAR", &configchar, (void *)&(opts.outopts.repsepchar)},
  {"DECPOINT", &configchar, (void *)&(opts.outopts.decpt)},
  {"MARKCHAR", &configchar, (void *)&(opts.outopts.markchar)},
  {"REQFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_REQ)])},
  {"REQARGSFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_REQ)])},
  {"REDIRFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_REDIR)])},
  {"REDIRARGSFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_REDIR)])},
  {"FAILFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_FAIL)])},
  {"FAILARGSFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_FAIL)])},
  {"TYPEFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_TYPE)])},
  {"SUBTYPEFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_TYPE)])},
  {"DIRFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_DIR)])},
  {"SUBDIRFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_DIR)])},
  {"HOSTFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_HOST)])},
  {"DOMFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_DOM)])},
  {"SUBDOMFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_DOM)])},
  {"ORGFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_ORG)])},
  {"SUBORGFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_ORG)])},
  {"REFFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_REF)])},
  {"REFARGSFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_REF)])},
  {"REFSITEFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_REFSITE)])},
  {"REFDIRFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_REFSITE)])},
  {"REDIRREFFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_REDIRREF)])},
  {"REDIRREFARGSFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_REDIRREF)])},
  {"FAILREFFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_FAILREF)])},
  {"FAILREFARGSFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_FAILREF)])},
  {"FULLBROWFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_BROWREP)])},
  {"BROWFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_BROWSUM)])},
  {"SUBBROWFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_BROWSUM)])},
  {"OSFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_OS)])},
  {"SUBOSFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_OS)])},
  {"VHOSTFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_VHOST)])},
  {"USERFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_USER)])},
  {"FAILUSERFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_FAILUSER)])},
  {"SEARCHQUERYFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_SEARCHREP)])},
  {"SEARCHWORDFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_SEARCHSUM)])},
  {"STATUSFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_CODE)])},
  {"FILEALIAS", &configalias, (void *)&(opts.aliashead[ITEM_FILE])},
  {"HOSTALIAS", &configalias, (void *)&(opts.aliashead[ITEM_HOST])},
  {"REFALIAS", &configalias, (void *)&(opts.aliashead[ITEM_REFERRER])},
  {"BROWALIAS", &configalias, (void *)&(opts.aliashead[ITEM_BROWSER])},
  {"USERALIAS", &configalias, (void *)&(opts.aliashead[ITEM_USER])},
  {"VHOSTALIAS", &configalias, (void *)&(opts.aliashead[ITEM_VHOST])},
  {"SEARCHENGINE", &configstrpair2list, (void *)&(opts.searchengines)},
  {"REQOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REQ)])},
  {"REDIROUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REDIR)])},
  {"FAILOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_FAIL)])},
  {"TYPEOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_TYPE)])},
  {"DIROUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_DIR)])},
  {"HOSTOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_HOST)])},
  {"DOMOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_DOM)])},
  {"ORGOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_ORG)])},
  {"REFOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REF)])},
  {"REFSITEOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REFSITE)])},
  {"REDIRREFOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REDIRREF)])},
  {"FAILREFOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_FAILREF)])},
  {"FULLBROWOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_BROWREP)])},
  {"BROWOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_BROWSUM)])},
  {"OSOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_OS)])},
  {"VHOSTOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_VHOST)])},
  {"USEROUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_USER)])},
  {"FAILUSEROUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_FAILUSER)])},
#ifndef NOPIPES
  {"UNCOMPRESS", &configstrpairlist, (void *)&uncompresshead},
#endif
  {"REQARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_REQ)])},
  {"REDIRARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_REDIR)])},
  {"FAILARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_FAIL)])},
  {"REFARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_REF)])},
  {"REDIRREFARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_REDIRREF)])},
  {"FAILREFARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_FAILREF)])},
  {"SUBDOMAIN", &configtree, (void *)&(opts.outopts.tree[G(REP_DOM)])},
  {"SUBDOM", &configtree, (void *)&(opts.outopts.tree[G(REP_DOM)])},
  {"SUBDIR", &configtree, (void *)&(opts.outopts.tree[G(REP_DIR)])},
  {"SUBTYPE", &configtree, (void *)&(opts.outopts.tree[G(REP_TYPE)])},
  {"REFDIR", &configtree, (void *)&(opts.outopts.tree[G(REP_REFSITE)])},
  {"SUBBROW", &configtree, (void *)&(opts.outopts.tree[G(REP_BROWSUM)])},
  {"SUBOS", &configtree, (void *)&(opts.outopts.tree[G(REP_OS)])},
  {"SUBORG", &configstrlist, (void *)&(opts.outopts.suborgs)},
  {"SUBORG2", &configtree, (void *)&(opts.outopts.tree[G(REP_ORG)])},
  /* have to postpone SUBORG's until domains file has been read */
  {"FILEINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_FILE])},
  {"FILEEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_FILE])},
  {"HOSTINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_HOST])},
  {"HOSTEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_HOST])},
  {"REFINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_REFERRER])},
  {"REFEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_REFERRER])},
  {"BROWINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_BROWSER])},
  {"BROWEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_BROWSER])},
  {"USERINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_USER])},
  {"USEREXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_USER])},
  {"VHOSTINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_VHOST])},
  {"VHOSTEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_VHOST])},
  {"STATUSINCLUDE", &configscinc, (void *)(opts.code2type)},
  {"STATUSEXCLUDE", &configscexc, (void *)(opts.code2type)},
  {"304ISSUCCESS", &configonoff, (void *)&(opts.succ304)},
  {"REQINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_REQ)])},
  {"REQEXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_REQ)])},
  {"REDIRINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_REDIR)])},
  {"REDIREXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_REDIR)])},
  {"FAILINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_FAIL)])},
  {"FAILEXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_FAIL)])},
  {"TYPEINCLUDE", &configincd, (void *)&(opts.outopts.wanthead[G(REP_TYPE)])},
  {"TYPEEXCLUDE", &configexcd, (void *)&(opts.outopts.wanthead[G(REP_TYPE)])},
  {"DIRINCLUDE", &configincs, (void *)&(opts.outopts.wanthead[G(REP_DIR)])},
  {"DIREXCLUDE", &configexcs, (void *)&(opts.outopts.wanthead[G(REP_DIR)])},
  {"HOSTREPINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_HOST)])},
  {"HOSTREPEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_HOST)])},
  {"DOMINCLUDE", &configincd, (void *)&(opts.outopts.wanthead[G(REP_DOM)])},
  {"DOMEXCLUDE", &configexcd, (void *)&(opts.outopts.wanthead[G(REP_DOM)])},
  {"ORGINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_ORG)])},
  {"ORGEXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_ORG)])},
  {"REFREPINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_REF)])},
  {"REFREPEXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_REF)])},
  {"REFSITEINCLUDE", &configincs,
   (void *)&(opts.outopts.wanthead[G(REP_REFSITE)])},
  {"REFSITEEXCLUDE", &configexcs,
   (void *)&(opts.outopts.wanthead[G(REP_REFSITE)])},
  {"REDIRREFINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_REDIRREF)])},
  {"REDIRREFEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_REDIRREF)])},
  {"FAILREFINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_FAILREF)])},
  {"FAILREFEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_FAILREF)])},
  {"BROWSUMINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_BROWSUM)])},
  {"BROWSUMEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_BROWSUM)])},
  {"FULLBROWINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_BROWREP)])},
  {"FULLBROWEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_BROWREP)])},
  {"OSINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_OS)])},
  {"OSEXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_OS)])},
  {"VHOSTREPINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_VHOST)])},
  {"VHOSTREPEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_VHOST)])},
  {"USERREPINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_USER)])},
  {"USERREPEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_USER)])},
  {"FAILUSERINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_FAILUSER)])},
  {"FAILUSEREXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_FAILUSER)])},
  {"SEARCHQUERYINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_SEARCHREP)])},
  {"SEARCHQUERYEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_SEARCHREP)])},
  {"SEARCHWORDINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_SEARCHSUM)])},
  {"SEARCHWORDEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_SEARCHSUM)])},
  {"LINKINCLUDE", &configinc, (void *)&(opts.outopts.link)},
  {"LINKEXCLUDE", &configexc, (void *)&(opts.outopts.link)},
  {"REFLINKINCLUDE", &configinc, (void *)&(opts.outopts.reflink)},
  {"REFLINKEXCLUDE", &configexc, (void *)&(opts.outopts.reflink)},
  {"ARGSINCLUDE", &configinc, (void *)&(opts.argshead)},
  {"ARGSEXCLUDE", &configexc, (void *)&(opts.argshead)},
  {"REFARGSINCLUDE", &configinc, (void *)&(opts.refargshead)},
  {"REFARGSEXCLUDE", &configexc, (void *)&(opts.refargshead)},
  {"PAGEINCLUDE", &configinc, (void *)&(opts.ispagehead)},
  {"PAGEEXCLUDE", &configexc, (void *)&(opts.ispagehead)},
  {"REQSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_REQ)])},
  {"REQARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REQ)])},
  {"REDIRSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_REDIR)])},
  {"REDIRARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REDIR)])},
  {"FAILSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_FAIL)])},
  {"FAILARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_FAIL)])},
  {"TYPESORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_TYPE)])},
  {"SUBTYPESORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_TYPE)])},
  {"DIRSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_DIR)])},
  {"SUBDIRSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_DIR)])},
  {"HOSTSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_HOST)])},
  {"DOMSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_DOM)])},
  {"SUBDOMSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_DOM)])},
  {"ORGSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_ORG)])},
  {"SUBORGSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_ORG)])},
  {"REFSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_REF)])},
  {"REFARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REF)])},
  {"REFSITESORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_REFSITE)])},
  {"REFDIRSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REFSITE)])},
  {"REDIRREFSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_REDIRREF)])},
  {"REDIRREFARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REDIRREF)])},
  {"FAILREFSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_FAILREF)])},
  {"FAILREFARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_FAILREF)])},
  {"FULLBROWSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_BROWREP)])},
  {"BROWSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_BROWSUM)])},
  {"SUBBROWSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_BROWSUM)])},
  {"OSSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_OS)])},
  {"SUBOSSORTBY", &configsortby, (void *)&(opts.outopts.subsortby[G(REP_OS)])},
  {"STATUSSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_CODE)])},
  {"VHOSTSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_VHOST)])},
  {"USERSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_USER)])},
  {"FAILUSERSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_FAILUSER)])},
  {"SEARCHQUERYSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_SEARCHREP)])},
  {"SEARCHWORDSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_SEARCHSUM)])},
  {"ALL", &configall, (void *)(opts.outopts.repq)},
  {"ALLBACK", &configallback, (void *)(opts.outopts.back)},
  {"MONTHLY", &configonoff, (void *)&(opts.outopts.repq[REP_MONTH])},
  {"WEEKLY", &configonoff, (void *)&(opts.outopts.repq[REP_WEEK])},
  {"FULLDAILY", &configonoff, (void *)&(opts.outopts.repq[REP_DAYREP])},
  {"DAILY", &configonoff, (void *)&(opts.outopts.repq[REP_DAYSUM])},
  {"FULLHOURLY", &configonoff, (void *)&(opts.outopts.repq[REP_HOURREP])},
  {"HOURLY", &configonoff, (void *)&(opts.outopts.repq[REP_HOURSUM])},
  {"QUARTER", &configonoff, (void *)&(opts.outopts.repq[REP_QUARTER])},
  {"FIVE", &configonoff, (void *)&(opts.outopts.repq[REP_FIVE])},
  {"GENERAL", &configonoff, (void *)&(opts.outopts.repq[REP_GENSUM])},
  {"LASTSEVEN", &configonoff, (void *)&(opts.outopts.last7)},
  {"RUNTIME", &configonoff, (void *)&(opts.outopts.runtime)},
  {"GOTOS", &configgotos, (void *)&(opts.outopts.gotos)},
  {"REQUEST", &configonoff, (void *)&(opts.outopts.repq[REP_REQ])},
  {"REDIR", &configonoff, (void *)&(opts.outopts.repq[REP_REDIR])},
  {"FAILURE", &configonoff, (void *)&(opts.outopts.repq[REP_FAIL])},
  {"FILETYPE", &configonoff, (void *)&(opts.outopts.repq[REP_TYPE])},
  {"SIZE", &configonoff, (void *)&(opts.outopts.repq[REP_SIZE])},
  {"PROCTIME", &configonoff, (void *)&(opts.outopts.repq[REP_PROCTIME])},
  {"DIRECTORY", &configonoff, (void *)&(opts.outopts.repq[REP_DIR])},
  {"HOST", &configonoff, (void *)&(opts.outopts.repq[REP_HOST])},
  {"DOMAIN", &configonoff, (void *)&(opts.outopts.repq[REP_DOM])},
  {"ORGANISATION", &configonoff, (void *)&(opts.outopts.repq[REP_ORG])},
  {"ORGANIZATION", &configonoff, (void *)&(opts.outopts.repq[REP_ORG])},
  {"REFERRER", &configonoff, (void *)&(opts.outopts.repq[REP_REF])},
  {"REFERER", &configonoff, (void *)&(opts.outopts.repq[REP_REF])},
  {"REFSITE", &configonoff, (void *)&(opts.outopts.repq[REP_REFSITE])},
  {"REDIRREF", &configonoff, (void *)&(opts.outopts.repq[REP_REDIRREF])},
  {"FAILREF", &configonoff, (void *)&(opts.outopts.repq[REP_FAILREF])},
  {"FULLBROWSER", &configonoff, (void *)&(opts.outopts.repq[REP_BROWREP])},
  {"BROWSER", &configonoff, (void *)&(opts.outopts.repq[REP_BROWSUM])},
  {"OSREP", &configonoff, (void *)&(opts.outopts.repq[REP_OS])},
  {"VHOST", &configonoff, (void *)&(opts.outopts.repq[REP_VHOST])},
  {"USER", &configonoff, (void *)&(opts.outopts.repq[REP_USER])},
  {"FAILUSER", &configonoff, (void *)&(opts.outopts.repq[REP_FAILUSER])},
  {"SEARCHQUERY", &configonoff, (void *)&(opts.outopts.repq[REP_SEARCHREP])},
  {"SEARCHWORD", &configonoff, (void *)&(opts.outopts.repq[REP_SEARCHSUM])},
  {"STATUS", &configonoff, (void *)&(opts.outopts.repq[REP_CODE])},
  {"MONTHBACK", &configonoff, (void *)&(opts.outopts.back[REP_MONTH])},
  {"WEEKBACK", &configonoff, (void *)&(opts.outopts.back[REP_WEEK])},
  {"FULLDAYBACK", &configonoff, (void *)&(opts.outopts.back[REP_DAYREP])},
  {"FULLHOURBACK", &configonoff, (void *)&(opts.outopts.back[REP_HOURREP])},
  {"QUARTERBACK", &configonoff, (void *)&(opts.outopts.back[REP_QUARTER])},
  {"FIVEBACK", &configonoff, (void *)&(opts.outopts.back[REP_FIVE])},
  {"RAWBYTES", &configonoff, (void *)&(opts.outopts.rawbytes)},
  {"NOROBOTS", &configonoff, (void *)&(opts.outopts.norobots)},
  {"SETTINGS", &configonoff, (void *)&vblesonly},
  {"CGI", &configonoff, (void *)&(opts.outopts.cgi)},
  {"OUTPUT", &configoutstyle, (void *)&(opts.outopts.outstyle)},
  {"CASE", &configcase, (void *)&(opts.miscopts.case_insensitive)},
  {"USERCASE", &configcase, (void *)&(opts.miscopts.usercase_insensitive)},
  {"SEARCHCHARCONVERT", &configonoff, (void *)&(opts.outopts.searchconv)},
  {"MONTHROWS", &configuint, (void *)&(opts.outopts.rows[REP_MONTH])},
  {"WEEKROWS", &configuint, (void *)&(opts.outopts.rows[REP_WEEK])},
  {"FULLDAYROWS", &configuint, (void *)&(opts.outopts.rows[REP_DAYREP])},
  {"FULLHOURROWS", &configuint, (void *)&(opts.outopts.rows[REP_HOURREP])},
  {"QUARTERROWS", &configuint, (void *)&(opts.outopts.rows[REP_QUARTER])},
  {"FIVEROWS", &configuint, (void *)&(opts.outopts.rows[REP_FIVE])},
  {"FILELOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_FILE])},
  {"HOSTLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_HOST])},
  {"REFLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_REFERRER])},
  {"BROWLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_BROWSER])},
  {"USERLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_USER])},
  {"VHOSTLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_VHOST])},
  {"ASCIIPAGEWIDTH", &configuint, (void *)&(opts.outopts.plainpagewidth)},
  {"PLAINPAGEWIDTH", &configuint, (void *)&(opts.outopts.plainpagewidth)},
  {"HTMLPAGEWIDTH", &configuint, (void *)&(opts.outopts.htmlpagewidth)},
  {"MINGRAPHWIDTH", &configuint, (void *)&(opts.outopts.mingraphwidth)},
  {"ERRLINELENGTH", &configuint, (void *)&errwidth},
  {"PROGRESSFREQ", &configulong, (void *)&progressfreq},
  {"WEEKBEGINSON", &configweekday, (void *)&(opts.outopts.weekbeginson)},
  {"FROM", &configstr, (void *)&(opts.dman.fromstr)},
  {"TO", &configstr, (void *)&(opts.dman.tostr)},
  {"REPORTORDER", &configrepord, (void *)(opts.outopts.reporder)},
  {"DEBUG", &configdebug, (void *)&debug_args},
  {"WARNINGS", &configdebug, (void *)&warn_args},
  {"DOMLEVEL", &configdomlevel, (void *)&domlevels},
#ifndef NODNS
  {"DNS", &configdns, (void *)&dnslevel},
  {"DNSFILE", &configstr, (void *)&dnsfile},
  {"DNSLOCKFILE", &configstr, (void *)&dnslockfile},
  {"DNSGOODHOURS", &configuint, (void *)&dnsgoodhrs},
  {"DNSBADHOURS", &configuint, (void *)&dnsbadhrs},
#endif
  {"CONFIGFILE", &configcall, NULL},
  {"", NULL, NULL}  /* at end as marker */
};

void globals(char *comname) {
  int i;

  time(&starttime);
  (void)parsedate(starttime, "-00-00-00:-00-00", &starttimec, FALSE, FALSE);
  (void)parsedate(starttime, "-00-00-00:-00-00", &starttimeuxc, FALSE, TRUE);
  /* parsedate() is needed because we don't know the encoding of time() */
  errfile = stderr;
  setvbuf(stderr, NULL, ERRBUFMODE, BUFSIZ);
  signal(SIGTERM, sighandler);
  signal(SIGINT, sighandler);
#ifdef SIGHUP
  signal(SIGHUP, sighandler);
#endif
#ifdef SIGQUIT
  signal(SIGQUIT, sighandler);
#endif
  block_start = (char *)xmalloc(BLOCKSIZE);
  workspace = (char *)xmalloc(BLOCKSIZE);
  for (i = 0; i < ITEM_NUMBER; i++) {
    mm[i].curr_pos = NULL;
    mm[i].first = NULL;
    mm[i].alignment = 1;
  }
  mmq.curr_pos = NULL;
  mmq.first = NULL;
  mmq.alignment = 1;
  mms.curr_pos = NULL;
  mms.first = NULL;
  mms.alignment = 1;
  xmemman = (Memman *)xmalloc(sizeof(Memman));
  xmemman->curr_pos = NULL;
  xmemman->first = NULL;
  xmemman->alignment = ALIGNMENT;
  amemman = (Memman *)xmalloc(sizeof(Memman));
  amemman->curr_pos = NULL;
  amemman->first = NULL;
  amemman->alignment = ALIGNMENT;
  for (i = 0; i < 256; i++)
    termchar[i] = FALSE;
  termchar[(unsigned char)'\r'] = TRUE;
  termchar[(unsigned char)'\n'] = TRUE;
  termchar[(unsigned char)'\0'] = TRUE;
  if (IS_EMPTY_STRING(comname))
    DEFAULTSTR(commandname, "analog")  /* no semicolon by defn of DEFAULTSTR */
  else
    DEFAULTSTR(commandname, comname);
  unwanted_entry = newhashentry(FALSE);
  blank_entry = newhashentry(FALSE);
  dummy_item = (Hashindex *)submalloc(xmemman, sizeof(Hashindex));
  dummy_item->own = newhashentry(FALSE);
  rep2lng = (unsigned int *)xmalloc(REP_NUMBER * sizeof(unsigned int));
  rep2lng[REP_GENSUM] = gensum_;
  rep2lng[REP_MONTH] = monthrep_;
  rep2lng[REP_WEEK] = weekrep_;
  rep2lng[REP_DAYREP] = dayrep_;
  rep2lng[REP_DAYSUM] = daysum_;
  rep2lng[REP_HOURREP] = hourrep_;
  rep2lng[REP_HOURSUM] = hoursum_;
  rep2lng[REP_QUARTER] = quarter_;
  rep2lng[REP_FIVE] = five_;
  rep2lng[REP_REQ] = reqrep_;
  rep2lng[REP_REDIR] = redirrep_;
  rep2lng[REP_FAIL] = failrep_;
  rep2lng[REP_TYPE] = typerep_;
  rep2lng[REP_SIZE] = sizerep_;
  rep2lng[REP_PROCTIME] = proctimerep_;
  rep2lng[REP_DIR] = dirrep_;
  rep2lng[REP_HOST] = hostrep_;
  rep2lng[REP_DOM] = domrep_;
  rep2lng[REP_ORG] = orgrep_;
  rep2lng[REP_REF] = refrep_;
  rep2lng[REP_REFSITE] = refsiterep_;
  rep2lng[REP_REDIRREF] = redirrefrep_;
  rep2lng[REP_FAILREF] = failrefrep_;
  rep2lng[REP_BROWREP] = browrep_;
  rep2lng[REP_BROWSUM] = browsum_;
  rep2lng[REP_OS] = osrep_;
  rep2lng[REP_VHOST] = vhostrep_;
  rep2lng[REP_USER] = userrep_;
  rep2lng[REP_FAILUSER] = failuserrep_;
  rep2lng[REP_SEARCHREP] = searchrep_;
  rep2lng[REP_SEARCHSUM] = searchsum_;
  rep2lng[REP_CODE] = statrep_;
  rep2type = (choice *)xmalloc(REP_NUMBER * sizeof(choice));
  rep2type[REP_MONTH] = INP_DATE;
  rep2type[REP_WEEK] = INP_DATE;
  rep2type[REP_DAYREP] = INP_DATE;
  rep2type[REP_DAYSUM] = INP_DATE;
  rep2type[REP_HOURREP] = INP_DATE;
  rep2type[REP_HOURSUM] = INP_DATE;
  rep2type[REP_QUARTER] = INP_DATE;
  rep2type[REP_FIVE] = INP_DATE;
  rep2type[REP_GENSUM] = UNSET;
  rep2type[REP_REQ] = ITEM_FILE;
  rep2type[REP_TYPE] = ITEM_FILE;
  rep2type[REP_DIR] = ITEM_FILE;
  rep2type[REP_REDIR] = ITEM_FILE;
  rep2type[REP_FAIL] = ITEM_FILE;
  rep2type[REP_HOST] = ITEM_HOST;
  rep2type[REP_DOM] = ITEM_HOST;
  rep2type[REP_ORG] = ITEM_HOST;
  rep2type[REP_USER] = ITEM_USER;
  rep2type[REP_FAILUSER] = ITEM_USER;
  rep2type[REP_REF] = ITEM_REFERRER;
  rep2type[REP_REFSITE] = ITEM_REFERRER;
  rep2type[REP_REDIRREF] = ITEM_REFERRER;
  rep2type[REP_FAILREF] = ITEM_REFERRER;
  rep2type[REP_SEARCHREP] = ITEM_REFERRER;
  rep2type[REP_SEARCHSUM] = ITEM_REFERRER;
  rep2type[REP_BROWREP] = ITEM_BROWSER;
  rep2type[REP_BROWSUM] = ITEM_BROWSER;
  rep2type[REP_OS] = ITEM_BROWSER;
  rep2type[REP_VHOST] = ITEM_VHOST;
  rep2type[REP_SIZE] = INP_BYTES;
  rep2type[REP_PROCTIME] = INP_PROCTIME;
  rep2type[REP_CODE] = INP_CODE;
  rep2reqs = (choice *)xmalloc(GENREP_NUMBER * sizeof(choice));
  rep2reqs[G(REP_REQ)] = REQUESTS;
  rep2reqs[G(REP_REDIR)] = REDIR;
  rep2reqs[G(REP_FAIL)] = FAIL;
  rep2reqs[G(REP_HOST)] = REQUESTS;
  rep2reqs[G(REP_USER)] = REQUESTS;
  rep2reqs[G(REP_FAILUSER)] = FAIL;
  rep2reqs[G(REP_REF)] = REQUESTS;
  rep2reqs[G(REP_REDIRREF)] = REDIR;
  rep2reqs[G(REP_FAILREF)] = FAIL;
  rep2reqs[G(REP_BROWREP)] = REQUESTS;
  rep2reqs[G(REP_VHOST)] = REQUESTS;
  rep2reqs[G(REP_TYPE)] = REQUESTS;
  rep2reqs[G(REP_DIR)] = REQUESTS;
  rep2reqs[G(REP_DOM)] = REQUESTS;
  rep2reqs[G(REP_ORG)] = REQUESTS;
  rep2reqs[G(REP_REFSITE)] = REQUESTS;
  rep2reqs[G(REP_BROWSUM)] = REQUESTS;
  rep2reqs[G(REP_OS)] = REQUESTS;
  rep2reqs[G(REP_SEARCHREP)] = REQUESTS;
  rep2reqs[G(REP_SEARCHSUM)] = REQUESTS;
  rep2date = (choice *)xmalloc(GENREP_NUMBER * sizeof(choice));
  for (i = 0; i <= G(LAST_NORMALREP); i++)
    rep2date[i] = (rep2reqs[i] == REDIR)?REDIRDATE:\
      ((rep2reqs[i] == FAIL)?FAILDATE:SUCCDATE);
  rep2gran = (unsigned int *)xmalloc(DATEREP_NUMBER * sizeof(unsigned int));
  rep2gran[REP_DAYREP] = 1;
  rep2gran[REP_HOURREP] = 24;
  rep2gran[REP_QUARTER] = 96;
  rep2gran[REP_FIVE] = 288;
  rep2gran[REP_MONTH] = 1;  /* next four only used in setting granularity */
  rep2gran[REP_WEEK] = 1;
  rep2gran[REP_DAYSUM] = 1;
  rep2gran[REP_HOURSUM] = 24;
  rep2datefmt = (unsigned int *)xmalloc(DATEREP_NUMBER * sizeof(unsigned int));
  rep2datefmt[REP_DAYREP] = dayrepfmt_;
  rep2datefmt[REP_HOURREP] = hourrepfmt_;
  rep2datefmt[REP_QUARTER] = quarterfmt_;
  rep2datefmt[REP_FIVE] = quarterfmt_;
  rep2datefmt[REP_WEEK] = weekfmt_;
  rep2datefmt[REP_MONTH] = monthfmt_;
  rep2colhead = (unsigned int *)xmalloc(REP_NUMBER * sizeof(unsigned int));
  rep2colhead[REP_DAYREP] = date_;
  rep2colhead[REP_DAYSUM] = day_;
  rep2colhead[REP_HOURREP] = datetime_;
  rep2colhead[REP_HOURSUM] = hr_;
  rep2colhead[REP_QUARTER] = datetime_;
  rep2colhead[REP_FIVE] = datetime_;
  rep2colhead[REP_WEEK] = weekbeg_;
  rep2colhead[REP_MONTH] = month_;
  rep2colhead[REP_REQ] = file_;
  rep2colhead[REP_REDIR] = file_;
  rep2colhead[REP_FAIL] = file_;
  rep2colhead[REP_TYPE] = ext_;
  rep2colhead[REP_SIZE] = size_;
  rep2colhead[REP_PROCTIME] = seconds_;
  rep2colhead[REP_DIR] = dir_;
  rep2colhead[REP_HOST] = host_;
  rep2colhead[REP_DOM] = dom_;
  rep2colhead[REP_ORG] = org_;
  rep2colhead[REP_REF] = url_;
  rep2colhead[REP_REFSITE] = site_;
  rep2colhead[REP_REDIRREF] = url_;
  rep2colhead[REP_FAILREF] = url_;
  rep2colhead[REP_BROWREP] = browser_;
  rep2colhead[REP_BROWSUM] = browser_;
  rep2colhead[REP_OS] = os_;
  rep2colhead[REP_VHOST] = vhost_;
  rep2colhead[REP_USER] = user_;
  rep2colhead[REP_FAILUSER] = user_;
  rep2colhead[REP_SEARCHREP] = search_;
  rep2colhead[REP_SEARCHSUM] = search_;
  rep2colhead[REP_CODE] = code_;
  rep2busystr = (unsigned int *)xmalloc(DATEREP_NUMBER * sizeof(unsigned int));
  rep2busystr[REP_DAYREP] = busyday_;
  rep2busystr[REP_HOURREP] = busyhour_;
  rep2busystr[REP_QUARTER] = busyquarter_;
  rep2busystr[REP_FIVE] = busyfive_;
  rep2busystr[REP_WEEK] = busyweek_;
  rep2busystr[REP_MONTH] = busymonth_;
  col2colhead = (unsigned int *)xmalloc(COL_NUMBER * sizeof(unsigned int));
  col2colhead[COL_REQS] = nreqs_;
  col2colhead[COL_PAGES] = npgs_;
  col2colhead[COL_BYTES] = nbytes_;
  col2colhead[COL_PREQS] = preqs_;
  col2colhead[COL_PPAGES] = ppgs_;
  col2colhead[COL_PBYTES] = pbytes_;
  col2colhead[COL_DATE] = lastdate_;
  col2colhead[COL_TIME] = lasttime_;
  col2colhead[COL_INDEX] = index_;
  method2sing = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2sing[REQUESTS] = request_;
  method2sing[PAGES] = pagereq_;
  method2sing[REDIR] = redirreq_;
  method2sing[FAIL] = failreq_;
  method2sing[BYTES] = byte_;
  method2pl = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2pl[REQUESTS] = requests_;
  method2pl[PAGES] = pagereqs_;
  method2pl[REDIR] = redirreqs_;
  method2pl[FAIL] = failreqs_;
  method2pl[BYTES] = bytes_;
  method2date = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2date[SUCCDATE] = sincedate_;
  method2date[REDIRDATE] = sinceredirdate_;
  method2date[FAILDATE] = sincefaildate_;
  method2pc = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2pc[REQUESTS] = prequests_;
  method2pc[PAGES] = ppages_;
  method2pc[REDIR] = predirs_;
  method2pc[FAIL] = pfails_;
  method2pc[BYTES] = ptraffic_;
  method2relpc = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2relpc[REQUESTS] = pmrequests_;
  method2relpc[PAGES] = pmpages_;
  method2relpc[REDIR] = pmredirs_;
  method2relpc[FAIL] = pmfails_;
  method2relpc[BYTES] = pmtraffic_;
  method2sort = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2sort[REQUESTS] = nrequests_;
  method2sort[PAGES] = npages_;
  method2sort[REDIR] = nredirs_;
  method2sort[FAIL] = nfails_;
  method2sort[SUCCDATE] = succdate_;
  method2sort[REDIRDATE] = redirdate_;
  method2sort[FAILDATE] = faildate_;
  method2sort[BYTES] = traffic_;
}

void defaults(Options *op) {
  double codethresh[] = {100., 101., 199., 200., 201., 202., 203., 204., 205.,
			 206., 299., 300., 301., 302., 303., 304., 305., 306.,
			 307., 399., 400., 401., 402., 403., 404., 405., 406.,
			 407., 408., 409., 410., 411., 412., 413., 414., 415.,
			 416., 417., 418., 419., 499., 500., 501., 502., 503.,
			 504., 505., 506., 599., -1.};
  double sizethresh[] = {0., 10., 100., 1024., 10240., 102400., 1048576.,
			 10485760., 104857600., 1073741824., -1.};
  double ptthresh[] = {0., 10., 20., 50., 100., 200., 500., 1000., 2000.,
		       5000., 10000., 20000., 60000., 120000., 300000., -1.};
  /* These thresholds have to be coordinated with the names in arrayrep() */
  double *thresh;
  int i, j, k;

  op->conffilelist = NULL;
  confline(op, "DEBUG", "OFF", NULL, -1);
  confline(op, "WARNINGS", "ON", NULL, -1);
  deflogformat = (Inputformatlist *)submalloc(xmemman,
					      sizeof(Inputformatlist));
  logformat = (Inputformatlist *)submalloc(xmemman, sizeof(Inputformatlist));
  deflogformat->used = TRUE;
  logformat->used = TRUE;
  configlogfmt((void *)&deflogformat, "DEFAULTLOGFORMAT", "AUTO", NULL, -1);
  configlogfmt((void *)&logformat, "LOGFORMAT", "DEFAULT", NULL, -1);
  deflogformat->used = TRUE;
  confline(op, "LOGFILE", LOGFILE, NULL, -1);
  confline(op, "CACHEFILE", CACHEFILE, NULL, -1);
  op->outopts.domainsfile = NULL;
  DEFAULTSTR(op->miscopts.dirsuffix, DIRSUFFIX);
#ifndef NODNS
  dnslevel = DNS;
  dnsgoodhrs = DNSGOODHOURS;
  dnsbadhrs = DNSBADHOURS;
  DEFAULTSTR(dnsfile, DNSFILE);
  DEFAULTSTR(dnslockfile, DNSLOCKFILE);
#endif
  op->miscopts.case_insensitive = CASE_INSENSITIVE;
  op->miscopts.usercase_insensitive = USERCASE_INSENSITIVE;
  op->outopts.searchconv = SEARCHCHARCONVERT;
  op->outopts.outstyle = OUTPUT;
  op->outopts.html = TRUE;
  op->outopts.cgi = FALSE;
  DEFAULTSTR(op->outopts.headerfile, HEADERFILE);
  DEFAULTSTR(op->outopts.footerfile, FOOTERFILE);
  DEFAULTSTR(op->outopts.outfile, OUTFILE);
  DEFAULTSTR(op->outopts.cacheoutfile, CACHEOUTFILE);
  DEFAULTSTR(op->outopts.imagedir, IMAGEDIR);
  confline(op, "MONTHCOLS", MONTHCOLS, NULL, -1);
  confline(op, "WEEKCOLS", WEEKCOLS, NULL, -1);
  confline(op, "FULLDAYCOLS", FULLDAYCOLS, NULL, -1);
  confline(op, "DAYCOLS", DAYCOLS, NULL, -1);
  confline(op, "FULLHOURCOLS", FULLHOURCOLS, NULL, -1);
  confline(op, "HOURCOLS", HOURCOLS, NULL, -1);
  confline(op, "QUARTERCOLS", QUARTERCOLS, NULL, -1);
  confline(op, "FIVECOLS", FIVECOLS, NULL, -1);
  confline(op, "REQCOLS", REQCOLS, NULL, -1);
  confline(op, "REDIRCOLS", REDIRCOLS, NULL, -1);
  confline(op, "FAILCOLS", FAILCOLS, NULL, -1);
  confline(op, "TYPECOLS", TYPECOLS, NULL, -1);
  confline(op, "SIZECOLS", SIZECOLS, NULL, -1);
  confline(op, "PROCTIMECOLS", PROCTIMECOLS, NULL, -1);
  confline(op, "DIRCOLS", DIRCOLS, NULL, -1);
  confline(op, "HOSTCOLS", HOSTCOLS, NULL, -1);
  confline(op, "DOMCOLS", DOMCOLS, NULL, -1);
  confline(op, "ORGCOLS", ORGCOLS, NULL, -1);
  confline(op, "REFCOLS", REFCOLS, NULL, -1);
  confline(op, "REFSITECOLS", REFSITECOLS, NULL, -1);
  confline(op, "REDIRREFCOLS", REDIRREFCOLS, NULL, -1);
  confline(op, "FAILREFCOLS", FAILREFCOLS, NULL, -1);
  confline(op, "FULLBROWCOLS", FULLBROWCOLS, NULL, -1);
  confline(op, "BROWCOLS", BROWCOLS, NULL, -1);
  confline(op, "OSCOLS", OSCOLS, NULL, -1);
  confline(op, "VHOSTCOLS", VHOSTCOLS, NULL, -1);
  confline(op, "USERCOLS", USERCOLS, NULL, -1);
  confline(op, "FAILUSERCOLS", FAILUSERCOLS, NULL, -1);
  confline(op, "SEARCHQUERYCOLS", SEARCHQUERYCOLS, NULL, -1);
  confline(op, "SEARCHWORDCOLS", SEARCHWORDCOLS, NULL, -1);
  confline(op, "STATUSCOLS", STATUSCOLS, NULL, -1);
  op->outopts.repq[REP_MONTH] = MONTHLY;
  op->outopts.repq[REP_WEEK] = WEEKLY;
  op->outopts.repq[REP_DAYREP] = FULLDAILY;
  op->outopts.repq[REP_DAYSUM] = DAILY;
  op->outopts.repq[REP_HOURREP] = FULLHOURLY;
  op->outopts.repq[REP_HOURSUM] = HOURLY;
  op->outopts.repq[REP_QUARTER] = QUARTER;
  op->outopts.repq[REP_FIVE] = FIVE;
  op->outopts.repq[REP_GENSUM] = GENERAL;
  op->outopts.repq[REP_REQ] = REQUEST;
  op->outopts.repq[REP_REDIR] = REDIRREP;
  op->outopts.repq[REP_FAIL] = FAILREP;
  op->outopts.repq[REP_TYPE] = FILETYPE;
  op->outopts.repq[REP_SIZE] = SIZEREP;
  op->outopts.repq[REP_PROCTIME] = PROCTIME;
  op->outopts.repq[REP_DIR] = DIRECTORY;
  op->outopts.repq[REP_HOST] = HOST;
  op->outopts.repq[REP_DOM] = DOMAINREP;
  op->outopts.repq[REP_ORG] = ORGANISATION;
  op->outopts.repq[REP_REF] = REFERRER;
  op->outopts.repq[REP_REFSITE] = REFSITE;
  op->outopts.repq[REP_REDIRREF] = REDIRREF;
  op->outopts.repq[REP_FAILREF] = FAILREF;
  op->outopts.repq[REP_BROWREP] = FULLBROWSER;
  op->outopts.repq[REP_BROWSUM] = BROWSER;
  op->outopts.repq[REP_OS] = OSREP;
  op->outopts.repq[REP_VHOST] = VHOST;
  op->outopts.repq[REP_USER] = USER;
  op->outopts.repq[REP_FAILUSER] = FAILUSER;
  op->outopts.repq[REP_SEARCHREP] = SEARCHQUERY;
  op->outopts.repq[REP_SEARCHSUM] = SEARCHWORD;
  op->outopts.repq[REP_CODE] = STATUS;
  op->outopts.last7 = LASTSEVEN;
  op->outopts.runtime = RUNTIME;
  op->outopts.gotos = GOTOS;
  op->outopts.lang.code = LANGUAGE;
  op->outopts.lang.file = NULL;
  op->outopts.graph[REP_MONTH] = MONTHGRAPH;
  op->outopts.graph[REP_WEEK] = WEEKGRAPH;
  op->outopts.graph[REP_DAYREP] = FULLDAYGRAPH;
  op->outopts.graph[REP_DAYSUM] = DAYGRAPH;
  op->outopts.graph[REP_HOURREP] = FULLHOURGRAPH;
  op->outopts.graph[REP_HOURSUM] = HOURGRAPH;
  op->outopts.graph[REP_QUARTER] = QUARTERGRAPH;
  op->outopts.graph[REP_FIVE] = FIVEGRAPH;
  op->outopts.back[REP_MONTH] = MONTHBACK;
  op->outopts.back[REP_WEEK] = WEEKBACK;
  op->outopts.back[REP_DAYREP] = FULLDAYBACK;
  op->outopts.back[REP_HOURREP] = FULLHOURBACK;
  op->outopts.back[REP_QUARTER] = QUARTERBACK;
  op->outopts.back[REP_FIVE] = FIVEBACK;
  op->outopts.rows[REP_MONTH] = MONTHROWS;
  op->outopts.rows[REP_WEEK] = WEEKROWS;
  op->outopts.rows[REP_DAYREP] = FULLDAYROWS;
  op->outopts.rows[REP_HOURREP] = FULLHOURROWS;
  op->outopts.rows[REP_QUARTER] = QUARTERROWS;
  op->outopts.rows[REP_FIVE] = FIVEROWS;
  op->outopts.sortby[G(REP_REQ)] = REQSORTBY;
  op->outopts.subsortby[G(REP_REQ)] = REQSORTBY;
  op->outopts.sortby[G(REP_REDIR)] = REDIRSORTBY;
  op->outopts.subsortby[G(REP_REDIR)] = REDIRSORTBY;
  op->outopts.sortby[G(REP_FAIL)] = FAILSORTBY;
  op->outopts.subsortby[G(REP_FAIL)] = FAILSORTBY;
  op->outopts.sortby[G(REP_TYPE)] = TYPESORTBY;
  op->outopts.subsortby[G(REP_TYPE)] = TYPESORTBY;
  op->outopts.sortby[G(REP_DIR)] = DIRSORTBY;
  op->outopts.subsortby[G(REP_DIR)] = DIRSORTBY;
  op->outopts.sortby[G(REP_HOST)] = HOSTSORTBY;
  op->outopts.sortby[G(REP_DOM)] = DOMSORTBY;
  op->outopts.subsortby[G(REP_DOM)] = DOMSORTBY;
  op->outopts.sortby[G(REP_ORG)] = ORGSORTBY;
  op->outopts.subsortby[G(REP_ORG)] = ORGSORTBY;
  op->outopts.sortby[G(REP_REF)] = REFSORTBY;
  op->outopts.subsortby[G(REP_REF)] = REFSORTBY;
  op->outopts.sortby[G(REP_REFSITE)] = REFSITESORTBY;
  op->outopts.subsortby[G(REP_REFSITE)] = REFSITESORTBY;
  op->outopts.sortby[G(REP_REDIRREF)] = REDIRREFSORTBY;
  op->outopts.subsortby[G(REP_REDIRREF)] = REDIRREFSORTBY;
  op->outopts.sortby[G(REP_FAILREF)] = FAILREFSORTBY;
  op->outopts.subsortby[G(REP_FAILREF)] = FAILREFSORTBY;
  op->outopts.sortby[G(REP_BROWREP)] = FULLBROWSORTBY;
  op->outopts.sortby[G(REP_BROWSUM)] = BROWSORTBY;
  op->outopts.subsortby[G(REP_BROWSUM)] = BROWSORTBY;
  op->outopts.sortby[G(REP_OS)] = OSSORTBY;
  op->outopts.subsortby[G(REP_OS)] = OSSORTBY;
  op->outopts.sortby[G(REP_VHOST)] = VHOSTSORTBY;
  op->outopts.sortby[G(REP_USER)] = USERSORTBY;
  op->outopts.sortby[G(REP_FAILUSER)] = FAILUSERSORTBY;
  op->outopts.sortby[G(REP_SEARCHREP)] = SEARCHQUERYSORTBY;
  op->outopts.sortby[G(REP_SEARCHSUM)] = SEARCHWORDSORTBY;
  op->outopts.sortby[G(REP_CODE)] = STATUSSORTBY;
  confline(op, "REQFLOOR", REQFLOOR, NULL, -1);
  confline(op, "REQARGSFLOOR", REQARGSFLOOR, NULL, -1);
  confline(op, "REDIRFLOOR", REDIRFLOOR, NULL, -1);
  confline(op, "REDIRARGSFLOOR", REDIRARGSFLOOR, NULL, -1);
  confline(op, "FAILFLOOR", FAILFLOOR, NULL, -1);
  confline(op, "FAILARGSFLOOR", FAILARGSFLOOR, NULL, -1);
  confline(op, "TYPEFLOOR", TYPEFLOOR, NULL, -1);
  confline(op, "SUBTYPEFLOOR", SUBTYPEFLOOR, NULL, -1);
  confline(op, "DIRFLOOR", DIRFLOOR, NULL, -1);
  confline(op, "SUBDIRFLOOR", SUBDIRFLOOR, NULL, -1);
  confline(op, "HOSTFLOOR", HOSTFLOOR, NULL, -1);
  confline(op, "DOMFLOOR", DOMFLOOR, NULL, -1);
  confline(op, "SUBDOMFLOOR", SUBDOMFLOOR, NULL, -1);
  confline(op, "ORGFLOOR", ORGFLOOR, NULL, -1);
  confline(op, "SUBORGFLOOR", SUBORGFLOOR, NULL, -1);
  confline(op, "REFFLOOR", REFFLOOR, NULL, -1);
  confline(op, "REFARGSFLOOR", REFARGSFLOOR, NULL, -1);
  confline(op, "REFSITEFLOOR", REFSITEFLOOR, NULL, -1);
  confline(op, "REFDIRFLOOR", REFDIRFLOOR, NULL, -1);
  confline(op, "REDIRREFFLOOR", REDIRREFFLOOR, NULL, -1);
  confline(op, "REDIRREFARGSFLOOR", REDIRREFARGSFLOOR, NULL, -1);
  confline(op, "FAILREFFLOOR", FAILREFFLOOR, NULL, -1);
  confline(op, "FAILREFARGSFLOOR", FAILREFARGSFLOOR, NULL, -1);
  confline(op, "FULLBROWFLOOR", FULLBROWFLOOR, NULL, -1);
  confline(op, "BROWFLOOR", BROWFLOOR, NULL, -1);
  confline(op, "SUBBROWFLOOR", BROWFLOOR, NULL, -1);
  confline(op, "OSFLOOR", OSFLOOR, NULL, -1);
  confline(op, "SUBOSFLOOR", SUBOSFLOOR, NULL, -1);
  confline(op, "VHOSTFLOOR", VHOSTFLOOR, NULL, -1);
  confline(op, "USERFLOOR", USERFLOOR, NULL, -1);
  confline(op, "FAILUSERFLOOR", FAILUSERFLOOR, NULL, -1);
  confline(op, "SEARCHQUERYFLOOR", SEARCHQUERYFLOOR, NULL, -1);
  confline(op, "SEARCHWORDFLOOR", SEARCHWORDFLOOR, NULL, -1);
  confline(op, "STATUSFLOOR", STATUSFLOOR, NULL, -1);
  confline(op, "REPORTORDER", REPORTORDER, NULL, -1);
  op->outopts.barstyle = BARSTYLE;
  op->outopts.markchar = MARKCHAR;
  op->outopts.rawbytes = RAWBYTES;
  op->outopts.norobots = NOROBOTS;
  DEFAULTSTR(op->outopts.hostname, HOSTNAME);
  DEFAULTSTR(op->outopts.hosturl, HOSTURL);
  op->outopts.baseurl = NULL;
  DEFAULTSTR(op->outopts.logo, LOGO);
  DEFAULTSTR(op->outopts.stylesheet, STYLESHEET);
  op->outopts.weekbeginson = WEEKBEGINSON;
  op->outopts.plainpagewidth = PLAINPAGEWIDTH;
  op->outopts.htmlpagewidth = HTMLPAGEWIDTH;
  op->outopts.mingraphwidth = MINGRAPHWIDTH;
  op->outopts.sepchar = SEPCHAR;
  op->outopts.repsepchar = REPSEPCHAR;
  op->outopts.decpt = DECPOINT;
  DEFAULTSTR(op->outopts.compsep, COMPSEP);
  op->outopts.link = NULL;
  op->outopts.reflink = NULL;
  for (i = 0; i < GENREP_NUMBER; i++) {
    op->outopts.wanthead[i] = NULL;
    op->outopts.aliashead[i] = NULL;
    op->outopts.tree[i] = (Tree *)xmalloc(sizeof(Tree));
    op->outopts.tree[i]->tree = NULL;
    op->outopts.tree[i]->space = (Memman *)xmalloc(sizeof(Memman));
    op->outopts.tree[i]->space->curr_pos = NULL;
    op->outopts.tree[i]->space->first = NULL;
    op->outopts.tree[i]->space->alignment = ALIGNMENT;
  }
  domlevels = (Strpair **)xmalloc(DOMLEVEL_NUMBER * sizeof(Strpair *));
  for (i = 0; i < DOMLEVEL_NUMBER; i++)
    domlevels[i] = NULL;
  op->outopts.tree[G(REP_REQ)]->cutfn = &rnextname;
  op->outopts.tree[G(REP_REDIR)]->cutfn = &rnextname;
  op->outopts.tree[G(REP_FAIL)]->cutfn = &rnextname;
  op->outopts.tree[G(REP_REF)]->cutfn = &rnextname;
  op->outopts.tree[G(REP_REDIRREF)]->cutfn = &rnextname;
  op->outopts.tree[G(REP_FAILREF)]->cutfn = &rnextname;
  op->outopts.tree[G(REP_TYPE)]->cutfn = &tnextname;
  op->outopts.tree[G(REP_DIR)]->cutfn = &inextname;
  op->outopts.tree[G(REP_DOM)]->cutfn = &onextname;
  op->outopts.tree[G(REP_REFSITE)]->cutfn = &snextname;
  op->outopts.tree[G(REP_BROWSUM)]->cutfn = &bnextname;
  op->outopts.tree[G(REP_OS)]->cutfn = &pnextname;
  op->outopts.tree[G(REP_ORG)]->cutfn = &Znextname;
  for (i = 0; i < DERVREP_NUMBER; i++) {
    op->outopts.derv[i] = (Derv *)xmalloc(sizeof(Derv));
    op->outopts.derv[i]->table = rehash(NULL, HASHSIZE, NULL);
    op->outopts.derv[i]->space = (Memman *)xmalloc(sizeof(Memman));
    op->outopts.derv[i]->space->curr_pos = NULL;
    op->outopts.derv[i]->space->first = NULL;
    op->outopts.derv[i]->space->alignment = 1;
    op->outopts.derv[i]->list = &(op->searchengines);
  }
  op->outopts.derv[REP_SEARCHREP - FIRST_DERVREP]->cutfn = &Nnextname;
  op->outopts.derv[REP_SEARCHSUM - FIRST_DERVREP]->cutfn = &nnextname;
  op->outopts.derv[REP_BROWSUM - FIRST_DERVREP]->cutfn = &Bnextname;
  op->outopts.derv[REP_OS - FIRST_DERVREP]->cutfn = &Pnextname;
  op->outopts.suborgs = NULL;
  for (i = 0; i < LOGDATA_NUMBER; i++)
    op->miscopts.data[i] = 0;
  op->miscopts.bytes = 0.0;
  op->miscopts.bytes7 = 0.0;
  confline(op, "REQARGS", "*?*", NULL, -1);
  confline(op, "REDIRARGS", "*?*", NULL, -1);
  confline(op, "FAILARGS", "*?*", NULL, -1);
  confline(op, "REFARGS", "*?*", NULL, -1);
  confline(op, "REDIRREFARGS", "*?*", NULL, -1);
  confline(op, "FAILREFARGS", "*?*", NULL, -1);
  confline(op, "SUBDOMAIN", "*", NULL, -1);
  confline(op, "SUBORG2", "*", NULL, -1);
  confline(op, "SUBDIR", "*", NULL, -1);
  confline(op, "SUBTYPE", "*", NULL, -1);
  confline(op, "REFDIR", "*", NULL, -1);
  confline(op, "SUBBROW", "*", NULL, -1);
  confline(op, "SUBOS", "*:*", NULL, -1);
  for (i = 0; i < ITEM_NUMBER; i++) {
    op->wanthead[i] = NULL;
    op->aliashead[i] = NULL;
    op->hash[i] = rehash(NULL, HASHSIZE, NULL);
    op->miscopts.lowmem[i] = 0;
  }
  for (i = 0; i < MIN_SC; i++)
    op->code2type[i] = UNWANTED;
  for ( ; i < SC_NUMBER; i++)
    op->code2type[i] = UNSET;
  op->code2type[0] = UNSET;  /* code2type[0] used as a special marker in ... */
  op->succ304 = TRUE;    /* ... configsinex(), correctlogfmt() & finalinit() */
  for (i = 0; i < ARRAYREP_NUMBER; i++) {
    if (i == REP_CODE - FIRST_ARRAYREP)
      thresh = codethresh;
    else if (i == REP_SIZE - FIRST_ARRAYREP)
      thresh = sizethresh;
    else
      thresh = ptthresh;
    for (k = 0; thresh[k] > -0.5; k++)
      ;  /* find size of array */
    k++;
    op->arraydata[i] = (Arraydata *)xmalloc(k * sizeof(Arraydata));
    for (j = 0; j < k; j++) {
      op->arraydata[i][j].threshold = thresh[j];
      op->arraydata[i][j].reqs = 0;
      op->arraydata[i][j].pages = 0;
      op->arraydata[i][j].bytes = 0.0;
      op->arraydata[i][j].lastdate = 0;
    }
  }
  op->searchengines = NULL;
  op->ispagehead = NULL;
  op->argshead = NULL;
  op->refargshead = NULL;
  confline(op, "PAGEINCLUDE", "REGEXPI:\\.asp$", NULL, -1);
  confline(op, "PAGEINCLUDE", "*/", NULL, -1);
  confline(op, "PAGEINCLUDE", "REGEXPI:\\.html?$", NULL, -1);
  op->dman.fromstr = NULL;
  op->dman.tostr = NULL;
  op->dman.currdp = NULL;
  op->dman.firstdp = NULL;
  op->dman.lastdp = NULL;
  op->dman.firsttime = LAST_TIME;
  op->dman.lasttime = FIRST_TIME;
}
