#!/bin/sh

#
# Build aclocal.m4 from libtool's libtool.m4 and our own M4 files.
#
libtoolize=`build/PrintPath glibtoolize libtoolize`
if [ "x$libtoolize" = "x" ]; then
    echo "libtoolize not found in path"
    exit 1
fi
ltpath=`dirname $libtoolize`
ltfile=`cd $ltpath/../share/aclocal ; pwd`/libtool.m4
echo "Incorporating $ltfile into aclocal.m4 ..."
echo "dnl THIS FILE IS AUTOMATICALLY GENERATED BY buildconf.sh" > aclocal.m4
echo "dnl edits here will be lost" >> aclocal.m4
cat build/apu-conf.m4 $ltfile >> aclocal.m4

#
# Create the libtool helper files
#
# Note: we always replace the files, and we copy (rather than link) them.
#
echo "Copying libtool helper files ..."
$libtoolize --force --copy

#
# Generate the autoconf header (include/apu_config.h) and ./configure
#
echo "Creating include/private/apu_config.h ..."
autoheader

echo "Creating configure ..."
### do some work to toss config.cache?
autoconf

#
# If Expat has been bundled, then go and configure the thing
#
if test -d xml/expat; then
  echo "Invoking xml/expat/buildconf.sh ..."
  (cd xml/expat; ./buildconf.sh)
fi
### expat-cvs (from SourceForge's CVS) does not have a buildconf.sh (yet)
