from os import _exit, fork, execvp, waitpid, dup2

from rox.MultipleChoice import MultipleChoice
from rox.support import *

from gtk import *

# Open a modal dialog box showing a message.
# The user can choose from a selection of buttons at the bottom.
# Returns -1 if the window is destroyed, or the number of the button
# if one is clicked (starting from zero).
#
# If a dialog is already open, returns -1 without waiting AND
# brings the current dialog to the front.
current_dialog = None
def get_choice(message, title, buttons):
	global current_dialog

	if current_dialog:
		current_dialog.hide()
		current_dialog.show()
		return -1

	current_dialog = MultipleChoice(message, buttons)
	current_dialog.set_title(title)
	choice_return = current_dialog.wait()

	print "Return", choice_return

	current_dialog = None

	return choice_return

def child(*argv):
	"""Spawn a new process. Connect stderr to stdout."""
	child = fork()
	if child == 0:
		# We are the child
		try:
			dup2(1, 2)
			execvp(argv[0], argv)
		except:
			pass
		print "Warning: exec('%s') failed!" % argv[0]
		_exit(1)
	elif child == -1:
		print "Error: fork() failed!"
