dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl $Id: acinclude.m4,v 1.1 1999/05/15 22:48:04 assar Exp $
dnl
dnl Only put things that for some reason can't live in the `cf'
dnl directory in this file.
dnl

dnl $xId: misc.m4,v 1.1 1997/12/14 15:59:04 joda Exp $
dnl
define(upcase,`echo $1 | tr abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ`)dnl

dnl
dnl $Id: prog-cc-flags.m4,v 1.2 2000/01/23 12:34:11 assar Exp $
dnl

AC_DEFUN(AC_PROG_CC_FLAGS, [
AC_REQUIRE([AC_PROG_CC])dnl
AC_MSG_CHECKING(for $CC warning options)
if test "$GCC" = "yes"; then
  extra_flags="-Wall -Wmissing-prototypes -Wpointer-arith -Wbad-function-cast -Wmissing-declarations -Wnested-externs"
  CFLAGS="$CFLAGS $extra_flags"
  AC_MSG_RESULT($extra_flags)
else
  AC_MSG_RESULT(none)
fi
])

dnl 
dnl See if there is any X11 present
dnl
dnl $Id: check-x.m4,v 1.1 1999/07/13 21:20:51 joda Exp $

AC_DEFUN(KRB_CHECK_X,[
AC_PATH_XTRA

# try to figure out if we need any additional ld flags, like -R
# and yes, the autoconf X test is utterly broken
if test "$no_x" != yes; then
	AC_CACHE_CHECK(for special X linker flags,krb_cv_sys_x_libs_rpath,[
	ac_save_libs="$LIBS"
	ac_save_cflags="$CFLAGS"
	CFLAGS="$CFLAGS $X_CFLAGS"
	krb_cv_sys_x_libs_rpath=""
	krb_cv_sys_x_libs=""
	for rflag in "" "-R" "-R " "-rpath "; do
		if test "$rflag" = ""; then
			foo="$X_LIBS"
		else
			foo=""
			for flag in $X_LIBS; do
			case $flag in
			-L*)
				foo="$foo $flag `echo $flag | sed \"s/-L/$rflag/\"`"
				;;
			*)
				foo="$foo $flag"
				;;
			esac
			done
		fi
		LIBS="$ac_save_libs $foo -lX11"
		AC_TRY_RUN([
		#include <X11/Xlib.h>
		foo()
		{
		XOpenDisplay(NULL);
		}
		main()
		{
		return 0;
		}
		], krb_cv_sys_x_libs_rpath="$rflag"; krb_cv_sys_x_libs="$foo"; break,:)
	done
	LIBS="$ac_save_libs"
	CFLAGS="$ac_save_cflags"
	])
	X_LIBS="$krb_cv_sys_x_libs"
fi
])

dnl
dnl $Id: func-ntohl.m4,v 1.1 1999/05/15 22:45:26 assar Exp $
dnl
dnl test for how to do ntohl
dnl

AC_DEFUN(AC_FUNC_NTOHL, [
AC_REQUIRE([AC_CANONICAL_TARGET])
AC_MSG_CHECKING(for efficient ntohl)
AC_CACHE_VAL(ac_cv_func_ntohl, [
case "$target_cpu" in
changequote(, )dnl
i[3-9]86) AC_TRY_RUN(
changequote([, ])dnl
[
#if defined(__GNUC__) && defined(i386)
unsigned long foo(unsigned long x)
{
  asm("bswap %0" : "=r" (x) : "0" (x));
  return x;
}
#endif

int main(void)
{
  return foo(0x12345678) != 0x78563412;
}
],
ac_cv_func_ntohl="bswap",
ac_cv_func_ntohl="ntohl",
ac_cv_func_ntohl="ntohl") ;;
alpha) ac_cv_func_ntohl="bswap32" ;;
*) ac_cv_func_ntohl="ntohl" ;;
esac
])
AC_MSG_RESULT($ac_cv_func_ntohl)
AC_DEFINE_UNQUOTED(EFF_NTOHL, $ac_cv_func_ntohl, [how should ntohl be done?])
])

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

dnl
dnl $Id: check-kerberos.m4,v 1.34 2000/07/14 20:55:32 jas Exp $
dnl
dnl Check if the dog is alive
dnl
dnl Arguments:
dnl
dnl   AC_CHECK_KERBEROS(4):
dnl      check for krb4 libs and krb5 krb4 compat libs
dnl   AC_CHECK_KERBEROS(45):
dnl      check for krb4 libs and krb5 libs
dnl   AC_CHECK_KERBEROS(5):
dnl      check for krb5 libs
dnl   AC_CHECK_KERBEROS([45]auto):
dnl      check for kerberos without a --with-krbN
dnl
dnl Set:
dnl   ac_cv_found_krb4=[yes|no]
dnl   KRB4_{LIB|INC}_DIR
dnl   KRB4_{LIB,INC}_FLAGS
dnl
dnl   ac_cv_found_krb5=[yes|no]
dnl   KRB5_{LIB|INC}_DIR
dnl   KRB5_{LIB,INC}_FLAGS
dnl
dnl
dnl Check order
dnl    krb5
dnl     include testing of libk5crypto/libcrypto
dnl    krb4
dnl      krb5 compat if needed (included in krb4 test)
dnl      this is the reson krb5 is tested first
dnl

AC_DEFUN(AC_CHECK_KERBEROS,[

dnl
dnl Parse args for kerberos4
dnl

ifelse(-1,regexp($1,[[45]]),[
  errprint(__file__:__line__: [CHECK_KERBEROS: have to give at lease 4 or 5
])
  m4exit(1)
])

ifelse(-1,regexp($1,4),[with_krb4=no],[ dnl WITHOUT KERBEROS4 (1)

AC_ARG_WITH(krb4,
[  --with-krb4=dir         use kerberos 4 in dir],
[if test "X$withval" = "X"; then
  ifelse(-1,regexp($1,[auto]),[
    AC_MSG_ERROR([You have to give a dir to --with-krb4])],
    [:])
fi],
[ifelse(-1,regexp($1,auto),[with_krb4=no],[with_krb4=yes])])

AC_ARG_WITH(krb4-lib,
[  --with-krb4-lib=dir     use kerberos 4 libraries in dir],
[if test "$withval" = "yes" -o "$withval" = "no"; then
  AC_MSG_ERROR([No argument for --with-krb4-lib])
fi])

AC_ARG_WITH(krb4-include,
[  --with-krb4-include=dir use kerberos 4 headers in dir],
[if test "$withval" = "yes" -o "$withval" = "no"; then
  AC_MSG_ERROR([No argument for --with-krb4-include])
fi])

]) dnl WITHOUT KERBEROS4 (1)

dnl
dnl Parse args for kerberos5
dnl

AC_ARG_WITH(krb5,
[  --with-krb5=dir         use ]dnl
ifelse(-1,regexp($1,5),[kerberos 4 compat from ])[kerberos 5 in dir],
[
if test "X$withval" = "X"; then
  ifelse(-1,regexp($1,[auto]),[
    AC_MSG_ERROR([You have to give a dir to --with-krb5])],
    [:])
  ifelse(-1,regexp($1,5),[
    if test "X$with_krb4" != "Xno"; then
       AC_MSG_ERROR([Already specified kerberos 4 with --with-krb4])
    fi])
elif test "$withval" = "no"; then
ifelse(-1,regexp($1,4),[with_krb5=no],
[if test "$with_krb4" = "yes"; then
  with_krb5=compat
else
  with_krb5=no
fi])
fi
],
[ifelse(-1,regexp($1,auto),[with_krb5=compat],[with_krb5=yes])])

AC_ARG_WITH(krb5-include,
[  --with-krb5-include=dir use ]dnl
ifelse(-1,regexp($1,5),[kerberos 4 compat from ])[kerberos 5 headers in dir],
[if test "$withval" = "yes" -o "$withval" = "no"; then
  AC_MSG_ERROR([No argument for --with-krb5-include])
fi
ifelse(-1,regexp($1,5),[
if test "X$with_krb4_include" != "X"; then
  AC_MSG_ERROR([Already specified kerberos 4 headers with --with-krb4-include])
fi])])

AC_ARG_WITH(krb5-lib,
[  --with-krb5-lib=dir     use kerberos 5 libraries in dir],
[if test "$withval" = "yes" -o "$withval" = "no"; then
  AC_MSG_ERROR([No argument for --with-krb5-lib])
fi
ifelse(-1,regexp($1,5),[
if test "X$with_krb4_lib" != "X"; then
  AC_MSG_ERROR([Already specified kerberos 4 libraries with --with-krb4-lib])
fi])])


dnl
dnl Check for kerberos5
dnl

case X"$with_krb5" in
  Xyes|Xno|Xcompat)
    ;;
  *)
    ac_cv_krb5_where_lib="$with_krb5/lib"
    ac_cv_krb5_where_inc="$with_krb5/include"
    ac_cv_found_krb5=yes
    ;;
esac

if test "X$with_krb5_include" != "X"; then
  ac_cv_krb4_where_inc=$with_krb5_include
  ac_cv_found_krb5=yes
fi

if test "X$with_krb5_lib" != "X"; then
  ac_cv_krb5_where_lib=$with_krb5_lib
  with_krb5=yes
fi

ifelse(-1,regexp($1,auto),[],[
if test "$with_krb5" != "no"; then
  if test "$ac_cv_krb5_where_lib" = ""; then
    AC_KRB5_LIB_WHERE(["" /usr/heimdal/lib /usr/athena/lib /usr/kerberos/lib /usr/local/lib])
  else
    AC_KRB5_LIB_WHERE($ac_cv_krb5_where_lib)
  fi
fi
])

if test "X$with_krb5_include" != "X"; then
  ac_cv_krb5_where_inc=$with_krb5_include
  ac_cv_found_krb5=yes
  with_krb5=yes
fi

ifelse(-1,regexp($1,auto),[],[ dnl KRB5-AUTO
if test "$with_krb5" != "no"; then
  if test "$ac_cv_krb5_where_inc" = ""; then
    AC_KRB5_INC_WHERE(["" /usr/heimdal/include /usr/athena/include /usr/kerberos/include /usr/include/kerberosV /usr/include/kerberos /usr/include/krb5 /usr/local/include])
  else
    AC_KRB5_INC_WHERE($ac_cv_krb5_where_inc)
  fi
fi
]) dnl KRB5-AUTO

ifelse(-1,regexp($1,4),[],[  dnl WITHOUT KERBEROS4 (2)

dnl
dnl Check for kerberos4
dnl

if test "X$with_krb4" != "Xyes" -a "X$with_krb4" != "Xno"; then
  ac_cv_krb4_where_lib=$with_krb4/lib
  ac_cv_krb4_where_inc=$with_krb4/include
  ac_cv_found_krb4=yes
  ifelse(-1,regexp($1,5),[ac_cv_found_krb5=no])
fi

if test "X$with_krb4_lib" != "X"; then
  ac_cv_krb4_where_lib=$with_krb4_lib
  ac_cv_found_krb4=yes
fi

ifelse(-1,regexp($1,auto),[],[
if test "$with_krb4" != "no"; then
  if test "$ac_cv_krb4_where_lib" = ""; then
    AC_KRB4_LIB_WHERE(["" /usr/athena/lib /usr/kerberos/lib /usr/lib /usr/local/lib])
  else
    AC_KRB4_LIB_WHERE($ac_cv_krb4_where_lib)
  fi
fi
])

if test "X$with_krb4_include" != "X"; then
  ac_cv_krb4_where_inc=$with_krb4_include
  ac_cv_found_krb4=yes
fi

ifelse(-1,regexp($1,auto),[],[
if test "$with_krb4" != "no"; then
  if test "$ac_cv_krb4_where_inc" = ""; then
    AC_KRB4_INC_WHERE(["" /usr/include /usr/athena/include /usr/kerberos/include /usr/include/kerberos /usr/local/include])
  else
    AC_KRB4_INC_WHERE($ac_cv_krb4_where_inc)
  fi
fi
])

]) dnl WITHOUT KERBEROS4 (2)


dnl
dnl
dnl

ifelse(-1,regexp($1,5),[],[   dnl KRB5 VARS

if test "X$ac_cv_found_krb5" = "Xyes"; then
  KRB5_INC_DIR=$ac_cv_krb5_where_inc
  KRB5_LIB_DIR=$ac_cv_krb5_where_lib
  KRB5_INC_FLAGS=
  if test "X$KRB5_INC_DIR" != "X" ; then
    KRB5_INC_FLAGS="-I${KRB5_INC_DIR}"
  fi
  KRB5_LIB_FLAGS=
  if test "X$KRB5_LIB_DIR" != "X" ; then
     KRB5_LIB_FLAGS="-L${KRB5_LIB_DIR}"
  fi
  KRB5_LIB_FLAGS="$KRB5_LIB_FLAGS -lkrb5 -lcom_err $ac_cv_krb5_extralib"
fi

]) dnl KRB5 VARS

ifelse(-1,regexp($1,4),[],[   dnl KRB4 VARS

if test "X$ac_cv_found_krb4" = "Xyes"; then
  KRB4_INC_DIR=$ac_cv_krb4_where_inc
  KRB4_LIB_DIR=$ac_cv_krb4_where_lib
  KRB4_INC_FLAGS=
  if test "X$KRB4_INC_DIR" != "X" ; then
    KRB4_INC_FLAGS="-I${KRB4_INC_DIR}"
  fi
  KRB4_LIB_FLAGS="$ac_cv_krb4_extralib"
  if test "X$KRB4_LIB_DIR" != "X" ; then
     KRB4_LIB_FLAGS="-L${KRB4_LIB_DIR} ${KRB4_LIB_FLAGS}"
  fi

dnl
dnl Check if what krb4-compat libs we have
dnl

elif test "X$with_krb5" != "Xno" ; then

  AC_MSG_CHECKING(figuring out what way to use kerberos 5 compat)

  KRB4_INC_DIR=$ac_cv_krb5_where_inc
  KRB4_LIB_DIR=$ac_cv_krb5_where_lib
  if test "X$KRB4_INC_DIR" != "X"; then
    KRB4_INC_FLAGS="-I${KRB4_INC_DIR}/kerberosIV -I${KRB4_INC_DIR}"
  else
    KRB4_INC_FLAGS=""
  fi
  if test "X$ac_cv_krb4_where_lib" != "X" ; then
    KRB4_LIB_FLAGS="-L${ac_cv_krb4_where_lib}"
  fi
  KRB4_LIB_FLAGS="$KRB4_LIB_FLAGS -lkrb4 -ldes425 -lkrb5 -lcom_err"
  KRB4_LIB_FLAGS="$KRB4_LIB_FLAGS $ac_cv_krb5_extralib"
  if test "X${KRB4_LIB_DIR}" != X; then
	KRB4_LIB_FLAGS="-L$KRB4_LIB_DIR $KRB4_LIB_FLAGS"
  fi
  AC_MSG_RESULT(done)
fi

]) dnl KRB4 VARS


dnl
dnl Export variables, but only we have want it
dnl

dnl KRB 5 - export

if test "X$ac_cv_found_krb5" = "Xyes"; then
  if test "X$ac_cv_found_krb4_lib" = "Xcompat"; then
    ac_cv_found_krb4=yes
    with_krb4=yes
    ifelse(-1,regexp($1,5),[ dnl 5
      ac_cv_found_krb5=no
    ],[
      AC_DEFINE(HAVE_KRB5_COMPAT_KRB4, 1,
        [define if you have kerberos 4 compat])
    ]) dnl END 5
  fi
  ifelse(-1,regexp($1,5),[],[
    with_krb5=yes
    AC_DEFINE(HAVE_KRB5, 1, [define if you have kerberos 5])
  ])
  AC_DEFINE(KERBEROS, 1, [define if you have kerberos])
fi

ifelse(-1,regexp($1,5),[],[
AC_SUBST(KRB5_LIB_DIR)
AC_SUBST(KRB5_INC_DIR)
AC_SUBST(KRB5_INC_FLAGS)
AC_SUBST(KRB5_LIB_FLAGS)]) dnl END KRB5 - export

dnl KRB 4 - export

ifelse(-1,regexp($1,4),[],[

if test "$ac_cv_found_krb4" = "yes"; then
  with_krb4=yes
  AC_DEFINE(KERBEROS, 1, [define if you have kerberos])
  AC_DEFINE(HAVE_KRB4, 1, [define if you have kerberos 4])
fi

AC_SUBST(KRB4_LIB_DIR)
AC_SUBST(KRB4_INC_DIR)
AC_SUBST(KRB4_INC_FLAGS)
AC_SUBST(KRB4_LIB_FLAGS)]) dnl END KRB4 - export

]) dnl END AC_CHECK_KERBEROS end of this short function

dnl
dnl KRB4 tests
dnl

AC_DEFUN(AC_KRB4_INC_WHERE1, [
saved_CPPFLAGS="${CPPFLAGS}"
if test -n "$1"; then
   CPPFLAGS="$saved_CPPFLAGS -I$1"
fi
AC_TRY_COMPILE([#include <krb.h>],
[struct ktext foo;],
[ac_cv_found_krb4=yes
ac_cv_found_krb4_inc=yes],
ac_cv_found_krb4_inc=no)
CPPFLAGS=$saved_CPPFLAGS
])

AC_DEFUN(AC_KRB4_INC_WHERE, [
   for i in $1; do
      for j in "" kerberos "kerberosIV"; do
	if test -n "$i"; then
	  if test -n "$j"; then
	    d="$i/$j"
	  else
	    d="$i"
	  fi
	else
	  d="$j"
	fi
        AC_MSG_CHECKING(for kerberos4 headers in $d)
	AC_KRB4_INC_WHERE1($d)
        if test "$ac_cv_found_krb4_inc" = "yes"; then
          ac_cv_krb4_where_inc=$d
	  AC_MSG_RESULT(found)
	  break 2
        else
	  AC_MSG_RESULT(not found)
        fi
      done
   done
])

dnl
dnl
dnl


AC_DEFUN(AC_KRB4_LIB_WHERE1, [
saved_LIBS=$LIBS
for a in "-lkrb -ldes"			dnl kth-krb && mit-krb
	 "-lkrb -ldes -lroken"		dnl kth-krb in nbsd
	 "-lkrb -ldes -lroken -lcom_err" dnl kth-krb in nbsd for real
	 "-lkrb -ldes -lcom_err" 	dnl kth-krb in fbsd
	; do
  LIBS="$saved_LIBS"
  if test "X$1" != "X"; then
     LIBS="$LIBS -L$1"
  fi
  LIBS="$LIBS $a"
  AC_TRY_LINK([],
  [dest_tkt();],
  [ac_cv_found_krb4_lib=yes
   ac_cv_krb4_extralib="$a"
   ac_cv_found_krb4=yes
   break],
  [ac_cv_found_krb4_lib=no
   if test "$ac_cv_found_krb4_lib" = "no"; then
    if test "X$1" != "X"; then
       LIBS="$saved_LIBS -L$1"
    fi
    LIBS="$LIBS -lkrb4 -ldes425 -lkrb5 -lcom_err $ac_cv_krb5_extralib"
    AC_TRY_LINK([], 
    [dest_tkt();],
    [ac_cv_found_krb4_lib=compat
     break],
    [ac_cv_found_krb4_lib=no])
   fi])
done
LIBS=$saved_LIBS
])

AC_DEFUN(AC_KRB4_LIB_WHERE, [
   for i in $1; do
      AC_MSG_CHECKING(for kerberos4 libraries in $i)
      AC_KRB4_LIB_WHERE1($i)
      if test "$ac_cv_found_krb4_lib" != "no" ; then
        ac_cv_krb4_where_lib=$i
	AC_MSG_RESULT(found)
	break
      else
	AC_MSG_RESULT(not found)
      fi
    done
])

dnl
dnl KRB5 tests
dnl

AC_DEFUN(AC_KRB5_INC_WHERE1, [
saved_CPPFLAGS=$CPPFLAGS
if test "X$1" != "X" ; then
   CPPFLAGS="$saved_CPPFLAGS -I$1"
fi
AC_TRY_COMPILE([#include <krb5.h>],
[krb5_kvno foo;],
ac_cv_found_krb5_inc=yes,
ac_cv_found_krb5_inc=no)
CPPFLAGS=$saved_CPPFLAGS
])

AC_DEFUN(AC_KRB5_INC_WHERE, [
   for i in $1; do
      AC_MSG_CHECKING(for kerberos5 headers in $i)
      AC_KRB5_INC_WHERE1($i)
      if test "$ac_cv_found_krb5_inc" = "yes"; then
        ac_cv_krb5_where_inc=$i
	AC_MSG_RESULT(found)
	break
      else
	AC_MSG_RESULT(not found)
      fi
    done
])


dnl
dnl
dnl

AC_DEFUN(AC_KRB5_LIB_WHERE1, [
saved_LIBS=$LIBS
for a in "-lk5crypto -lcom_err" 		dnl new mit krb
	 "-lcrypto -lcom_err" 			dnl old mit krb
         "-lasn1 -ldes -lroken" 		dnl heimdal w/ roken w/o dep on db
         "-lasn1 -ldes -lroken -lresolv" 	dnl heimdal w/ roken w/o dep on db w/ dep on resolv
         "-lasn1 -lcrypto -lcom_err -lroken"	dnl heimdal-BSD w/ roken w/o dep on db
	 "-lasn1 -ldes -lroken -ldb" 		dnl heimdal w/ roken w/ dep on db
	 "-lasn1 -ldes -lroken -ldb -lresolv" 	dnl heimdal w/ roken w/ dep on db w/ dep on resolv
	 "-lasn1 -lcrypto -lcom_err -lroken -ldb" dnl heimdal-BSD w/ roken w/ dep on db
	; do
  LIBS="$saved_LIBS"
  if test "X$1" != "X"; then
    LIBS="$LIBS -L$1"
  fi
  LIBS="$LIBS -lkrb5 $a"
  AC_TRY_LINK([],
  [krb5_init_context();],
  [ac_cv_found_krb5_lib=yes
   ac_cv_found_krb5=yes
   ac_cv_krb5_extralib=$a
   break],
  ac_cv_found_krb5_lib=no)
done
LIBS=$saved_LIBS
])

AC_DEFUN(AC_KRB5_LIB_WHERE, [
   for i in $1; do
      AC_MSG_CHECKING(for kerberos5 libraries in $i)
      AC_KRB5_LIB_WHERE1($i)
      if test "$ac_cv_found_krb5_lib" != "no" ; then
        ac_cv_krb5_where_lib=$i
	AC_MSG_RESULT(found)
	break
      else
	AC_MSG_RESULT(not found)
      fi
    done
])



dnl
dnl $Id: check-kafs.m4,v 1.3.2.1 2000/08/04 10:54:41 lha Exp $
dnl
dnl check for libkafs/krbafs
dnl

AC_DEFUN(AC_CHECK_KAFS,[

AC_ARG_WITH(krbafs,
[  --with-krbafs=dir       use libkrbafs (from cmu, extracted from kth-krb) in dir],

[if test "$with_krbafs" = "yes"; then
  AC_MSG_ERROR([You have to give the path to krbafs lib])
elif test "$with_krbafs" = "no"; then
  ac_cv_funclib_k_hasafs=no
else
  KAFS_LIBS_FLAGS="-L${with_krbafs}/lib"
fi])

AC_CACHE_CHECK([checking for libkafs/libkrbafs],
[ac_cv_funclib_k_hasafs],[

saved_LIBS="$LIBS"

for a in "$KRB4_LIB_FLAGS" \
	 "$KRB5_LIB_FLAGS" \
	 "$KRB5_LIB_FLAGS $KRB4_LIB_FLAGS" ; do
  for b in "kafs" "krbafs"; do
    LIBS="$saved_LIBS ${KAFS_LIBS_FLAGS} $a -l$b"
    AC_TRY_LINK([],
    [k_hasafs();],
    [ac_cv_funclib_k_hasafs=yes
    ac_cv_libkafs_flags="$KAFS_LIBS_FLAGS $a -l$b"
    break 2],
    [ac_cv_funclib_k_hasafs=no])
  done
done

LIBS="$saved_LIBS"])

if test "X$ac_cv_funclib_k_hasafs" != "Xno"; then
   KAFS_LIBS="$ac_cv_libkafs_flags"
fi

AC_SUBST(KAFS_LIBS)dnl

])dnl

dnl
dnl $Id: type-msghdr.m4,v 1.1 1999/05/15 22:45:35 assar Exp $
dnl

dnl
dnl Check for struct msghdr
dnl

AC_DEFUN(AC_TYPE_MSGHDR, [

AC_CACHE_CHECK(for struct msghdr, ac_cv_struct_msghdr, [
AC_EGREP_HEADER([struct msghdr], sys/socket.h,
ac_cv_struct_msghdr=yes,
ac_cv_struct_msghdr=no)
])
if test "$ac_cv_struct_msghdr" = "yes"; then
  AC_DEFINE(HAVE_STRUCT_MSGHDR, 1, [define if you have struct msghdr])
fi
])

dnl
dnl $Id: type-iovec.m4,v 1.2 1999/06/24 01:44:58 assar Exp $
dnl

dnl
dnl Check for struct iovec
dnl

AC_DEFUN(AC_TYPE_IOVEC, [

AC_CACHE_CHECK(for struct iovec, ac_cv_struct_iovec, [
AC_EGREP_HEADER(
changequote(, )dnl
struct[ 	]*iovec,
changequote([,])dnl
sys/uio.h,
ac_cv_struct_iovec=yes,
ac_cv_struct_iovec=no)
])
if test "$ac_cv_struct_iovec" = "yes"; then
  AC_DEFINE(HAVE_STRUCT_IOVEC, 1, [define if you have struct iovec])
fi
])

dnl
dnl $Id: type-krb-principal.m4,v 1.3 2000/01/23 13:01:42 lha Exp $
dnl

dnl
dnl Check for struct krb_principal
dnl

AC_DEFUN(AC_TYPE_KRB_PRINCIPAL, [

AC_CACHE_CHECK(for krb_principal, ac_cv_struct_krb_principal, [
if test "$ac_cv_found_krb4" = "yes"; then
save_CPPFLAGS="${CPPFLAGS}"
CPPFLAGS="${KRB4_INC_FLAGS} $CPPFLAGS"
AC_EGREP_HEADER(krb_principal, krb.h,ac_cv_struct_krb_principal=yes)
CPPFLAGS="${save_CPPFLAGS}"
eval "ac_cv_struct_krb_principal=${ac_cv_struct_krb_principal-no}"
else
dnl Gross hack to avoid struct krb_principal get defined when we don't have krb
eval "ac_cv_struct_krb_principal=no"
fi
])
if test "$ac_cv_struct_krb_principal" = "yes"; then
  AC_DEFINE(HAVE_KRB_PRINCIPAL, 1, [define if you have a struct krb_principal])
fi
])

dnl
dnl $Id: func-krb-get-err-text.m4,v 1.3 2000/01/23 13:01:51 lha Exp $
dnl

dnl
dnl Check for krb_get_err_text
dnl

AC_DEFUN(AC_FUNC_KRB_GET_ERR_TEXT, [

AC_CACHE_CHECK(for krb_get_err_text, ac_cv_func_krb_get_err_text, [
if test "$ac_cv_found_krb4" = "yes"; then
save_CPPFLAGS="${CPPFLAGS}"
save_LIBS="${LIBS}"
CPPFLAGS="${KRB4_INC_FLAGS} ${CPPFLAGS}"
LIBS="${KRB4_LIB_FLAGS} ${LIBS}"
AC_TRY_LINK([#include <krb.h>],
[krb_get_err_text(0);],
ac_cv_func_krb_get_err_text=yes,
ac_cv_func_krb_get_err_text=no)
CPPFLAGS="${save_CPPFLAGS}"
LIBS="${save_LIBS}"
fi
])
if test "$ac_cv_func_krb_get_err_text" = "yes"; then
  AC_DEFINE(HAVE_KRB_GET_ERR_TEXT, 1, [define if you have krb_get_err_text])
fi
])

dnl
dnl $Id: func-krb-get-default-tkt-root.m4,v 1.3 2000/01/23 16:53:21 lha Exp $
dnl

dnl
dnl Check for krb_get_default_tkt_root
dnl

AC_DEFUN(AC_FUNC_KRB_GET_DEFAULT_TKT_ROOT, [

AC_CACHE_CHECK(for krb_get_default_tkt_root, ac_cv_func_krb_get_default_tkt_root, [
if test "$ac_cv_found_krb4" = "yes"; then
save_CPPFLAGS="${CPPFLAGS}"
save_LIBS="${LIBS}"
CPPFLAGS="${KRB4_INC_FLAGS} ${CPPFLAGS}"
LIBS="${KRB4_LIB_FLAGS} ${LIBS}"
AC_TRY_LINK([#include <krb.h>],
[krb_get_default_tkt_root();],
ac_cv_func_krb_get_default_tkt_root=yes,
ac_cv_func_krb_get_default_tkt_root=no)
CPPFLAGS="${save_CPPFLAGS}"
LIBS="${save_LIBS}"
else
dnl Make it say no
eval "ac_cv_func_krb_get_default_tkt_root=no"
fi
])
if test "$ac_cv_func_krb_get_default_tkt_root" = "yes"; then
  AC_DEFINE(HAVE_KRB_GET_DEFAULT_TKT_ROOT, 1, [define if you have krb_get_default_tkt_root])
fi
])

dnl
dnl $Id: func-krb-kdctimeofday.m4,v 1.4 2000/05/23 07:21:24 assar Exp $
dnl

dnl
dnl Check for krb_kdctimeofday
dnl

AC_DEFUN(AC_FUNC_KRB_KDCTIMEOFDAY, [

AC_CACHE_CHECK(for krb_kdctimeofday, ac_cv_func_krb_kdctimeofday, [
if test "$ac_cv_found_krb4" = "yes"; then
save_CPPFLAGS="${CPPFLAGS}"
save_LIBS="${LIBS}"
CPPFLAGS="${KRB4_INC_FLAGS} ${CPPFLAGS}"
LIBS="${KRB4_LIB_FLAGS} ${LIBS}"
AC_TRY_LINK([#include <krb.h>],
[krb_kdctimeofday(0);],
ac_cv_func_krb_kdctimeofday=yes,
ac_cv_func_krb_kdctimeofday=no)
CPPFLAGS="${save_CPPFLAGS}"
LIBS="${save_LIBS}"
else
dnl Make it say no
eval "ac_cv_func_krb_kdctimeofday=no"
fi
])
if test "$ac_cv_func_krb_kdctimeofday" = "yes"; then
  AC_DEFINE(HAVE_KRB_KDCTIMEOFDAY, 1, [define if you have krb_kdctimeofday])
fi
])

dnl $Id: test-package.m4,v 1.1 1999/05/15 22:45:34 assar Exp $
dnl
dnl AC_TEST_PACKAGE_NEW(package,headers,libraries,extra libs,default locations)

AC_DEFUN(AC_TEST_PACKAGE,[AC_TEST_PACKAGE_NEW($1,[#include <$2>],$4,,$5)])

AC_DEFUN(AC_TEST_PACKAGE_NEW,[
AC_ARG_WITH($1,
[  --with-$1=dir                use $1 in dir])
AC_ARG_WITH($1-lib,
[  --with-$1-lib=dir            use $1 libraries in dir],
[if test "$withval" = "yes" -o "$withval" = "no"; then
  AC_MSG_ERROR([No argument for --with-$1-lib])
elif test "X$with_$1" = "X"; then
  with_$1=yes
fi])
AC_ARG_WITH($1-include,
[  --with-$1-include=dir        use $1 headers in dir],
[if test "$withval" = "yes" -o "$withval" = "no"; then
  AC_MSG_ERROR([No argument for --with-$1-include])
elif test "X$with_$1" = "X"; then
  with_$1=yes
fi])

AC_MSG_CHECKING(for $1)

case "$with_$1" in
yes)	;;
no)	;;
"")	;;
*)	if test "$with_$1_include" = ""; then
		with_$1_include="$with_$1/include"
	fi
	if test "$with_$1_lib" = ""; then
		with_$1_lib="$with_$1/lib$abilibdirext"
	fi
	;;
esac
header_dirs=
lib_dirs=
d='$5'
for i in $d; do
	header_dirs="$header_dirs $i/include"
	lib_dirs="$lib_dirs $i/lib$abilibdirext"
done

case "$with_$1_include" in
yes) ;;
no)  ;;
*)   header_dirs="$with_$1_include $header_dirs";;
esac
case "$with_$1_lib" in
yes) ;;
no)  ;;
*)   lib_dirs="$with_$1_lib $lib_dirs";;
esac

save_CFLAGS="$CFLAGS"
save_LIBS="$LIBS"
ires= lres=
for i in $header_dirs; do
	CFLAGS="-I$i $save_CFLAGS"
	AC_TRY_COMPILE([$2],,ires=$i;break)
done
for i in $lib_dirs; do
	LIBS="-L$i $3 $4 $save_LIBS"
	AC_TRY_LINK([$2],,lres=$i;break)
done
CFLAGS="$save_CFLAGS"
LIBS="$save_LIBS"

if test "$ires" -a "$lres"; then
	$1_includedir="$ires"
	$1_libdir="$lres"
	INCLUDE_$1="-I$$1_includedir"
	LIB_$1="-L$$1_libdir $3"
	AC_DEFINE_UNQUOTED(upcase($1),1,[Define if you have the $1 package.])
	with_$1=yes
	AC_MSG_RESULT([headers $ires, libraries $lres])
else
	INCLUDE_$1=
	LIB_$1=
	with_$1=no
	AC_MSG_RESULT($with_$1)
fi
AC_SUBST(INCLUDE_$1)
AC_SUBST(LIB_$1)
])

dnl $Id: find-func-no-libs.m4,v 1.3 1999/10/30 21:04:34 assar Exp $
dnl
dnl
dnl Look for function in any of the specified libraries
dnl

dnl AC_FIND_FUNC_NO_LIBS(func, libraries, includes, arguments, extra libs, extra args)
AC_DEFUN(AC_FIND_FUNC_NO_LIBS, [
AC_FIND_FUNC_NO_LIBS2([$1], ["" $2], [$3], [$4], [$5], [$6])])

dnl $Id: find-func-no-libs2.m4,v 1.3 1999/10/30 21:03:36 assar Exp $
dnl
dnl
dnl Look for function in any of the specified libraries
dnl

dnl AC_FIND_FUNC_NO_LIBS2(func, libraries, includes, arguments, extra libs, extra args)
AC_DEFUN(AC_FIND_FUNC_NO_LIBS2, [

AC_MSG_CHECKING([for $1])
AC_CACHE_VAL(ac_cv_funclib_$1,
[
if eval "test \"\$ac_cv_func_$1\" != yes" ; then
	ac_save_LIBS="$LIBS"
	for ac_lib in $2; do
		if test -n "$ac_lib"; then 
			ac_lib="-l$ac_lib"
		else
			ac_lib=""
		fi
		LIBS="$6 $ac_lib $5 $ac_save_LIBS"
		AC_TRY_LINK([$3],[$1($4)],eval "if test -n \"$ac_lib\";then ac_cv_funclib_$1=$ac_lib; else ac_cv_funclib_$1=yes; fi";break)
	done
	eval "ac_cv_funclib_$1=\${ac_cv_funclib_$1-no}"
	LIBS="$ac_save_LIBS"
fi
])

eval "ac_res=\$ac_cv_funclib_$1"

dnl autoheader tricks *sigh*
: << END
@@@funcs="$funcs $1"@@@
@@@libs="$libs $2"@@@
END

# $1
eval "ac_tr_func=HAVE_[]upcase($1)"
eval "ac_tr_lib=HAVE_LIB[]upcase($ac_res | sed -e 's/-l//')"
eval "LIB_$1=$ac_res"

case "$ac_res" in
	yes)
	eval "ac_cv_func_$1=yes"
	eval "LIB_$1="
	AC_DEFINE_UNQUOTED($ac_tr_func)
	AC_MSG_RESULT([yes])
	;;
	no)
	eval "ac_cv_func_$1=no"
	eval "LIB_$1="
	AC_MSG_RESULT([no])
	;;
	*)
	eval "ac_cv_func_$1=yes"
	eval "ac_cv_lib_`echo "$ac_res" | sed 's/-l//'`=yes"
	AC_DEFINE_UNQUOTED($ac_tr_func)
	AC_DEFINE_UNQUOTED($ac_tr_lib)
	AC_MSG_RESULT([yes, in $ac_res])
	;;
esac
AC_SUBST(LIB_$1)
])

dnl
dnl $Id: check-lfs.m4,v 1.2 2000/03/14 00:04:10 assar Exp $
dnl

AC_DEFUN(AC_HAVE_GETCONF, [
AC_CHECK_PROG(ac_cv_prog_getconf,[getconf],yes)
])

AC_DEFUN(AC_GETCONF_FLAGS,[
if test "$ac_cv_prog_getconf" = "yes";then
AC_MSG_CHECKING([if we have $1])
FOO="`getconf $1 2>/dev/null >/dev/null`"
if test $? = 0 ;then
$2="[$]$2 $FOO"
AC_MSG_RESULT([yes $FOO])
else
AC_MSG_RESULT(no)
fi
fi

])

AC_DEFUN(AC_CHECK_LFS, [
if test "${ac_cv_prog_getconf-set}" = set ;then
AC_HAVE_GETCONF
fi
AC_GETCONF_FLAGS(LFS_CFLAGS, CFLAGS)
AC_GETCONF_FLAGS(LFS_LDFLAGS, LDFLAGS)
])



dnl
dnl $Id: check-glibc.m4,v 1.2 2000/03/14 00:04:09 assar Exp $
dnl
dnl
dnl test for GNU libc
dnl

AC_DEFUN(AC_CHECK_GLIBC,[
AC_CACHE_CHECK([for glibc],ac_cv_libc_glibc,[
AC_EGREP_CPP(yes,
[#include <features.h>
#ifdef __GLIBC__
yes
#endif
],
eval "ac_cv_libc_glibc=yes",
eval "ac_cv_libc_glibc=no")])
if test "$ac_cv_libc_glibc" = "yes";then
	AC_DEFINE(HAVE_GLIBC, 1,
	[define if you have a glibc-based system])
fi
])

dnl
dnl $Id: krb-bigendian.m4,v 1.1.12.1 2000/08/19 17:03:24 ahltorp Exp $
dnl

dnl check if this computer is little or big-endian
dnl if we can figure it out at compile-time then don't define the cpp symbol
dnl otherwise test for it and define it.  also allow options for overriding
dnl it when cross-compiling

AC_DEFUN(KRB_C_BIGENDIAN, [
AC_ARG_ENABLE(bigendian,
[  --enable-bigendian	the target is big endian],
krb_cv_c_bigendian=yes)
AC_ARG_ENABLE(littleendian,
[  --enable-littleendian	the target is little endian],
krb_cv_c_bigendian=no)
AC_CACHE_CHECK(whether byte order is known at compile time,
krb_cv_c_bigendian_compile,
[AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/param.h>],[
#if !BYTE_ORDER || !BIG_ENDIAN || !LITTLE_ENDIAN
 bogus endian macros
#endif], krb_cv_c_bigendian_compile=yes, krb_cv_c_bigendian_compile=no)])
AC_CACHE_CHECK(whether byte ordering is bigendian, krb_cv_c_bigendian,[
  if test "$krb_cv_c_bigendian_compile" = "yes"; then
    AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/param.h>],[
#if BYTE_ORDER != BIG_ENDIAN
  not big endian
#endif], krb_cv_c_bigendian=yes, krb_cv_c_bigendian=no)
  else
    AC_TRY_RUN([main () {
    /* Are we little or big endian?  From Harbison&Steele.  */
    union
    {
	long l;
	char c[sizeof (long)];
    } u;
    u.l = 1;
    exit (u.c[sizeof (long) - 1] == 1);
  }], krb_cv_c_bigendian=no, krb_cv_c_bigendian=yes,
  AC_MSG_ERROR([specify either --enable-bigendian or --enable-littleendian]))
  fi
])
if test "$krb_cv_c_bigendian" = "yes"; then
  AC_DEFINE(WORDS_BIGENDIAN, 1, [define if target is big endian])dnl
fi
if test "$krb_cv_c_bigendian_compile" = "yes"; then
  AC_DEFINE(ENDIANESS_IN_SYS_PARAM_H, 1, [define if sys/param.h defines the endiness])dnl
fi
])

dnl
dnl $Id: c-function.m4,v 1.1 1999/05/15 22:45:20 assar Exp $
dnl

dnl
dnl Test for __FUNCTION__
dnl

AC_DEFUN(AC_C___FUNCTION__, [
AC_MSG_CHECKING(for __FUNCTION__)
AC_CACHE_VAL(ac_cv___function__, [
AC_TRY_RUN([
#include <string.h>

static char *foo()
{
  return __FUNCTION__;
}

int main()
{
  return strcmp(foo(), "foo") != 0;
}
],
ac_cv___function__=yes,
ac_cv___function__=no,
ac_cv___function__=no)])
if test "$ac_cv___function__" = "yes"; then
  AC_DEFINE(HAVE___FUNCTION__, 1, [define if your compiler has __FUNCTION__])
fi
AC_MSG_RESULT($ac_cv___function__)
])


dnl
dnl $Id: c-attribute.m4,v 1.1 1999/05/15 22:45:20 assar Exp $
dnl

dnl
dnl Test for __attribute__
dnl

AC_DEFUN(AC_C___ATTRIBUTE__, [
AC_MSG_CHECKING(for __attribute__)
AC_CACHE_VAL(ac_cv___attribute__, [
AC_TRY_COMPILE([
#include <stdlib.h>
],
[
static void foo(void) __attribute__ ((noreturn));

static void
foo(void)
{
  exit(1);
}
],
ac_cv___attribute__=yes,
ac_cv___attribute__=no)])
if test "$ac_cv___attribute__" = "yes"; then
  AC_DEFINE(HAVE___ATTRIBUTE__, 1, [define if your compiler has __attribute__])
fi
AC_MSG_RESULT($ac_cv___attribute__)
])


dnl $Id: krb-find-db.m4,v 1.1 1999/05/15 22:45:28 assar Exp $
dnl
dnl find a suitable database library
dnl
dnl AC_FIND_DB(libraries)
AC_DEFUN(KRB_FIND_DB, [

lib_dbm=no
lib_db=no

for i in $1; do

	if test "$i"; then
		m="lib$i"
		l="-l$i"
	else
		m="libc"
		l=""
	fi	

	AC_MSG_CHECKING(for dbm_open in $m)
	AC_CACHE_VAL(ac_cv_krb_dbm_open_$m, [

	save_LIBS="$LIBS"
	LIBS="$l $LIBS"
	AC_TRY_RUN([
#include <unistd.h>
#include <fcntl.h>
#include <ndbm.h>
int main()
{
  DBM *d;

  d = dbm_open("conftest", O_RDWR | O_CREAT, 0666);
  if(d == NULL)
    return 1;
  dbm_close(d);
  return 0;
}], [
	if test -f conftest.db; then
		ac_res=db
	else
		ac_res=dbm
	fi], ac_res=no, ac_res=no)

	LIBS="$save_LIBS"

	eval ac_cv_krb_dbm_open_$m=$ac_res])
	eval ac_res=\$ac_cv_krb_dbm_open_$m
	AC_MSG_RESULT($ac_res)

	if test "$lib_dbm" = no -a $ac_res = dbm; then
		lib_dbm="$l"
	elif test "$lib_db" = no -a $ac_res = db; then
		lib_db="$l"
		break
	fi
done

AC_MSG_CHECKING(for NDBM library)
ac_ndbm=no
if test "$lib_db" != no; then
	LIB_DBM="$lib_db"
	ac_ndbm=yes
	AC_DEFINE(HAVE_NEW_DB, 1, [Define if NDBM really is DB (creates files ending in .db).])
	if test "$LIB_DBM"; then
		ac_res="yes, $LIB_DBM"
	else
		ac_res=yes
	fi
elif test "$lib_dbm" != no; then
	LIB_DBM="$lib_dbm"
	ac_ndbm=yes
	if test "$LIB_DBM"; then
		ac_res="yes, $LIB_DBM"
	else
		ac_res=yes
	fi
else
	LIB_DBM=""
	ac_res=no
fi
test "$ac_ndbm" = yes && AC_DEFINE(NDBM, 1, [Define if you have NDBM (and not DBM)])dnl
AC_SUBST(LIB_DBM)
DBLIB="$LIB_DBM"
AC_SUBST(DBLIB)
AC_MSG_RESULT($ac_res)

])

dnl $Id: krb-sys-nextstep.m4,v 1.2 1999/05/16 13:44:46 assar Exp $
dnl
dnl
dnl NEXTSTEP is not posix compliant by default,
dnl you need a switch -posix to the compiler
dnl

AC_DEFUN(AC_KRB_SYS_NEXTSTEP, [
AC_MSG_CHECKING(for NEXTSTEP)
AC_CACHE_VAL(krb_cv_sys_nextstep,
AC_EGREP_CPP(yes, 
[#if defined(NeXT) && !defined(__APPLE__)
	yes
#endif 
], krb_cv_sys_nextstep=yes, krb_cv_sys_nextstep=no) )
if test "$krb_cv_sys_nextstep" = "yes"; then
  CFLAGS="$CFLAGS -posix"
  CPPFLAGS="$CPPFLAGS -posix"
  LIBS="$LIBS -posix"
fi
AC_MSG_RESULT($krb_cv_sys_nextstep)
])

dnl $Id: krb-sys-aix.m4,v 1.1 1999/05/15 22:45:31 assar Exp $
dnl
dnl
dnl AIX have a very different syscall convention
dnl
AC_DEFUN(AC_KRB_SYS_AIX, [
AC_MSG_CHECKING(for AIX)
AC_CACHE_VAL(krb_cv_sys_aix,
AC_EGREP_CPP(yes, 
[#ifdef _AIX
	yes
#endif 
], krb_cv_sys_aix=yes, krb_cv_sys_aix=no) )
AC_MSG_RESULT($krb_cv_sys_aix)
])

dnl $Id: krb-struct-winsize.m4,v 1.1 1999/05/15 22:45:31 assar Exp $
dnl
dnl
dnl Search for struct winsize
dnl

AC_DEFUN(AC_KRB_STRUCT_WINSIZE, [
AC_MSG_CHECKING(for struct winsize)
AC_CACHE_VAL(ac_cv_struct_winsize, [
ac_cv_struct_winsize=no
for i in sys/termios.h sys/ioctl.h; do
AC_EGREP_HEADER(
changequote(, )dnl
struct[ 	]*winsize,dnl
changequote([,])dnl
$i, ac_cv_struct_winsize=yes; break)dnl
done
])
if test "$ac_cv_struct_winsize" = "yes"; then
  AC_DEFINE(HAVE_STRUCT_WINSIZE, 1, [define if struct winsize is declared in sys/termios.h])
fi
AC_MSG_RESULT($ac_cv_struct_winsize)
AC_EGREP_HEADER(ws_xpixel, termios.h, 
	AC_DEFINE(HAVE_WS_XPIXEL, 1, [define if struct winsize has ws_xpixel]))
AC_EGREP_HEADER(ws_ypixel, termios.h, 
	AC_DEFINE(HAVE_WS_YPIXEL, 1, [define if struct winsize has ws_ypixel]))
])

dnl $Id: find-func.m4,v 1.1 1999/05/15 22:45:25 assar Exp $
dnl
dnl AC_FIND_FUNC(func, libraries, includes, arguments)
AC_DEFUN(AC_FIND_FUNC, [
AC_FIND_FUNC_NO_LIBS([$1], [$2], [$3], [$4])
if test -n "$LIB_$1"; then
	LIBS="$LIB_$1 $LIBS"
fi
])

dnl $Id: broken-snprintf.m4,v 1.1 1999/05/15 22:45:18 assar Exp $
dnl
AC_DEFUN(AC_BROKEN_SNPRINTF, [
AC_CACHE_CHECK(for working snprintf,ac_cv_func_snprintf_working,
ac_cv_func_snprintf_working=yes
AC_TRY_RUN([
#include <stdio.h>
#include <string.h>
int main()
{
changequote(`,')dnl
	char foo[3];
changequote([,])dnl
	snprintf(foo, 2, "12");
	return strcmp(foo, "1");
}],:,ac_cv_func_snprintf_working=no,:))

if test "$ac_cv_func_snprintf_working" = yes; then
	AC_DEFINE(HAVE_SNPRINTF, 1, [define if you have a working snprintf])
fi
if test "$ac_cv_func_snprintf_working" = yes; then
	AC_NEED_PROTO([#include <stdio.h>],snprintf)
fi
])

AC_DEFUN(AC_BROKEN_VSNPRINTF,[
AC_CACHE_CHECK(for working vsnprintf,ac_cv_func_vsnprintf_working,
ac_cv_func_vsnprintf_working=yes
AC_TRY_RUN([
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

int foo(int num, ...)
{
changequote(`,')dnl
	char bar[3];
changequote([,])dnl
	va_list arg;
	va_start(arg, num);
	vsnprintf(bar, 2, "%s", arg);
	va_end(arg);
	return strcmp(bar, "1");
}


int main()
{
	return foo(0, "12");
}],:,ac_cv_func_vsnprintf_working=no,:))

if test "$ac_cv_func_vsnprintf_working" = yes; then
	AC_DEFINE(HAVE_VSNPRINTF, 1, [define if you have a working vsnprintf])
fi
if test "$ac_cv_func_vsnprintf_working" = yes; then
	AC_NEED_PROTO([#include <stdio.h>],vsnprintf)
fi
])

dnl $Id: need-proto.m4,v 1.1 1999/05/15 22:45:33 assar Exp $
dnl
dnl
dnl Check if we need the prototype for a function
dnl

dnl AC_NEED_PROTO(includes, function)

AC_DEFUN(AC_NEED_PROTO, [
if test "$ac_cv_func_$2+set" != set -o "$ac_cv_func_$2" = yes; then
AC_CACHE_CHECK([if $2 needs a prototype], ac_cv_func_$2_noproto,
AC_TRY_COMPILE([$1],
[struct foo { int foo; } xx;
extern int $2 (struct foo*);
$2(&xx);
],
eval "ac_cv_func_$2_noproto=yes",
eval "ac_cv_func_$2_noproto=no"))
define([foo], [NEED_]translit($2, [a-z], [A-Z])[_PROTO])
if test "$ac_cv_func_$2_noproto" = yes; then
	AC_DEFINE(foo, 1, [define if the system is missing a prototype for $2()])
fi
undefine([foo])
fi
])

dnl
dnl $Id: have-types.m4,v 1.1 1999/05/15 22:45:28 assar Exp $
dnl

AC_DEFUN(AC_HAVE_TYPES, [
for i in $1; do
        AC_HAVE_TYPE($i)
done
: << END
changequote(`,')dnl
@@@funcs="$funcs $1"@@@
changequote([,])dnl
END
])

dnl $Id: have-type.m4,v 1.2 1999/12/31 03:12:22 assar Exp $
dnl
dnl check for existance of a type

dnl AC_HAVE_TYPE(TYPE,INCLUDES)
AC_DEFUN(AC_HAVE_TYPE, [
AC_REQUIRE([AC_HEADER_STDC])
cv=`echo "$1" | sed 'y%./+- %__p__%'`
AC_MSG_CHECKING(for $1)
AC_CACHE_VAL([ac_cv_type_$cv],
AC_TRY_COMPILE(
[#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
$2],
[$1 foo;],
eval "ac_cv_type_$cv=yes",
eval "ac_cv_type_$cv=no"))dnl
AC_MSG_RESULT(`eval echo \\$ac_cv_type_$cv`)
if test `eval echo \\$ac_cv_type_$cv` = yes; then
  ac_tr_hdr=HAVE_`echo $1 | sed 'y%abcdefghijklmnopqrstuvwxyz./- %ABCDEFGHIJKLMNOPQRSTUVWXYZ____%'`
dnl autoheader tricks *sigh*
define(foo,translit($1, [ ], [_]))
: << END
@@@funcs="$funcs foo"@@@
END
undefine([foo])
  AC_DEFINE_UNQUOTED($ac_tr_hdr, 1)
fi
])

dnl $Id: check-var.m4,v 1.1 1999/05/15 22:45:24 assar Exp $
dnl
dnl AC_CHECK_VAR(includes, variable)
AC_DEFUN(AC_CHECK_VAR, [
AC_MSG_CHECKING(for $2)
AC_CACHE_VAL(ac_cv_var_$2, [
AC_TRY_LINK([extern int $2;
int foo() { return $2; }],
	    [foo()],
	    ac_cv_var_$2=yes, ac_cv_var_$2=no)
])
define([foo], [HAVE_]translit($2, [a-z], [A-Z]))

AC_MSG_RESULT(`eval echo \\$ac_cv_var_$2`)
if test `eval echo \\$ac_cv_var_$2` = yes; then
	AC_DEFINE_UNQUOTED(foo, 1, [define if you have $2])
	AC_CHECK_DECLARATION([$1],[$2])
fi
undefine([foo])
])

dnl $Id: check-declaration.m4,v 1.2 1999/10/06 03:15:53 assar Exp $
dnl
dnl
dnl Check if we need the declaration of a variable
dnl

dnl AC_CHECK_DECLARATION(includes, variable)
AC_DEFUN(AC_CHECK_DECLARATION, [
AC_MSG_CHECKING([if $2 is properly declared])
AC_CACHE_VAL(ac_cv_var_$2_declaration, [
AC_TRY_COMPILE([$1
extern struct { int foo; } $2;],
[$2.foo = 1;],
eval "ac_cv_var_$2_declaration=no",
eval "ac_cv_var_$2_declaration=yes")
])

define(foo, [HAVE_]translit($2, [a-z], [A-Z])[_DECLARATION])

AC_MSG_RESULT($ac_cv_var_$2_declaration)
if eval "test \"\$ac_cv_var_$2_declaration\" = yes"; then
	AC_DEFINE(foo, 1, [define if your system declares $2])
fi
undefine([foo])
])

dnl $Id: find-if-not-broken.m4,v 1.1 1999/05/15 22:45:25 assar Exp $
dnl
dnl
dnl Mix between AC_FIND_FUNC and AC_BROKEN
dnl

AC_DEFUN(AC_FIND_IF_NOT_BROKEN,
[AC_FIND_FUNC([$1], [$2], [$3], [$4])
if eval "test \"$ac_cv_func_$1\" != yes"; then
LIBOBJS[]="$LIBOBJS $1.o"
fi
AC_SUBST(LIBOBJS)dnl
])

dnl
dnl $Id: func-hstrerror-const.m4,v 1.2 1999/05/28 13:18:04 assar Exp $
dnl
dnl Test if hstrerror wants const or not
dnl

dnl AC_FUNC_HSTRERROR_CONST(includes, function)

AC_DEFUN(AC_FUNC_HSTRERROR_CONST, [
AC_CACHE_CHECK([if hstrerror needs const], ac_cv_func_hstrerror_const,
AC_TRY_COMPILE([netdb.h],
[const char *hstrerror(int);],
ac_cv_func_hstrerror_const=no,
ac_cv_func_hstrerror_const=yes))
if test "$ac_cv_func_hstrerror_const" = "yes"; then
	AC_DEFINE(NEED_HSTRERROR_CONST, 1, [define if hstrerror is const])
fi
])

dnl $Id: broken.m4,v 1.1 1999/05/15 22:45:18 assar Exp $
dnl
dnl
dnl Same as AC _REPLACE_FUNCS, just define HAVE_func if found in normal
dnl libraries 

AC_DEFUN(AC_BROKEN,
[for ac_func in $1
do
AC_CHECK_FUNC($ac_func, [
ac_tr_func=HAVE_[]upcase($ac_func)
AC_DEFINE_UNQUOTED($ac_tr_func)],[LIBOBJS[]="$LIBOBJS ${ac_func}.o"])
dnl autoheader tricks *sigh*
: << END
@@@funcs="$funcs $1"@@@
END
done
AC_SUBST(LIBOBJS)dnl
])

dnl
dnl $Id: func-getvfsbyname.m4,v 1.1 1999/05/15 22:45:25 assar Exp $
dnl

AC_DEFUN(AC_FUNC_GETVFSBYNAME, [
AC_CHECK_FUNCS(getvfsbyname)
if test "$ac_cv_func_getvfsbyname" = "yes"; then
AC_CACHE_CHECK(for two argument getvfsbyname,
ac_cv_func_getvfsbyname_two_arguments,
AC_TRY_COMPILE(
[#include <sys/types.h>
#include <sys/param.h>
#include <sys/mount.h>],
[struct vfsconf vfc;
int foo = getvfsbyname("arla", &vfc);
],
ac_cv_func_getvfsbyname_two_arguments=yes,
ac_cv_func_getvfsbyname_two_arguments=no))
if test "$ac_cv_func_getvfsbyname_two_arguments" = "yes"; then
  AC_DEFINE(HAVE_GETVFSBYNAME_TWO_ARGS, 1,
	[define if getvfsbyname takes two arguments])
fi
fi
])

dnl $Id: header-dirent-dir-h.m4,v 1.1 2000/03/24 04:07:32 assar Exp $

dnl
dnl Check if we can include both dirent.h and sys/dir.h
dnl

AC_DEFUN(AC_DIRENT_SYS_DIR_H, [
AC_CACHE_CHECK(if we can include both dirent.h and sys/dir.h,
ac_cv_header_dirent_and_sys_dir,
AC_TRY_CPP([
#include <sys/types.h>
#include <dirent.h>
#include <sys/dir.h>
],
ac_cv_header_dirent_and_sys_dir=yes,
ac_cv_header_dirent_and_sys_dir=no))
if test "$ac_cv_header_dirent_and_sys_dir" = yes; then
	AC_DEFINE(DIRENT_AND_SYS_DIR_H, 1,
	[define if you can include both dirent.h and sys/dir.h])
fi
])

dnl $Id: have-struct-field.m4,v 1.1 1999/05/15 22:45:27 assar Exp $
dnl
dnl check for fields in a structure
dnl
dnl AC_HAVE_STRUCT_FIELD(struct, field, headers)

AC_DEFUN(AC_HAVE_STRUCT_FIELD, [
define(cache_val, translit(ac_cv_type_$1_$2, [A-Z ], [a-z_]))
AC_CACHE_CHECK([for $2 in $1], cache_val,[
AC_TRY_COMPILE([$3],[$1 x; x.$2;],
cache_val=yes,
cache_val=no)])
if test "$cache_val" = yes; then
	define(foo, translit(HAVE_$1_$2, [a-z ], [A-Z_]))
	AC_DEFINE(foo, 1, [Define if $1 has field $2.])
	undefine(foo)
fi
undefine(cache_val)
])

dnl
dnl $Id: elf-object-format.m4,v 1.1 1999/05/15 22:45:24 assar Exp $
dnl
dnl test for ELF

AC_DEFUN(AC_ELF_OBJECT_FORMAT,[
AC_CACHE_CHECK([for ELF object format], ac_cv_sys_elf_object_format,[
ac_cv_sys_elf_object_format=no
echo 'int foo;' > conftest.$ac_ext
if AC_TRY_EVAL(ac_compile); then
	case `file conftest.o 2> /dev/null` in
	*ELF*)	ac_cv_sys_elf_object_format=yes ;;
	esac
fi
rm -f conftest*])])

dnl
dnl $Id: kernel.m4,v 1.1 1999/05/15 22:45:28 assar Exp $
dnl

dnl 
dnl Check for where the kernel is stored
dnl

AC_DEFUN(AC_KERNEL,
[
dnl XXX XXX XXX *** this test sucks *** XXX XXX XXX
if test "$ac_kernel_ld" = ""; then
if test "$ac_cv_sys_elf_object_format" = yes; then
ac_kernel_ld='${LD-ld} -o conftest $LDFLAGS -R $KERNEL conftest.o -e _foo 1>&AC_FD_CC'
else
ac_kernel_ld='${LD-ld} -o conftest $LDFLAGS -A $KERNEL conftest.o -e _foo 1>&AC_FD_CC'
fi
fi
])

dnl
dnl $Id: check-kernel-funcs.m4,v 1.2 1999/08/09 23:02:45 assar Exp $
dnl

dnl AC_CHECK_KERNEL_FUNCS(functions...)
AC_DEFUN(AC_CHECK_KERNEL_FUNCS,
[for ac_func in $1
do
AC_CHECK_KERNEL($ac_func, ac_cv_kernel_func_$ac_func, [$ac_func]())
done
]
: << END
@@@funcs="$funcs [patsubst([$1], [\w+], [kernel_\&])]"@@@
END
)

dnl
dnl $Id: check-kernel.m4,v 1.3 2000/03/24 03:50:56 assar Exp $
dnl

dnl there are two different heuristics for doing the kernel tests
dnl a) running nm and greping the output
dnl b) trying linking against the kernel

dnl AC_CHECK_KERNEL(name, cv, magic, [includes])
AC_DEFUN(AC_CHECK_KERNEL,
[AC_MSG_CHECKING([for $1 in kernel])
AC_CACHE_VAL($2,
[
if test "$target_os" = "macos10.0"; then
  if nm $KERNEL | egrep "\\<_?$1\\>" >/dev/null 2>&1; then
    eval "$2=yes"
  else
    eval "$2=no"
  fi
else
cat > conftest.$ac_ext <<EOF
dnl This sometimes fails to find confdefs.h, for some reason.
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
#include "confdefs.h"
[$4]
int _foo() {
return foo();
}
int foo() {
[$3];
return 0; }
EOF
save_CFLAGS="$CFLAGS"
CFLAGS="$CFLAGS $test_KERNEL_CFLAGS $KERNEL_CPPFLAGS"
if AC_TRY_EVAL(ac_compile) && AC_TRY_EVAL(ac_kernel_ld) && test -s conftest; then
  eval "$2=yes"
else
  eval "$2=no"
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
fi
CFLAGS="$save_CFLAGS"
rm -f conftest*
fi])
changequote(, )dnl
eval "ac_tr_var=HAVE_KERNEL_`echo $1 | tr '[a-z]' '[A-Z]'`"
changequote([, ])dnl

AC_MSG_RESULT(`eval echo \\${$2}`)
if test `eval echo \\${$2}` = yes; then
  AC_DEFINE_UNQUOTED($ac_tr_var, 1)
fi
])

dnl define([foo], [[HAVE_KERNEL_]translit($1, [a-z], [A-Z])])
dnl : << END
dnl @@@syms="$syms foo"@@@
dnl END
dnl undefine([foo])

dnl
dnl $Id: check-kernel-func.m4,v 1.2 1999/08/09 23:02:01 assar Exp $
dnl

dnl AC_CHECK_KERNEL_FUNC(func, param, [includes])
AC_DEFUN(AC_CHECK_KERNEL_FUNC,
AC_CHECK_KERNEL($1, ac_cv_kernel_func_$1, [$1]([$2]), $4)
: << END
@@@funcs="$funcs [patsubst([$1], [\w+], [kernel_\&])]"@@@
END
)

dnl
dnl $Id: bsd-header-vnode-if-h.m4,v 1.2 2000/03/16 10:34:32 assar Exp $
dnl

AC_DEFUN(AC_BSD_HEADER_VNODE_IF_H, [
AC_MSG_CHECKING(if vnode_if.h needs to be built)
changequote(, )dnl
rm -f vnode_if.[ch]
changequote([,])dnl
AC_TRY_CPP_KERNEL([
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/vnode.h>
], ac_cv_header_vnode_if_h=no,
ac_cv_header_vnode_if_h=yes)
dnl
if test "$ac_cv_header_vnode_if_h" = "yes"; then
test -d ../sys || mkdir ../sys 
if test -f $SYS/kern/vnode_if.pl; then
  perl $SYS/kern/vnode_if.pl -h $SYS/kern/vnode_if.src
elif test -f $SYS/kern/vnode_if.sh; then
  /bin/sh $SYS/kern/vnode_if.sh $SYS/kern/vnode_if.src
else
  AC_MSG_ERROR(unable to find any vnode_if script)
fi
if test -f vnode_if.h; then
  :
else
  AC_MSG_ERROR(failed to create vnode_if.h)
fi
AC_TRY_CPP_KERNEL([
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/vnode.h>
], ac_cv_header_vnode_if_h=yes; VNODE_IF_H=vnode_if.h,
AC_MSG_ERROR(tried creating vnode_if.h but still could not include vnode.h))
fi
AC_MSG_RESULT($ac_cv_header_vnode_if_h)
AC_SUBST(VNODE_IF_H)])

dnl
dnl $Id: try-cpp-kernel.m4,v 1.1 2000/03/16 10:20:34 assar Exp $
dnl

AC_DEFUN(AC_TRY_CPP_KERNEL,[
save_CPPFLAGS="$CPPFLAGS"
CPPFLAGS="$CPPFLAGS $KERNEL_CPPFLAGS"
AC_TRY_CPP([$1], [$2], [$3])
CPPFLAGS="$save_CPPFLAGS"
])

dnl
dnl $Id: check-kernel-var.m4,v 1.2 2000/01/25 20:31:24 assar Exp $
dnl

dnl AC_CHECK_KERNEL_VAR(var, type, [includes])
AC_DEFUN(AC_CHECK_KERNEL_VAR,
AC_CHECK_KERNEL($1, ac_cv_kernel_var_$1, [extern $2 $1; return $1], $4)
: << END
@@@funcs="$funcs kernel_$1"@@@
END
)

dnl
dnl $Id: check-kernel-vop-t.m4,v 1.1 1999/05/15 22:45:22 assar Exp $
dnl

dnl
dnl try to find out if we have a vop_t
dnl

AC_DEFUN(AC_CHECK_KERNEL_VOP_T, [

AC_CACHE_CHECK(for vop_t, ac_cv_type_vop_t,
AC_EGREP_HEADER(vop_t, sys/vnode.h, ac_cv_type_vop_t=yes, ac_cv_type_vop_t=no))

if test "$ac_cv_type_vop_t" = "yes"; then
	AC_DEFINE(HAVE_VOP_T, 1, [define if you have a vop_t])
fi
])

dnl
dnl $Id: bsd-vfs-object-create.m4,v 1.1 1999/05/15 22:45:19 assar Exp $
dnl

dnl
dnl check for number of arguments to vfs_object_create
dnl

AC_DEFUN(AC_BSD_FUNC_VFS_OBJECT_CREATE, [
AC_CHECK_KERNEL_FUNCS(vfs_object_create)
if test "$ac_cv_kernel_func_vfs_object_create" = "yes"; then
AC_CACHE_CHECK(if vfs_object_create takes four arguments,
ac_cv_func_vfs_object_create_four_args,
AC_TRY_COMPILE_KERNEL([
#include <sys/types.h>
#include <sys/param.h>
#include <sys/vnode.h>
],
[vfs_object_create(0, 0, 0, 0);],
ac_cv_func_vfs_object_create_four_args=yes,
ac_cv_func_vfs_object_create_four_args=no))
if test "$ac_cv_func_vfs_object_create_four_args" = "yes"; then
	ac_foo=
	AC_DEFINE(HAVE_FOUR_ARGUMENT_VFS_OBJECT_CREATE, 1,
	[if vfs_object_create takes four arguments])
fi
fi
])

dnl
dnl $Id: try-compile-kernel.m4,v 1.2 2000/02/22 23:01:53 assar Exp $
dnl

AC_DEFUN(AC_TRY_COMPILE_KERNEL,[
save_CFLAGS="$CFLAGS"
CFLAGS="$CFLAGS $test_KERNEL_CFLAGS $KERNEL_CPPFLAGS"
AC_TRY_COMPILE([$1], [$2], [$3], [$4])
CFLAGS="$save_CFLAGS"
])

dnl
dnl $Id: bsd-vop-lock.m4,v 1.3 2000/01/30 23:56:45 assar Exp $
dnl

dnl
dnl Find out if VOP_LOCK takes one, two, or three arguments
dnl

AC_DEFUN(AC_BSD_FUNC_VOP_LOCK, [
AC_CACHE_CHECK(if VOP_LOCK takes one argument, ac_cv_func_vop_lock_one_arg,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[VOP_LOCK(0)],
ac_cv_func_vop_lock_one_arg=yes,
ac_cv_func_vop_lock_one_arg=no))
if test "$ac_cv_func_vop_lock_one_arg" = yes; then
	AC_DEFINE_UNQUOTED(HAVE_ONE_ARGUMENT_VOP_LOCK, 1,
	[define if VOP_LOCK takes one argument])
fi

AC_CACHE_CHECK(if VOP_LOCK takes two arguments, ac_cv_func_vop_lock_two_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[VOP_LOCK(0, 0)],
ac_cv_func_vop_lock_two_args=yes,
ac_cv_func_vop_lock_two_args=no))
if test "$ac_cv_func_vop_lock_two_args" = yes; then
	AC_DEFINE(HAVE_TWO_ARGUMENT_VOP_LOCK, 1,
	[define if VOP_LOCK takes two arguments])
fi

AC_CACHE_CHECK(if VOP_LOCK takes three arguments, ac_cv_func_vop_lock_three_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[VOP_LOCK(0, 0, 0)],
ac_cv_func_vop_lock_three_args=yes,
ac_cv_func_vop_lock_three_args=no))
if test "$ac_cv_func_vop_lock_three_args" = yes; then
	AC_DEFINE(HAVE_THREE_ARGUMENT_VOP_LOCK, 1,
	[define if VOP_LOCK takes three arguments])
fi
])

dnl
dnl $Id: bsd-vfs-busy.m4,v 1.3 2000/02/20 03:06:43 assar Exp $
dnl

dnl
dnl try to find out if vfs_busy takes three/four arguments
dnl

AC_DEFUN(AC_BSD_FUNC_VFS_BUSY,[
AC_CACHE_CHECK(if vfs_busy takes three arguments, ac_cv_func_vfs_busy_three_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/ucred.h>
#ifdef HAVE_SYS_MODULE_H
#include <sys/module.h>
#endif
#include <sys/mount.h>],[vfs_busy(0, 0, 0)],
ac_cv_func_vfs_busy_three_args=yes,
ac_cv_func_vfs_busy_three_args=no))
if test "$ac_cv_func_vfs_busy_three_args" = yes; then
	AC_DEFINE(HAVE_THREE_ARGUMENT_VFS_BUSY, 1,
	[define if vfs_busy takes three arguments])
fi

AC_CACHE_CHECK(if vfs_busy takes four arguments, ac_cv_func_vfs_busy_four_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/ucred.h>
#ifdef HAVE_SYS_MODULE_H
#include <sys/module.h>
#endif
#include <sys/mount.h>],[vfs_busy(0, 0, 0, 0)],
ac_cv_func_vfs_busy_four_args=yes,
ac_cv_func_vfs_busy_four_args=no))
if test "$ac_cv_func_vfs_busy_four_args" = yes; then
	AC_DEFINE(HAVE_FOUR_ARGUMENT_VFS_BUSY, 1,
	[define if vfs_busy takes four arguments])
fi
])

dnl
dnl $Id: bsd-vget.m4,v 1.4 2000/06/12 06:13:52 assar Exp $
dnl

AC_DEFUN(AC_BSD_FUNC_VGET, [
AC_CACHE_CHECK(if vget takes one argument, ac_cv_func_vget_one_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#if defined(__osf__) && defined(__GNUC__)
#define asm __foo_asm
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[vget(0)],
ac_cv_func_vget_one_args=yes,
ac_cv_func_vget_one_args=no))
if test "$ac_cv_func_vget_one_args" = yes; then
	AC_DEFINE_UNQUOTED(HAVE_ONE_ARGUMENT_VGET, 1,
	[define if vget takes one argument])
fi

AC_CACHE_CHECK(if vget takes two arguments, ac_cv_func_vget_two_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[vget(0, 0)],
ac_cv_func_vget_two_args=yes,
ac_cv_func_vget_two_args=no))
if test "$ac_cv_func_vget_two_args" = yes; then
	AC_DEFINE_UNQUOTED(HAVE_TWO_ARGUMENT_VGET, 1,
	[define if vget takes two arguments])
fi

AC_CACHE_CHECK(if vget takes three arguments, ac_cv_func_vget_three_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/vnode.h>
],[vget(0, 0, 0)],
ac_cv_func_vget_three_args=yes,
ac_cv_func_vget_three_args=no))
if test "$ac_cv_func_vget_three_args" = yes; then
	AC_DEFINE(HAVE_THREE_ARGUMENT_VGET, 1,
	[define if vget takes three arguments])
fi

if test "$ac_cv_func_vget_one_args" = "no" -a "$ac_cv_func_vget_two_args" = "no" -a "$ac_cv_func_vget_three_args" = "no"; then
  AC_MSG_ERROR([test for number of arguments of vget failed])
fi
])

dnl
dnl $Id: bsd-func-suser.m4,v 1.3 2000/03/24 03:39:43 assar Exp $
dnl

AC_DEFUN(AC_BSD_FUNC_SUSER, [
AC_CACHE_CHECK(if suser takes two arguments,
ac_cv_func_suser_two_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/proc.h>
], [suser(NULL, NULL)],
ac_cv_func_suser_two_args=yes,
ac_cv_func_suser_two_args=no))
if test "$ac_cv_func_suser_two_args" = yes; then
	AC_DEFINE(HAVE_TWO_ARGUMENT_SUSER, 1,
	[define if suser takes two arguments])
fi
])

dnl
dnl $Id: bsd-func-vfs-getnewfsid.m4,v 1.2 2000/05/23 14:30:43 assar Exp $
dnl

AC_DEFUN(AC_BSD_FUNC_VFS_GETNEWFSID, [
AC_CHECK_KERNEL_FUNCS(vfs_getnewfsid)
if test "$ac_cv_kernel_func_vfs_getnewfsid" = "yes"; then
AC_CACHE_CHECK(if vfs_getnewfsid takes two arguments,
ac_cv_func_vfs_getnewfsid_two_args,
AC_TRY_COMPILE_KERNEL([
#include <sys/types.h>
#include <sys/param.h>
#ifdef HAVE_SYS_MODULE_H
#include <sys/module.h>
#endif
#include <sys/mount.h>
#include <sys/vnode.h>
],
[vfs_getnewfsid(NULL, 0);],
ac_cv_func_vfs_getnewfsid_two_args=yes,
ac_cv_func_vfs_getnewfsid_two_args=no))
if test "$ac_cv_func_vfs_getnewfsid_two_args" = yes; then
	AC_DEFINE(HAVE_TWO_ARGUMENT_VFS_GETNEWFSID, 1,
	[define if vfs_getnewfsid takes two arguments])
fi
fi
])

dnl
dnl $Id: bsd-func-lockmgr.m4,v 1.3 2000/03/24 03:36:23 assar Exp $
dnl

AC_DEFUN(AC_BSD_FUNC_LOCKMGR, [
AC_CACHE_CHECK(if lockmgr takes four arguments,
ac_cv_func_lockmgr_four_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/proc.h>
#include <sys/lock.h>
], [lockmgr(NULL, 0, NULL, NULL)],
ac_cv_func_lockmgr_four_args=yes,
ac_cv_func_lockmgr_four_args=no))
if test "$ac_cv_func_lockmgr_four_args" = yes; then
	AC_DEFINE(HAVE_FOUR_ARGUMENT_LOCKMGR, 1,
	[define if lockmgr takes four arguments])
fi
])

dnl
dnl $Id: bsd-func-lockstatus.m4,v 1.6 2000/03/24 03:39:42 assar Exp $
dnl

AC_DEFUN(AC_BSD_FUNC_LOCKSTATUS, [
AC_CHECK_KERNEL_FUNCS(lockstatus)
if test "$ac_cv_kernel_func_lockstatus" = "yes"; then
AC_CACHE_CHECK(if lockstatus takes two arguments,
ac_cv_func_lockstatus_two_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/proc.h>
#include <sys/lock.h>
], [lockstatus(NULL, NULL)],
ac_cv_func_lockstatus_two_args=yes,
ac_cv_func_lockstatus_two_args=no))
if test "$ac_cv_func_lockstatus_two_args" = yes; then
	AC_DEFINE(HAVE_TWO_ARGUMENT_LOCKSTATUS, 1,
	[define if lockstatus takes two arguments])
fi

AC_CACHE_CHECK(if lockstatus takes one argument,
ac_cv_func_lockstatus_one_args,
AC_TRY_COMPILE_KERNEL([
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/lock.h>
], [lockstatus(NULL)],
ac_cv_func_lockstatus_one_args=yes,
ac_cv_func_lockstatus_one_args=no))
if test "$ac_cv_func_lockstatus_one_args" = yes; then
	AC_DEFINE(HAVE_ONE_ARGUMENT_LOCKSTATUS, 1,
	[define if lockstatus takes one argument])
fi

if test "$ac_cv_func_lockstatus_two_args" = "no" -a "$ac_cv_func_lockstatus_one_args" = "no"; then
	AC_MSG_ERROR([unable to figure out how many args lockstatus takes])
fi
fi
])

dnl
dnl $Id: osf-func-ubc-lookup.m4,v 1.2 2000/06/12 06:57:40 assar Exp $
dnl

AC_DEFUN(AC_OSF_FUNC_UBC_LOOKUP, [
AC_CACHE_CHECK(if ubc_lookup takes six arguments,
ac_cv_func_ubc_lookup_six_args,
AC_TRY_COMPILE_KERNEL([
#if defined(__osf__) && defined(__GNUC__)
#define asm __foo_asm
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/lock.h>
#include <vm/vm_ubc.h>
], [ubc_lookup(NULL, 0, 0, 0, NULL, NULL)],
ac_cv_func_ubc_lookup_six_args=yes,
ac_cv_func_ubc_lookup_six_args=no))
if test "$ac_cv_func_ubc_lookup_six_args" = yes; then
	AC_DEFINE(HAVE_SIX_ARGUMENT_UBC_LOOKUP, 1,
	[define if ubc_lookup takes six arguments])
fi
])

dnl
dnl $Id: check-dirsiz.m4,v 1.1 1999/05/15 22:45:21 assar Exp $
dnl

dnl
dnl Check where DIRSIZ lives
dnl

AC_DEFUN(AC_CHECK_DIRSIZ, [

AC_CACHE_CHECK([if DIRSIZ lives in dirent.h], ac_cv_dirsiz_in_dirent,
AC_EGREP_CPP(yes,[#include <dirent.h>
#ifdef DIRSIZE
yes
#endif],
eval "ac_cv_dirsiz_in_dirent=yes",
eval "ac_cv_dirsiz_in_dirent=no"))
if test "$ac_cv_dirsiz_in_dirent" = "yes"; then
  AC_DEFINE(DIRSIZ_IN_DIRENT_H, 1, [define if DIRSIZ is defined in dirent.h])
fi

AC_CACHE_CHECK([if DIRSIZ lives in sys/dir.h], ac_cv_dirsiz_in_sys_dir,
AC_EGREP_CPP(yes,[#include <sys/dir.h>
#ifdef DIRSIZ
yes
#endif],
eval "ac_cv_dirsiz_in_sys_dir=yes",
eval "ac_cv_dirsiz_in_sys_dir=no"))
if test "$ac_cv_dirsiz_in_sys_dir" = "yes"; then
  AC_DEFINE(DIRSIZ_IN_SYS_DIR_H, 1, [define if DIRSIZ is defined in sys/dir.h])
fi

AC_CACHE_CHECK([if _GENERIC_DIRSIZ lives in sys/dirent.h],
ac_cv_generic_dirsiz_in_sys_dirent,
AC_EGREP_CPP(yes,[#include <sys/dirent.h>
#ifdef _GENERIC_DIRSIZ
yes
#endif],
eval "ac_cv_generic_dirsiz_in_sys_dirent=yes",
eval "ac_cv_generic_dirsiz_in_sys_dirent=no"))
if test "$ac_cv_generic_dirsiz_in_sys_dirent" = "yes"; then
  AC_DEFINE(GENERIC_DIRSIZ_IN_SYS_DIRENT_H, 1,
	[define if DIRSIZ is defined in sys/dirent.h])
fi
])

dnl
dnl $Id: have-kernel-struct-field.m4,v 1.3 1999/10/06 03:32:07 assar Exp $
dnl

dnl AC_HAVE_KERNEL_STRUCT_FIELD(includes, struct, type, field)
AC_DEFUN(AC_HAVE_KERNEL_STRUCT_FIELD, [
define(cache_val, translit(ac_cv_struct_$2_$4, [A-Z ], [a-z_]))
AC_CACHE_CHECK([if struct $2 has a field $4], cache_val, [
AC_TRY_COMPILE_KERNEL([$1],
[struct $2 foo; $3 bar = foo.$4; ],
cache_val=yes,
cache_val=no)])
if test "$cache_val" = yes; then
	define(foo, translit(HAVE_STRUCT_$2_$4, [a-z ], [A-Z_]))
	AC_DEFINE(foo, 1, [Define if struct $2 has field $4])
	undefine(foo)
fi
undefine(cache_val)
])

dnl
dnl $Id: kernel-have-def.m4,v 1.1 1999/08/09 17:17:06 assar Exp $
dnl

dnl AC_HAVE_KERNEL_DEF(includes, [struct|typedef])
AC_DEFUN(AC_HAVE_KERNEL_DEF, [
define(cache_val, translit(ac_cv_have_def_$2, [A-Z ], [a-z_]))
AC_CACHE_CHECK([if $2 exists], cache_val, [
AC_TRY_COMPILE_KERNEL([$1],
[$2 foo],
cache_val=yes,
cache_val=no)])
if test "$cache_val" = yes; then
	define(foo, translit(HAVE_DEF_$2, [a-z ], [A-Z_]))
	AC_DEFINE(foo, 1, [Define if you have $2])
	undefine(foo)
fi
undefine([cache_val])
])

dnl
dnl $Id: bsd-uvm-only.m4,v 1.2.2.1 2000/10/08 03:07:42 lha Exp $
dnl

AC_DEFUN(AC_CHECK_BSD_UVM_ONLY,[
AC_CACHE_CHECK(if we can only include uvm headers,
ac_cv_kernel_uvm_only,
AC_TRY_COMPILE_KERNEL([
#include <sys/types.h>
#include <sys/param.h>
#ifdef HAVE_VM_VM_H
#include <vm/vm.h>
#endif
#ifdef HAVE_VM_VM_EXTERN_H
#include <vm/vm_extern.h>
#endif
#ifdef HAVE_VM_VM_ZONE_H
#include <vm/vm_zone.h>
#endif
#ifdef HAVE_VM_VM_OBJECT_H
#include <vm/vm_object.h>
#endif
#ifdef HAVE_UVM_UVM_EXTERN_H
#include <uvm/uvm_extern.h>
#endif
], [int suvmtiuk = 1;
],
ac_cv_kernel_uvm_only=yes,
ac_cv_kernel_uvm_only=no))]
if test "$ac_cv_kernel_uvm_only" = no; then
AC_DEFINE(HAVE_KERNEL_UVM_ONLY, 1,
[define if we only can include uvm headers])
fi
)

dnl
dnl $Id: linux-func-d_alloc_root-two_args.m4,v 1.2 1999/07/22 04:59:34 assar Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_D_ALLOC_ROOT_TWO_ARGS, [
AC_CACHE_CHECK(if d_alloc_root takes two arguments,
ac_cv_func_d_alloc_root_two_args,
AC_TRY_COMPILE_KERNEL([#include <asm/current.h>
#include <linux/fs.h>
#include <linux/dcache.h>],
[
d_alloc_root(NULL, NULL)
],
ac_cv_func_d_alloc_root_two_args=yes,
ac_cv_func_d_alloc_root_two_args=no))

if test "$ac_cv_func_d_alloc_root_two_args" = "yes"; then
  AC_DEFINE(HAVE_D_ALLOC_ROOT_TWO_ARGS, 1,
	[define if d_alloc_root takes two arguments])
fi
])

dnl
dnl $Id: linux-func-devfs-register-eleven-args.m4,v 1.1 1999/11/03 01:09:04 mackan Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_DEVFS_REGISTER_ELEVEN_ARGS, [

AC_CACHE_CHECK(if devfs_register takes the dir argument,
ac_cv_func_devfs_register_eleven_args,
AC_TRY_COMPILE_KERNEL([#include <linux/devfs_fs_kernel.h>
],[devfs_handle_t de;
devfs_register(de, NULL, 0, 0, 0, 0, 0, 0, 0, NULL, NULL);
],
ac_cv_func_devfs_register_eleven_args=yes,
ac_cv_func_devfs_register_eleven_args=no))
if test "$ac_cv_func_devfs_register_eleven_args" = "yes"; then
  AC_DEFINE(HAVE_DEVFS_REGISTER_ELEVEN_ARGS, 1,
	[define if devfs_register takes eleven arguments])
fi
])

dnl
dnl $Id: have-linux-kernel-types.m4,v 1.1 1999/05/15 22:45:27 assar Exp $
dnl
dnl Check for types in the Linux kernel
dnl

AC_DEFUN(AC_HAVE_LINUX_KERNEL_TYPES, [
for i in $1; do
        AC_HAVE_LINUX_KERNEL_TYPE($i)
done
: << END
@@@funcs="$funcs patsubst([$1], [\w+], [linux_kernel_\&])"@@@
END
])

dnl
dnl $Id: have-linux-kernel-type.m4,v 1.2 1999/12/05 10:33:09 assar Exp $
dnl
dnl Check for types in the Linux kernel
dnl

dnl AC_HAVE_LINUX_KERNEL_TYPE(type)
AC_DEFUN(AC_HAVE_LINUX_KERNEL_TYPE, [
cv=`echo "$1" | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
AC_MSG_CHECKING(for $i in the linux kernel)
AC_CACHE_VAL(ac_cv_linux_kernel_type_$cv,
AC_TRY_COMPILE_KERNEL([
#define __KERNEL__
#include <linux/types.h>
],
[$1 x;],
eval "ac_cv_linux_kernel_type_$cv=yes",
eval "ac_cv_linux_kernel_type_$cv=no"))dnl
AC_MSG_RESULT(`eval echo \\$ac_cv_linux_kernel_type_$cv`)
if test `eval echo \\$ac_cv_linux_kernel_type_$cv` = yes; then
  ac_tr_hdr=HAVE_LINUX_KERNEL_`echo $1 | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  AC_DEFINE_UNQUOTED($ac_tr_hdr, 1)
fi
])

dnl
dnl $Id: linux-type-wait-queue-head.m4,v 1.2 1999/05/16 16:38:36 assar Exp $
dnl

AC_DEFUN(AC_LINUX_TYPE_WAIT_QUEUE_HEAD_T, [
AC_CACHE_CHECK([for wait_queue_head_t],
ac_cv_type_wait_queue_head_t,[
AC_TRY_COMPILE_KERNEL([#include <linux/wait.h>],
[wait_queue_head_t foo;],
ac_cv_type_wait_queue_head_t=yes,
ac_cv_type_wait_queue_head_t=no)])
if test "$ac_cv_type_wait_queue_head_t" = "yes"; then
  AC_DEFINE(HAVE_WAIT_QUEUE_HEAD_T, 1,
	[define if you have a wait_queue_head_t])
fi
])

dnl
dnl $Id: linux-type-wait-queue-task-list.m4,v 1.1.2.1 2000/10/08 03:20:37 lha Exp $
dnl

AC_DEFUN(AC_LINUX_TYPE_WAIT_QUEUE_TASK_LIST, [
AC_CACHE_CHECK([for wait_queue_task_list],
ac_cv_type_wait_queue_task_list,[
AC_TRY_COMPILE_KERNEL([#include <linux/stddef.h>
#include <linux/wait.h>],
[wait_queue_head_t foo;
void *p;
p = &foo.task_list;],
ac_cv_type_wait_queue_task_list=yes,
ac_cv_type_wait_queue_task_list=no)])
if test "$ac_cv_type_wait_queue_task_list" = "yes"; then
  AC_DEFINE(HAVE_WAIT_QUEUE_TASK_LIST, 1,
	[define if you have a wait_queue_task_list])
fi
])

dnl
dnl $Id: linux-func-init-wait-queue-head.m4,v 1.1 1999/05/16 23:21:54 assar Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_INIT_WAITQUEUE_HEAD, [
AC_CACHE_CHECK([for init_waitqueue_head],
ac_cv_func_init_waitqueue_head,[
AC_TRY_COMPILE_KERNEL([#include <linux/wait.h>],
[wait_queue_head_t foo;
init_waitqueue_head(&foo)],
ac_cv_func_init_waitqueue_head=yes,
ac_cv_func_init_waitqueue_head=no)])
if test "$ac_cv_func_init_waitqueue_head" = "yes"; then
  AC_DEFINE(HAVE_INIT_WAITQUEUE_HEAD, 1,
	[define if you have a init_waitqueue_head])
fi
])

dnl
dnl $Id: linux-func-init-mutex.m4,v 1.6 2000/02/22 23:01:53 assar Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_INIT_MUTEX, [
AC_CACHE_CHECK([for init_MUTEX],
ac_cv_func_init_mutex, [
save_CPPFLAGS="$CPPFLAGS"
CPPFLAGS="$CPPFLAGS $test_KERNEL_CFLAGS $KERNEL_CPPFLAGS"
AC_EGREP_CPP([init_MUTEX],
[#include <asm/semaphore.h>],
ac_cv_func_init_mutex=yes,
ac_cv_func_init_mutex=no)]
CPPFLAGS="$save_CPPFLAGS"
)
if test "$ac_cv_func_init_mutex" = "yes"; then
  AC_DEFINE(HAVE_INIT_MUTEX, 1,
	[define if you have a function init_MUTEX])
fi
])

dnl
dnl $Id: linux-filldir-dt-type.m4,v 1.1.2.2 2000/09/13 07:02:58 lha Exp $
dnl

AC_DEFUN(AC_LINUX_FILLDIR_DT_TYPE, [
AC_CACHE_CHECK([for whether filldir_t includes a dt_type],
ac_cv_type_filldir_dt_type,
AC_TRY_COMPILE_KERNEL([#include <asm/current.h>
#include <linux/fs.h>],
[
int foo(void *a, const char *b, int c, off_t d, ino_t e, unsigned type);

filldir_t bar = foo;
],
ac_cv_type_filldir_dt_type=yes,
ac_cv_type_filldir_dt_type=no))

if test "$ac_cv_type_filldir_dt_type" = "yes"; then
  AC_DEFINE(HAVE_FILLDIR_T_DT_TYPE, 1, [define if filldir_t takes a dt_type argument])
fi
])

dnl
dnl $Id: linux-func-dget-locked.m4,v 1.1.2.1 2000/09/14 11:28:16 lha Exp $
dnl

AC_DEFUN(AC_LINUX_FUNC_DGET_LOCKED, [
AC_CACHE_CHECK([for dget_locked],
ac_cv_func_dget_locked, [
save_CPPFLAGS="$CPPFLAGS"
CPPFLAGS="$CPPFLAGS $test_KERNEL_CFLAGS $KERNEL_CPPFLAGS"
AC_EGREP_CPP([dget_locked],
[#include <linux/dcache.h>],
ac_cv_func_dget_locked=yes,
ac_cv_func_dget_locked=no)]
CPPFLAGS="$save_CPPFLAGS"
)
if test "$ac_cv_func_dget_locked" = "yes"; then
  AC_DEFINE(HAVE_DGET_LOCKED, 1,
	[define if you have a function dget_locked])
fi
])

dnl $Id: krb-version.m4,v 1.3 2000/06/03 20:31:44 lha Exp $
dnl
dnl
dnl output a C header-file with some version strings
dnl
AC_DEFUN(AC_KRB_VERSION,[
dnl AC_OUTPUT_COMMANDS([
cat > include/${PACKAGE}-newversion.h.in <<FOOBAR
char *${PACKAGE}_long_version = "@(#)\$Version: $PACKAGE-$VERSION by @USER@ on @HOST@ ($host) @DATE@ \$";
char *${PACKAGE}_version = "$PACKAGE-$VERSION";
FOOBAR

if test -f include/${PACKAGE}-version.h && cmp -s include/${PACKAGE}-newversion.h.in include/${PACKAGE}-version.h.in; then
	echo "include/${PACKAGE}-version.h is unchanged"
	rm -f include/${PACKAGE}-newversion.h.in
else
 	echo "creating include/${PACKAGE}-version.h"
 	User=${USER-${LOGNAME}}
 	Host=`(hostname || uname -n) 2>/dev/null | sed 1q`
 	Date=`date`
	mv -f include/${PACKAGE}-newversion.h.in include/${PACKAGE}-version.h.in
	sed -e "s/@USER@/$User/" -e "s/@HOST@/$Host/" -e "s/@DATE@/$Date/" include/${PACKAGE}-version.h.in > include/${PACKAGE}-version.h
fi
dnl ],host=$host PACKAGE=$PACKAGE VERSION=$VERSION)
])

