; $Id: make-release.el,v 1.2 2000/06/06 17:52:30 lha Exp $

(defun bump-version (filename v-string)
  (save-excursion
    (find-file filename)
    (while (re-search-forward "arla-[0-9\\.]*[0-9]" nil t)
      (replace-match v-string nil nil))
    (save-buffer)))

(let* ((version (getenv "HV"))
       (arla-version (concat "arla-" version))
       (version-string (concat "Release " version)))
  (find-file "configure.in")
  (re-search-forward "VERSION=\\(.*\\)$")
  (replace-match version nil nil nil 1)
  (save-buffer)
  (find-file "ChangeLog")
  (add-change-log-entry nil nil nil nil)
  (insert version-string)
  (save-buffer)
  (mapcar (function (lambda (v) (bump-version v arla-version)))
	  '("README" "LIESMICH" "doc/arla.texi")) 
  (kill-emacs))
