/*
 * Copyright (c) 1995, 1996, 1997, 1998, 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <xfs/xfs_locl.h>
#include <xfs/xfs_message.h>
#include <xfs/xfs_fs.h>
#include <xfs/xfs_dev.h>
#include <xfs/xfs_syscalls.h>

RCSID("$Id: xfs_wrap-osf.c,v 1.6 1999/06/22 09:04:28 joda Exp $");

#include <xfs/xfs_deb.h>

extern int xfs_syscall_num;
extern int xfs_dev_major;

cfg_subsys_attr_t xfs_attributes[] = {
    { 
	"syscall",
	CFG_ATTR_INTTYPE,
	CFG_OP_QUERY, 
	(caddr_t)&xfs_syscall_num,
	0,
	0,
	0 
    },
    {
	"major",
	CFG_ATTR_INTTYPE,
	CFG_OP_QUERY, 
	(caddr_t)&xfs_dev_major,
	0,
	0,
	0 
    },
    { 
	"debug",
	CFG_ATTR_UINTTYPE,
	CFG_OP_QUERY|CFG_OP_RECONFIGURE,
	(caddr_t)&xfsdeb,
	0,
	0xffffffff,
	0 
    },
    { "" }
};

/*
 * Iff `dev' represents a valid xfs device.
 */

int
xfs_is_xfs_dev (dev_t dev)
{
    return major (dev) == xfs_dev_major
	&& minor(dev) >= 0 && minor(dev) < NXFS;
}

int
xfs_configure(cfg_op_t op,
	      cfg_attr_t *indata,
	      size_t indatalen,
	      cfg_attr_t *outdata,
	      size_t outdatalen)
{
    int ret = 0;
    
    switch(op) {
    case CFG_OP_CONFIGURE:
	xfs_install_syscall();
	ret = xfs_install_device();
	if(ret) {
	    xfs_uninstall_syscall();
	    break;
	}
	ret = xfs_install_fs();
	if(ret) {
	    xfs_uninstall_fs();
	    xfs_uninstall_syscall();
	    break;
	}
	break;
    case CFG_OP_UNCONFIGURE:
	ret = xfs_uninstall_fs();
	if(ret != 0)
	    break;
	ret = xfs_uninstall_device();
	if(ret != 0)
	    break;
	/* this won't fail */
	xfs_uninstall_syscall();
	break;
    case CFG_OP_QUERY:
    case CFG_OP_RECONFIGURE:
	break;
    default:
	return ENOTSUP;
    }
    return ret;
}
