/*
 * Copyright (c) 1995 - 2000 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: xfs_locl.h,v 1.44 2000/06/23 07:52:43 lha Exp $ */
/* $Source: /afs/stacken.kth.se/src/SourceRepository/arla/xfs/linux/xfs/xfs_locl.h,v $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <asm/current.h>
#include <linux/config.h>
#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/version.h>
#include <linux/module.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/time.h>
#include <linux/sched.h>
#include <linux/stat.h>
#include <linux/string.h>
#include <linux/locks.h>
#include <linux/smp_lock.h>
#ifdef HAVE_LINUX_DEVFS_FS_KERNEL_H
# include <linux/devfs_fs_kernel.h>
#else
# ifdef HAVE_LINUX_DEVFS_FS_H
#  include <linux/devfs_fs.h>
# endif
#endif
#ifdef CONFIG_DEVFS_FS
# define DEVFS_SUPPORT
#endif

#if LINUX_VERSION_CODE >= 0x20300
#define LINUX2_3 1 
#endif

/*
 * Linux 2.3.39 and above has a new setgroups() system call for
 * 32-bit UIDs, on arm, i386, m68k, sh, and sparc32. The old system call
 * also has to be handled properly, with a different type for gid_t.
 * See xfs_syscalls.c for more information.
 */

#include <asm/unistd.h>

#ifdef __NR_setgroups32
#define ARLA_NR_setgroups	__NR_setgroups32

/*
 * For the time being Linux 2.3/2.4 will call the old 16-bit uid
 * setgroups() __NR_setgroups; at some point in the future it may go away,
 * so we put this ifdef here
 */
#ifdef __NR_setgroups
#define ARLA_NR_setgroups16	__NR_setgroups
#endif

#else
#define ARLA_NR_setgroups	__NR_setgroups
#endif

#include <asm/uaccess.h>

/* 
 * The people at FSF seems to think that user program
 * should include /usr/include/{,sys} and the kernel
 * should have their own include files.
 *
 * That seems ok to me, but then we don't get the int23_t & friends
 * from userland. And in kernelspace it seems that we should use 
 * __{s,u}32, and that seems silly, so we typedef them ourself.
 * It's the same thing with MAXPATHLEN that is named PATH_MAX in 
 * the kernel.
 *
 * Thank you to N.N for pointing this out.
 */

#ifdef HAVE_GLIBC

#ifndef HAVE_LINUX_KERNEL_INT8_T
typedef __s8     int8_t;
#endif
#ifndef HAVE_LINUX_KERNEL_U_INT8_T
typedef __u8   u_int8_t;
#endif
#ifndef HAVE_LINUX_KERNEL_INT16_T
typedef __s16    int16_t;
#endif
#ifndef HAVE_LINUX_KERNEL_U_INT16_T
typedef __u16  u_int16_t;
#endif
#ifndef HAVE_LINUX_KERNEL_INT32_T
typedef __s32    int32_t;
#endif
#ifndef HAVE_LINUX_KERNEL_U_INT32_T
typedef __u32  u_int32_t;
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN PATH_MAX 
#endif

#endif

#include <xfs/xfs_message.h>
#include <xfs/xfs_fs.h>
#include <xfs/xfs_node.h>
#include <xfs/xfs_deb.h>

int
xfs_replace_root(struct super_block *sb);

extern struct dentry_operations xfs_dentry_operations;

struct dentry * xfs_fh_to_dentry(struct xfs_cache_handle *handle);

/*
 * i_blocks should apparently always be returned in 512-bytes units
 */

#define I_BLOCKS_UNIT 512

#define I_BLOCKS_BITS 9

static __inline__ int
xfs_iread (struct inode *inode)
{
#ifndef LINUX2_3
    return inode->i_count;
#else
    return atomic_read(&inode->i_count);
#endif
}

static __inline__ void
xfs_iref (struct inode *inode)
{
#ifndef LINUX2_3
    ++inode->i_count;
#else
    atomic_inc(&inode->i_count);
#endif
}

#ifndef LINUX2_3

#define DECLARE_FSTYPE(var,type,read,flags)	\
struct file_system_type var = {			\
	name:		type,			\
        read_super:	read,			\
	fs_flags:	flags,			\
}


#define XFS_RESET_I_MAPPING(node) while (0) { }

#else /* LINUX2_3 */

#define XFS_RESET_I_MAPPING(node) (node)->i_mapping = &((node)->i_data)

extern struct address_space_operations xfs_aops;

#endif /* LINUX2_3 */
