/*
 * Copyright (c) 1995 - 2000 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <xfs/xfs_locl.h>

RCSID("$Id: xfs_load.c,v 1.23 2000/03/25 00:16:23 mackan Exp $");

#define XFS_MAJOR 103
#include <xfs/xfs_message.h>
#include <xfs/xfs_dev.h>
#include <xfs/xfs_syscalls.h>

extern struct super_block * xfs_read_super (struct super_block * sb,
					    void * data,
					    int silent);

extern struct file_operations xfs_fops;

static DECLARE_FSTYPE(xfs_fs_type, "xfs", xfs_read_super, 0);

#ifdef DEVFS_SUPPORT
static devfs_handle_t xfs_devfs_handle;
#endif

int init_xfs_fs(void)
{
    int ret;
    XFSDEB(XDEBVFOPS, ("init_xfs_fs\n"));
    XFSDEB(XDEBVFOPS, ("xfs_fs_type: %p\n",&xfs_fs_type));
    ret = register_filesystem(&xfs_fs_type);
    XFSDEB(XDEBVFOPS, ("init_xfs_fs exit\n"));
    return ret;
}

int init_module(void)
{
    int status;
    
    XFSDEB(XDEBVFOPS, ("init_module\n"));
    install_afs_syscall();
    if ((status = init_xfs_fs()) != 0) {
	XFSDEB(XDEBVFOPS, ("init_module: init_xfs_fs failed\n"));
	return status;
    }
#ifdef DEVFS_SUPPORT
    xfs_devfs_handle = devfs_register(
#ifdef HAVE_DEVFS_REGISTER_ELEVEN_ARGS
	    NULL,
#endif
	    "xfs0", 0, DEVFS_FL_NONE, XFS_MAJOR, 0,
	    S_IRUSR | S_IWUSR | S_IFCHR, 0, 0, &xfs_fops, NULL);
    if (xfs_devfs_handle == NULL) {
#else
    if (register_chrdev(XFS_MAJOR,"xfs",&xfs_fops)) {
#endif
	XFSDEB(XDEBVFOPS, ("xfs: unable to get major %d\n", XFS_MAJOR));
	unregister_filesystem(&xfs_fs_type);
	return -EIO;
    }
    xfs_init_device();
    XFSDEB(XDEBVFOPS, ("init_module exit\n"));
    return status;
}

void cleanup_module(void)
{
    unregister_filesystem(&xfs_fs_type);
#ifdef DEVFS_SUPPORT
    devfs_unregister(xfs_devfs_handle);
#else
    unregister_chrdev(XFS_MAJOR,"xfs");
#endif
    restore_afs_syscall();
}

