/*
 * Copyright (c) 1995 - 2000 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: xfs_dev.h,v 1.1 2000/05/08 05:21:59 lha Exp $ */

#ifndef _xfs_dev_h
#define _xfs_dev_h

int
xfs_message_send(struct xfs_channel *chan,
		 struct xfs_message_header * message,
		 u_int size);

int
xfs_message_rpc(struct xfs_channel *chan,
		struct xfs_message_header * message,
		u_int size);

int
xfs_message_receive(struct xfs_channel *chan,
		    struct xfs_message_header *message,
		    u_int size);

int
xfs_message_wakeup(struct xfs_channel *chan,
		   struct xfs_message_wakeup *message,
		   u_int size);

int
xfs_message_wakeup_data(struct xfs_channel *chan,
			struct xfs_message_wakeup_data * message,
			u_int size);

int
xfs_message_installroot(struct xfs_channel *chan,
			struct xfs_message_installroot * message,
			u_int size);

int
xfs_message_installnode(struct xfs_channel *chan,
			struct xfs_message_installnode * message,
			u_int size);

int
xfs_message_installattr(struct xfs_channel *chan,
			struct xfs_message_installattr * message,
			u_int size);

int
xfs_message_installdata(struct xfs_channel *chan,
			struct xfs_message_installdata * message,
			u_int size);

int
xfs_message_invalidnode(struct xfs_channel *chan,
			struct xfs_message_invalidnode * message,
			u_int size);

int
xfs_message_updatefid(struct xfs_channel *chan,
		      struct xfs_message_updatefid * message,
		      u_int size);

int
xfs_message_gc_nodes(struct xfs_channel *chan,
		     struct xfs_message_gc_nodes * message,
		     u_int size);

int
xfs_message_version(struct xfs_channel *chan,
		    struct xfs_message_version *message,
		    u_int size);


#endif /* _xfs_dev_h */
