/*
 * Copyright (c) 2000 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* xfs_node.c */

#ifndef _XFS_NODE_H
#define _XFS_NODE_H 1

struct xfs_node *
xfs_node_find (struct xfs_channel *chan, struct xfs_handle *handle);

int
xfs_new_node (struct xfs_channel *chan,
	      struct xfs_msg_node *node,
	      struct xfs_node **npp);

void
xfs_free_node (struct xfs_node *node);

void
xfs_vref (struct xfs_node *node);

void
xfs_vrele (struct xfs_node *node);

int
xfs_fhlookup (struct xfs_fhandle_t *fh, HANDLE *cache_node);

int
xfs_fhget (const char *path, struct xfs_fhandle_t *fh);

void
xfs_attr2vattr(const struct xfs_attr *xa, struct xfs_node *node);

void
vattr2xfs_attr(struct xfs_node *node, struct xfs_attr *xa);

void
xfs_close_data_handle (struct xfs_node *t);

int
xfs_open_file (const char *fname, HANDLE RelatedFile, 
	       int Disposition, int CreateOptions, 
	       HANDLE *ret_handle, FILE_OBJECT **ret_object);

int
xfs_get_root (struct xfs_channel *chan);

#endif
