/*
 * Copyright (c) 1995, 1996, 1997, 1998, 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <xfs/xfs_locl.h>

RCSID("$Id: xfs_syscalls-wrap-osf.c,v 1.4 2000/10/02 23:32:46 lha Exp $");

/*
 * XFS system calls.
 */

#include <xfs/xfs_syscalls.h>
#include <xfs/xfs_message.h>
#include <xfs/xfs_fs.h>
#include <xfs/xfs_dev.h>
#include <xfs/xfs_node.h>
#include <xfs/xfs_deb.h>

#include <kafs.h>

int nosys(struct proc *, ...);

static int
try_install_syscall(int callno,
		    int (*call)(struct proc *, ...), 
		    int narg, 
		    int parallel)
{
    if(sysent[callno].sy_call == nosys) {
	sysent[callno].sy_call = call;
	sysent[callno].sy_narg = narg;
	sysent[callno].sy_parallel = parallel;
	return callno;
    }
    return -1;
}

static void
del_syscall(int syscall)
{
    sysent[syscall].sy_call = nosys;
    sysent[syscall].sy_narg = 1;
    sysent[syscall].sy_parallel = 1;
}

int xfs_syscall_num;

static struct sysent old_setgroups;

int (*old_setgroups_func)(struct proc *, void *);

/* XXX */

#define AFS_SYSCALL	232
#define AFS_SYSCALL2	258

void
xfs_install_syscall(void)
{
    int i;

    old_setgroups = sysent[SYS_setgroups];
    old_setgroups_func = old_setgroups.sy_call;
    sysent[SYS_setgroups].sy_call = xfs_setgroups;

    /* first try fixed values */
    xfs_syscall_num = try_install_syscall(AFS_SYSCALL, xfspioctl, 5, 0);
    if(xfs_syscall_num != -1)
	return;
    xfs_syscall_num = try_install_syscall(AFS_SYSCALL2, xfspioctl, 5, 0);
    if(xfs_syscall_num != -1)
	return;
    /* if that fails, fall back to any free syscall */
    for(i = 1; i < nsysent; i++) {
	xfs_syscall_num = try_install_syscall(i, xfspioctl, 5, 0);
	if(xfs_syscall_num != -1)
	    return;
    }
}

void
xfs_uninstall_syscall(void)
{
    del_syscall(xfs_syscall_num);
    sysent[SYS_setgroups] = old_setgroups;
}
