/******************************************************************************
**
** parse_cl.c
**
** Thu May 17 12:48:59 2001
** Linux 2.4.4 (#1 SMP Sam Apr 28 13:21:30 CEST 2001) i686
** martin@linux. (Martin Bickel)
**
** C file for command line parser
**
** Automatically created by genparse v0.5.2
**
** See http://genparse.sourceforge.net/ for details and updates
**
******************************************************************************/

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include "parse_cl.h"

/*----------------------------------------------------------------------------
**
** usage()
**
** Print out usage information, then exit
**
**--------------------------------------------------------------------------*/

void usage(char *executable)
{
  printf("usage: %s [ -vh ] DATAFILE ARCHIVEFILE \n", executable);
  printf("  [ -v ] ");
  printf("[ --verbose  ] ");
  printf("(");
  printf("type=");
  printf("INTEGER,");
  printf(" range=0...1,");
  printf(" default=1");
  printf(")\n");
  printf("         Set verbosity level to x\n");
  printf("  [ -h ] ");
  printf("[ --help  ] ");
  printf("(");
  printf("type=");
  printf("FLAG");
  printf(")\n");
  printf("         Display help information.\n");

  exit(1);
}

/*----------------------------------------------------------------------------
**
** free_args()
**
** Call this to free the memory that was dynamically allocated by the parser.
**
**--------------------------------------------------------------------------*/

void free_args(struct arg_t *my_args)
{
  free(my_args);
}

/*----------------------------------------------------------------------------
**
** Cmdline()
**
** Parse the argv array into the command line structure
**
**--------------------------------------------------------------------------*/

struct arg_t *Cmdline(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  int c;
  struct arg_t *my_args;
  int errflg = 0;

  static struct option long_options[] =
  {
    {"verbose", 1, 0, 'v'},
    {"help", 0, 0, 'h'},
    {0, 0, 0, 0}
  };

  my_args = (struct arg_t *) malloc (sizeof(struct arg_t));

  my_args->v = 1;
  my_args->h = false;

  while ((c = getopt_long(argc, argv, "v:h", long_options, &option_index)) != EOF)
    {
      switch(c)
        {
        case 'v': 
          my_args->v = atoi(optarg);
          if (my_args->v < 0)
            {
              fprintf(stderr, "parameter range error: v must be >= 0\n");
              errflg++;
            }
          if (my_args->v > 1)
            {
              fprintf(stderr, "parameter range error: v must be <= 1\n");
              errflg++;
            }
          break;

        case 'h': 
          my_args->h = true;
          usage(argv[0]);
          break;

        default:
          usage(argv[0]);

        }
    } /* while */

  if (errflg)
    usage(argv[0]);

  if (optind >= argc)
    my_args->optind = 0;
  else
    my_args->optind = optind;
  return my_args;
}
