/*
    This file is part of Advanced Strategic Command; http://www.asc-hq.de
    Copyright (C) 1994-2001  Martin Bickel, Marc Schellenberger and
    Steffen Froehlich
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING. If not, write to the 
    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA  02111-1307  USA
*/
// Version v2.0 , change also GENERAL


#include <stdio.h>

#include "../tpascal.inc"
#include "../typen.h"
#include "../basestrm.h"
#include "../misc.h"
#include "../sgstream.h"
#include "../buildingtype.h"
#include "../vehicletype.h"
#include "../errors.h"
#include "../graphicset.h"
#include "../ascstring.h"
#include "../itemrepository.h"
#include "../strtmesg.h"


// including the command line parser, which is generated by genparse
#include "../clparser/weaponguide.cpp"

int main(int argc, char *argv[] )
{
   Cmdline cl ( argc, argv );

   if ( cl.v() ) {
      cout << argv[0] << " " << getVersionString() << endl;
      exit(0);
   }

   verbosity = cl.r();

   initFileIO( cl.c(), 4 );  // passing the filename from the command line options

   try {

      loadpalette();
      loadbi3graphics();

      loadalltextfiles();
      loadallobjecttypes();
      loadallbuildingtypes();
      loadallvehicletypes();
      freetextdata();


      char* wildcard;



      if ( cl.next_param() < argc ) {
         wildcard = argv[cl.next_param()];
         // if a command line parameter is specified, use it as wildcard
         // for example: weaponguide s*.veh
      }
      else {
         wildcard =  "*";
         // else use all verhicles
      }



      FILE* overview = fopen ( "overview.html", "w" );
      FILE* overview1 = fopen ( "overview1.html", "w" );
      // opens a file for writing and assigns the file pointer overview to it

      // Beginn des HTML Files HEAD und BODY
      //  \n is the sequence to start a new line

      fprintf ( overview , "<html>\n"
                "<HEAD>\n"
                "<TITLE>UNITGUIDE OVERVIEW LEFT</TITLE>\n"
                "<base target=\"base\">\n"
                "<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../ug.css\">\n"
                "</HEAD>\n"
                "\n"
                "<BODY bgcolor=\"#447744\" text=\"#eabc1a\" link=\"#EABC1A\" vlink=\"#EABC1A\" alink=\"#EABC1A\" background=\"../ug-hin.gif\" leftmargin=\"5\" topmargin=\"2\">\n"                "<table width=\"100%\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">\n"
                "<tr><td><a href=\"overview1.html\">SEE PICTURES</a></td></tr><tr><td></td></tr>\n" );

      fprintf ( overview1 , "<html>\n"
                "<HEAD>\n"
                "<TITLE>WEAPONGUIDE OVERVIEW PICTURES</TITLE>\n"
                "<base target=\"base\">\n"
                "<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../ug.css\">\n"
                "</HEAD>\n"
                "\n"
                "<BODY bgcolor=\"#447744\" text=\"#eabc1a\" link=\"#EABC1A\" vlink=\"#EABC1A\" alink=\"#EABC1A\" background=\"../ug-hin.gif\" leftmargin=\"5\" topmargin=\"0\">\n" );

      for ( int unit = 0; unit < vehicletypenum; unit++ ) {
         pvehicletype  ft = getvehicletype_forpos ( unit );
         ASCString fn = extractFileName_withoutSuffix( ft->filename );
         if ( patimat ( wildcard, ft->filename.c_str() )) {
            ASCString cn = fn;
            cn.toLower();
            // now we are cycling through all files that match wildcard

            printf(" processing unit %s , ID %d ... ", ft->description.c_str(), ft->id );


            string s, s1, s2, s3, s4, s5, s6, b1, b2;
            s = s1 = s2 = s3 = s4 = s5 = s6 = b1 = b2 = cn;

            // this is a C++ string which is much more powerful than the standard C strings ( char* )

            s += ".html";    // frame
            s1 += "1.html";  // general
            s2 += "2.html";  // movement
            s3 += "3.html";  // weapon
            s4 += "4.html";  // functions
            s5 += "5.html";  // loading
            s6 += "6.html";  // description
            b1 += ".gif";    // little pic
            b2 += ".jpg";    // big pic

            FILE* detailed = fopen ( s.c_str(), "w" );
            FILE* detailed1 = fopen ( s1.c_str(), "w" );
            FILE* detailed2 = fopen ( s2.c_str(), "w" );
            FILE* detailed3 = fopen ( s3.c_str(), "w" );
            FILE* detailed4 = fopen ( s4.c_str(), "w" );
            FILE* detailed5 = fopen ( s5.c_str(), "w" );
            FILE* detailed6 = fopen ( s6.c_str(), "w" );
            // c_str() converts a c++ string back to a c string which fopen requires


            // Beginn Einzelfiles
            // UNIT FRAME
            fprintf ( detailed, "<html>\n"
                      "<HEAD>\n"
                      "<TITLE>UNITGUIDE FRAME</TITLE>\n"
                      "<frameset  rows=\"220,*\" border=0 >\n"
                      "<frame name=\"over\" src=\"%s\" marginheight=\"0\">\n"
                      "<frame name=\"under\" src=\"%s\" marginheight=\"2\">\n"
                      "<noframes><body><p>Diese Seite verwendet Frames. Frames werden von Ihrem Browser aber nicht untersttzt.</p></body></noframes>\n"
                      "</frameset>\n"
                      "</html>\n", s1.c_str() , s6.c_str() );

            // UNIT GENERAL
            fprintf ( detailed1, "<html>\n"
                      "<HEAD>\n"
                      "<TITLE>UNITGUIDE GENERAL</TITLE>\n"
                      "<base target=\"under\"> \n"
                      "<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../ug.css\">\n"
                      "</HEAD>\n"
                      "\n"
                      "<BODY bgcolor=\"#447744\" text=\"#eabc1a\" link=\"#EABC1A\" vlink=\"#EABC1A\" alink=\"#EABC1A\" background=\"../ug-hin.gif\">\n" );

            // UNIT TERRAIN
            fprintf ( detailed2, "<html>\n"
                      "<HEAD>\n"
                      "<TITLE>UNITGUIDE MOVEMENT</TITLE>\n"
                      "<base target=\"under\"> \n"
                      "<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../ug.css\">\n"
                      "</HEAD>\n"
                      "\n"
                      "<BODY bgcolor=\"#447744\" text=\"#eabc1a\" link=\"#EABC1A\" vlink=\"#EABC1A\" alink=\"#EABC1A\" background=\"../ug-hin.gif\">\n" );

            // UNIT WEAPONS
            fprintf ( detailed3, "<html>\n"
                      "<HEAD>\n"
                      "<TITLE>UNITGUIDE TERRAIN</TITLE>\n"
                      "<base target=\"under\"> \n"
                      "<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../ug.css\">\n"
                      "</HEAD>\n"
                      "\n"
                      "<BODY bgcolor=\"#447744\" text=\"#eabc1a\" link=\"#EABC1A\" vlink=\"#EABC1A\" alink=\"#EABC1A\" background=\"../ug-hin.gif\">\n" );

            // UNIT FUNCTIONS
            fprintf ( detailed4, "<html>\n"
                      "<HEAD>\n"
                      "<TITLE>UNITGUIDE FUNCTIONS</TITLE>\n"
                      "<base target=\"under\"> \n"
                      "<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../ug.css\">\n"
                      "</HEAD>\n"
                      "\n"
                      "<BODY bgcolor=\"#447744\" text=\"#eabc1a\" link=\"#EABC1A\" vlink=\"#EABC1A\" alink=\"#EABC1A\" background=\"../ug-hin.gif\">\n" );

            // UNIT LOADING
            fprintf ( detailed5, "<html>\n"
                      "<HEAD>\n"
                      "<TITLE>UNITGUIDE LOADING</TITLE>\n"
                      "<base target=\"under\"> \n"
                      "<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../ug.css\">\n"
                      "</HEAD>\n"
                      "\n"
                      "<BODY bgcolor=\"#447744\" text=\"#eabc1a\" link=\"#EABC1A\" vlink=\"#EABC1A\" alink=\"#EABC1A\" background=\"../ug-hin.gif\">\n" );

            // UNIT DESCRIPTION
            fprintf ( detailed6, "<html>\n"
                      "<HEAD>\n"
                      "<TITLE>UNITGUIDE DESCRIPTION</TITLE>\n"
                      "<base target=\"under\"> \n"
                      "<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../ug.css\">\n"
                      "</HEAD>\n"
                      "\n"
                      "<BODY bgcolor=\"#447744\" text=\"#eabc1a\" link=\"#EABC1A\" vlink=\"#EABC1A\" alink=\"#EABC1A\" background=\"../ug-hin.gif\">\n" );

            // OVERVIEW LEFT
            fprintf ( overview, " <tr><td><A HREF=\"%s\">", s.c_str() );
            fprintf ( overview, "%s", ft->getName().c_str() );
            fprintf ( overview, " </A></td></tr>\n" );

            // OVERVIEW RIGHT
            fprintf ( overview1, "<table align=\"center\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">\n"
                      " <tr><td rowspan=\"2\" width=\"50\">" );
            if ( exist ( b1.c_str() ))
               fprintf ( overview1, "<img src=\"%s\" border=\"0\">", b1.c_str() );
            fprintf ( overview1, "</td><td width=\"140\"><A HREF=\"%s\">%s</A></td></tr><tr><td><a href=\"%s\">%s</a></td></tr></table>\n", s.c_str(), ft->name.c_str(), s.c_str(), ft->description.c_str() );

            // END OVERVIEW RIGHT

            // we are adding a link to the overview file.
            // to put a singile " into a string we must use double quotes ( "" ), because a single quote is interpreted as the end of the string by C
            // %s tells C to insert a string there. The strings are appended at the end of the command
            // at the first %s the filename in s is inserted, at the second %s the unit variable 'description'

            // UNIT GENERAL
            fprintf ( detailed1, "<table width=\"100%\" id=\"H2\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"> \n"
                      "<tr><td colspan=\"2\"></td><td id=\"H9\" align=\"right\">UNIT GUIDE v2.0 german </td></tr>"
                      "<tr><td width=\"50\">" );
            if ( exist ( b1.c_str() ))
               fprintf ( detailed1, "<img src=\"%s\">", b1.c_str() );
            fprintf ( detailed1, "</td>\n<td>" );

            fprintf ( detailed1, "<table width=\"500\" id=\"H2\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"> \n" );
            fprintf ( detailed1, "<tr>  <td bgcolor=\"#20483f\"><img src=\" ../m-name.png\" alt=\"Name\"></td>  <td align=\"center\" colspan=\"4\">%s</td> </tr>\n", ft->name.c_str() );
            if ( !ft->description.empty() )
               fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\"><img src=\"../m-description.png\" alt=\"Kurzbeschreibung\"></td>  <td align=\"center\" colspan=\"4\">%s</td> </tr>\n", ft->description.c_str() );
            else
               fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\"><img src=\"../m-description.png\" alt=\"Kurzbeschreibung\"></td>  <td align=\"center\" colspan=\"4\">--</td> </tr>\n" );
            fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\"><img src=\"../m-id.png\" alt=\"Identifikationsnummer\"></td>           <td align=\"center\">%i</td> <td></td><td bgcolor=\"#20483f\"><img src=\"../m-weight.png\" alt=\"Gewicht\"></td> <td align=\"center\">%d</td> <td bgcolor=\"#20483f\"><img src=\"../m-type.png\" alt=\"Einheitentyp\"></td><td width=\"200\">%s</td> </tr>\n", ft->id, ft->weight, cmovemalitypes[ft->movemalustyp]  );
            fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\"><img src=\"../m-armor.png\" alt=\"Panzerung\"></td>        <td align=\"center\">%i</td> <td></td><td bgcolor=\"#20483f\"><img src=\"../m-view.png\" alt=\"Sicht/Radar\"></td>   <td align=\"center\">%d</td> </tr>\n", ft->armor, (ft->view/10) );
            fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\"><img src=\"../m-coste.png\" alt=\"Produktionskosten Energie\"></td>  <td align=\"center\">%i</td> <td></td><td bgcolor=\"#20483f\"><img src=\"../m-jamming.png\" alt=\"Radarstoerung\"></td><td align=\"center\">%d</td> </tr>\n", ft->productionCost.material, (ft->jamming/10) );
            fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\"><img src=\"../m-costm.png\" alt=\"Produktionskosten Material\"></td><td align=\"center\">%i</td> </tr>\n", ft->productionCost.energy );

            if ( ft->wait )
               fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\" colspan=\"4\">Angriff nach Bewegung</td> <td>No</td> </tr>\n" );
            else
               fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\" colspan=\"4\">Angriff nach Bewegung</td> <td>Yes</td> </tr>\n" );

            if ( ft->functions & cf_moveafterattack )
               fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\" colspan=\"4\">Bewegung nach Angriff</td> <td>Yes</td></tr>\n" );
            else
               fprintf ( detailed1, "<tr><td bgcolor=\"#20483f\" colspan=\"4\">Bewegung nach Angriff</td> <td>No</td></tr>\n" );

            fprintf ( detailed1, "</table>\n" );
            fprintf ( detailed1, "</td>\n\n<td width=\"150\">" );
            if ( exist ( b2.c_str() ))
               fprintf ( detailed1, "<img src=\"%s\">", b2.c_str() );
            fprintf ( detailed1, "</td></tr></table>\n" );
            fprintf ( detailed1, "<table width=\"100%\" id=\"H2\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">\n<tr align=\"center\">" );
            fprintf ( detailed1, "<td><a href=\"%s\">BEWEGUNG</a></td>", s2.c_str() );
            fprintf ( detailed1, "<td><a href=\"%s\">WAFFEN</a></td>" , s3.c_str() );
            fprintf ( detailed1, "<td><a href=\"%s\">FUNKTIONEN</a></td>" , s4.c_str() );
            fprintf ( detailed1, "<td><a href=\"%s\">LADEKAPAZIT&Auml;TEN</a></td>" , s5.c_str() );
            fprintf ( detailed1, "<td><a href=\"%s\">BESCHREIBUNG</a></td>" , s6.c_str() );
            //         fprintf ( detailed1, "<td><a href=\"%s\">Research</a></td>" , s4.c_str() );
            fprintf ( detailed1, "</tr></table>\n" );
            // END UNIT GENERAL

            // some details about the unit; %d tells C to insert a decimal number there
            // take a look at the vehicletype class in vehicletype.h for the names of all variables that make a vehicletype
            // be carefuel not to make a , at the end of the first lines, since this would seperate the string in to several independant strings

            // choehenstufen is a global array that contains the names of the height levels


            // BEGIN MOVEMENT

            // Hoehenstufen
            int i,w;
            // Tabellenbeginn
            fprintf( detailed2, "<TABLE align=\"left\" rules=\"rows\" id=\"H9\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">"
                     "<TR><td colspan=\"9\" bgcolor=\"#20483f\" id=\"H2\" align=\"center\">Erreichbare H&ouml;henstufen:</td></tr>\n<tr>");
            // Spaltentitel
            fprintf ( detailed2, "<td></td>" );
            for ( i = 0; i < 8; i++ ) {
               fprintf ( detailed2, " <TD><IMG src=\"../hoehe%d.gif\" ", i);
               if ( i==0 )
                    fprintf (detailed2, " alt=\"deep_submerged / tief getaucht\" " );
               if ( i==1 )
                    fprintf (detailed2, " alt=\"submerged / getaucht\" ");
               if ( i==2 )
                    fprintf (detailed2, " alt=\"floating / schwimmend\" ");
               if ( i==3 )
                    fprintf (detailed2, " alt=\"ground_based / fahrend\" ");
               if ( i==4 )
                    fprintf (detailed2, " alt=\"low_level_flight / tief fliegend\" ");
               if ( i==5 )
                    fprintf (detailed2, " alt=\"medium_level_flight / normale Flugh&ouml;he\" ");
               if ( i==6 )
                    fprintf (detailed2, " alt=\"high_level_flight / sehr hoch fliegend\" ");
               if ( i==7 )
                    fprintf (detailed2, " alt=\"orbit / Erdumlaufbahn\" ");
			   fprintf ( detailed2, " ></TD>");
			}
			fprintf( detailed2, "</TR>\n<TR>");
            // Spaltenwerte Hacken
            fprintf ( detailed2, "<td></td>" );
            for ( i = 0; i < 8; i++ )
               if ( ft->height & ( 1 << i ))
                  fprintf ( detailed2, " <TD><img src=\"../hacken.gif\"></TD>" );
               else
                  fprintf ( detailed2, " <TD></TD>"  );
            fprintf( detailed2, "</TR>\n<TR>");
            // Spaltenwerte pro Runde
            fprintf ( detailed2, "<td>Round</td>" );
            for ( i = 0; i < 8; i++ )
               if ( ft->height & ( 1 << i ))
                  fprintf ( detailed2, " <TD align=\"center\">%d</TD>", (ft->movement[i]/10) );
               else
                  fprintf ( detailed2, " <TD></TD>"  );
            fprintf( detailed2, "</TR>\n<TR>\n");
            fprintf( detailed2, "\n</TR>\n</TABLE>\n");

            // Einzelne Werte
            // Tabellenbeginn
            fprintf( detailed2, "<TABLE id=\"H2\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">\n" );
            fprintf( detailed2, "<TR><td bgcolor=\"#20483f\">Treibstofftank</td>    <td align=\"center\">%d</td></tr>\n", ft->tank.fuel );
            fprintf( detailed2, "<TR><td bgcolor=\"#20483f\">Materialtank</td><td align=\"center\">%d</td></tr>\n", ft->tank.material );
            fprintf( detailed2, "<TR><td bgcolor=\"#20483f\">Energspeicher</td>  <td align=\"center\">%d</td></tr>\n", ft->tank.energy );
            fprintf( detailed2, "<TR><td bgcolor=\"#20483f\">Verbrauch</td>  <td align=\"center\">%d</td></tr>\n", ft->fuelConsumption );
            if ( ft->fuelConsumption > 0 )
               fprintf( detailed2, "<tr><td bgcolor=\"#20483f\">max.Reichweite</td>   <TD align=\"center\">%d</TD></tr>\n", (ft->tank.fuel/ft->fuelConsumption) );
            else
               fprintf( detailed2, "<tr><td bgcolor=\"#20483f\">max.Reichweite</td>   <TD align=\"center\">--</TD></tr>\n" );
            fprintf( detailed2, "<TR><td bgcolor=\"#20483f\">Hoehenstufenwechsel</td>   <td align=\"center\">%d</td></tr>\n", ft->steigung );
            fprintf( detailed2, "\n</TABLE>\n");


            // Bodentypen global
            fprintf( detailed2,"<br><br>\n<table rules=\"rows\" id=\"H2\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"><tr><td colspan=\"34\" bgcolor=\"#20483f\" align=\"center\">" );
            fprintf( detailed2,"Bodentypeneigenschaften der Einheit</td></tr>\n<tr>" );

            // Spalten gfx
            fprintf ( detailed2, "<td></td>" );
            for ( i = 0; i < cbodenartennum ; i++ )
               fprintf ( detailed2, " <TD><IMG src=\"../gfx%d.gif\" alt=\"%s\"></TD>", i, cbodenarten[i]);
            fprintf( detailed2, "</TR>\n<TR>\n");

            // Spaltenwerte befahrbare Bodentypen
            fprintf ( detailed2, "<td>befahrbar</td>" );
            for ( i = 0; i < cbodenartennum ; i++) {
               if ( ft->terrainaccess.terrain.test(i) )
                  fprintf ( detailed2, "<td><img src=\"../hacken.gif\"></td>" );
               else
                  fprintf ( detailed2, "<td></td>" );
            } /* endfor */
            fprintf( detailed2, "</TR>\n<TR>\n");

            // Spaltenwerte stirbt auf
            fprintf ( detailed2, "<td>Zerstrung</td>" );
            for ( i = 0; i < cbodenartennum ; i++) {
               if ( ft->terrainaccess.terrainkill.test(i))
                  fprintf ( detailed2, "<td><img src=\"../hacken.gif\"></td>" );
               else
                  fprintf ( detailed2, "<td></td>" );
            } /* endfor */
            fprintf( detailed2, "</TR>\n<TR>\n");

            // Spaltenwerte can not drive on
            fprintf ( detailed2, "<td>nicht befahrbar</td>" );
            for ( i = 0; i < cbodenartennum ; i++) {
               if ( ft->terrainaccess.terrainnot.test(i) )
                  fprintf ( detailed2, "<td><img src=\"../hacken.gif\"></td>" );
               else
                  fprintf ( detailed2, "<td></td>" );
            } /* endfor */

            fprintf ( detailed2, "</tr><tr>\n" );
            // Spaltenwerte can need terrain
            fprintf ( detailed2, "<td>benoetigt immer</td>" );
            for ( i = 0; i < cbodenartennum ; i++) {
               if ( ft->terrainaccess.terrainreq.test(i) )
                  fprintf ( detailed2, "<td><img src=\"../hacken.gif\"></td>" );
               else
                  fprintf ( detailed2, "<td></td>" );
            } /* endfor */
            fprintf ( detailed2, "</tr></table>\n" );

            // Erklaerungen
            fprintf( detailed2,"<br><br>\n<table id=\"H2\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"><tr><td colspan=\"3\" bgcolor=\"#20483f\" align=\"center\">" );
            fprintf( detailed2,"Erklaerungen zu den Bodentypen</td></tr>\n" );
              //only ANY  (lowland)
            fprintf( detailed2,"<tr><td colspan=\"3\" bgcolor=\"#20483f\">Basistypen</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx1.gif\"></td><td>lowland / Flachland, Wiese, Feld</td><td rowspan=\"15\">(BASIS) Diese Felder sind nur befahrbar, wenn das weisse Hackchen gesetz ist. Die Zerstrung tritt nur ein, wenn sich auf dem Feld kein anders Objekt befindet, welches ein gefahrlosen befahren zulaesst. (Brcke ueber Flu)</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx14.gif\"></td><td>hard sand / fester Sand</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx15.gif\"></td><td>soft sand / Mullsand-Sandwueste</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx21.gif\"></td><td>mountains / normale Berge</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx4.gif\"></td><td>high mountains / hohe Berge</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx22.gif\"></td><td>very shallow water / sehr flaches wasser</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx0.gif\"></td><td>shallow water / flaches wasser</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx12.gif\"></td><td>water / normales Wasser</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx13.gif\"></td><td>deep water / tiefes Wasser</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx24.gif\"></td><td>Lava</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx25.gif\"></td><td>ditch / Befestigungen- Schtzengrben</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx26.gif\"></td><td>hillside / Huegel-Gefaelle</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx27.gif\"></td><td>turret foundation / spezieller Untergrund fuer stationaere Einheiten</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx29.gif\"></td><td>Instalation</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx31.gif\"></td><td>river / fluss</td></tr>\n" );
              //only NOT (swamp,forest)
            fprintf( detailed2,"<tr><td colspan=\"3\" bgcolor=\"#20483f\">Wettertypen und besondere Eigenschaften</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx18.gif\"></td><td>mud / Matsch, feuchte Wiesen</td><td rowspan=\"10\">Diese Feldtypen sind generell befahrbar. Eine Einheit die z.B. nicht durch Sumpf oder Wald fahren kann, hat dies speziell bei \"nicht befahrbar\" vermerkt !! Bei Einheiten darf diese Eigenschaft niemals bei \"befahrbar\" gesetzt sein. Einzige Ausnahme ist \"fozen_water\" bei Einheiten, die ueber zugefrorenes Wasser fahren koennen.</tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx28.gif\"></td><td>morass / Morast, sehr schwer befahrbares Gelaende</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx2.gif\"></td><td>swamp / Sumpf</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx19.gif\"></td><td>snow / wenig Schnee</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx20.gif\"></td><td>deep snow / tiefer Schnee</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx30.gif\"></td><td>pack ice / Packeis</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx32.gif\"></td><td>frozen water / gefrorenes Wasser</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx3.gif\"></td><td>forest / Wald</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx17.gif\"></td><td>small rocks / kleine Steine - wenig Gerll</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx23.gif\"></td><td>large rocks / groe Steine - viel Gerll</td></tr>\n" );
              // plus ANY (road, rail,)
            fprintf( detailed2,"<tr><td colspan=\"3\" bgcolor=\"#20483f\">Typen fuer spezielle Objekte</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx5.gif\"></td><td>road / Strae</td><td rowspan=\"5\">Diese Eigenschaften werden hauptsaechlich bei Objekten verwendet. Felder mit dieser Eigenschaft sind generell befahrbar, auch wenn dies nicht speziell vermerkt ist, denn sie treten nur in Zusammenhang mit einem Basisfeld auf. Ein Panzer kann Schienen ueberqueren - aber nicht, wenn sie sich ber Wasser befinden. Ein Zug, der diese Eigenschaft speziell besitzt, kann das.</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx6.gif\"></td><td>railroad / Schienen</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx9.gif\"></td><td>runway / Landebahn</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx10.gif\"></td><td>pipeline / oberirdische Rohrleitung</td></tr>\n" );
            fprintf( detailed2,"<tr><td><img src=\"../gfx11.gif\"></td><td>buried pipeline / unterirdische Pipeline</td></tr>\n" );
            fprintf ( detailed2, "</table>\n" );

            // ENDE MOVEMENT





            // BEGIN WEAPONS
            // Waffen NR-AMMO-DISTANCE-STRENGS-SHOT FROM-ATTACK TO-TYP
            fprintf ( detailed3, "<table id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"> \n" );
            // berschriften
            fprintf ( detailed3, "<tr><td colspan=\"2\"></td>"
                      "    <td bgcolor=\"#20483f\" colspan=\"4\" align=\"center\">Entfernung</td>"
                      "    <td bgcolor=\"#20483f\" colspan=\"8\" align=\"center\">schiesst von</td>"
                      "    <td></td>"
                      "    <td bgcolor=\"#20483f\" colspan=\"8\" align=\"center\">schiesst auf</td>"
                      "    <td bgcolor=\"#20483f\">Typ</td>"
                      "</tr>\n" );
            // GFX
            fprintf ( detailed3, "<tr><td></td>"
                      "    <td><img src=\"../ammo.gif\" alt=\"max.ammunition / max. Anzahl Munition\"></td>"
                      "    <td><img src=\"../dis1.gif\" alt=\"min.targetrange / min. Angriffsreichweite\"></td>"
                      "    <td><img src=\"../str1.gif\" alt=\"weaponstrengs by min.targetrange / Angriffsst&auml;re bei min. Angriffsreichweite\"></td>"
                      "    <td><img src=\"../dis2.gif\" alt=\"max.targetrange / max. Angriffsreichweite\"></td>"
                      "    <td><img src=\"../str2.gif\" alt=\"weaponstrengs by max.targetrange / Angriffsstr&auml;rke bei max. Angriffsreichweite\"></td>" );
            // Hhenstufenzeichen einfgen fr shoot from und target
            for ( i = 0; i < 8; i++ ) {
               fprintf ( detailed3, " <TD><IMG src=\"../hoehe%d.gif\" ", i);
			   if ( i==0 )
                    fprintf (detailed3, " alt=\"deep_submerged / tief getaucht\" " );
               if ( i==1 )
                    fprintf (detailed3, " alt=\"submerged / getaucht\" ");
               if ( i==2 )
                    fprintf (detailed3, " alt=\"floating / schwimmend\" ");
               if ( i==3 )
                    fprintf (detailed3, " alt=\"ground_based / fahrend\" ");
               if ( i==4 )
                    fprintf (detailed3, " alt=\"low_level_flight / tief fliegend\" ");
               if ( i==5 )
                    fprintf (detailed3, " alt=\"medium_level_flight / normale Flugh&ouml;he\" ");
               if ( i==6 )
                    fprintf (detailed3, " alt=\"high_level_flight / sehr hoch fliegend\" ");
               if ( i==7 )
                    fprintf (detailed3, " alt=\"orbit / Erdumlaufbahn\" ");
			   fprintf ( detailed3, " ></TD>" );
			}
            fprintf (detailed3, "<td></td> ");
            for ( i = 0; i < 8; i++ ) {
               fprintf ( detailed3, " <TD><IMG src=\"../hoehe%d.gif\" ", i);
			                  if ( i==0 )
                    fprintf (detailed3, " alt=\"deep_submerged / tief getaucht\" " );
               if ( i==1 )
                    fprintf (detailed3, " alt=\"submerged / getaucht\" ");
               if ( i==2 )
                    fprintf (detailed3, " alt=\"floating / schwimmend\" ");
               if ( i==3 )
                    fprintf (detailed3, " alt=\"ground_based / fahrend\" ");
               if ( i==4 )
                    fprintf (detailed3, " alt=\"low_level_flight / tief fliegend\" ");
               if ( i==5 )
                    fprintf (detailed3, " alt=\"medium_level_flight / normale Flugh&ouml;he\" ");
               if ( i==6 )
                    fprintf (detailed3, " alt=\"high_level_flight / sehr hoch fliegend\" ");
               if ( i==7 )
                    fprintf (detailed3, " alt=\"orbit / Erdumlaufbahn\" ");
			   fprintf ( detailed3, " ></TD>" );
            }
			fprintf ( detailed3, "    <td></td>"
                      "</tr>\n" );

            // Werte der Waffen
            for ( w = 0; w < ft->weapons.count ; w++) {
               fprintf ( detailed3, "<tr><td>#%d</td>", w+1 );
               fprintf ( detailed3, "    <td align=\"center\">%d</td>", ft->weapons.weapon[w].count );
               fprintf ( detailed3, "    <td align=\"center\">%d</td>", (ft->weapons.weapon[w].mindistance+9)/10 );
               fprintf ( detailed3, "    <td align=\"center\">%d</td>", ft->weapons.weapon[w].maxstrength );
               fprintf ( detailed3, "    <td align=\"center\">%d</td>", (ft->weapons.weapon[w].maxdistance)/10 );
               fprintf ( detailed3, "    <td align=\"center\">%d</td>", ft->weapons.weapon[w].minstrength );
               // Hhenstufenzeichen einfgen fr shoot from und target
               for ( i = 0; i < 8; i++ )
                  if ( ft->weapons.weapon[w].sourceheight & ( 1 << i ) )
                     fprintf ( detailed3, "<td><img src=\"../hacken.gif\"></td> " );
                  else
                     fprintf ( detailed3, "<td></td>" );
               fprintf ( detailed3, "    <td></td>");
               for ( i = 0; i < 8; i++ )
                  if ( ft->weapons.weapon[w].targ & ( 1 << i ) )
                     fprintf ( detailed3, "<td><img src=\"../hacken.gif\"></td>" );
                  else
                     fprintf ( detailed3, "<td></td>" );

               fprintf ( detailed3, "    <td nowrap>" );
               for ( i = 0; i < cwaffentypennum; i++ )
                  if ( ft->weapons.weapon[w].gettype() & ( 1 << i ) )
                     fprintf ( detailed3, "%s.", cwaffentypen[i] );
               fprintf ( detailed3, "</td></tr>\n" );
            }
            fprintf ( detailed3, "</table>\n" );

            fprintf ( detailed3, "<br>\n\n" );
            // Die entfernung wird durch 10 dividiert, um die Anzahl der Felder zu erhalten
            // Die normale Division rundet IMMER ab, also 1,9 / 2 = 0
            // Aber die minimale Entfernung mu aufgerundet werden, deshalb benutze ich einen kleinen Trick: Ich addiere vor der Division 9 (also Quotient-1) dazu

            //Weapon can hit:
            fprintf ( detailed3, "<table id=\"H9\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"> \n" );
            // Ueberschrift
            fprintf ( detailed3, "<tr><td></td><td align=\"center\" colspan=\"18\" bgcolor=\"#20483f\">Waffe schiesst auf: </td></tr>" );
            // Spalten GFX
            fprintf ( detailed3, "<tr><td></td>" );
            for ( i = 0; i < cmovemalitypenum; i++ ) {
               fprintf ( detailed3, " <TD><IMG src=\"../typ%d.gif\" ", i);

               if ( i==0 )
                    fprintf (detailed3, " alt=\"default/undefiniert\" " );
               if ( i==1 )
                    fprintf (detailed3, " alt=\"light tracked vehicle / leichte Kettenfahrzeuge\" ");
               if ( i==2 )
                    fprintf (detailed3, " alt=\"medium tracked vehicle / mittlere Kettenfahrzeuge\" ");
               if ( i==3 )
                    fprintf (detailed3, " alt=\"heavy tracked vehicle / schwere Kettenfahrzeuge\" ");
               if ( i==4 )
                    fprintf (detailed3, " alt=\"light wheeled vehicle / leichte Radfahrzeuge\" ");
               if ( i==5 )
                    fprintf (detailed3, " alt=\"medium wheeled vehicle / mittlere Radfahrzeuge\" ");
               if ( i==6 )
                    fprintf (detailed3, " alt=\"heavy wheeled vehicle / schwere Radfahrzeuge\" ");
               if ( i==7 )
                    fprintf (detailed3, " alt=\"trooper / Soldaten-Roboter\" ");
               if ( i==8 )
                    fprintf (detailed3, " alt=\"rail vehicle / Schienenfahrzeuge\" ");
               if ( i==9 )
                    fprintf (detailed3, " alt=\"medium aircraft \" ");
               if ( i==10 )
                    fprintf (detailed3, " alt=\"medium ship \" ");
               if ( i==11 )
                    fprintf (detailed3, " alt=\"building turret object / Geb&auml;ude-Bunker-Objekte\" ");
               if ( i==12 )
                    fprintf (detailed3, " alt=\"light aircraft\" ");
               if ( i==13 )
                    fprintf (detailed3, " alt=\"heavy aircraft\" ");
               if ( i==14 )
                    fprintf (detailed3, " alt=\"light ship\" ");
               if ( i==15 )
                    fprintf (detailed3, " alt=\"heavy ship\" ");
               if ( i==16 )
                    fprintf (detailed3, " alt=\"helicopter\" ");
               if ( i==17 )
                    fprintf (detailed3, " alt=\"hoovercraft\" ");

               fprintf ( detailed3, "></TD>" );
            }
         fprintf ( detailed3, "</TR>\n");
            // Spaltenwerte
            for ( int w = 0; w < ft->weapons.count ; w++) {
               fprintf ( detailed3, "<TR><td>#%d</td>", w+1 );
               for ( i = 0; i < cmovemalitypenum; i++ )
                  fprintf ( detailed3, "<td>%d %%</td>", ft->weapons.weapon[w].targetingAccuracy[i] );
               fprintf ( detailed3, "</TR>\n");
            }
            //Ende tabelle
            fprintf ( detailed3, "</table><br> \n" );

            // Effizienz
            fprintf ( detailed3, "<table id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"> \n" );
            // Ueberschrift
            fprintf ( detailed3, "<tr><td></td><td align=\"center\" colspan=\"14\" bgcolor=\"#20483f\" >Waffenstaerke ueber mehrere Hoehenstufen : </td></tr>\n" );
            // Spalten Ueberschrift
            fprintf ( detailed3, "<tr><td></td>" );
            for ( i = 0; i < 13; i++ )
               fprintf(detailed3, "<td align=\"center\">%d</td>", i-6 );
            fprintf ( detailed3, "</TR>\n");
            // Spaltenwerte
            for ( int w = 0; w < ft->weapons.count ; w++) {
               fprintf ( detailed3, "<TR><td>#%d</td>", w+1 );
               for ( i = 0; i < 13; i++ )
                  if ( ft->weapons.weapon[w].efficiency[i] > 0 )
                           fprintf ( detailed3, " <TD align=\"center\">%d%%</TD>", ft->weapons.weapon[w].efficiency[i] );
                        else
                           fprintf ( detailed3, " <TD></TD>"  );

//                  fprintf ( detailed3, "<td align=\"center\">%d%%</td>", ft->weapons.weapon[w].efficiency[i] );
               fprintf ( detailed3, "</TR>\n");
            }
            //Ende tabelle
            fprintf ( detailed3, "</table> \n" );
            //ENDE WAFFEN

			
			
			
			
            //BEGINN FUNCTIONS
            fprintf ( detailed4, "<table align=\"left\" id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">" );
            // Ueberschrift
            fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\">Merkmale der Einheit</td></tr>" );
            for ( i = 0; i<cvehiclefunctionsnum; i++)
               if ( ft->functions & ( 1 << i ))
                  fprintf ( detailed4, "<tr><td>%s</td></tr>", cvehiclefunctions[i] );
            //Ende tabelle
            fprintf ( detailed4, "</table>\n" );
            
			//Einzelwerte
            fprintf ( detailed4, "<table id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">" );
            if ( ft->maxwindspeedonwater )
               fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\">max.Windst&auml;rke</td> <td>%d</td> </tr>", ft->maxwindspeedonwater );
            else
               fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\">max.Windst&auml;rke</td> <td>--</td> </tr>" );
            fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\">Radius f&uuml;r Ressourcensuche</td><td>%d</td> </tr>", ft->digrange );
            fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\">Autoreparaturrate </td> <td>%d%%</td> </tr>", ft->autorepairrate );
            fprintf ( detailed4, "</table>\n" );

            // Objekte
            fprintf ( detailed4, "<table align=\"left\" id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">\n" );
            // Ueberschrift baubare Objekte
            fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\" colspan=\"2\">baubare OBJEKTE</td></tr>\n" );
            for ( unsigned int i = 0; i < ft->objectsBuildable.size(); i++ ) {
//               fprintf( detailed4, "<tr><td>es knnen die Objekte mit ids von %d bis %d gebaut werden</td></tr>\n", ft->objectsBuildable[i].from, ft->objectsBuildable[i].to );
               for ( int b = 0; b < objecttypenum; b++ ) {
                  pobjecttype obj = getobjecttype_forpos ( b );
                  if (     obj->id >= ft->objectsBuildable[i].from
                        && obj->id <= ft->objectsBuildable[i].to ) {
                     fprintf ( detailed4, "<tr><td>ID %d </td><td align=\"center\"> %s </td></tr>\n", obj->id, obj->name.c_str() );
                  }
               }
            }
            fprintf ( detailed4, "</table>\n" );

             // Objekte abreissbar
            fprintf ( detailed4, "<table align=\"left\" id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">\n" );
            // Ueberschrift abreissbare Objekte
            fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\" colspan=\"2\">abreissbare OBJEKTE</td></tr>\n" );
           for ( unsigned int i = 0; i < ft->objectsRemovable.size(); i++ ) {
               for ( int b = 0; b < objecttypenum; b++ ) {
                  pobjecttype obj = getobjecttype_forpos ( b );
                  if (     obj->id >= ft->objectsRemovable[i].from
                        && obj->id <= ft->objectsRemovable[i].to ) {
                     fprintf ( detailed4, "<tr><td>ID %d </td><td align=\"center\"> %s </td></tr>\n", obj->id, obj->name.c_str() );
                  }
               }
            }
            fprintf ( detailed4, "</table>\n" );

			// UNITS
            fprintf ( detailed4, "<table align=\"left\" id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">\n" );
            // Ueberschrift baubare Einheiten
            fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\" colspan=\"2\">baubare UNITS</td></tr>\n" );
            for ( unsigned int i = 0; i < ft->vehiclesBuildable.size(); i++ ) {
//               fprintf( detailed4, "<tr><td colspan=\"2\">baubar ID %d bis %d </td></tr>\n", ft->vehiclesBuildable[i].from, ft->vehiclesBuildable[i].to );
               for ( int b = 0; b < vehicletypenum; b++ ) {
                  pvehicletype veh = getvehicletype_forpos ( b );
                  if (     veh->id >= ft->vehiclesBuildable[i].from
                        && veh->id <= ft->vehiclesBuildable[i].to ) {
                     fprintf ( detailed4, "<tr><td>ID %d </td><td align=\"center\"> %s </td></tr>\n", veh->id, veh->getName().c_str() );
                  }
               }
            }
            fprintf ( detailed4, "</table>\n" );
            
			// Geb&auml;ude
            fprintf ( detailed4, "<table align=\"left\" id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">\n" );
            // Ueberschrift baubare Gebaeude
            fprintf ( detailed4, "<tr><td align=\"center\" bgcolor=\"#20483f\" colspan=\"2\">baubare GEB&Auml;UDE</td></tr>\n" );
            for ( unsigned int i = 0; i < ft->buildingsBuildable.size(); i++ ) {
//               fprintf( detailed4, "<tr><td>baubar ID %d bis %d </td></tr>\n", ft->buildingsBuildable[i].from, ft->vehiclesBuildable[i].to );
               for ( int b = 0; b < buildingtypenum; b++ ) {
                  pbuildingtype bld = getbuildingtype_forpos ( b );
                  if (     bld->id >= ft->buildingsBuildable[i].from
                           && bld->id <= ft->buildingsBuildable[i].to ) {
                     fprintf ( detailed4, "<tr><td>ID %d </td><td align=\"center\"> %s </td></tr>\n", bld->id, bld->name.c_str() );
                  }
               }
            }
            fprintf ( detailed4, "</table>\n" );

            //ENDE FUNKTIONS

			
			

			
			
			
			
			
			
            //BEGINN LOADING
            if ( ft->loadcapacity ) {
               fprintf ( detailed5, "<table align=\"left\" id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"> " );
               fprintf ( detailed5, "<tr><td align=\"center\" bgcolor=\"#20483f\">Einladbare UNITS</td></tr>" );
			   
			   for ( int c = 0; c < cmovemalitypenum; c++ )
               if ( ft->vehicleCategoriesLoadable & (1 << c))
                  fprintf ( detailed5, "<tr><td align=\"center\" > %s </td></tr>", cmovemalitypes[c] );
			   
               fprintf ( detailed5, "</table>" );

               fprintf ( detailed5, "<table id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">" );
               fprintf ( detailed5, "<tr><td align=\"center\" bgcolor=\"#20483f\">max. Zuladung</td> <td>%d</td> </tr>", ft->loadcapacity );
               fprintf ( detailed5, "<tr><td align=\"center\" bgcolor=\"#20483f\">max. Gewicht einer Einheit</td><td>%d</td> </tr>", ft->maxunitweight );
               fprintf ( detailed5, "</table>" );
			   
			   // Ladbar von H&ouml;henstufen 
               fprintf ( detailed5, "<table id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\"> \n" );
               // berschriften
               fprintf ( detailed5,
                      "    <td bgcolor=\"#20483f\" colspan=\"9\" align=\"center\"> Voraussetzungen f&uuml;r das Ein- und Ausladen </td>"
                      "</tr>\n" );
               // GFX
               fprintf ( detailed5, "<tr><td></td>\n");
               // Hhenstufenzeichen einfgen fr shoot from und target
               for ( i = 0; i < 8; i++ ) {
                  fprintf ( detailed5, " <TD><IMG src=\"../hoehe%d.gif\" ", i);
				  if ( i==0 )
                    fprintf (detailed5, " alt=\"deep_submerged / tief getaucht\" " );
                  if ( i==1 )
                    fprintf (detailed5, " alt=\"submerged / getaucht\" ");
                  if ( i==2 )
                    fprintf (detailed5, " alt=\"floating / schwimmend\" ");
                  if ( i==3 )
                    fprintf (detailed5, " alt=\"ground_based / fahrend\" ");
                  if ( i==4 )
                    fprintf (detailed5, " alt=\"low_level_flight / tief fliegend\" ");
                  if ( i==5 )
                    fprintf (detailed5, " alt=\"medium_level_flight / normale Flugh&ouml;he\" ");
                  if ( i==6 )
                    fprintf (detailed5, " alt=\"high_level_flight / sehr hoch fliegend\" ");
                  if ( i==7 )
                    fprintf (detailed5, " alt=\"orbit / Erdumlaufbahn\" ");
				  fprintf ( detailed5, "></TD>" );
               }
			   fprintf ( detailed5, "</tr>\n" );
               
			   // Hhenstufenzeichen einfgen fr can load and unload from:
               fprintf ( detailed5, "<tr><td>UNIT muss auf dieser Stufe sein</td>" );
			   for ( int h = 0; h < 8; h++ ) {
                  if ( ft->loadcapability & (1 << h))
                     fprintf ( detailed5, "<td><img src=\"../hacken.gif\"></td> " );	
			      else
                     fprintf ( detailed5, "<td></td>" );
			   }
	           fprintf ( detailed5,	"</tr>\n" );	   
			   
			   // Hhenstufenzeichen einfgen fr can load and unload from:
               fprintf ( detailed5, "<tr><td>UNIT muss diese Stufe selbst erreichen</td>" );
			   for ( int h = 0; h < 8; h++ ) {
                  if ( ft->loadcapabilityreq & (1 << h))
                     fprintf ( detailed5, "<td><img src=\"../hacken.gif\"></td> " );	
			      else
                     fprintf ( detailed5, "<td></td>" );
			   }
	           fprintf ( detailed5,	"</tr>\n" );
	
	           // Hhenstufenzeichen einfgen fr can load and unload from:
               fprintf ( detailed5, "<tr><td>UNIT darf diese Stufe selbst nicht erreichen</td>" );
			   for ( int h = 0; h < 8; h++ ) {
                  if ( ft->loadcapabilitynot & (1 << h))
                     fprintf ( detailed5, "<td><img src=\"../hacken.gif\"></td> " );	
			      else
                     fprintf ( detailed5, "<td></td>" );
			   }
	           fprintf ( detailed5,	"</tr>\n" );
			   fprintf ( detailed5, "</table>\n" );            
			
			} else {
               fprintf ( detailed5, "<table align}\"left\" id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">" );
               fprintf ( detailed5, "<tr><td align=\"center\" bgcolor=\"#20483f\">&nbsp;</td></tr>" );
               fprintf ( detailed5, "<tr><td align=\"center\" ><br>Keine Transporteinheit !<br></td></tr>" );
               fprintf ( detailed5, "</table>" );
            }
            //ENDE LOADING

			
			
			
			
			
            //BEGINN DESCRIPTION
            fprintf ( detailed6, "<table align=\"left\" id=\"H10\" border=\"1\" bordercolordark=\"#333333\" bordercolorlight=\"#408050\" cellpadding=\"1\" cellspacing=\"1\">" );
            fprintf ( detailed6, "<tr><td align=\"center\" bgcolor=\"#20483f\">Informationen zur Einheit</td></tr>" );
            if ( !ft->infotext.empty() ) {
               ASCString text = ft->infotext;
               while ( text.find ( "#crt#" ) != ASCString::npos )
                  text.replace ( text.find  ("#crt#"), 5, "<p>");
               while ( text.find ( "#CRT#" ) != ASCString::npos )
                  text.replace ( text.find  ("#CRT#"), 5, "<p>");
               while ( text.find ( "\n" ) != ASCString::npos )
                  text.replace ( text.find  ("\n"), 1, "<p>");
               while ( text.find ( "\r" ) != ASCString::npos )
                  text.replace ( text.find  ("\r"), 1, "");

               ASCString::size_type begin = 0;
               ASCString::size_type end = 0;
               do {
                  begin = text.find ( "#", end );
                  if ( begin != ASCString::npos && begin+1 < text.length() ) {
                     end = text.find ( "#", begin+1 );
                     if ( end != ASCString::npos ) {
                        text.erase ( begin, end-begin+1 );
                        begin = 0;
                        end = 0;
                     }
                  } else
                     end = ASCString::npos;
               } while ( end != ASCString::npos );

               fprintf ( detailed6, "<tr><td><br>%s<br></td></tr>", text.c_str() );
            }
            //            fprintf ( detailed6, "<tr><td><br><br>%s</td></tr>", ft->infotext );
            else {
               fprintf ( detailed6, "<tr><td><br><br>keine Beschreibung verf&uumlgbar !<br><br></td></tr>" );
            }
            //Ende tabelle
            fprintf ( detailed6, "</table> \n" );
            //ENDE DESCRIPTION


/*           // NEU - noch anzupassen
            for ( int h = 0; h < 8; h++ ) {
               if ( ft->loadcapability & (1 << h))
                  printf("Hhenstufe kann geladen werden" );

               if ( ft->loadcapabilityreq & (1 << h))
                  printf("Hhenstufe mu erreichbar sein, um geladen werden zu knnen" );

               if ( ft->loadcapability & (1 << h))
                  printf("Hhenstufe darf nicht erreichbar sein" );
            }

            // ft->loadcapacity  ist maximale ladekapazitt
            for ( int c = 0; c < cmovemalitypenum; c++ )
               if ( ft->vehicleCategoriesLoadable & (1 << c))
                  printf(" Kategorie %s kann geladen werden", cmovemalitypes[c] );

            for (  i = 0; i < ft->buildingsBuildable.size(); i++ ) {
               printf("es knnen die gebude mit ids von %d bis %d gebaut werden\n", ft->buildingsBuildable[i].from, ft->buildingsBuildable[i].to );
               for ( int b = 0; b < buildingtypenum; b++ ) {
                  pbuildingtype bld = getbuildingtype_forpos ( b );
                  if (     bld->id >= ft->buildingsBuildable[i].from
                           && bld->id <= ft->buildingsBuildable[i].to ) {
                     printf( "das gebude mit id %d und dem Namen %s kann gebaut werden\n", bld->id, bld->name.c_str() );
                  }
               }
            }
*/
/*            for ( int i = 0; i  < ft->vehiclesBuildable.size(); i++ ) {
               printf("es knnen die einheiten mit ids von %d bis %d gebaut werden\n", ft->vehiclesBuildable[i].from, ft->vehiclesBuildable[i].to );
               for ( int b = 0; b < vehicletypenum; b++ ) {
                  pvehicletype veh = getvehicletype_forpos ( b );
                  if (     veh->id >= ft->vehiclesBuildable[i].from
                        && veh->id <= ft->vehiclesBuildable[i].to ) {
                     printf( "die einheit mit id %d und dem Namen %s kann gebaut werden\n", veh->id, veh->getName().c_str() );
                  }
               }
            }
*/
/*            for ( int i = 0; i < ft->objectsBuildable.size(); i++ ) {
               printf("es knnen die Objekte mit ids von %d bis %d gebaut werden\n", ft->objectsBuildable[i].from, ft->objectsBuildable[i].to );
               for ( int b = 0; b < objecttypenum; b++ ) {
                  pobjecttype obj = getobjecttype_forpos ( b );
                  if (     obj->id >= ft->objectsBuildable[i].from
                        && obj->id <= ft->objectsBuildable[i].to ) {
                     printf( "die einheit mit id %d und dem Namen %s kann gebaut werden\n", obj->id, obj->name.c_str() );
                  }
               }
            }
*/
            // ABSCHLU DER DOKUMENTE

            fprintf ( detailed1, "</body></html>\n");
            fprintf ( detailed2, "</body></html>\n");
            fprintf ( detailed3, "</body></html>\n");
            fprintf ( detailed4, "</body></html>\n");
            fprintf ( detailed5, "</body></html>\n");
            fprintf ( detailed6, "</body></html>\n");
            // Ende des Einheiten Dokuments

            fclose ( detailed );
            fclose ( detailed1 );
            fclose ( detailed2 );
            fclose ( detailed3 );
            fclose ( detailed4 );
            fclose ( detailed5 );
            fclose ( detailed6 );
            // closing the file

            printf(" done \n" );
            // we are writing this not to a file, but the screen

         }

      }

      // Dokument bersicht Ende

      fprintf( overview , "</table></body></html>\n" );
      fprintf ( overview1, "</body></html>\n" );

      fclose ( overview );
      fclose ( overview1 );

   } /* endtry */
   catch ( tfileerror err ) {
      fatalError("fatal error accessing file " + err.getFileName() );
      return 1;
   } /* endcatch */
   catch ( ASCmsgException err ) {
      fatalError("a fatal exception occured: " + err.getMessage() );
      return 2;
   } /* endcatch */
   catch ( ASCexception ) {
      fatalError("\na fatal exception occured\n" );
      return 2;
   } /* endcatch */

   return 0;
};



