::PYTHON::

"""
    Quota-committal-based version of 'vos partinfo'

    This tool displays output similar to the output of 'vos partinfo'
    but instead of showing 'K free' on a partition, it shows the number
    of K uncommitted quota-wise.  That is, when volumes are created,
    they are assigned a quota, and as such, that space should be technically
    marked as unavailable space, even if the volume is not full of data.
    This tool will show you how much space is "truly" free for your
    committal to a new or different volume on the same partition.

    * FIX THIS -- Show usage info
"""

sitelib = '::LIBDIR::'

import sys, re
sys.path.append(sitelib)

try:
    import afs_quotapartinfo
    import afs_site
except:
    print "Failed to import AFS Tool Suite libraries from", sitelib
    sys.exit(1)

if len(sys.argv) < 2 or len(sys.argv) > 3:
    print "Usage: quota_partinfo <server> [partition]"
    print ""
    print "Examples: quota_partinfo srv1"
    print "          quota_partinfo srv3 c"
    print "          quota_partinfo meow.tchhht.com /vicepc"
    sys.exit(1)

if len(sys.argv) == 2:
    server = sys.argv[1]
    partition = ''
else:
    server = sys.argv[1]
    partition = sys.argv[2]

qpidata = afs_quotapartinfo.QuotaPartinfoData(server, partition)
qpidata.load()
qpidata.printReport()

#-----------------------------------------------------------------------------#
#                (c) Copyright 2000 The MITRE Corporation                     #
#-----------------------------------------------------------------------------#
