::PYTHON::

"""
    Script to make sure things are replicated that need to be.  This is
    not a library to be imported.

    Configured with a set of regular expressions, which represent volume
    name patterns expected to be replicated, examines the contents of the
    VLDB to see if volumes actually are replicated.

"""

# Where can we find the ATS libs?
sitelib = '::LIBDIR::'

import sys, re
sys.path.append(sitelib)
import afs_vldb, afs_paths, afs_space_usage_db

cfp = afs_space_usage_db.SpaceUsageDatabase()

crexps = []
for s in cfp.getSections():
    if cfp.isReplicated(s):
        r = cfp.getRegexp(s)
        crexps.append(re.compile(r))

v = afs_vldb.VLDBData()
v.load()

for e in v.getEntries():
    vname = e.getVName()
    for c in crexps:
        match = c.match(vname)
        if match != None:
            numsites = len(e.getROsites())
            if numsites < 1:
                print vname, "is not replicated and MIGHT need to be."

#-----------------------------------------------------------------------------#
#                (c) Copyright 2000 The MITRE Corporation                     #
#-----------------------------------------------------------------------------#
