[= AutoGen5 template -*-texinfo-*-

##  -*- Mode: texinfo -*- 
## 
##  AutoOpts copyright 1992-1997 Bruce Korb
## 
## Author:            Bruce Korb <bkorb@gnu.org>
## Maintainer:        Bruce Korb <bkorb@gnu.org>
## Created:           Tue Sep 15 13:13:48 1998
## Last Modified:     Mar 4, 2001
##            by:     Bruce Korb <bkorb@gnu.org>
## ---------------------------------------------------------------------
## $Id: doc.tpl,v 2.71 2001/03/11 02:53:11 bkorb Exp $
## ---------------------------------------------------------------------
## Text:

=]

AutoOpts [=
`( . ${top_srcdir}/VERSION > /dev/null 2>&1 || :
echo ${AO_CURRENT-8}.${AO_REVISION-0} )`
=] is bundled with AutoGen.  It is a tool that virtually eliminates
the hassle of processing options and keeping man pages, info docs and
usage text up to date.  This package allows you to specify several program
attributes, up to a hundred option types and many option attributes.
From this, it then produces all the code necessary to parse and handle
the command line and initialization file options, and the documentation
that should go with your program as well.

AutoOpts is distributed under The GNU General Public License with the
Library extentions (LGPL).  It is in no way a "lesser" license.
You have greater license with it.

@menu
* Features::          AutoOpts Features
* Quick Start::       Quick Start
* opts.def::          Option Definitions File
* AutoOpts API::      Programmatic Interface
* option descriptor:: Option Descriptor File
* Using AutoOpts::    Using AutoOpts
* shell options::     AutoOpts for Shell Scripts
* AutoInfo::          Automated @samp{Invoking Info} Doc
* AutoMan pages::     Automated Man Pages
@end menu

@node Features
@section AutoOpts Features
@cindex features

AutoOpts supports option processing; option state saving; and
program documentation with the following features:

@enumerate
@item
POSIX-compliant short (flag) option processing, if your options specify
at least one option @code{value} (@pxref{Optional Attributes}).

@item
GNU-style long options processing, if you specify @code{long-opts}
(@pxref{program attributes}) as a global program attribute.  Long options
are recognized without case sensitivity, and they may be abbreviated to
the minimum length that is unique within the set of program options.

@item
Process environment variable initializations, if the @code{environrc}
program attribute is specified and the variable(s) exist.
@xref{program attributes}.

@item
Process initialization/rc files, if the @code{homerc} program attribute(s)
are specified and the file(s) exist).  @xref{loading rc files},
and @xref{program attributes}.

@item
Store the option state into an initialization/rc file.
@xref{saving rc files}.

@item
Verify that required options are present the
required minimum number of times on the command line.
@xref{Optional Attributes}.

@item
Verify that options do not appear more than the maximum number
of times.
@xref{Optional Attributes}.

@item
Verify that conflicting options do not appear together.
@xref{Multiply Optional}.

@item
Verify that options that require the presence of other options
are, in fact, used in the presence of other options.
@xref{Multiply Optional}.

@item
Provides a callable routine (@pxref{optionLoadLine}) to parse a line of
text as if it were a line from one of the RC/INI files.  (Consequently,
you may stash options in a text file you process and pass the relevant
text for option processing.)

@item
@code{help} and @code{more-help} are automatically supported.
@code{more-help} will automatically page the generated help.
AutoOpts produces usage information through the library routine
@code{optionUsage()}.  It will print out the invocation syntax and a
list of every option.

@noindent
Two levels of usage are supported.  If the user supplies an invalid
(unknown) option, then the @i{brief} mode is emitted.  That contains
simply the usage line and listing of valid options.  The @i{extended}
mode is used when the @samp{--help} or @samp{--more-help} is specified
on the command line.  This mode will add information about how the
option is treated (if there is any special treatment for it), and it
will display any @samp{detail} text specified for the program.

@item
By adding a @samp{doc} and @samp{arg_name} attributes to each option,
AutoGen will also be able to produce a man page and the @samp{invoking}
section of a texinfo document.  These documentation templates will also
weave in the @samp{explain} and @samp{detail} program attributes as well.

@item
Produce a #define for the program version that can be
used by the library routine @samp{doVersion()}.

@item
Insert the option processing state into Scheme-defined variables.
Thus, Guile based applications that are linked with private
@code{main()} routines can take advantage of all of AutoOpts' functionality.

@item
If @code{TEST_MAIN} is defined, the output @file{.c} file will contain a
main routine that will be compiled when @code{TEST_<prog-name>_OPTS} is
defined.  @xref{shell options}.  If you choose to compile this program,
it is currently capable of producing one of three results:

@enumerate a
@item
If @code{TEST_MAIN} is defined to contain 3 or fewer characters
(e.g., "yes"), then it will produce a program that processes the
arguments and writes to standard out portable shell commands
containing the digested options (i.e., it will call @code{putBourneShell}).

@item
If @code{TEST_MAIN} is set to @code{putShellParse}, it will produce a
program that will generate portable shell commands to parse the defined
options.  The expectation is that this result will be copied into a
shell script and used there.

@item
If @code{TEST_MAIN} is set to anything else, it must be
a routine name and that routine will be called with
a pointer to the option descriptions as the single argument.
You must supply this routine and, obviously, you can
cause it to do whatever you wish it to do.
@end enumerate

@item
Long options can be specified as having enabling or disabling prefixes.
For example, the @code{mumble} option may have an enabling @code{must}
prefix and a disabling @code{dont}, yielding @code{--must-mumble} and
@code{--dont-mumble} as recognized options.  @code{--mumble} will
@strong{not} be recognized.

@item
If a global program attribute @code{version} is supplied, then
a GNU-compliant @samp{--version} option will be supported.

@item
There are facilities in place to allow libraries to intermingle their
command line and initialization options with client program options.
@end enumerate

@noindent
Explanatory details:
@menu
* loading rc files::  loading rc files
* saving rc files::   saving rc files
* optionLoadLine::    process a text string for options
@end menu

@node loading rc files
@unnumberedsubsec loading rc files
@cindex loading rc files
Initialization files are enabled by specifying the program attribute
@code{homerc} (@pxref{program attributes}).  The initialization values
are identified by the long option name followed by white space and any
associated value.  The value, if any, will continue through the end of
the last line not continued with a backslash.  Leading and trailing
white space is stripped.

Initialization files are selected both by the @code{homerc} entries and,
optionally, via an automatically supplied command line option.  The
first component of the @code{homerc} entry may be an environment
variable such as @code{$HOME}, or it may also be @code{$$} (@strong{two}
dollar sign characters) to specify the directory of the executable.
For example:

@example
homerc = "$$/../share/autogen";
@end example

The initialization files are processed in the order they are specified
by the @code{homerc} attribute, so that each new file will normally
override the settings of the previous files.  A few options may be
marked for @code{immediate action} (@pxref{immediate action}).  Any such
options are acted upon in @strong{reverse} order.  The disabled
@code{load-opts} (@code{--no-load-opts}) option, for example, is an
immediate action option.  Its presence in the last @code{homerc} file
will prevent the processing of any prior @code{homerc} files.

Further initialization file processing can be @strong{suppressed} by
specifying @code{--no-load-opts} on the command line, or
@code{PROGRAM_LOAD_OPTS=no} in the environment, or @code{no-load-opts}
in any of the specified @code{homerc} files.

@noindent
will cause the AutoOpts library to look in the normal autogen datadir
for an initialization file.

@node saving rc files
@unnumberedsubsec saving rc files
@cindex saving rc files
When initialization files are enabled for an application, the user is
also provided with an automatically supplied @code{--save-opts} option.
All of the known option state will be written to either the specified
output file or, if it is not specified, then to the last specified
@code{homerc} file.

@node optionLoadLine
@unnumberedsubsec process a text string for options
@cindex optionLoadLine
This routine expects a NUL-terminated string to contain a long option
name followed, optionally, by a string value.  Leading and trailing
white space is trimmed from the value, but otherwise new lines are
not discarded.  The caller is expected to have NUL terminated the
string at the correct point.

@node Quick Start
@section Quick Start
@cindex Quick Start

Since it is generally easier to start with a simple example than it is
to look at the options that AutoGen uses itself, here is a very simple
AutoOpts example.  You can copy this example out of the Info file and
into a source file to try it.  You can then embellish it into what you
really need.

Assume you have a program named @code{check} that takes
two options:

@enumerate
@item
A list of directories to check over for whatever it is @code{check} does.
You want this option available as a POSIX-style flag option
and a GNU long option.  You want to allow as many of these
as the user wishes.
@item
An option to show or not show the definition tree being used.
Only one occurrence is to be allowed, specifying one or the other.
@end enumerate

@noindent
First, specify your program attributes and its options to AutoOpts,
as with the following example.

@smallexample
AutoGen Definitions options;
prog-name     = check;
prog-title    = "Checkout Automated Options";
long-opts;

flag = @{
    name      = check_dirs;
    value     = L;        /* flag style option character */
    arg_type  = string;   /* option argument indication  */
    max       = NOLIMIT;  /* occurrence limit (none)     */
    stack_arg;            /* save opt args in a stack    */
    descrip   = "Checkout directory list";
@};

flag = @{
    name      = show_defs;
    descrip   = "Show the definition tree";
    disable   = dont;     /* mark as enable/disable type */
                          /* option.  Disable as `dont-' */
@};
@end smallexample

@noindent
Then perform the following steps:

@enumerate
@item
@code{autogen -L $prefix/share/autogen -DTEST_MAIN=yes checkopt.def}
@item
@code{cc -o check -DTEST_CHECK_OPTS -g checkopt.c -L $prefix/lib -lopts}
@end enumerate

@noindent
And now, @code{./check --help} yields:

@smallexample
check - Checkout Automated Options
USAGE:  check [-<flag> [<val>]]... [--<name>[@{=| @}<val>]]...
  Flg Arg Option-Name    Description
   -L YES check-dirs     Checkout directory list
                                - may appear without limit
      no  show-defs      Show the definition tree
                                - disabled as --dont-show-defs
   -? no  help           Display usage information and exit
   -! no  more-help      Extended usage information passed thru pager

Options may be specified by doubled markers and their name
or by a single marker and the flag character/option value.
@end smallexample

Normally, however, you would compile @file{checkopt.c} as in:

@smallexample
cc -o checkopt.o -I$prefix/include -c checkopt.c
@end smallexample

and link @file{checkopt.o} with the rest of your program.
The main program causes the options to be processed
by calling @code{optionProcess}:

@smallexample
main( int argc, char** argv )
@{
  @{
    int optct = optionProcess( &checkOptions, argc, argv );
    argc -= optct;
    argv += optct;
  @}
@end smallexample

The options are tested and used as in the following fragment:

@smallexample
  if (HAVE_OPT( SHOW_DEFS )) @{
    int    dirct = STACKCT_OPT( CHECK_DIRS );
    char** dirs  = STACKLST_OPT( CHECK_DIRS );
    while (dirct-- > 0) @{
      char* dir = *dirs++;
      ...
@end smallexample

A lot of magic happens to make this happen.
The rest of this chapter will help you learn how to specify
the option processing and how to examine the resulting state.

@node opts.def
@section Option Definitions File
@cindex opts.def

This file contains the AutoGen definitions that describe the options for
a particular program.  There are several groups of definitions.  The
first describes the program and over-all option processing attributes.
The second group describes the name, usage and other attributes related
to each option.  The third group are used for documenting your program
and are @strong{not} used for command line processing.  The last section
below will describe the command line options that are automatically
provided by AutoOpts.

The list of program and option attributes is quite extensive.  Keep in
mind that the majority are rarely used and can be safely ignored.
However, when you have special option processing requirements, the
flexibility is there.

@menu
* program attributes::        Program Description Attributes
* option attributes::         Option Attributes
* documentation attributes::  Man and Info doc Attributes
* immediate action::          Immediate Action Attributes
* standard options::          Automatically Supported Options
@end menu

@node program attributes
@subsection Program Description Attributes
@cindex program attributes

The following global option definitions are used to define attributes of
the entire program.  The first two are required of every program.  The
rest have been alphabetized.  Except as noted, there may be only one
copy of each of these definitions:

@table @samp
@cindex prog-name
@item prog-name
This attribute is required and its value must follow legal C syntax for
variables.  Because of this constraint, if the file name of your program
is different from this, then use the @var{prog-file-name}, described
below.

@cindex prog-title
@item prog-title
This attribute is required and may be any descriptive text.

@cindex prog_desc
@item prog_desc @strong{and}
@cindex opts_ptr
@itemx opts_ptr
These define global pointer variables that point to the program
descriptor and the first option descriptor for a library option.  This
is intended for use by certain libraries that need command line and/or
initialization file option processing.  These definitions have no effect
on the option template output, but are used for creating a library
interface file.  Normally, the first "option" for a library will be a
documentation option that cannot be specified on the command line, but
is marked as @code{settable}.  The library client program will invoke the
@code{SET_OPTION} macro which will invoke a handler function that will
finally set these global variables.

@cindex allow_errors
@item allow_errors
The presence of this attribute indicates ignoring any command line
option errors.  This may also be turned on and off by invoking the
macros @code{ERRSKIP_OPTERR} and @code{ERRSTOP_OPTERR} from the
generated interface file.

@cindex argument
@item argument
Specifies the syntax of the arguments that @strong{follow} the options.
It may not be empty, but if it is not supplied, then option processing
must consume all the arguments.  If it is supplied and starts with an
open bracket (@code{[}), then there is no requirement on the presence or
absence of command line argument following the options.  Lastly, if it
is supplied and does not start with an open bracket, then option
processing must @strong{not} consume all of the command line arguments.

@cindex copyright
@item copyright

The @code{copyright} is a structured value containing three to five
values.  If @code{copyright} is used, then the first three are required.

@enumerate
@item
@file{date} - the list of applicable dates for the copyright.
@item
@file{owner} - the name of the copyright holder.
@item
@file{type} - specifies the type of distribution license.
AutoOpts/AutoGen will automatically support the text of the GNU Public
License (@file{GPL}), the GNU Public License with Library extensions
(@file{LGPL}), the Free BSD license (@file{BSD}), and a
write-it-yourself copyright notice (@file{NOTE}).  Only these values are
recognized.
@item
@file{text} - the text of the copyright notice.  It is only needed
if @file{type} is set to @file{NOTE}.
@item
@file{author} - in case the author name is to appear in the documentation
and is different from the copyright owner.
@end enumerate
@*
An example of this might be:
@example
copyright = @{
    date  = "1992-[=`date +%Y`=]";
    owner = "Bruce Korb";
    type  = GPL;
@};
@end example

@cindex prog-file-name
@item prog-file-name
If the @var{prog-name} attribute does not match the program
file name, then this attribute must be supplied so that where
a file name is required, it can be correctly supplied.

@cindex detail
@item detail
This string is added to the usage output when the HELP option is
selected.

@cindex environrc
@item environrc
Indicates looking in the environment for values of variables named
@*
PROGRAM_OPTNAME.
@*
where @code{PROGRAM} is the upper cased C-name of the program and
@code{OPTNAME} is the upper cased C-name of the option.  The
@code{C-name}s are the regular names with all special characters
converted to underscores (@code{_}).

If a particular option may be disabled, then its disabled state
is indicated by setting the value to the disablement prefix.
So, for example, if the disablement prefix were @code{dont}, then
you can disable the @code{optname} option by setting the
@code{PROGRAM_OPTNAME} environment variable to `@i{dont}'.
@xref{Optional Attributes}.

@cindex explain
@item explain
Gives additional information whenever the usage routine is invoked..

@cindex export
@item export
This string is inserted into the .h interface file.  Generally used for
global variables or @code{#include} directives required by
@code{flag_code} text and shared with other program text.

@cindex homerc
@item homerc
Specifies either a directory or a file using a specific path (like @code{.}
or @file{/usr/local/share/progname}) or an environment variable (like
@file{$HOME/rc/} or @file{$PREFIX/share/progname}) or the directory
where the executable was found (@file{$$[/...]}) to use to try to find
the rcfile.  Use as many as you like.  The presence of this attribute
activates the @code{SAVE_OPTS} and @code{LOAD_OPTS} options.
@xref{loading rc files}.

@cindex include
@item include
This string is inserted into the .c file.  Generally used for global
variables required only by @code{flag_code} program text.

@cindex long-opts
@item long-opts
Presence indicates GNU-standard long option processing.  If any options
do not have an option value (flag character) specified, and least one
does specify such a value, then you must specify @code{long-opts}.  If
none of your options specify an option value (flag character) and you do
not specify @code{long-opts}, then:

@itemize @bullet
@item
all program arguments are processed as named options
@item
the flag markers @code{-} and @code{--} are completely optional
@item
the @code{argument} program attribute is disallowed
@end itemize

@cindex prefix
@item prefix
This value is inserted into @strong{all} global names.  This will
disambiguate them if more than one set of options are to be compiled
into a single program.

@cindex rcfile
@item rcfile
Specifies the initialization file name.  This is only useful if you
have provided at least one @code{homerc} attribute.
@noindent
default: .<prog-name>rc

@cindex test_main
@item test_main
Creates a test main procedure for testing option processing.  The
resulting program may also be used to process the arguments of a shell
script.  You would use it thus:

@example
eval `./programopts $@@`
if [ -z "$@{OPTION_CT@}" ] ; then exit 1 ; fi
shift $@{OPTION_CT@}
@end example

@cindex guile-main
@item guile-main
Creates a guile-style main and inner-main procedures.
The inner main procedure will call @code{optionProcess()} and will
invoke any code specified by this attribute.  If this attribute
does not specify any code, then calls to the AutoOpts library procedure
@code{export_options_to_guile()} and then @code{scm_shell()} will
be inserted into @code{inner_main()}.

@cindex before-guile-boot
@item before-guile-boot
If @code{guile-main} has been specified and if this is specified
as well, then this code will be inserted into the actual @code{main()}
procedure before @code{gh_enter()} is called.

@cindex rcsection
@item rcsection
If you have a collection of option descriptions that are intended
to use the same RC/ini files, then you will likely want to partition
that file.  That will be possible by specifying this attribute
with AutoOpts version 9.2 and later.

Every RC file will be considered partitioned by lines that commence with
the square open bracket (@code{[}).  All text before such a line is
always processed.  Once such a line is found, the @strong{upper-cased}
c-variable-syntax program name will be compared against the text
following that bracket.  If there is a match and the next character
after that is a square close bracket (@code{]}), then the section is
processed and the file closed.  Otherwise, the section is ignored and a
matching section is searched for.

For exampe, if the @code{foo-bar} options had a sectioned RC file,
then a line containing @code{[FOO_BAR]} would be searched for.

@cindex usage
@item usage
Optionally names the usage procedure, if the library routine
@code{optionUsage()} does not work for you.  If you specify
@code{gnu_usage} as the value of this attribute, for example,
you will use a procedure by that name for displaying usage.
Of course, you will need to provide that procedure.

@cindex version
@item version
Specifies the program version and activates the VERSION option.

@cindex automatic option flags
@item automatic option flags
If POSIX-style flag options are being used by an application,
then the flag characters for the automatically supported options
are normally selected by AutoOpts.  However, because you cannot
make a choice that everyone will accept, it is also possible to
specify the flag character to use.  The five automatic options,
the attribute to use to change the flag character, and the default
flag characters are:
@example
--help         help-value       -?
--more-help    more-help-value  -!
--version      version-value    -v
--save-opts    save-opts-value  ->
--load-opts    load-opts-value  -<
@end example
Note that some of these default characters are special to the shell.
Your users will need to quote them to use them.

If the @code{value} specified is empty, then the flag for that option
is disabled.  Otherwise, the value must be set to a single character.
@end table

@node option attributes
@subsection Option Attributes
@cindex option attributes

For each option you wish to specify, you must have a block macro named
@code{flag} defined.  It @strong{MUST} contain at least two defined text
macros named @code{name} and @code{descrip}.  If any options do not have a
@code{value} macro, then the @code{long-opts} global text macro must be
defined.  As a special exception, if no options have a @code{value}
@strong{and} @code{long-opts} is not defined @strong{and} @code{argument} is
not defined, then all arguments to the program are named and the @code{-}
and @code{--} command line markers are completely optional.

There are four categories of option attributes.  The fifth section below
describes what data are available for writing option processing code.

@menu
* Required Attributes::         Required Attributes
* Optional Attributes::         Singly Optional Attributes
* Multiply Optional::           Multiply Optional Attributes
* Option Processing::           Special Option Processing
* Option Processing Data::      Data for Option Processing
@end menu

@node Required Attributes
@subsubsection Required Attributes
@cindex Required Attributes

Every option must have exactly one copy of both of these attributes.

@table @samp
@cindex name
@item name
Long name for the option.  Even if you are not accepting long options
and are only accepting flags, it must be provided.  AutoOpts generates
private, named storage that require this name.

@cindex descrip
@item descrip
Except for documentation options, a @strong{very} brief description
of the option.  About 40 characters on one line, maximum.
It appears on the @code{usage()} output next to the option name.
Documentation options appear on one or more lines by themselves,
visually separating the usage options.
@end table

@node Optional Attributes
@subsubsection Singly Optional Attributes
@cindex Optional Attributes

These option attributes are optional.  Any that do appear in the
definition of a flag, may appear only once.

@table @samp
@cindex documentation
@item documentation
If present, disables all other attributes except @code{settable},
@code{call_proc} and @code{flag_code}.  @code{settable} must be and is
only specified if @code{call_proc} or @code{flag_code} has been specified.
When present, the @code{descrip} attribute will be displayed only
when the @code{--help} option has been specified.  It will be displayed
flush to the left hand margin and may consist of one or more lines
of text.  The name of the option will not be printed.

The option may be made settable if, for example, you are supplying
options to a client program.  In that fashion, your handler routine for
the documentation option can save the address of the program descriptor
and your first option (@code{prog_desc} and @code{opts_ptr}) in global
pointers.

@cindex value
@item value
The flag character to specify for traditional option flags.  e.g. @code{-L}.

@item flag_arg
This attribute has been eliminated.  Please use the appropriate
combination of @var{arg_type}, @var{arg_default} and @var{arg_optional}.

@cindex arg_type
@item arg_type
This specifies the type of argument the option will take.
If not present, the option cannot take an argument.
If present, it must be one of the following four.
The bracketed part of the name is optional.

@table @samp
@item str[@i{ing}]
The argument may be any arbitrary string.

@item num[@i{ber}]
The argument must be a correctly formed number, without any trailing
U's or L's.

@item bool[@i{ean}]
The argument will be interpreted and always yield either AG_TRUE or
AG_FALSE.  False values are: the empty string, the number zero, or a
string that starts with @code{f}, @code{F}, @code{n} or @code{N}
(representing False or No).  Anything else will be interpreted as True.

@item key[@i{word}]
The argument must match a specified list of strings.
Assuming you have named the option, @code{opt-name},
the strings will be converted into an enumeration of type @code{te_Opt_Name}
with the values @code{OPT_NAME_KEYWORD}.  If you have @strong{not}
specified a default value, the value @code{OPT_NAME_UNDEFINED} will be
inserted with the value zero.  The option will be initialized to that
value.  You may now use this in your code as follows:

@smallexample
te_Opt_Name opt = OPT_VALUE_OPT_NAME;
switch (opt) @{
case OPT_NAME_UNDEFINED:  /* undefined things */ break;
case OPT_NAME_KEYWORD:    /* `keyword' things */ break;
default: /* utterly impossible */ ;
@}
@end smallexample
@end table

@cindex arg_optional
@item arg_optional
This attribute indicates that the user does not have to supply an
argument for the option.  This is only valid if the @var{arg_type} is
@code{string} or @code{keyword}.  If it is @code{keyword}, then
this attribute may also specify the default keyword to assume when
the argument is not supplied.  Without such a specification, the
default keyword will be the zero-valued keyword.

@cindex arg_default
@item arg_default
This specifies the default value to be used when the option is
not specified or preset.

@cindex min
@item min
Minimum occurrence count.  If present, then the option @strong{must}
appear on the command line.  Preset values do not count towards the
minimum occurrence count.

@cindex max
@item max
Maximum occurrence count (invalid if @var{disable} present).

@cindex enable
@item enable
Long-name prefix for enabling the option (invalid if @var{disable}
@strong{not} present).

@cindex disable
@item disable
Prefix for disabling (inverting sense of) the option.

@cindex enabled
@item enabled
If default is for option being enabled.  (Otherwise, the OPTST_DISABLED
bit is set at compile time.)

@cindex no_preset
@item no_preset
If presetting this option is not allowed.  (Thus, environment variables
and values set in rc/ini files will be ignored.)

@cindex settable
@item settable
If the option can be set outside of option processing.  If this
attribute is defined, special macros for setting this particular option
will be inserted into the interface file.  For example,
@code{TEMPL_DIRS} is a settable option for AutoGen, so a macro named
@code{SET_OPT_TEMPL_DIRS(a)} appears in the interface file.  This
attribute interacts with the @var{documentation} attribute.

@cindex equivalence
@item equivalence
Generally, when several options are mutually exclusive and basically serve
the purpose of selecting one of several processing modes, these options
can be considered an equivalence class.  Sometimes, it is just easier to
deal with them as such.

For an option equivalence class, there is a single occurrence counter
for all the members of the class.  All members of the equivalence class
must contain the same equivalenced-to option, including the
equivalenced-to option itself.  Thus, it must be a member.

As an example, @code{cpio(1)} has three options @code{-o}, @code{-i},
and @code{-p} that define the operational mode of the program
(@code{create}, @code{extract} and @code{pass-through}, respectively).
They form an equivalence class from which one and only one member must
appear on the command line.  If @code{cpio} were an AutoOpt-ed program,
then each of these option definitions would contain:

@example
equivalence = create;
@end example

and the program would be able to determine the operating mode
with code that worked something like this:

@example
switch (WHICH_IDX_CREATE) @{
case INDEX_OPT_CREATE:       ...
case INDEX_OPT_EXTRACT:      ...
case INDEX_OPT_PASS_THROUGH: ...
default:    /* cannot happen */
@}
@end example

@cindex default
@item default
If your program processes its arguments in named-option mode, then you
may select @strong{one} of your options to be the default option.  That
option must have a required option argument.

If you have done this, then any arguments that do not match an option
name and do not contain an equal sign (@code{=}) will be interpreted as
option arguments to the default option.
@end table

@node Multiply Optional
@subsubsection Multiply Optional Attributes
@cindex Multiply Optional

These attributes may be used as many times as you need.
They are used at the end of the option processing to verify
that the context within which each option is found does not
conflict with the presence or absence of other options.

This is not a complete cover of all possible conflicts and
requirements, but it simple to implement and covers the
more common situations.

@table @samp
@cindex flags_must
@item flags_must
one entry for every option that @strong{must} be present
when this option is present

@cindex flags_cant
@item flags_cant
one entry for every option that @strong{cannot} be present
when this option is present
@end table

@node Option Processing
@subsubsection Special Option Processing
@cindex Option Processing

The first two attributes interact with the @code{documentation} and
@code{settable} attributes.  See their documentation above.

Pick zero or one of the next four:

@table @samp
@cindex flag_code
@item flag_code
statements to execute when the option is encountered.
The generated procedure will look like this:

@example
static void
doOpt<name>( tOptions* pOptions, tOptDesc* pOptDesc )
@{
<flag_code>
@}
@end example

Only certain fields within the @code{tOptions} and @code{tOptDesc}
structures may be accessed.  @xref{Option Processing Data}.

@cindex call_proc
@item call_proc
external procedure to call when option is encountered.  The calling
sequence must conform to the sequence defined above for the generated
procedure, @code{doOpt<name>}.  It has the same restrictions
regarding the fields within the structures passed in as arguments.
@xref{Option Processing Data}.

@cindex flag_proc
@item flag_proc
Name of another option whose @code{flag_code} can be executed
when this option is encountered.

@cindex stack_arg
@item stack_arg
Call a special library routine to stack the option's arguments.  Special
macros in the interface file are provided for determining how many of
the options were found (@code{STACKCT_OPT(NAME)}) and to obtain a
pointer to a list of pointers to the argument values
(@code{STACKLST_OPT(NAME)}).
@end table

@node Option Processing Data
@subsubsection Data for Option Processing
@cindex Option Processing Data

The following fields may be used in the following ways and may be used
for read only.  The first set is addressed from the @code{tOptDesc*}
pointer:

@table @samp
@cindex optIndex
@item optIndex
@cindex optValue
@item optValue
These may be used by option procedures to determine which option they
are working on (in case they handle several options).

@cindex optActualIndex
@item optActualIndex
@cindex optActualValue
@item optActualValue
These may be used by option procedures to determine which option was
used to set the current option.  This may be different from the above if
the options are members of an equivalence class.

@cindex optOccCt
@item optOccCt
If AutoOpts is processing command line arguments, then this value will
contain the current occurrence count.  During the option preset phase
(reading rc/ini files and examining environment variables), the value is
zero.

@cindex fOptState
@item fOptState
The field may be tested for the following bit values
(prefix each name with @code{OPTST_}, e.g. @code{OPTST_INIT}):

@table @samp
@item INIT
Initial compiled value.  As a bit test, it will always yield FALSE.

@item SET
The option was set via the @code{SET_OPT()} macro.

@item PRESET
The option was set via an RC/INI file, or a call to the
@code{optionLoadLine()} routine.

@item DEFINED
The option was set via a command line option.

@item SET_MASK
This is a mask of flags that show the set state, one of the
above four values.

@item EQUIVALENCE
This bit is set when the option was selected by an equivalenced option.

@item DISABLED
This bit is set if the option is to be disabled.
(Meaning it was a long option prefixed by the disablement prefix, or
the option has not been specified yet and initializes as @code{disabled}.)
@end table

@cindex pzLastArg
@item pzLastArg
Pointer to the latest argument string.  BEWARE:  If the argument type is
numeric, this will be the argument @strong{value} and not a pointer to a
string.
@end table

The following two fields are addressed from the @code{tOptions*} pointer:

@table @samp
@cindex pzProgName
@item pzProgName
Points to a NUL-terminated string containing the current program
name, as retrieved from the argument vector.

@cindex pzProgPath
@item pzProgPath
Points to a NUL-terminated string containing the full path of
the current program, as retrieved from the argument vector.
(If available on your system.)

@end table

Note:  these fields get filled in during the first call to
@code{optionProcess()}.  All other fields are private, for the exclusive
use of AutoOpts code and is subject to change.

@node documentation attributes
@subsection Man and Info doc Attributes
@cindex documentation attributes

AutoOpts includes AutoGen templates for producing abbreviated man pages
and for producing the invoking section of an info document.  To take
advantage of these templates, you must add several attributes to your
option definitions.

@cindex doc
First, every @code{flag} definition must have a @code{doc} attribute
defined and many will need an @code{arg_name} attribute as well.  The
@code{doc} text should be in plain sentences with minimal formatting.  The
Texinfo commands @code{@@code}, and @code{@@var} will have its enclosed
text made into @strong{\fB} entries in the man page, and the @code{@@file}
text will be made into @strong{\fI} entries.  The @code{arg_name} attribute
is used to display the option's argument in the man page.

@cindex detail
@cindex prog_man_descrip
@cindex prog_info_descrip
Then, you need to supply a brief description of what your program does.
If you already have a @code{detail} definition, this may be sufficient.
If not, or if you need special formatting for one of the manual formats,
then you will need either a definition for @code{prog_man_descrip} or
@code{prog_info_descrip} or both.  These will be inserted verbatim
in the man page document and the info document, respectively.

@cindex man_doc
Finally, if you need to add man page sections like @code{SEE ALSO} or
@code{USAGE} or other, put that text in a @code{man_doc} definition.  This
text will be inserted verbatim in the man page after the @code{OPTIONS}
section and before the @code{AUTHOR} section.

@node immediate action
@subsection Immediate Action Attributes
@cindex immediate action

Certain options may need to be processed early.  For example, in order
to suppress the processing of RC files, it is necessary to process the
command line option @code{--no-load-opts} @strong{before} the RC files
are processed.  To accommodate this, certain options may have their
enabled or disabled forms marked for immediate processing.  The
consequence of this is that they are processed ahead of all other
options in the reverse of normal order.

Normally, the first options processed are the options specified in the
first @code{homerc} file, followed by then next @code{homerc} file
through to the end of RC file processing.  Next, environment variables
are processed and finally, the command line options.  The later
options override settings processed earlier.  That actually gives them
higher priority.  Command line immediate action options actually have
the lowest priority of all.  They would be used only if they are to have
an effect on the processing of subsequent options.

@table @samp
@cindex immediate
@item immediate
Use this option attribute to specify that the enabled form of the option
is to be processed immediately.  The @code{help} and @code{more-help}
options are so specified.  They will also call @code{exit()} upon
completion, so they @strong{do} have an effect on the processing
of the remaining options :-).

@cindex immed_disable
@item immed_disable
Use this option attribute to specify that the disabled form of the option
is to be processed immediately.  The @code{load-opts} option is so
specified so that the @code{--no-load-opts} command line option will
suppress the processing of RC files and environment variables.
@end table

@node standard options
@subsection Automatically Supported Options
@cindex standard options

AutoOpts provides automated support for five options.  @code{help} and
@code{more-help} are always provided.  @code{version} is provided if
@code{version} is defined in the option definitions.  @code{save-opts}
and @code{load-opts} are provided if at least one @code{homerc} is
defined.

Below are the option names and flag values.  The flags are activated if
and only if at least one user-defined option also uses a flag value.
They may be changed to characters of your choosing by specifying
the program options @code{mumble-value = 'x';}, where @code{mumble} is
one of the names below and @code{x} is the character of your choice.

@table @samp
@item help -?
This option will immediately invoke the @code{USAGE()} procedure
and display the usage line, a description of each option with
its description and option usage information.  This is followed
by the contents of the definition of the @code{detail} text macro.

@item more-help -!
This option is identical to the @code{help} option, except that
it also includes the contents of the @code{detail-file} file
(if provided and found), plus the output is passed through
a pager program.  (@code{more} by default, or the program identified
by the @code{PAGER} environment variable.)

@item version -v
This will print the program name, title and version.
If it is followed by the letter @code{c} and
a value for @code{copyright} and @code{owner} have been provided,
then the copyright will be printed, too.
If it is followed by the letter @code{n}, then the full
copyright notice (if available) will be printed.

@item save-opts ->
This option will cause the option state to be printed in
RC/INI file format when option processing is done but not
yet verified for consistency.  The program will terminate
successfully without running when this has completed.
Note that for most shells you will have to quote or escape the
flag character to restrict special meanings to the shell.

The output file will be the RC/INI file name (default or provided
by @code{rcfile}) in the last directory named in a @code{homerc}
definition

@item load-opts -<
This option will load options from the named file.  They
will be treated exactly as if they were loaded from the
normally found RC/INI files, but will not be loaded until
the option is actually processed.  This can also be used
within an RC/INI file causing them to nest.

It is ultimately intended that specifying the option,
@code{no-load-opts} will suppress the processing of rc/ini files and
environment variables.  To do this, AutoOpts must first implement
pre-scanning of the options, environment and rc files.
@end table

@node AutoOpts API
@section Programmatic Interface
@cindex AutoOpts API

The user interface for access to the argument information is completely
defined in the generated header file and in the portions of the
distributed file "options.h" that are marked "public".

In the following macros, text marked @code{<OPT_NAME>} or @code{optname}
is the name of the option @strong{in upper case} and @strong{segmented
with underscores @code{_}}.  The macros and enumerations defined in the
options header (interface) file are used as follows:

To see how these @code{#define} macros are used in a program,
the reader is referred to the several @file{opts.h} files
included with the AutoGen sources.

@menu
* CLEAR_OPT::               CLEAR_OPT( <NAME> ) - Clear Option Markings
* COUNT_OPT::               COUNT_OPT( <NAME> ) - Definition Count
* DESC::                    DESC( <NAME> ) - Option Descriptor
* DISABLE_OPT_name::        DISABLE_OPT_name - Disable an option
* ENABLED::                 ENABLED( <NAME> ) - Is Option Enabled?
* ERRSKIP_OPTERR::          ERRSKIP_OPTERR - Ignore Option Errors
* ERRSTOP_OPTERR::          ERRSTOP_OPTERR - Stop on Errors
* HAVE_OPT::                HAVE_OPT( <NAME> ) - Have this option?
* ISSEL_OPT::               ISSEL_OPT( <NAME> ) - Is Option Selected?
* ISUNUSED_OPT::            ISUNUSED_OPT( <NAME> ) - Never Specified?
* OPTION_CT::               OPTION_CT - Full Count of Options
* OPT_ARG::                 OPT_ARG( <NAME> ) - Option Argument String
* OPT_VALUE_name::          OPT_VALUE_name - Option Argument Value
* RESTART_OPT::             RESTART_OPT( n ) - Resume Option Processing
* SET_OPT_name::            SET_OPT_name - Force an option to be set
* STACKCT_OPT::             STACKCT_OPT( <NAME> ) - Stacked Arg Count
* STACKLST_OPT::            STACKLST_OPT( <NAME> ) - Argument Stack
* START_OPT::               START_OPT - Restart Option Processing
* STATE_OPT::               STATE_OPT( <NAME> ) - Option State
* USAGE::                   USAGE( exit-code ) - Usage invocation macro
* VALUE_OPT_name::          VALUE_OPT_name - Option Flag Value
* VERSION::                 VERSION - Version and Full Version
* WHICH_IDX_name::          WHICH_IDX_name - Which Equivalenced Index
* WHICH_OPT_name::          WHICH_OPT_name - Which Equivalenced Option
* teOptIndex::              teOptIndex - Option Index and Enumeration
* OPTIONS_STRUCT_VERSION::  OPTIONS_STRUCT_VERSION - active version
* libopts procedures::      libopts Procedures
@end menu

@node CLEAR_OPT
@subsection CLEAR_OPT( <NAME> ) - Clear Option Markings
@findex CLEAR_OPT

Make as if the option had never been specified.
@code{HAVE_OPT(<NAME>)} will yield @code{FALSE}
after invoking this macro.

@node COUNT_OPT
@subsection COUNT_OPT( <NAME> ) - Definition Count
@findex COUNT_OPT

This macro will tell you how many times the option was
specified on the command line.  It does not include counts
of preset options.

@example
if (COUNT_OPT( NAME ) != desired-count) @{
    make-an-undesirable-message.
@}
@end example

@node DESC
@subsection DESC( <NAME> ) - Option Descriptor
@findex DESC

This macro is used internally by other AutoOpt macros.
It is not for general use.  It is used to obtain the option description
corresponding to its @strong{UPPER CASED} option name argument.
This is primarily used in other macro definitions.

@node DISABLE_OPT_name
@subsection DISABLE_OPT_name - Disable an option
@findex DISABLE_OPT_name

This macro is emitted if it is both settable
and it can be disabled.  If it cannot be disabled, it may
always be CLEAR-ed (see above).

The form of the macro will actually depend on whether the
option is equivalenced to another, and/or has an assigned
handler procedure.  Unlike the @code{SET_OPT} macro,
this macro does not allow an option argument.

@example
DISABLE_OPT_NAME;
@end example

@node ENABLED
@subsection ENABLED( <NAME> ) - Is Option Enabled?
@findex ENABLED

Yields true if the option defaults to disabled and
@code{ISUNUSED_OPT()} would yield true.  It also yields true if
the option has been specified with a disablement prefix,
disablement value or the @code{DISABLE_OPT_NAME} macro was invoked.

@node ERRSKIP_OPTERR
@subsection ERRSKIP_OPTERR - Ignore Option Errors
@findex ERRSKIP_OPTERR

When it is necessary to continue (return to caller)
on option errors, invoke this option.  It is reversible.
@xref{ERRSTOP_OPTERR}.

@node ERRSTOP_OPTERR
@subsection ERRSTOP_OPTERR - Stop on Errors
@findex ERRSTOP_OPTERR

After invoking this macro, if @code{optionProcess()}
encounters an error, it will call @code{exit(1)} rather than return.
This is the default processing mode.  It can be overridden by
specifying @code{allow_errors} in the definitions file,
or invoking the macro @xref{ERRSKIP_OPTERR}.

@node HAVE_OPT
@subsection HAVE_OPT( <NAME> ) - Have this option?
@findex HAVE_OPT

This macro yields true if the option has been specified
in any fashion at all.  It is used thus:

@example
if (HAVE_OPT( NAME )) @{
    <do-things-associated-with-opt-name>;
@}
@end example

@node ISSEL_OPT
@subsection ISSEL_OPT( <NAME> ) - Is Option Selected?
@findex ISSEL_OPT

This macro yields true if the option has been
specified either on the command line or via a SET/DISABLE macro.

@node ISUNUSED_OPT
@subsection ISUNUSED_OPT( <NAME> ) - Never Specified?
@findex ISUNUSED_OPT

This macro yields true if the option has
never been specified, or has been cleared via the
@code{CLEAR_OPT()} macro.

@node OPTION_CT
@subsection OPTION_CT - Full Count of Options
@findex OPTION_CT

The full count of all options, both those defined
and those generated automatically by AutoOpts.  This is primarily
used to initialize the program option descriptor structure.

@node OPT_ARG
@subsection OPT_ARG( <NAME> ) - Option Argument String
@findex OPT_ARG

The option argument value as a pointer to string.
Note that argument values that have been specified as numbers
are stored as numbers.  For such options, use instead the
@code{OPT_VALUE_name} define.  It is used thus:

@example
if (HAVE_OPT( NAME )) @{
    char* p = OPT_ARG( NAME );
    <do-things-with-opt-name-argument-string>;
@}
@end example

@node OPT_VALUE_name
@subsection OPT_VALUE_name - Option Argument Value
@findex OPT_VALUE_name

This macro gets emitted only for options that
take numeric arguments.  The macro yields a word-sized integer
containing the numeric value of the option argument.

@example
int opt_val = OPT_VALUE_NAME;
@end example

@node RESTART_OPT
@subsection RESTART_OPT( n ) - Resume Option Processing
@findex RESTART_OPT

If option processing has stopped (either because of an error
or something was encountered that looked like a program argument),
it can be resumed by providing this macro with the index @code{n}
of the next option to process and calling @code{optionProcess()} again.

@node SET_OPT_name
@subsection SET_OPT_name - Force an option to be set
@findex SET_OPT_name

This macro gets emitted only when the given
option has the @code{settable} attribute specified.

The form of the macro will actually depend on whether the
option is equivalenced to another, has an option argument
and/or has an assigned handler procedure.  If the option has
an argument, then this macro will too.

@example
SET_OPT_NAME( "string-value" );
@end example

@node STACKCT_OPT
@subsection STACKCT_OPT( <NAME> ) - Stacked Arg Count
@findex STACKCT_OPT

When the option handling attribute is specified
as @code{stack_arg}, this macro may be used to determine how
many of them actually got stacked.

Do not use this on options that have not been stacked or has not been
specified (the @code{stack_arg} attribute must have been specified,
and @code{HAVE_OPT(<NAME>)} must yield TRUE).
Otherwise, you will likely page fault.

@example
if (HAVE_OPT( NAME )) @{
    int     ct = STACKCT_OPT(  NAME );
    char**  pp = STACKLST_OPT( NAME );

    do  @{
        char* p = *pp++;
        do-things-with-p;
    @} while (--ct > 0);
@}
@end example

@node STACKLST_OPT
@subsection STACKLST_OPT( <NAME> ) - Argument Stack
@findex STACKLST_OPT

The address of the list of pointers to the
option arguments.  The pointers are ordered by the order in
which they were encountered in the option presets and
command line processing.

Do not use this on options that have not been stacked or has not been
specified (the @code{stack_arg} attribute must have been specified,
and @code{HAVE_OPT(<OPTION>)} must yield TRUE).
Otherwise, you will likely page fault.

@example
if (HAVE_OPT( NAME )) @{
    int     ct = STACKCT_OPT(  NAME );
    char**  pp = STACKLST_OPT( NAME );

    do  @{
        char* p = *pp++;
        do-things-with-p;
    @} while (--ct > 0);
@}
@end example

@node START_OPT
@subsection START_OPT - Restart Option Processing
@findex START_OPT

This is just a shortcut for RESTART_OPT(1) (@xref{RESTART_OPT}.)

@node STATE_OPT
@subsection STATE_OPT( <NAME> ) - Option State
@findex STATE_OPT

If you need to know if an option was set because of
presetting actions (RC/INI processing or environment variables),
versus a command line entry versus one of the SET/DISABLE macros,
then use this macro.  It will yield one of four values:
@code{OPTST_INIT}, @code{OPTST_SET}, @code{OPTST_PRESET}
or @code{OPTST_DEFINED}.  It is used thus:

@example
switch (STATE_OPT( NAME )) @{
    case OPTST_INIT:
        not-preset, set or on the command line.  (unless CLEAR-ed)

    case OPTST_SET:
        option set via the SET_OPT_NAME() macro.

    case OPTST_PRESET:
        option set via an RC/INI file or environment variable

    case OPTST_DEFINED:
        option set via a command line option.

    default:
        cannot happen :)
@}
@end example

@node USAGE
@subsection USAGE( exit-code ) - Usage invocation macro
@findex USAGE

This macro invokes the procedure registered to display
the usage text.  Normally, this will be @code{optionUsage} from the
AutoOpts library, but you may select another procedure by specifying
@code{usage = "proc_name"} program attribute.  This procedure must
take two arguments: first, a pointer to the option descriptor, and
second the exit code.  The macro supplies the option descriptor
automatically.  This routine is expected to call @code{exit(3)} with
the provided exit code.

The @code{optionUsage} routine also behaves differently depending
on the exit code.  If the exit code is zero, it is assumed that
assistance has been requested.  Consequently, a little more
information is provided than when displaying usage and exiting
with a non-zero exit code.

@node VALUE_OPT_name
@subsection VALUE_OPT_name - Option Flag Value
@findex VALUE_OPT_name

This is a #define for the flag character used to
specify an option on the command line.  If @code{value} was not
specified for the option, then it is a unique number associated
with the option.  @code{option value} refers to this value,
@code{option argument} refers to the (optional) argument to the
option.

@example
switch (WHICH_OPT_OTHER_OPT) @{
case VALUE_OPT_NAME:
    this-option-was-really-opt-name;
case VALUE_OPT_OTHER_OPT:
    this-option-was-really-other-opt;
@}
@end example

@node VERSION
@subsection VERSION - Version and Full Version
@findex VERSION

If the @code{version} attribute is defined for the program,
then a stringified version will be #defined as PROGRAM_VERSION and
PROGRAM_FULL_VERSION.  PROGRAM_FULL_VERSION is used for printing
the program version in response to the version option.  The version
option is automatically supplied in response to this attribute, too.

You may access PROGRAM_VERSION via @code{programOptions.pzFullVersion}.

@node WHICH_IDX_name
@subsection WHICH_IDX_name - Which Equivalenced Index
@findex WHICH_IDX_name

This macro gets emitted only for equivalenced-to options.  It is used to
obtain the index for the one of the several equivalence class members
set the equivalenced-to option.

@example
switch (WHICH_IDX_OTHER_OPT) @{
case INDEX_OPT_NAME:
    this-option-was-really-opt-name;
case INDEX_OPT_OTHER_OPT:
    this-option-was-really-other-opt;
@}
@end example

@node WHICH_OPT_name
@subsection WHICH_OPT_name - Which Equivalenced Option
@findex WHICH_OPT_name

This macro gets emitted only for equivalenced-to options.  It is used to
obtain the value code for the one of the several equivalence class members
set the equivalenced-to option.

@example
switch (WHICH_OPT_OTHER_OPT) @{
case VALUE_OPT_NAME:
    this-option-was-really-opt-name;
case VALUE_OPT_OTHER_OPT:
    this-option-was-really-other-opt;
@}
@end example

@node teOptIndex
@subsection teOptIndex - Option Index and Enumeration
@findex teOptIndex

This enum defines the complete set of options, both
user specified and automatically provided.  This can be used,
for example, to distinguish which of the equivalenced options
was actually used.

@example
switch (pOptDesc->optActualIndex) @{
case INDEX_OPT_FIRST:
    stuff;
case INDEX_OPT_DIFFERENT:
    different-stuff;
default:
    unknown-things;
@}
@end example

@node OPTIONS_STRUCT_VERSION
@subsection OPTIONS_STRUCT_VERSION - active version

You will not actually need to reference this value, but you need to be
aware that it is there.  It is the first value in the option descriptor
that you pass to @code{optionProcess}.  It contains a magic number and
version information.  Normally, you should be able to work with a more
recent option library than the one you compiled with.  However, if the
library is changed incompatibly, then the library will detect the out of
date magic marker, explain the difficulty and exit.  You will then need
to rebuild and recompile your option definitions.  This has not been
necessary for several years.

@node libopts procedures
@subsection libopts procedures

These are the publicly exported procedures from the libopts library.

@table @samp
@item optionProcess
This is the main entry point for processing options.  It is intended
that this procedure be called once at the beginning of the execution of
a program.  Depending on options selected earlier, it is sometimes
necessary to stop and restart option processing, or to select completely
different sets of options.  This can be done easily, but you generally
do not want to do this.

@item optionVersion
Returns the full version string compiled into the library.

@item optionLoadLine
When passed a pointer to the option struct and a string, it will
find the option named by the first token on the string and set
the option argument to the remainder of the string.  The caller must
NUL terminate the string.  Any embedded new lines will be included
in the option argument.

@item putBourneShell
This routine will write to stdout the state of the options as encoded
in the option structure.  It will also write out the number of arguments
consumed by option processing.  The output result can be eval-ed by
a shell in the following manner:

@smallexample
eval "`handle-prog-opts $@{1+\"$@@\"@}`"
[ -z "$OPTION_CT" ] && exit 1
shift $OPTION_CT
@end smallexample

@noindent
This routine is normally specified by specifying
@code{test-main = yes;} in the option definitions file.

@item putShellParse
This routine will write to stdout a series of shell commands that
will parse the command line options.  This routine will be called
when you specify @code{test-main = putShellParse;} and the result
is compiled with @code{-DTEST_xxx_OPTS} defined.  This is the
only way it should ever be invoked.

@item all the rest
The remaining routines are for the exclusive use of the generated
option processing code.  You should not be using them directly.
@end table

@node option descriptor
@section Option Descriptor File
@cindex option descriptor

This is the module that is to be compiled and linked with your program.
It contains internal data and procedures subject to change.  Basically,
it contains a single global data structure containing all the
information provided in the option definitions, plus a number of static
strings and any callout procedures that are specified or required.  You
should never have need for looking at this, except to examine the code
generated for implementing the @code{flag_code} construct.

@node Using AutoOpts
@section Using AutoOpts
@cindex using AutoOpts

To use AutoOpts in your application:

@itemize @bullet
@item
Create a file @samp{myopts.def}, according to the documentation above.
It is probably easiest to start with the example in @ref{Quick Start}
and edit it into the form you need.

@item
Run AutoGen to create the option interface file (@code{myopts.h})
and the option descriptor code (@code{myopts.c}):

@example
autogen -L $prefix/share/autogen myopts.def
@end example

@item
In all your source files where you need to refer to option state,
@code{#include "myopts.h"} (generated for you).
@item
In your main routine, code something along the lines of:

@example
main( int argc, char** argv )
@{
    @{
        int arg_ct = optionProcess( &myprogOptions, argc, argv );
        argc -= arg_ct;
        if ((argc < ARGC_MIN) || (argc > ARGC_MAX)) @{
            fprintf( stderr, "%s ERROR:  remaining args (%d) "
                     "out of range\n", myprogOptions.pzProgName,
                     argc );

            USAGE( EXIT_FAILURE );
        @}
        argv += arg_ct;
    @}
    if (HAVE_OPT(OPT_NAME))
        respond_to_opt_name();
    ...
@}
@end example

@item
Compile @samp{myopts.c} and link your program
with the following additional arguments:

@example
myopts.o -L $prefix/lib -lopts
@end example
@end itemize

@node shell options
@section AutoOpts for Shell Scripts
@cindex shell options

AutoOpts may be used with shell scripts by automatically creating a
complete program that will process command line options and pass back
the results to the invoking shell by issuing shell variable assignment
commands.  It may also be used to generate portable shell code that can
be inserted into your script.

The functionality of these features, of course, is somewhat constrained
compared with the normal program facilities.  Specifically, you cannot
invoke callout procedures with either of these methods.  Additionally,
if you generate a shell script:

@enumerate
@item
You cannot obtain options from RC/INI files.
@item
You cannot obtain options from environment variables.
@item
You cannot save the option state to an option file.
@item
Option conflict/requirement verification is disabled.
@end enumerate

Both of these methods are enabled by running AutoGen on
the definitions file with the additional global attribute:

@example
test_main [ = proc-to-call ] ;
@end example

If you do not supply a @code{proc-to-call}, it will default
to @code{putBourneShell}.  That will produce a program that
will process the options and generate shell text for the
invoking shell to interpret.  If you supply the name,
@code{putShellParse}, then you will have a program that
will generate a shell script that can parse the options.
If you supply a different procedure name, you will have to
provide that routine and it may do whatever you like.

In summary, you will need to issue approximately the
following two commands to have a working program:

@example
autogen -DTEST_MAIN -L <opt-template-dir> program.def
cc -o program -L <opt-lib-dir> -I <opt-include-dir> \
        -DTEST_program_OPTS program.c -lopts
@end example

The resulting
program can be used within your shell script as follows:

@example
eval `./programopts $@@`
if [ -z "$@{OPTION_CT@}" ] ; then exit 1 ; fi
shift $@{OPTION_CT@}
@end example

If you had used @code{-DTEST_MAIN=putShellParse} instead, then you can,
at this point, merely run the program and it will write the parsing
script to standard out.  You may also provide this program with command
line options to specify the shell script file to create or edit, and you
may specify the shell program to use on the first shell script line.
That program's usage text would look something like this:

@example
[= `

[ ! -d .tmp ] && mkdir .tmp
OPTDIR=\`cd ${top_srcdir}/autoopts ; pwd\`

libs="\`cd ${OPTDIR} ; [ -d .libs ] && cd .libs ; pwd\`"
if [ -f ${libs}/libopts.a ]
then libs="${libs}/libopts.a"
else libs="-L ${libs} -lopts"
fi

opts="-o genshellopt -DTEST_GETDEFS_OPTS -g -I${OPTDIR}"

( cat ${top_srcdir}/getdefs/opts.def
  echo "test_main = 'putShellParse';"
) | (
  cd .tmp
  HOME='' ${AGEXE} -t40 -L${OPTDIR} -bgenshellopt -- -

  ${CC} ${opts} genshellopt.c ${libs}
) > /dev/null 2>&1

( .tmp/genshellopt --help 2>&1 ) |
  sed -e 's;\t;        ;g' -e 's;{;@{;g' -e 's;};@};g'
  rm -rf .tmp

` =]
@end example

@node AutoInfo
@section Automated @samp{Invoking Info} Doc
@cindex AutoInfo

Using the option definitions for an AutoOpt client program, the
@file{aginfo.tpl} template will produce texinfo text that documents the
invocation of your program.  The text emitted is designed to be included
in the full texinfo document for your product.  It is not a
stand-alone document.

Two files will be produced, a @file{.texi} file and a @file{.menu} file.
You should include the @file{.menu} file in your document where you wish
to reference the @samp{invoking} chapter, section or subsection.  The
documentation level is selected by passing a @samp{-DLEVEL=<level-name>}
argument to AutoGen when you build the document.  (See the example
invocation below.)

The @file{.texi} file will contain an introductory paragraph, a menu
and a subordinate section for the invocation usage and for each
documented option.  The introductory paragraph is normally the boiler
plate text:

@example
This chapter documents the @@file@{AutoOpts@} generated usage text
and option meanings for the @@file@{your-program@} program.
@end example

@noindent
However, if your program's option definitions include a
@samp{prog_info_descrip} section, then that is what will be used instead.

These files are produced by invoking the following command:

@example
AutoGen -L $@{prefix@}/share/autogen -T aginfo.tpl \
        -DLEVEL=section your-opts.def
@end example

@noindent
Where @file{$@{prefix@}} is the AutoGen installation prefix
and @file{your-opts.def} is the name of your product's option
definition file.

@node AutoMan pages
@section Automated Man Pages
@cindex AutoMan pages

Using the option definitions for an AutoOpt client program,
the @samp{agman1.tpl} template will produce an nroff document
suitable for use as a @samp{man(1)} page document for a command
line command.  The description section of the document is either
the @samp{prog_man_descrip} text, if present, or the @samp{detail}
text.

Each option in the option definitions file is fully documented
in its usage.  This includes all the information documented
above for each option (@pxref{option attributes}), plus
the @samp{doc} attribute is appended.  Since the @samp{doc}
text is presumed to be designed for @code{texinfo} documentation,
@code{sed} is used to convert some constructs from @code{texi}
to @code{nroff}-for-@code{man}-pages.  Specifically,

@example
convert @@code, @@var and @@samp into \fB...\fP phrases
convert @@file into \fI...\fP phrases
Remove the '@@' prefix from curly braces
Indent example regions
Delete the example commands
Replace @samp{end example} command with ".br"
Replace the @samp{@@*} command with ".br"
@end example

@noindent
This document is produced by invoking the following command:

@example
AutoGen -L $@{prefix@}/share/autogen -T agman1.tpl options.def
@end example

@noindent
Where @file{$@{prefix@}} is the AutoGen installation prefix
and @file{options.def} is the name of your product's option
definition file.
