/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */
/* Balsa E-Mail Client
 *
 * Copyright (C) 1997-2000 Stuart Parmenter and others,
 *                         See the file AUTHORS for a list.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option) 
 * any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */
/*
 * filter-funcs.h
 *
 * Various internal filter functions, not for general
 * use.
 */


#ifndef __FILTER_FUNCS_H__
#define __FILTER_FUNCS_H__

#include "filter.h"
#include "filter-private.h"

/* Conditions */

LibBalsaCondition* libbalsa_condition_new(void);

void libbalsa_condition_free(LibBalsaCondition*); 
void libbalsa_conditions_free(GSList * conditions);

LibBalsaConditionRegex* libbalsa_condition_regex_new(void);
LibBalsaCondition* libbalsa_condition_clone(LibBalsaCondition* cnd);
void libbalsa_condition_regex_free(LibBalsaConditionRegex *, gpointer);
void regexs_free(GSList *);
void libbalsa_condition_compile_regexs(LibBalsaCondition* cond);
/* Filters */
/* Free a filter
 * free_condition is a gint into a gpointer : if <>0 the function frees filter conditions also
 */
LibBalsaFilter *libbalsa_filter_new(void);
void libbalsa_filter_free(LibBalsaFilter *, gpointer free_condition);
void libbalsa_filter_clear_filters(GSList *,gint free_conditions);
void libbalsa_filter_append_condition(LibBalsaFilter*, LibBalsaCondition *);
void libbalsa_filter_prepend_condition(LibBalsaFilter*, LibBalsaCondition*);
void libbalsa_filter_delete_regex(LibBalsaFilter*,LibBalsaCondition*,
                                  LibBalsaConditionRegex *, gpointer);
gboolean libbalsa_filter_compile_regexs(LibBalsaFilter *);

gboolean libbalsa_filter_export_sieve(LibBalsaFilter* fil, gchar* filename);
#endif				/* __FILTER_FUNCS_H__ */
