//bf.cpp version 0.0.1- a brainfuck compiler
//tested under slackware Linux
//coded by the1 (http://www.angelfire.com/linux/the1)
//Shouts to mikecc
//This file is GNU/GPL
//see http://www.gnu.org/copyleft/gpl.html for more info

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string>
#include <getopt.h>
using namespace std;

int main(int argc, char *argv[])
{
int a;
char instruction;
string  outfilename, command, infilename, type;
ifstream infile;
ofstream outfile;
bool last_brace;
	
	if(argc < 2)
		{	
		cout << "Invalid argument\n";
		cout << argv[0] << " -i input_file_name -t type_of_output -o output_file_name\n";
		cout << "Allowable output types are: a (assembler), c++, e (executable)\n"; 
		return 0;
		}
	

	while ((a = getopt(argc,argv,"i:t:o:")) != -1)
       	{
                switch(a)	
		{
	               case 'i':
				infilename = optarg;
				break;
	
		       case 't':
                                type = optarg;
                                break;

                        case 'o':
                                outfilename = optarg;
                                break;


                        default:
                                printf("[-] invalid option.\n");
                                break;
                }
        }
	infile.open(infilename.c_str());
	outfile.open("temp.cpp");
	
	outfile << "#include <iostream.h>\n";
	outfile << "int main()\n";
	outfile << "{\n";
	
	outfile << "char a[30000];\n";
	outfile << "char* p=a;\n";
	outfile << "for(int x=0; x<30000; x++)\n";
	outfile << "{\n";
	outfile << "a[x]=0;\n";
	outfile << "}\n";
	while(!infile.eof())
		{
		
		infile >> instruction;
		last_brace=false;
		switch(instruction)
			{
			case '>':
			outfile << "p++;\n";
			break;
			case '<':
			outfile << "p--;\n";
			break;
			case '+':
			outfile << "++*p;\n"; 
			break;
			case'-':
			outfile << "--*p;\n";
			break;
			case '.':
			outfile << "cout << *p;\n"; 
			break;
			case ',':
			outfile << "cin >> *p;\n"; 
			break;
			case '[':
			outfile << "while(*p) {\n";
			break;
			case ']':
			outfile << "}\n"; 
			last_brace=true;
			break;
			default:
			cout << "\nInvalid instruction in brainfuck file\n";  
			}
		}
	if(last_brace==false)
		{
		outfile << "}\n";
		}
	infile.close();
	outfile.close();
	if(type == "e")
		{
		command="g++ temp.cpp -o " + outfilename;
		system(command.c_str());
		system("rm temp.cpp");
		}
	else
	if(type == "a")
		{
		command="g++ temp.cpp -S -o " + outfilename;
		system(command.c_str());
		system("rm temp.cpp");
		}
	if(type == "c++")
		{
		command="cp temp.cpp " + outfilename;
		system(command.c_str());
		system("rm temp.cpp");
		}
	else
	cout << "\nYour source file appears to be valid, however the type of output you requested is not supported.\n";
return 0;
}
