/*  txlog.c    CCMATH mathematics library source code.
 *
 *  Copyright (C)  2000   Daniel A. Atkinson    All rights reserved.
 *  This code may be redistributed under the terms of the GNU library
 *  public license (LGPL). ( See the lgpl.license file for details.)
 * ------------------------------------------------------------------------
 */
/*
    Test:  xlog  xexp

    Uses:  atox  xprcmp  xadd  prxpr
*/
#define XMATH 1
#include "ccmath.h"
int decd=30;
void main(void)
{ struct xpr z,h,f,w,u;
  printf("     Test of Log Function\n");
  h=atox(".25"); z=h; w=atox("4.01");
  for(; xprcmp(&z,&w)<0 ;z=xadd(z,h,0)){

/* compute extended precision natural logarithm */
    f=xlog(z);
    printf(" %8.4f  ",xtodub(z)); prxpr(f,decd);

/* check using exponential */
    u=xexp(f);
    printf("   exp(z)  "); prxpr(u,decd);
   }
}
/*  Test output

     Test of Log Function
   0.2500   -1.386294361119890618834464242916e+0
   exp(z)    2.500000000000000000000000000000e-1
   0.5000   -6.931471805599453094172321214582e-1
   exp(z)    5.000000000000000000000000000000e-1
   0.7500   -2.876820724517809274392190059938e-1
   exp(z)    7.500000000000000000000000000000e-1
   1.0000   -3.948156385993833498764754782299e-33
   exp(z)    1.000000000000000000000000000000e+0
   1.2500    2.231435513142097557662950903098e-1
   exp(z)    1.250000000000000000000000000000e+0
   1.5000    4.054651081081643819780131154643e-1
   exp(z)    1.500000000000000000000000000000e+0
   1.7500    5.596157879354226862708885005268e-1
   exp(z)    1.750000000000000000000000000000e+0
   2.0000    6.931471805599453094172321214582e-1
   exp(z)    2.000000000000000000000000000000e+0
   2.2500    8.109302162163287639560262309287e-1
   exp(z)    2.250000000000000000000000000001e+0
   2.5000    9.162907318741550651835272117680e-1
   exp(z)    2.500000000000000000000000000019e+0
   2.7500    1.011600911678479925227479335049e+0
   exp(z)    2.750000000000000000000000000000e+0
   3.0000    1.098612288668109691395245236923e+0
   exp(z)    3.000000000000000000000000000000e+0
   3.2500    1.178654996341646117219023198649e+0
   exp(z)    3.250000000000000000000000000000e+0
   3.5000    1.252762968495367995688120621985e+0
   exp(z)    3.500000000000000000000000000000e+0
   3.7500    1.321755839982319447161540327232e+0
   exp(z)    3.750000000000000000000000000000e+0
   4.0000    1.386294361119890618834464242916e+0
   exp(z)    4.000000000000000000000000000000e+0
*/
