/*  tevpsq.c    CCMATH mathematics library source code.
 *
 *  Copyright (C)  2000   Daniel A. Atkinson    All rights reserved.
 *  This code may be redistributed under the terms of the GNU library
 *  public license (LGPL). ( See the lgpl.license file for details.)
 * ------------------------------------------------------------------------
 */
/*
    Test:  evpsq  evpsqv
    Uses:  plsq
*/
#include "ccmath.h"
#define ND 100
#define NP 5
double x[ND],y[ND];
void main(void)
{ double dx,z,w,ss,s;
/* set dimensions of arrays used by plsq for output */
  double ssq[NP]; Opol cf[NP];
  int n,np,j;
  printf("     Test of Polynominal Least Squares\n");
/* set number of input points */
  n=ND;
/*
  The test fit inputs are the values of a polynominal of
  degree 4, defined in this loop.
*/
  for(j=0,dx=.1; j<n ;++j){
    z=(x[j]=j*dx); y[j]=1.+z*(1.+z*(2.+z*(-3.+.5*z)));
   }
/* set maximum fit order */
  np=NP;
  plsq(x,y,n,cf,ssq,np);
  ss=ssq[np-1];
  for(j=0; j<n ;++j){
    z=evpsq(x[j],cf,np);
    w=evpsqv(x[j],cf,np,&s,ss);
    printf("%3d  %11.5f %11.5f %11.5f %11.5f\n",j,z,z-w,s,y[j]);
   }
}
/* Test output

     Test of Polynominal Least Squares
  0      1.00000     0.00000     0.00000     1.00000
  1      1.11705     0.00000     0.00000     1.11705
  2      1.25680     0.00000     0.00000     1.25680
  3      1.40305     0.00000     0.00000     1.40305
  4      1.54080     0.00000     0.00000     1.54080
  5      1.65625     0.00000     0.00000     1.65625
  6      1.73680     0.00000     0.00000     1.73680
  7      1.77105     0.00000     0.00000     1.77105
  8      1.74880     0.00000     0.00000     1.74880
  9      1.66105     0.00000     0.00000     1.66105
 10      1.50000     0.00000     0.00000     1.50000
 11      1.25905     0.00000     0.00000     1.25905
 12      0.93280     0.00000     0.00000     0.93280
 13      0.51705     0.00000     0.00000     0.51705
 14      0.00880     0.00000     0.00000     0.00880
 15     -0.59375     0.00000     0.00000    -0.59375
 16     -1.29120     0.00000     0.00000    -1.29120
 17     -2.08295     0.00000     0.00000    -2.08295
 18     -2.96720     0.00000     0.00000    -2.96720
 19     -3.94095     0.00000     0.00000    -3.94095
 20     -5.00000     0.00000     0.00000    -5.00000
 21     -6.13895     0.00000     0.00000    -6.13895
 22     -7.35120     0.00000     0.00000    -7.35120
 23     -8.62895     0.00000     0.00000    -8.62895
 24     -9.96320     0.00000     0.00000    -9.96320
 25    -11.34375     0.00000     0.00000   -11.34375
 26    -12.75920     0.00000     0.00000   -12.75920
 27    -14.19695     0.00000     0.00000   -14.19695
 28    -15.64320     0.00000     0.00000   -15.64320
 29    -17.08295     0.00000     0.00000   -17.08295
 30    -18.50000     0.00000     0.00000   -18.50000
 31    -19.87695     0.00000     0.00000   -19.87695
 32    -21.19520     0.00000     0.00000   -21.19520
 33    -22.43495     0.00000     0.00000   -22.43495
 34    -23.57520     0.00000     0.00000   -23.57520
 35    -24.59375     0.00000     0.00000   -24.59375
 36    -25.46720     0.00000     0.00000   -25.46720
 37    -26.17095     0.00000     0.00000   -26.17095
 38    -26.67920     0.00000     0.00000   -26.67920
 39    -26.96495     0.00000     0.00000   -26.96495
 40    -27.00000     0.00000     0.00000   -27.00000
 41    -26.75495     0.00000     0.00000   -26.75495
 42    -26.19920     0.00000     0.00000   -26.19920
 43    -25.30095     0.00000     0.00000   -25.30095
 44    -24.02720     0.00000     0.00000   -24.02720
 45    -22.34375     0.00000     0.00000   -22.34375
 46    -20.21520     0.00000     0.00000   -20.21520
 47    -17.60495     0.00000     0.00000   -17.60495
 48    -14.47520     0.00000     0.00000   -14.47520
 49    -10.78695     0.00000     0.00000   -10.78695
 50     -6.50000     0.00000     0.00000    -6.50000
 51     -1.57295     0.00000     0.00000    -1.57295
 52      4.03680     0.00000     0.00000     4.03680
 53     10.37305     0.00000     0.00000    10.37305
 54     17.48080     0.00000     0.00000    17.48080
 55     25.40625     0.00000     0.00000    25.40625
 56     34.19680     0.00000     0.00000    34.19680
 57     43.90105     0.00000     0.00000    43.90105
 58     54.56880     0.00000     0.00000    54.56880
 59     66.25105     0.00000     0.00000    66.25105
 60     79.00000     0.00000     0.00000    79.00000
 61     92.86905     0.00000     0.00000    92.86905
 62    107.91280     0.00000     0.00000   107.91280
 63    124.18705     0.00000     0.00000   124.18705
 64    141.74880     0.00000     0.00000   141.74880
 65    160.65625     0.00000     0.00000   160.65625
 66    180.96880     0.00000     0.00000   180.96880
 67    202.74705     0.00000     0.00000   202.74705
 68    226.05280     0.00000     0.00000   226.05280
 69    250.94905     0.00000     0.00000   250.94905
 70    277.50000     0.00000     0.00000   277.50000
 71    305.77105     0.00000     0.00000   305.77105
 72    335.82880     0.00000     0.00000   335.82880
 73    367.74105     0.00000     0.00000   367.74105
 74    401.57680     0.00000     0.00000   401.57680
 75    437.40625     0.00000     0.00000   437.40625
 76    475.30080     0.00000     0.00000   475.30080
 77    515.33305     0.00000     0.00000   515.33305
 78    557.57680     0.00000     0.00000   557.57680
 79    602.10705     0.00000     0.00000   602.10705
 80    649.00000     0.00000     0.00000   649.00000
 81    698.33305     0.00000     0.00000   698.33305
 82    750.18480     0.00000     0.00000   750.18480
 83    804.63505     0.00000     0.00000   804.63505
 84    861.76480     0.00000     0.00000   861.76480
 85    921.65625     0.00000     0.00000   921.65625
 86    984.39280     0.00000     0.00000   984.39280
 87   1050.05905     0.00000     0.00000  1050.05905
 88   1118.74080     0.00000     0.00000  1118.74080
 89   1190.52505     0.00000     0.00000  1190.52505
 90   1265.50000     0.00000     0.00000  1265.50000
 91   1343.75505     0.00000     0.00000  1343.75505
 92   1425.38080     0.00000     0.00000  1425.38080
 93   1510.46905     0.00000     0.00000  1510.46905
 94   1599.11280     0.00000     0.00000  1599.11280
 95   1691.40625     0.00000     0.00000  1691.40625
 96   1787.44480     0.00000     0.00000  1787.44480
 97   1887.32505     0.00000     0.00000  1887.32505
 98   1991.14480     0.00000     0.00000  1991.14480
 99   2099.00305     0.00000     0.00000  2099.00305
*/
