/*  tftuns.c    CCMATH mathematics library source code.
 *
 *  Copyright (C)  2000   Daniel A. Atkinson    All rights reserved.
 *  This code may be redistributed under the terms of the GNU library
 *  public license (LGPL). ( See the lgpl.license file for details.)
 * ------------------------------------------------------------------------
 */
/*
    Test:  ftuns
    Uses:  fftgc  pfac
*/
#include "ccmath.h"
#include <math.h>
#define MPT 100
struct complex ft[MPT],*pc[MPT];
void main(void)
{ struct complex *f,**p,**h; double y;
  int kk[32],n=MPT,i;
  printf("     Test of FT Unscrambling (2 real series)\n");
  printf(" F1=-1, F2=1-2k/n for k<n/2 and F1=1, F2=2k/n-1 for k>n/2\n");
  for(i=0,y=2./n,f=ft; i<n ;++i,++f){
    if(i<n/2){ f->re= -1.; f->im=1.-i*y;}
    else{ f->re=1.; f->im=y*i-1.;}
   }
  ft[0].re=ft[n/2].re=0.;
  n=pfac(n,kk,'o');
  printf("      n= %d\n",n);
  fftgc(pc,ft,n,kk,'d');
  ftuns(pc,n);
  printf("%3d %10f %10f    %10f %10f\n",0,(*pc)->re,0.,(*pc)->im,0.);
  for(p=pc+1,h=pc+n-1,i=1; i<n/2 ;++p,--h){
    printf("%3d %10f %10f  ",i++,(*p)->re,(*p)->im);
    printf("  %10f %10f\n",(*h)->re,(*h)->im);
   }
  printf("%3d %10f %10f    %10f %10f\n",i,(*p)->re,0.,(*h)->im,0.);
}
/* Test output

     Test of FT Unscrambling (2 real series)
 F1=-1, F2=1-2k/n for k<n/2 and F1=1, F2=2k/n-1 for k>n/2
      n= 100
  0   0.000000   0.000000      0.500000   0.000000
  1   0.000000   0.636410      0.202709  -0.000000
  2   0.000000  -0.000000      0.000000  -0.000000
  3  -0.000000   0.211578      0.022583  -0.000000
  4  -0.000000  -0.000000      0.000000   0.000000
  5   0.000000   0.126275      0.008173  -0.000000
  6   0.000000  -0.000000      0.000000  -0.000000
  7  -0.000000   0.089475      0.004203  -0.000000
  8   0.000000  -0.000000     -0.000000   0.000000
  9   0.000000   0.068840      0.002570  -0.000000
 10   0.000000  -0.000000      0.000000  -0.000000
 11  -0.000000   0.055552      0.001743  -0.000000
 12   0.000000  -0.000000      0.000000   0.000000
 13   0.000000   0.046217      0.001268  -0.000000
 14   0.000000  -0.000000      0.000000  -0.000000
 15   0.000000   0.039252      0.000970  -0.000000
 16   0.000000  -0.000000      0.000000  -0.000000
 17   0.000000   0.033818      0.000772  -0.000000
 18   0.000000  -0.000000      0.000000   0.000000
 19   0.000000   0.029429      0.000633   0.000000
 20   0.000000  -0.000000      0.000000  -0.000000
 21   0.000000   0.025784      0.000532   0.000000
 22   0.000000  -0.000000     -0.000000   0.000000
 23  -0.000000   0.022686      0.000457  -0.000000
 24   0.000000  -0.000000      0.000000  -0.000000
 25   0.000000   0.020000      0.000400  -0.000000
 26   0.000000  -0.000000      0.000000   0.000000
 27  -0.000000   0.017632      0.000355  -0.000000
 28   0.000000  -0.000000      0.000000  -0.000000
 29   0.000000   0.015514      0.000320  -0.000000
 30   0.000000  -0.000000     -0.000000   0.000000
 31   0.000000   0.013592      0.000292   0.000000
 32   0.000000  -0.000000     -0.000000  -0.000000
 33   0.000000   0.011828      0.000270   0.000000
 34   0.000000  -0.000000     -0.000000  -0.000000
 35   0.000000   0.010191      0.000252  -0.000000
 36   0.000000  -0.000000      0.000000  -0.000000
 37   0.000000   0.008655      0.000237  -0.000000
 38   0.000000  -0.000000     -0.000000  -0.000000
 39   0.000000   0.007200      0.000226  -0.000000
 40   0.000000  -0.000000      0.000000  -0.000000
 41   0.000000   0.005811      0.000217   0.000000
 42   0.000000  -0.000000     -0.000000  -0.000000
 43   0.000000   0.004471      0.000210   0.000000
 44   0.000000  -0.000000     -0.000000   0.000000
 45   0.000000   0.003168      0.000205   0.000000
 46   0.000000  -0.000000     -0.000000  -0.000000
 47   0.000000   0.001891      0.000202  -0.000000
 48   0.000000  -0.000000      0.000000  -0.000000
 49   0.000000   0.000629      0.000200   0.000000
 50   0.000000   0.000000      0.000000   0.000000
*/
