/*  tairy.c    CCMATH mathematics library source code.
 *
 *  Copyright (C)  2000   Daniel A. Atkinson    All rights reserved.
 *  This code may be redistributed under the terms of the GNU library
 *  public license (LGPL). ( See the lgpl.license file for details.)
 * ------------------------------------------------------------------------
 */
/*
     Test:  airy  biry
*/
#include "ccmath.h"
#include <math.h>
void main(void)
{ double x,dx,fa,fb,fc,fd;
  printf("     Test of Airy Functions\n");
  printf("    x        Ai(x)            Ai'(x)");
  printf("           Bi(x)            Bi'(x)\n");
  x= -8.; dx=.5;
  for(; x<8.01 ;x+=dx){

/* compute Airy functions of the first kind */
    fa=airy(x,0); fb=airy(x,1);

/* compute Airy functions of the second kind */
    fc=biry(x,0); fd=biry(x,1);

    printf(" %5.2f %15.9f %15.9f %15.4f %15.4f\n",x,fa,fb,fc,fd);
   }
}
/* Test output

     Test of Airy Functions
    x        Ai(x)            Ai'(x)           Bi(x)            Bi'(x)
 -8.00    -0.052705050     0.935560938         -0.3313         -0.1595
 -7.50     0.321775716     0.318809507         -0.1125          0.8778
 -7.00     0.184280835    -0.771008168          0.2938          0.4982
 -6.50    -0.238020302    -0.674952493          0.2610         -0.5972
 -6.00    -0.329145174     0.345935487         -0.1467         -0.8129
 -5.50     0.017781541     0.864197218         -0.3678          0.0251
 -5.00     0.350761009     0.327192819         -0.1384          0.7784
 -4.50     0.292152781    -0.523362532          0.2539          0.6347
 -4.00    -0.070265533    -0.790628575          0.3922         -0.1167
 -3.50    -0.375533823    -0.343443433          0.1689         -0.6931
 -3.00    -0.378814294     0.314583769         -0.1983         -0.6756
 -2.50    -0.112325068     0.678852734         -0.4324         -0.2204
 -2.00     0.227407428     0.618259021         -0.4123          0.2788
 -1.50     0.464256578     0.309186967         -0.1918          0.5579
 -1.00     0.535560883    -0.010160567          0.1040          0.5924
 -0.50     0.475728092    -0.204081670          0.3804          0.5059
  0.00     0.355028054    -0.258819404          0.6149          0.4483
  0.50     0.231693606    -0.224910533          0.8543          0.5446
  1.00     0.135292416    -0.159147441          1.2074          0.9324
  1.50     0.071749497    -0.097382013          1.8789          1.8862
  2.00     0.034924130    -0.053090384          3.2981          4.1007
  2.50     0.015725923    -0.026250881          6.4817          9.4214
  3.00     0.006591139    -0.011912977         14.0373         22.9222
  3.50     0.002584099    -0.005004414         33.0555         59.1643
  4.00     0.000951564    -0.001958641         83.8471        161.9267
  4.50     0.000330250    -0.000717867        227.5881        469.1351
  5.00     0.000108344    -0.000247414        657.7920       1435.8191
  5.50     0.000033685    -0.000080463       2016.5800       4632.5537
  6.00     0.000009948    -0.000024765       6536.4461      15725.6026
  6.50     0.000002796    -0.000007232      22340.6077      56062.4958
  7.00     0.000000749    -0.000002008      80327.7907     209552.6709
  7.50     0.000000192    -0.000000531     303229.6151     819987.8354
  8.00     0.000000047    -0.000000134    1199586.0041    3354342.3127
*/
