/*  tspbes.c    CCMATH mathematics library source code.
 *
 *  Copyright (C)  2000   Daniel A. Atkinson    All rights reserved.
 *  This code may be redistributed under the terms of the GNU library
 *  public license (LGPL). ( See the lgpl.license file for details.)
 * ------------------------------------------------------------------------
 */
/*
    Test:  Spherical Bessel Functions
           jspbes  yspbes  kspbes

*/
#include "ccmath.h"
#include <math.h>
void main(void)
{ double (*funs)(int,double);
  double x,dx,xmx,f,s; char t[2]; int n,i;
  printf("     Test of Spherical Bessel Functions\n");
  xmx=10.; dx=0.5;
  for(i=0; i<4 ;++i){
	switch(i){
	  case 0: t[0]='j'; x=0.; n=0;
			  funs=jspbes; printf("  j(n,x)\n"); break;
	  case 1: t[0]='y'; x=0.5; n=1;
			  funs=yspbes; printf("  y(n,x)\n"); break;
	  case 2: t[0]='k'; x=0.5; n=1;
			  funs=kspbes; printf("  k(n,x)\n"); break;
	  case 3: t[0]='e'; x=0.5; n=1;
			  funs=kspbes; printf("  k(n,-x)\n"); break;
	 }
    if(t[0]=='e') s= -1; else s=1;
    for(; x<xmx+0.1 ;x+=dx){

/* compute specified spherical Bessel function */
      f=(*funs)(n,s*x);
      printf(" %7.2f   %18.8f\n",x,f);
     }
	printf("\n");
   }
}
/*  Test output

     Test of Spherical Bessel Functions
  j(n,x)
    0.00           1.00000000
    0.50           0.95885108
    1.00           0.84147098
    1.50           0.66499666
    2.00           0.45464871
    2.50           0.23938886
    3.00           0.04704000
    3.50          -0.10022378
    4.00          -0.18920062
    4.50          -0.21722892
    5.00          -0.19178485
    5.50          -0.12828006
    6.00          -0.04656925
    6.50           0.03309538
    7.00           0.09385523
    7.50           0.12506666
    8.00           0.12366978
    8.50           0.09393966
    9.00           0.04579094
    9.50          -0.00791064
   10.00          -0.05440211

  y(n,x)
    0.50          -4.46918132
    1.00          -1.38177329
    1.50          -0.69643541
    2.00          -0.35061200
    2.50          -0.11120588
    3.00           0.06295916
    3.50           0.17666922
    4.00           0.23005335
    4.50           0.22763858
    5.00           0.18043837
    5.50           0.10485296
    6.00           0.01989785
    6.50          -0.05620988
    7.00          -0.10924099
    7.50          -0.13122907
    8.00          -0.12139634
    8.50          -0.08560732
    9.00          -0.03454242
    9.50           0.01895964
   10.00           0.06279283

  k(n,x)
    0.50           3.63918396
    1.00           0.73575888
    1.50           0.24792240
    2.00           0.10150146
    2.50           0.04596760
    3.00           0.02212759
    3.50           0.01109292
    4.00           0.00572364
    4.50           0.00301726
    5.00           0.00161711
    5.50           0.00087815
    6.00           0.00048198
    6.50           0.00026688
    7.00           0.00014888
    7.50           0.00008358
    8.00           0.00004717
    8.50           0.00002675
    9.00           0.00001524
    9.50           0.00000871
   10.00           0.00000499

  k(n,-x)
    0.50           3.29744254
    1.00           0.00000000
    1.50          -0.99593090
    2.00          -1.84726402
    2.50          -2.92379855
    3.00          -4.46345265
    3.50          -6.75825550
    4.00         -10.23715313
    4.50         -15.55851652
    5.00         -23.74610546
    5.50         -36.40045273
    6.00         -56.03177687
    6.50         -86.58648478
    7.00        -134.28161124
    7.50        -208.92934567
    8.00        -326.04227983
    8.50        -510.18361664
    9.00        -800.30458544
    9.50       -1258.25682052
   10.00       -1982.38192153

*/
