/* @(#)sector.c	1.9 02/09/28 Copyright 2001-2002 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)sector.c	1.9 02/09/28 Copyright 2001-2002 J. Schilling";
#endif
/*
 *	Functions needed to use libedc_ecc from cdrecord
 *
 *	Copyright (c) 2001-2002 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <mconfig.h>
#include <standard.h>
#include <utypes.h>
#include <timedefs.h>
#include <schily.h>

#include "cdrecord.h"
#include "movesect.h"

#ifdef	HAVE_LIB_EDC_ECC


#define	LAYER2
#define	EDC_LAYER2
#define	ENCODER
#define	EDC_ENCODER
#include <ecc.h>

#ifdef	DO8
#define	HAVE_NEW_LIB_EDC
#endif

EXPORT	int	encspeed	__PR((void));
EXPORT	void	encsectors	__PR((track_t *trackp, Uchar *bp, int address, int nsecs));
EXPORT	void	scrsectors	__PR((track_t *trackp, Uchar *bp, int address, int nsecs));
EXPORT	void	encodesector	__PR((Uchar *sp, int sectype, int address));
EXPORT	void	fillsector	__PR((Uchar *sp, int sectype, int address));

/*
 * Sector types known by lib libedc_ecc:
 */
#ifdef	__comment__
				/*   MMC					*/
#define MODE_0	0		/* -> XX  12+4+2336	(12+4uuu von libedc)	*/
#define MODE_1	1		/* -> 8   12+4+2048+288 (124+4uuu+288 von libedc)*/
#define MODE_2	2		/* -> 9	  12+4+2336	(12+4uuu von libedc)	*/
#define MODE_2_FORM_1	3	/* -> 10/11 12+4+8+2048+280 (12+4hhhuuu+280 von libedc)*/
#define MODE_2_FORM_2	4	/* -> 12 (eher 13!) 12+4+8+2324+4 (12+4hhhuuu+4 von libedc)*/
#define AUDIO	5
#define UNKNOWN	6
#endif

/*
 * known sector types
 */
#ifndef EDC_MODE_0
#define EDC_MODE_0	MODE_0
#endif
#ifndef	EDC_MODE_1
#define EDC_MODE_1	MODE_1
#endif
#ifndef EDC_MODE_2
#define EDC_MODE_2	MODE_2
#endif
#ifndef EDC_MODE_2_FORM_1
#define EDC_MODE_2_FORM_1	MODE_2_FORM_1
#endif
#ifndef EDC_MODE_2_FORM_2
#define EDC_MODE_2_FORM_2	MODE_2_FORM_2
#endif
#ifndef EDC_AUDIO
#define EDC_AUDIO	AUDIO
#endif
#ifndef EDC_UNKNOWN
#define EDC_UNKNOWN	UNKNOWN
#endif

/*
 * Compute max sector encoding speed
 */
EXPORT int
encspeed()
{
	track_t	t[1];
	Uchar	sect[2352];
	int	i;
	struct	timeval tv;
	struct	timeval tv2;

	t[0].sectype = ST_MODE_1;

	gettimeofday(&tv, (struct timezone *)0);
	for (i=0; i < 75000; i++) {		/* Goes up to 1000x */
		encsectors(t, sect, 12345, 1);
		gettimeofday(&tv2, (struct timezone *)0);
		if (tv2.tv_sec >= (tv.tv_sec+1) &&
		    tv2.tv_usec >= tv.tv_usec)
			break;
	}
	return ((i+74)/75);
}

/*
 * Encode sectors according to trackp->sectype
 */
EXPORT void
encsectors(trackp, bp, address, nsecs)
	track_t	*trackp;
	Uchar	*bp;
	int	address;
	int	nsecs;
{
	int	sectype = trackp->sectype;

	if ((sectype & ST_MODE_MASK) == ST_MODE_AUDIO)
		return;

	while (--nsecs >= 0) {
		encodesector(bp, sectype, address);
		address++;
		bp += trackp->secsize;
	}
}


EXPORT void
scrsectors(trackp, bp, address, nsecs)
	track_t	*trackp;
	Uchar	*bp;
	int	address;
	int	nsecs;
{
	comerrno(EX_BAD, "Cannot write in clone RAW mode.\n");
}

/*
 * Encode one sector according to trackp->sectype
 */
EXPORT void
encodesector(sp, sectype, address)
	Uchar	*sp;
	int	sectype;
	int	address;
{
	if (address < -150)
		address += 450150;
	else
		address += 150;
#define	_address address


	switch (sectype & ST_MODE_MASK) {

	case	ST_MODE_0:
		do_encode_L2 (sp, EDC_MODE_0, _address);
		break;

	case	ST_MODE_1:
		do_encode_L2 (sp, EDC_MODE_1, _address);
		break;

	case	ST_MODE_2:
		do_encode_L2 (sp, EDC_MODE_2, _address);
		break;

	case	ST_MODE_2_FORM_1:
		sp[16+2]   &= ~0x20;	/* Form 1 sector */
		sp[16+4+2] &= ~0x20;	/* Form 1 sector 2nd copy */
		/* FALLTHROUGH */

	case	ST_MODE_2_MIXED:
		do_encode_L2 (sp, EDC_MODE_2_FORM_1, _address);
		break;

	case	ST_MODE_2_FORM_2:
		sp[16+2]   |= 0x20;	/* Form 2 sector */
		sp[16+4+2] |= 0x20;	/* Form 2 sector 2nd copy */

		do_encode_L2 (sp, EDC_MODE_2_FORM_2, _address);
		break;

	case	ST_MODE_AUDIO:
		return;
	default:
		fill2352(sp, '\0');
		return;
	}
	if ((sectype & ST_NOSCRAMBLE) == 0) {
		scramble_L2(sp);
#ifndef	EDC_SCRAMBLE_NOSWAP
		swabbytes(sp, 2352);
#endif
	}
}

/*
 * Create one zero filles encoded sector (according to trackp->sectype)
 */
EXPORT void
fillsector(sp, sectype, address)
	Uchar	*sp;
	int	sectype;
	int	address;
{
	fill2352(sp, '\0');
	encodesector(sp, sectype, address);
}

#endif	/* HAVE_LIB_EDC_ECC */
