#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include <z/itemize.h>
#include <krb.h>
#include <krb_db.h>
#include <kadm.h>
#include <readline/readline.h>
#include <pw.h>
#include "user.h"

extern bool nodir;
extern bool nokrb;

void
doit (d, u)
    int d;
    user *u;
{
    doit_pw (d, u);
    doit_pnr (d, u);
    if (!nodir)
	doit_dir (u);
    if (!nokrb)
	doit_krb (u);
}


doit_pw (d, u)
    int d;
    user *u;
{
    puts ("Adding user to passwd-database...");

    pw_create (d, build_pwline (u));
    if (pw_errno != PW_EOK)
	pw_abort ();
}

doit_pnr (d, u)
    int d;
    user *u;
{
  if (u->pnr != NULL) {
    puts ("Adding user to pnr-database...");
    
    pnr_create (d, u->pnr, u->logname);
    if (pw_errno != PW_EOK)
	pw_abort ();
  }
}


doit_dir (u)
    user *u;
{
    char syscmd[1024];

    puts ("Creating home directory...");

    sprintf (syscmd, "echo /usr/local/staff/bin/pwmkhomedir %s \\; /usr/athena/bin/kdestroy |/usr/athena/bin/ksu", u->logname);
    system (syscmd);
}


doit_krb (u)
    user *u;
{
    pw_kadm_usr_init (5);
    
    puts ("Entering password into Kerberos database(borde gras annorlunda)...");

    pw_kadm_add_new_key (u->logname, u->passwd);
    if (pw_errno != PW_EOK)
	pw_abort ();

    pw_kadm_destroy_ticket ();
}
