#include <stdlib.h>
#include <sys/param.h>
#include <unistd.h>
#include <ctype.h>

#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include "pw.h"

static void
shift (argcp, argvp)
    int *argcp;
    char ***argvp;
{
    (*argvp)[1] = (*argvp)[0];
    (*argvp)++;
    (*argcp)--;
}

int
pw_args (argcp, argvp)
    int *argcp;
    char ***argvp;
{
    int type;
    char *name;
    int d;

    
    type = PW_REMOTE;
    name = NULL;

    /* Debug flag should be first - if at all */

    if ((*argcp) > 1 && strcmp ("-debug", (*argvp)[1]) == 0)
    {
	pw_debug = TRUE;
	shift (argcp, argvp);
    }

    if ((*argcp) > 1 && strcmp ("-local", (*argvp)[1]) == 0)
    {
	type = PW_LOCAL;
	name = NULL;
	shift (argcp, argvp);
    }
    else if ((*argcp) > 2 && strcmp ("-file", (*argvp)[1]) == 0)
    {
	type = PW_LOCAL;
	name = (*argvp)[2];
	shift (argcp, argvp);
	shift (argcp, argvp);
    }
    else if ((*argcp) > 1 && strcmp ("-remote", (*argvp)[1]) == 0)
    {
	type = PW_REMOTE;
	name = NULL;
	shift (argcp, argvp);
    }
    else if ((*argcp) > 2 && strcmp ("-server", (*argvp)[1]) == 0)
    {
	type = PW_REMOTE;
	name = (*argvp)[2];
	shift (argcp, argvp);
	shift (argcp, argvp);
    }
    else if ((*argcp) > 1 && strcmp ("-nis", (*argvp)[1]) == 0)
    {
	type = PW_NDBM;
	name = NULL;
	shift (argcp, argvp);
    }
    else if ((*argcp) > 2 && strcmp ("-ndbm", (*argvp)[1]) == 0)
    {
	type = PW_NDBM;
	name = (*argvp)[2];
	shift (argcp, argvp);
	shift (argcp, argvp);
    }

    d = pw_open (name, type,
		 ((type != PW_REMOTE) && (getuid() == 0) ? PW_FROOT : 0));
    if (d == -1)
	pw_abort ();

    return d;
}

char *
pw_getpwarg (d, argcp, argvp)
    int d;
    int *argcp;
    char ***argvp;
{
    char *line;
    int uid;
    int i;
    int len;
    
    if ((*argcp) > 2 && strcmp ((*argvp)[1], "-uid") == 0)
    {
	len = strlen ((*argvp)[2]);
	if (len == 0)
	{
	    pw_errno = PW_EBADUID;
	    return NULL;
	}
	for (i = 0; i < strlen ((*argvp)[2]); i++)
	    if (!isdigit ((*argvp)[2][i]))
	    {
		pw_errno = PW_EBADUID;
		return NULL;
	    }
	uid = atoi ((*argvp)[2]);
	line = pw_getpwuid (d, uid);
	shift (argcp, argvp);
	shift (argcp, argvp);
    }
    else if ((*argcp) > 2 && strcmp ((*argvp)[1], "-name") == 0)
    {
	len = strlen ((*argvp)[2]);
	if (len == 0)
	{
	    pw_errno = PW_EBADNAME;
	    return NULL;
	}
	line = pw_getpwnam (d, (*argvp)[2]);
	shift (argcp, argvp);
	shift (argcp, argvp);
    }
    else if ((*argcp) > 1)
    {
	len = strlen ((*argvp)[1]);
	if (len == 0)
	{
	    pw_errno = PW_EBADNAME;
	    return NULL;
	}
	line = pw_getpwnam (d, (*argvp)[1]);
	if (line == NULL)
	{
	    for (i = 0; i < strlen ((*argvp)[1]); i++)
		if (!isdigit ((*argvp)[1][i]))
		    return NULL;
	    uid = atoi ((*argvp)[1]);
	    line = pw_getpwuid (d, uid);
	}
	shift (argcp, argvp);
    }
    else
	ASSERT (FALSE);

    return line;
}
