
/* chcomment.c
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <strings.h>
#include "../../readline/readline.h"
#include <z/bool.h>
#include <z/error.h>
#include <z/file.h>
#include <z/itemize.h>
#include <pw.h>

extern char *getpass ();

char *progname = "chcomment";
char *chcomment ();

int
main (argc, argv)
    int argc;
    char *argv[];
{
    int d;			/* Descriptor for PW database */
    char *old;			/* Old comment line (what to change from) */
    char *new;			/* New comment line (what to change to) */
    char *logname;
    char *pnr;
    extern char *getlogin ();
    extern char *getenv ();
    //pw_open("/var/chpass/passwd", PW_NDBM, 0);
    d = pw_args (&argc, &argv);

    
    if (argc == 1)
    {
	logname = getlogin ();
	if (logname == NULL)
	    logname = getenv ("USER");
	if (logname == NULL)
	  my_abort ("Who are you? (User %s is not known)", logname);
 	if ((pnr = pnr_getbyname(d, logname)) == NULL)
	  my_abort ("%s, you aren't authorized to change you comment\n",logname);
	ASSERT((old = comment_getbypnr (d, pnr)) != NULL);
    }
    else
      pw_abort ();
    
    new = chcomment (old, logname);

    if (strcmp (old, new) == 0)
	my_abort ("No change");

    comment_change (d, pnr, new);
    if (pw_errno != PW_EOK)
	pw_abort ();
    
    exit (0);
}

static char *xold;

void insert_old ()
{
    strcpy (rl_line_buffer, xold);
    rl_point = 0;
    rl_end = strlen (xold);
}

char *
chcomment (old, logname)
    char *old;
    char *logname;
{
    char *new;
    char prompt[]="Comment: ";
    char *cp;

    printf ("Changing comment for \"%s\"\n",logname );

    rl_startup_hook = insert_old;

    xold = old;

retry:
    new = readline (prompt);
    
    if (new == NULL)
      exit (1);

    while (*new == ' ')
      new++;
    cp = new + strlen (new);
    while (*--cp == ' ')
      *cp = '\0';

    return strdup (new);
}

