
#include <stdio.h>
#include <ctype.h>

#include <z/bool.h>
#include <z/error.h>
#include <pw.h>

char *progname = "pw8859-1";

extern unsigned char *strdup (char *);

char *
convert (old)
    char *old;
{
    unsigned char *new;
    unsigned char *cp;

    new = strdup (old);
    cp = new;
    while (*cp)
    {
	switch (*cp)
	{
	case '}':
	    *cp = '';
	    break;

	case '{':
	    *cp = '';
	    break;

	case '|':
	    *cp = '';
	    break;

	case ']':
	    *cp = '';
	    break;

	case '[':
	    *cp = '';
	    break;

	case '\\':
	    *cp = '';
	    break;

	}
	cp++;
    }
    if (strcmp (old,new) != 0)
	printf ("%s\n", new);
    return new;
}

main (argc, argv)
    int argc;
    char *argv[];
{
    int d;
    int uid;
    int result;
    int len;
    int i;

    d = pw_args (&argc, &argv);

    if (argc != 1)
    {
	fprintf (stderr, "usage: pw8859-1\n");
	exit (1);
    }

    pw_map (d, convert);

    if (pw_errno != PW_EOK)
	pw_abort ();
    
    exit (0);
}
