
#include <stdio.h>

#include <z/bool.h>
#include <pw.h>


char *progname = "pwdelete";

bool nopw = FALSE;
bool nokrb = FALSE;
bool nodir = FALSE;

main (argc, argv)
    int argc;
    char *argv[];
{
    int argi;
    int res;
    int d;
    char *line;
    pw_data *pwd;
    char syscmd[1024];

    d = pw_args (&argc, &argv);

    line = pw_getpwarg (d, &argc, &argv);
    if (line == NULL)
	pw_abort ();
    
    argi = 1;
    while (argc > argi)
    {
        if (strcmp (argv[argi], "-nopw") == 0)
            nopw = TRUE;
        else if (strcmp (argv[argi], "-nokrb") == 0)
            nokrb = TRUE;
        else if (strcmp (argv[argi], "-nodir") == 0)
            nodir = TRUE;
        else
        {
            fprintf (stderr,
		     "usage: %s (name|uid) [-nopw] [-nokrb] [-nodir]\n",
		     progname);
            exit (1);
        }
        argi++;
    }

    pwd = pw_string_to_data (line);
    if (pwd == NULL)
	my_abort ("Memory allocation fails");

    if ((res = pw_syntax (pwd, PW_SYNTAX_SLOPPY)) != PW_SYNTAX_EOK)
	my_abort ("Corrupt passwd-entry: %s", pw_syntax_message (res));

    if (!nodir)
    {
      puts("Don't forget to remove user volume!\n");
/*
	if (strncmp (pwd->pwv[PW_DIR], "/home/", 6) != 0)
	    warning ("Not deleting home directory \"%s\"", pwd->pwv[PW_DIR]);
	else
	{
	    puts ("Deleting home directory...");
	    
	    sprintf (syscmd, "/etc/chown -R root %s", pwd->pwv[PW_DIR]);
	    system (syscmd);
	    
	    sprintf (syscmd, "/bin/chmod -R 700 %s", pwd->pwv[PW_DIR]);
	    system (syscmd);
	    
	    sprintf (syscmd, "/bin/rm -r %s", pwd->pwv[PW_DIR]);
	    system (syscmd);

	    puts ("Deleting mail file...");
	    
	    sprintf (syscmd, "/bin/rm /var/spool/mail/%s", pwd->pwv[PW_NAME]);
	    system (syscmd);
	}
*/
    }

    if (!nokrb)
    {
	pw_kadm_usr_init (30);

	puts ("Zapping password in Kerberos database...");

	pw_kadm_zap_principal (pwd->pwv[PW_NAME]);
	if (pw_errno != PW_EOK)
	    pw_error ();

	pw_kadm_destroy_ticket ();
    }

    if (!nopw)
    {
	puts ("Removing user from pw-database...");

	pw_delete (d, line);
	if (pw_errno != PW_EOK)
	    pw_abort ();
    }

   exit (0);
}
