
/* pwmkhomedir
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <strings.h>
#include <sys/param.h>
#include <varargs.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/itemize.h>
#include <pw.h>

extern int errno;

#define SKELDIR "/usr/athena/lib/prototype_user"

#define CP	"/bin/cp"
#define LN	"/bin/ln"
#define TAR	"/bin/tar"
#define CHOWN	"/etc/chown"
#define RM	"/bin/rm"

void mkhomedir ();

char *progname = "pwmkhomedir";

int syscommand(va_alist)
va_dcl
{
  va_list args;
  char *fmt;
  char syscmd[1024];
  int res;

  va_start(args);

  fmt = va_arg(args, char *);
  (void)vsprintf(syscmd, fmt, args);
  res = system(syscmd);

  va_end(args);
  return(res);
}

int
main (argc, argv)
    int argc;
    char *argv[];
{
    int	d;
    int i;

    
    /*
     * Must run as root
     */

    if (setreuid (0, 0) == -1)
	my_sysabort ("Can't set real uid to root: setreuid(2) fails");


    /*
     * Open a channel to the chpass server.
     */
    
    d = pw_open (NULL, PW_REMOTE, 0);
    if (d == -1)
	pw_abort ();

    
    /*
     * Call the function mkhomedir for each of the names given on the
     * command line
     */
    
    for (i = 1; i < argc; i++)
	mkhomedir (d, argv[i]);

    exit (0);
}

void
mkhomedir (d, name)
    int d;
    char *name;
{
    int  res;				/* General purpose result code */
    char *line;				/* Response from chpass-server */
    pw_data *pwd;
    char **pathv;			/* Itemization of some pathnames */
    int uid;				/* The users uid */
    static char homedir[MAXPATHLEN];	/* Users home directory */
    static char cat[MAXPATHLEN];	/* Category */
    static char primary_cat[MAXPATHLEN];/* 'cat' without optional hostpart */
    char *dash;				/* For calculating 'primary_cat' */
    static char catdir[MAXPATHLEN];	/* Category directory */
    static char infodir[MAXPATHLEN];	/* Skeleton directory for category */
    static char cwd[MAXPATHLEN];	/* Result of getwd(3) in 'catdir' */
    static char first[MAXPATHLEN];	/* First component of 'cwd' */
    static char second[MAXPATHLEN];	/* Second component of 'cwd' */
    static char syscmd[1024];		/* For system(3) */
    static char volume[256];            /* AFS volume name */


    /*
     * Ask chpass-server for data about the user
     */

    line = pw_getpwnam (d, name);
    if (line == NULL)
    {
	my_error ("Can't find user \"%s\" in servers database", name);
	if (pw_errno != PW_ENOTFOUND)
	    pw_error ();
	free (line);
	return;
    }


    /*
     * Extract home directory and uid.
     */

    pwd = pw_string_to_data (line);
    if (pwd == NULL)
	my_abort ("Memory allocation fails");
    if ((res = pw_syntax (pwd, PW_SYNTAX_SLOPPY)) != PW_SYNTAX_EOK)
    {
	my_error ("Corrupt passwd-entry: %s", pw_syntax_message (res));
	pw_free_data (pwd);
	return;
    }
    strcpy (homedir, pwd->pwv[PW_DIR]);
    uid = atoi (pwd->pwv[PW_UID]);
    
    pw_free_data (pwd);
    

    /*
     * Extract category and check home directory "syntax" 
     */

    pathv = itemize (homedir, "/");
    if (pathv == NULL)
	my_abort ("Not enough core");

    if (pathv[0] == NULL || pathv[0][0] != '\0'
    ||  pathv[1] == NULL || strcmp (pathv[1], "home") != 0)
    {
	my_error ("Strange directory name for user \"%s\": %s",
	       name, homedir);
	itemfree (pathv);
	return;
    }

    strcpy (cat, pathv[2]);
    itemfree (pathv);

    syscommand("/usr/local/staff/bin/make-afsuser.sh polis b %s %s %d", cat, name, uid);

    return;
}
