/* errors.c
 *
 */

#include <z/bool.h>
#include <z/error.h>
#include "pw.h"

extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;

extern char *krb_err_txt[];
extern char *error_message ();

enum pw_errcode pw_errno = PW_EOK;
int pw_krberr;
int pw_syntaxerr;

char *pw_errlist[] =
{
/* PW_EOK */		"No error (success)",
/* PW_ELINETOOLONG */	"Entry to insert is too long",
/* PW_ENEWSYNTAX */	"Entry to insert contains a syntax error",
/* PW_EOLDSYNTAX */	"Entry to update contains a syntax error",
/* PW_EFSFAIL */	"Some unusual filesystem-related problem",
/* PW_ELOCKED */	"The password-file is locked",
/* PW_ENOTFOUND */	"Relevant entry not found",
/* PW_EUIDEXISTS */	"An entry with this uid already exists",
/* PW_ENAMEEXISTS */	"An entry with this logname already exists",
/* PW_EBADPASSWD */	"The password-file is corrupt",
/* PW_ENOTSORTED */	"The password-file is not sorted",
/* PW_EOPEN */		"Failed to open the password-file",
/* PW_ECREAT */		"Failed to create lockfile",
/* PW_EREAD */		"Read error",
/* PW_EWRITE */		"Write error",
/* PW_EHOST */		"Unknown host",
/* PW_ESOCKET */	"Can't create communication socket(2)",
/* PW_EBIND */		"Can't bind(2) to server",
/* PW_ECONNECT */	"Can't connect(2) to server",
/* PW_ESEND */ 		"Can't send(2) request to server",
/* PW_ERECV */ 		"Can't recv(2) reply from server",
/* PW_EROOT */		"Disallowed manipulation of root-entry",
/* PW_ETOOMANY */	"Too many active descriptors already",
/* PW_EDESCRIPTOR */	"Bad descriptor",
/* PW_ENOTACTIVE */	"Descriptor is not active",
/* PW_EAUTHENTICATOR */	"Kerberos authenticator not valid",
/* PW_EREQUEST */	"Request was corrupt at server",
/* PW_EREPLY */ 	"Reply from server is corrupt",
/* PW_ETICKET */	"Can't create Kerberos ticket for service",
/* PW_ECREDENTIALS */	"Can't get Kerberos credentials",
/* PW_EIMPL */		"Requested operation is not implemented",
/* PW_EBADUID */	"Bad uid for this request",
/* PW_EBADNAME */	"Bad login name for this request",
/* PW_ETIMEOUT */ 	"Server doesn't respond (timeout)",
/* PW_EAUTHORITY */ 	"No authority for operation",
/* PW_EKADMLINK */	"Can't initialise link to kadmin server",
/* PW_EKADMINTKT */	"Can't get initial ticket for kadmin service",
/* PW_EKADMEXISTS */	"Principal exists",
/* PW_EKADMOP */  	"Kadmin operation failed",
/* PW_EBUILDAUTH */	"Failed to build Kerberos authenticator",
/* PW_EMEMORY */  	"Memory allocation failed",
/* PW_ENOAFS */  	"AFS is not running on this host",
/* PW_EAFSTOKEN */  	"Can't create AFS token",
/* PW_ENISDOMAIN */  	"Can't get NIS domain name",
/* PW_ENISMASTER */ 	"Can't locate NIS master",
/* PW_EBADPNR */        "Bad pnr for request"
};

int pw_nerr = sizeof pw_errlist / sizeof pw_errlist[0];

bool
pw_is_krberr (err)
    int err;
{
    switch (err)
    {
    case PW_EAUTHENTICATOR:
    case PW_EREQUEST:
    case PW_EREPLY:
    case PW_ETICKET:
    case PW_ECREDENTIALS:
    case PW_EBUILDAUTH:
	return TRUE;

    default:
	return FALSE;
    }
}

bool
pw_is_kadmerr (err)
    int err;
{
    switch (err)
    {
    case PW_EKADMLINK:
    case PW_EKADMINTKT:
    case PW_EKADMOP:
	return TRUE;

    default:
	return FALSE;
    }
}

bool
pw_is_syserr (err)
    int err;
{
    switch (err)
    {
    case PW_EFSFAIL:
    case PW_EOPEN:
    case PW_ECREAT:
    case PW_EREAD:
    case PW_EWRITE:
    case PW_ESOCKET:
    case PW_EBIND:
    case PW_ECONNECT:
    case PW_ESEND:
    case PW_ERECV:
	return TRUE;

    default:
	return FALSE;
    }
}

bool
pw_is_syntaxerr (err)
    int err;
{
    switch (err)
    {
    case PW_EOLDSYNTAX:
    case PW_ENEWSYNTAX:
	return TRUE;

    default:
	return FALSE;
    }
}

static void
do_error (func)
    void (*func) ();
{
    if (pw_is_syserr (pw_errno))
	(*func) ("%s: %s", pw_errlist[pw_errno],
		 sys_errlist[errno]);
    else if (pw_is_krberr (pw_errno))
	(*func) ("%s: %s", pw_errlist[pw_errno],
		 krb_err_txt[pw_krberr]);
    else if (pw_is_kadmerr (pw_errno))
	(*func) ("%s: %s", pw_errlist[pw_errno],
		 error_message (pw_krberr));
    else if (pw_is_syntaxerr (pw_errno))
	(*func) ("%s: %s", pw_errlist[pw_errno],
		 pw_syntax_message (pw_syntaxerr));
    else
	(*func) ("%s", pw_errlist[pw_errno]);
}

void
pw_abort ()
{
    do_error (my_abort);
}

void
pw_error ()
{
    do_error (my_error);
}

void
pw_warning ()
{
    do_error (my_warning);
}
