#include <stdio.h>
#include <unistd.h>
#include <sys/param.h>
#include <z/bool.h>
#include <z/error.h>
#include <pw.h>
#include <readline/readline.h>
#include "user.h"

extern char *strdup ();
extern char *strip ();


void
auto_special (argc, argv, argi, d, u)
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    /* No auto procedures */
}

void
auto_generic (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->organization = catname;
    u->category = strdup (catname);
    lowcase (u->category);
}

void
auto_teach (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->organization = readline("Organisation: ");
    u->category = strdup (catname);
    lowcase (u->category);
}

void
auto_guest (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "guests";
}

void
auto_enstaka (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "kurs";
    u->organization = "Enstaka kurs";
    u->fullname = readline ("Full name: ");
    u->fullname = strip (u->fullname);
    if (strlen (u->fullname) == 0)
	exit (1);
    u->fullname = strdup (u->fullname);
    u->logname = pw_full2log (d, u->fullname, "x95");
    if (u->logname == NULL)
	pw_abort ();
}

void
auto_esekt (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "esekt";
    u->organization = "Esekt";
}

void
auto_asse (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "asse";
}

void
auto_signal (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "signal";
    u->organization = "Signalbehandling";
}

void
auto_ttt (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "ttt";
    u->organization = "Teletransmissionsteori";
}

void
auto_radio (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "radio";
    u->organization = "Radiosystemteknik";
}

void
auto_instrlab (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "instrlab";
    u->organization = "Elektrisk Mtteknik";
}

void
auto_control (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->category = "control";
    u->organization = "Reglerteknik";
}


void
auto_stud (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    int res;
    int i;
    static char dir[MAXPATHLEN];


    u->category = readline ("Student category (eg e93): ");
    u->category = strip (u->category);
    if (strlen (u->category) == 0)
	exit (1);
    u->category = strdup (u->category);
    lowcase (u->category);

    sprintf (dir, "/home/%s", u->category);
    res = access (dir, F_OK);
    if (res == -1)
	my_abort ("There is no such student category");

    u->organization = strdup (u->category);
    upcase (u->organization);

    u->fullname = readline ("Full name: ");
    u->fullname = strip (u->fullname);
    if (strlen (u->fullname) == 0)
	exit (1);
    u->fullname = strdup (u->fullname);

    u->logname = pw_full2log (d, u->fullname, u->category);
    if (u->logname == NULL)
	pw_abort ();
}

void
auto_staff (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    u->uid_min = 900;
    u->uid_max = 999;
    u->gid = 10;
    u->organization = "STAFF";
    u->category = "staff";
}


void
auto_utbytes (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
  u->organization = "UTBYTES";
  u->category = "utbytes";
  u->fullname = readline ("Full name: ");
  u->fullname = strip (u->fullname);
  if (strlen (u->fullname) == 0)
	exit (1);
  u->fullname = strdup (u->fullname);
    u->logname = pw_full2log (d, u->fullname, "x95");
  if (u->logname == NULL)
	pw_abort ();
}


void
auto_pdc (catname, argc, argv, argi, d, u)
    char *catname;
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    int res;
    static char dir[MAXPATHLEN];
    static char cat[256];

    u->uid_min = 17000;
    u->uid_max = 17499;
    u->gid = 30;

    u->category = readline ("PDC subcategory: ");
    u->category = strip (u->category);
    if (strlen (u->category) == 0)
	exit (1);

    u->organization = strdup (u->category);
    upcase (u->organization);

    sprintf (cat, "pdc/%s", u->category);
    u->category = strdup (cat);
    lowcase (u->category);

    sprintf (dir, "/home/%s", u->category);
    res = access (dir, F_OK);
    if (res == -1)
	my_abort ("There is no such PDC subcategory");
}
