#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <z/bool.h>
#include <z/error.h>
#include <sys/time.h>

#include "pw.h"


int
pw_checkpasswd (pword, name)
    char *pword;
    char *name;
{
    int transitions;
    int nonprint;
    int nonalpha;
    int alpha;
    int wasalpha;
    int l;
    int i;
    char rword[1024];
    
    transitions = 0;
    nonprint = 0;
    alpha = 0;
    nonalpha = 0;
    wasalpha = isalpha (pword[0]);
    l = strlen (pword);
    if (l == 0)
	return PW_CHECK_EMPTY;
    for (i = 0; i < l; i++)
    {
	rword[l - 1 - i] = pword[i];
	if (!isprint(pword[i]))
	    nonprint++;
	if (wasalpha ^ isalpha(pword[i]))
	    transitions++;
	wasalpha = isalpha(pword[i]);
	if (wasalpha)
	    alpha++;
	else
	    nonalpha++;
    }
    rword[l] = '\0';
    if (nonprint > 0)
	return PW_CHECK_NONPRINT;
    else if (l < 6)
	return PW_CHECK_SHORT;
/*
    else if (alpha == 0)
	return PW_CHECK_NOALPHA;
    else if (nonalpha == 0)
	return PW_CHECK_JUSTALPHA;
    else if (transitions < 2)
	return PW_CHECK_GROUPING;
    else if (strcmp(pword, name) == 0)
	return PW_CHECK_LOGNAME;
    else if (strcmp(rword, name) == 0)
	return PW_CHECK_REVERSEDLOGNAME;
*/
    else
	return PW_CHECK_OK;
}

char *
pw_checkpasswd_message (code)
    int code;
{
    switch (code)
    {
    case PW_CHECK_OK:
	return "Password is OK!\n";
	
    case PW_CHECK_EMPTY:
        return "Empty password.\n";

    case PW_CHECK_REVERSEDLOGNAME:
	return "Password reverse of login name.\n";

    case PW_CHECK_LOGNAME:
	return "Password same as login name.\n";

    case PW_CHECK_NONPRINT:
	return "Password contains non-printing (control) characters.\n";

    case PW_CHECK_SHORT:
	return "Password is too short (minimum 6 characters).\n";

    case PW_CHECK_NOALPHA:
	return "Password contains no alphabetic character.\n";

    case PW_CHECK_JUSTALPHA:
	return "Password contains no non-alphabetic character.\n";

    case PW_CHECK_GROUPING:
	return "\
Alpabetic and non-alphabetic must be mixed.\n\
It is not allowed to have all the alphabetic characters\n\
at the beginning and all the non-alphabetic characters at\n\
the end, nor vice versa.\n";

    default:
	ASSERT(FALSE);
	return NULL;
    }
}

/* returns an 8 character password */

static char * characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!?%/=+$;";

struct spell {
    char shortname;
    char * longname;
};


struct spell spelllist[] = {
    {'a',	"adam"},
    {'b',	"bertil"},
    {'c',	"caesar"},
    {'d',	"david"},
    {'e',	"erik"},
    {'f',	"filip"},
    {'g',	"gustav"},
    {'h',	"helge"},
    {'i',	"ivar"},
    {'j',	"johan"},
    {'k',	"kalle"},
    {'l',	"ludvig"},
    {'m',	"martin"},
    {'n',	"niklas"},
    {'o',	"olof"},
    {'p',	"petter"},
    {'q',	"quintus"},
    {'r',	"rudolf"},
    {'s',	"sigurd"},
    {'t',	"tore"},
    {'u',	"urban"},
    {'v',	"viktor"},
    {'w',	"willhelm"},
    {'x',	"xerxes"},
    {'y',	"yngve"},
    {'z',	"zta"},
    {'A',	"ADAM"},
    {'B',	"BERTIL"},
    {'C',	"CAESAR"},
    {'D',	"DAVID"},
    {'E',	"ERIK"},
    {'F',	"FILIP"},
    {'G',	"GUSTAV"},
    {'H',	"HELGE"},
    {'I',	"IVAR"},
    {'J',	"JOHAN"},
    {'K',	"KALLE"},
    {'L',	"LUDVIG"},
    {'M',	"MARTIN"},
    {'N',	"NIKLAS"},
    {'O',	"OLOF"},
    {'P',	"PETTER"},
    {'Q',	"QUINTUS"},
    {'R',	"RUDOLF"},
    {'S',	"SIGURD"},
    {'T',	"TORE"},
    {'U',	"URBAN"},
    {'V',	"VIKTOR"},
    {'W',	"WILLHELM"},
    {'X',	"XERXES"},
    {'Y',	"YNGVE"},
    {'Z',	"ZTA"},
    {'!',	"utropstecken"},
    {'#',	"brdgrd"},
    {'?',	"frgetecken"},
    {'%',	"procenttecken"},
    {'&',	"ampersand"},
    {'/',	"snedstreck"},
    {'(',	"vnsterparentes"},
    {')',	"hgerparentes"},
    {'=',	"likamed"},
    {'+',	"plus"},
    {'$',	"dollar"},
    {'^',	"circumflex"},
    {';',	"semikolon"},
    {'0',	"nolla"},
    {'1',	"etta"},
    {'2',	"tva"},
    {'3',	"trea"},
    {'4',	"fyra"},
    {'5',	"femma"},
    {'6',	"sexa"},
    {'7',	"sjua"},
    {'8',	"tta"},
    {'9',	"nia"}
};

char *
pw_convchartoword(char character) {
    int i;
    for(i =0 ; i < sizeof (spelllist); i++) {
	if(spelllist[i].shortname == character)
	    return strdup(spelllist[i].longname);
    } 
    return NULL;
}

char *
pw_mkpasswd(char *logname)
{
    char passwd[9];
    struct timeval tv;
    int pid = getpid();
    int len = strlen(characters);
    int i;


    gettimeofday(&tv, (struct timezone *) NULL);
    srandom(tv.tv_sec ^ tv.tv_usec ^ pid);
    
    for(i=0; i < 17; i++) random();

    for(i=0; i < 8 ; i++) {
	passwd[i] = characters[random()%len];
    }

    passwd[8] = '\0';

    return strdup(passwd);
}

