#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include <pw.h>
#include "../../readline/readline.h"
#include <sys/types.h>
#include <netinet/in.h>
#include <krb.h>
#include <krb_db.h>
#include <kadm.h>
#include "user.h"

char *progname = "pwcreate";

extern char *strip ();

extern void auto_special ();
extern void auto_wheel ();
extern void auto_staff ();
extern void auto_elhand ();
extern void auto_stud ();
extern void auto_generic ();
extern void auto_pdc ();
extern void auto_signal ();
extern void auto_control ();
extern void auto_guest ();
extern void auto_esekt ();
extern void auto_asse ();
extern void auto_ttt ();
extern void auto_radio ();
extern void auto_enstaka ();
extern void auto_utbytes ();
extern void auto_instrlab ();
extern void auto_teach ();
static char *category_completer ();
static char *null_completer ();

static struct categorydata
{
    char *name;
    char *text;
    void (*auto_func) ();
}
category[] =
{
    { "ASSE",	"vningsassistent",			auto_asse },
    { "CONTROL","Inst. fr Reglerteknik", 	        auto_control },
    { "ENSTAKA","Enstaka kurs",				auto_enstaka },
    { "ESEKT",	"E-sektionen", 				auto_esekt },
    { "GUEST",	"Gster", 				auto_guest },
    { "SIGNAL",	"Inst. fr Signalbehandling", 	        auto_signal },
    { "SPECIAL","Specialare" , 				auto_special },
    { "STAFF",	"Systemgruppen" , 			auto_staff },
    { "ELHAND", "Elhand",				auto_elhand },
    { "STUD",	"Student med personligt anvndarnamn", 	auto_stud },
    { "UTBYTES","Utbytesstudenter och utlnska studenter", auto_utbytes },
    { "TTT", "Inst. fr TTT", auto_ttt },
    { "RADIO", "Inst. fr Radiosystemteknik", auto_radio },
    { "INSTRLAB", "Inst. fr Elektrisk mtteknik", auto_instrlab },
    { "TEACH", "Lrare", auto_teach },
    { NULL,	NULL,					NULL }
/* NADA:
    { "SPECIAL","Specialare" , 				auto_special },
    { "WHEEL",	"Systemgruppen" , 			auto_wheel },
    { "STUD",	"Student med personligt anvndarnamn", 	auto_stud },
    { "IPLAB",	"Forskare/lrare IPLAB", 		auto_generic },
    { "C2M2",	"Forskare/lrare C2M2",			auto_generic },
    { "CVAP",	"Forskare/lrare CVAP",			auto_generic },
    { "SANS",	"Forskare/lrare SANS",			auto_generic },
    { "THEORY",	"Forskare/lrare THEORY",		auto_generic },
    { "NUM",	"Forskare/lrare NUM", 			auto_generic },
    { "PDC",	"Parallelldatorcentrum PDC",		auto_pdc },
    { "TEACH",	"vriga lrare (NADA)", 		auto_generic },
    { "ASS",	"Assistent (NADA)",  			auto_generic },
    { "NADA",	"vriga NADA-anstllda", 		auto_generic },
    { "MATH",	"Matematik KTH (somliga/spirit)",	auto_generic },
    { "KTHMATTE","Matematik KTH (andra/cyklop)",	auto_generic },
    { "SUMATTE","Matematik SU",				auto_generic },
    { "FYSIK4",	"Fysik IV",	  			auto_generic },
    { "MECH",	"Mekanik", 				auto_generic },
    { "TDS",	"Telekommunikation och datorsystem", 	auto_generic },
    { "SICS",	"Swedish Institute of Computer Science",auto_generic },
    { "REST",	"Andra instutioner p KTH/SU", 		auto_rest },
    { "GUEST",	"Gster", 				auto_guest },
    { NULL,	NULL,					NULL }
*/
};


bool nokrb = FALSE;
bool nodir = FALSE;

int
main (argc, argv)
    int argc;
    char *argv[];
{
    int argi;
    int cat;
    int d;
    user u;

    d = pw_args (&argc, &argv);

    set_defaults (&u);

    argi = 1;
    while (argc > argi)
    {
	if (strcmp (argv[argi], "-nokrb") == 0)
	    nokrb = TRUE;
	else if (strcmp (argv[argi], "-nodir") == 0)
	    nodir = TRUE;
	else
	{
	    fprintf (stderr, "usage: %s [-nokrb] [-nodir]\n", progname);
	    exit (1);
	}
	argi++;
    }

    cat = select_category (argc, argv, 1, d, &u);
    (category[cat].auto_func) (category[cat].name, argc, argv, argi, d, &u);
    manual (d, &u);
    doit (d, &u);

    exit (0);
}

void
show_categories ()
{
    int i;

    printf ("\nAvailable categories:\n\n");
    for (i = 0; category[i].name != NULL; i++)
	printf ("  %-10s %s\n", category[i].name, category[i].text);
    printf ("\n");
}

int
select_category (argc, argv, argi, d, u)
    int argc;
    char *argv[];
    int argi;
    int d;
    user *u;
{
    int  i;
    char *cp;
    char *line;
    char *catname;
    
get_category:
    rl_completion_entry_function = (Function *) category_completer ;
    catname = readline ("User category [STUD]: ");
    rl_completion_entry_function = (Function *) null_completer ;
    catname = strip (catname);
    if (strlen (catname) == 0)
	catname = "STUD";
    else
	catname = strdup (catname);

    i = 0;
    while (category[i].name && strcasecmp (category[i].name, catname) != NULL)
      i++;
    if (category[i].name == NULL)
    {
	show_categories ();
	goto get_category;
    }

    return i;
}

static char *
category_completer (text, state)
    char *text;
    int state;
{
    static int i;

    if (!state)
	i = 0;

    while (category[i].name != NULL)
    {
	if (strncasecmp (category[i].name, text, strlen (text)) == 0)
	    return strdup (category[i++].name);
	else
	    i++;
    }

    return NULL;
}

static char *
null_completer (text, state)
    char *text;
    int state;
{
    return NULL;
}

/* These are for the readline-library */

char *
xmalloc (size)
     int size;
{
  char * new;

  new = malloc (size);

  if (new == NULL)
  {
      fprintf (stderr, "Out of memory\n");
      exit (1);
  }

  return new;
}

char *
xrealloc (cp, size)
    char *	cp;
    int 	size;
{
  char * 	new;

  if (cp == NULL)
      new = xmalloc (size);
  else
      new = realloc (cp, size);

  if (new == NULL)
  {
      fprintf (stderr, "Out of memory\n");
      exit (1);
  }

  return new;
}

