#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include <z/date.h>
#include <pw.h>
#include <readline/readline.h>
#include "user.h"

extern bool nopw;
extern bool nokrb;
extern bool nodir;

static char *xold;

void insert_old ()
{
    strcpy (rl_line_buffer, xold);
    rl_point = 0;
    rl_end = strlen (xold);
}

void manual (d, u)
    int d;
    user *u;
{
    int res;
    char *answer;
    bool ok;
    char idstr[12];
    char homedir[MAXPATHLEN];
    char command[100];
    rl_startup_hook = insert_old;


    /*
     * Login name
     */

    xold = u->logname;
    if (xold == NULL)
	xold = "";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Login name: ");
	if (answer == NULL)
	    exit (1);
	res = pw_syntax_field (answer, PW_SYNTAX_NORMAL, PW_NAME);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else if (pw_getpwnam (d, answer) != NULL)
	    printf ("That name is already in use\n");
	else
	    ok = TRUE;
    }
    u->logname = strdup (answer);
    
    /*
     * Personnr, (own elektro specifik, mikan/961203)
     */
    xold = "";
    ok = FALSE;
    while (!ok)
      {
	answer = readline ("Personnr: (press C-D for unknown) ");
	if (answer == NULL)
	  ok = TRUE;
	else {
	  if (pnr_checkpnr (answer))
	    ok = TRUE;
	  else
	    printf ("Incorrect pnr\n");
	}
      }
    if (answer == NULL)
      u->pnr = NULL;
    else
      u->pnr = strdup(answer);
    


    /*
     * Password
     */

    if (!nokrb)
    {
	xold = pw_mkpasswd (u->logname);
	ok = FALSE;
	while (!ok)
	{
	    answer = readline ("Password: ");
	    if (answer == NULL)
		exit (1);
	    res = pw_checkpasswd (answer, u->logname);
	    if (res != PW_CHECK_OK)
		printf ("%s\n", pw_checkpasswd_message (res));
	    else
		ok = TRUE;
	}
	u->passwd = strdup (answer);
    }


    /*
     * UID
     */


    if (u->uid == -1)
    {
	u->uid = pw_firstuid (d, u->uid_min);
	if (u->uid == -1)
	    pw_abort ();
	if (u->uid > u->uid_max)
	    my_error ("No UIDs left in [%d, %d]", u->uid_min, u->uid_max);
    }

    if (u->uid == -1)
	xold = "";
    else
    {
	sprintf (idstr, "%d", u->uid);
	xold = idstr;
    }
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("UID: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, PW_UID);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else if (pw_getpwuid (d, atoi (answer)) != NULL)
	    printf ("That UID is already in use\n");
	else
	    ok = TRUE;
    }
    u->uid = atoi (answer);


    /*
     * GID
     */

    if (u->gid == -1)
	xold = "";
    else
    {
	sprintf (idstr, "%d", u->gid);
	xold = idstr;
    }
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("GID: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, PW_GID);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->gid = atoi (answer);

    /*
     * Fullname
     */

    if (u->fullname == NULL)
    {
	xold = "";
	ok = FALSE;
	while (!ok)
	{
	    answer = readline ("Full name: ");
	    if (answer == NULL)
		exit (1);
	    res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_FULLNAME);
	    if (res != PW_SYNTAX_EOK)
		printf ("%s\n", pw_syntax_message (res));
	    else
		ok = TRUE;
	}
	u->fullname = strdup (answer);
    }


    /*
     * Organization
     */

    xold = u->organization;
    if (xold == NULL)
	xold = "";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Organization: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_ORGANIZATION);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->organization = strdup (answer);


    /*
     * Office phone
     */

    xold = u->officephone;
    if (xold == NULL)
	xold = "";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Office phone: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_OFFICEPHONE);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->officephone = strdup (answer);


    /*
     * Home phone
     */

    xold = u->homephone;
    if (xold == NULL)
	xold = "";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Home phone: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_HOMEPHONE);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->homephone = strdup (answer);


    /*
     * Comment
     */

    xold = u->comment;
    if (xold == NULL)
	xold = "";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Comment: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_COMMENT);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->comment = strdup (answer);


    /*
     * Creation date
     */

    xold = date2str (u->creationdate);
    if (xold == NULL)
	xold = datetoday ();
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Creation date: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_CREATIONDATE);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->creationdate = date2int (answer);


    /*
     * Creator
     */

    xold = u->creator;
    if (xold == NULL)
	xold = "";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Creator: ");
	if (answer == NULL)
	    exit (1);
	res = pw_syntax_field (answer, PW_SYNTAX_NORMAL, GC_CREATOR);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->creator = strdup (answer);


    /*
     * Expiration date
     */

    xold = date2str (u->expirationdate);
    if (xold == NULL)
	xold = datetoday ();
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Expiration date: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_EXPIRATIONDATE);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->expirationdate = date2int (answer);


    /*
     * Mail forward address
     */

    xold = u->mailforward;
    if (xold == NULL)
	xold = "";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Mail forward address: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_MAILFORWARD);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->mailforward = strdup (answer);


    /*
     * Administrative information
     */

    xold = u->adminfo;
    if (xold == NULL)
	xold = "";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Administrative code: ");
	if (answer == NULL)
	    exit (1);
	res = gc_syntax_field (answer, PW_SYNTAX_NORMAL, GC_ADMINFO);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->adminfo = strdup (answer);


    /*
     * Home directory
     */

    xold = u->home;
    if (xold == NULL)
	if (u->category == NULL)
	    xold = "/";
	else
	{
	    sprintf (homedir, "/home/%s/%s", u->category, u->logname);
	    xold = homedir;
	}
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Home directory: ");
	if (answer == NULL)
	    exit (1);
	res = pw_syntax_field (answer, PW_SYNTAX_NORMAL, PW_DIR);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->home = strdup (answer);


    /*
     * Login shell
     */

    xold = u->shell;
    if (xold == NULL)
	xold = "/bin/sh";
    ok = FALSE;
    while (!ok)
    {
	answer = readline ("Login shell: ");
	if (answer == NULL)
	    exit (1);
	res = pw_syntax_field (answer, PW_SYNTAX_NORMAL, PW_SHELL);
	if (res != PW_SYNTAX_EOK)
	    printf ("%s\n", pw_syntax_message (res));
	else
	    ok = TRUE;
    }
    u->shell = strdup (answer);


}

