
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include <z/itemize.h>
#include <pw.h>

#include "params.h"
#include "user.h"

extern char *full2log ();
extern int errno;

char *progname = "pwstudents";
bool nohyphen = FALSE;

int
main (argc, argv)
    int argc;
    char *argv[];
{
  int res;
  int i;
  int d;
  user template;
  user u;
  char *prefix;
  char *infile;
  char *outfile;
  FILE *ifp;
  FILE *ofp;
  char buf[1024];
  char *fullname;
  char *pnr;
  char *logname;
  int uid;
  char dir[1024];
  char *line;
  int xerrno;
  char **item;
	    
  if (argc == 5 && strcmp (argv[1], "-nohyphen") == 0)
    {
      nohyphen = TRUE;
      argv++;
      argc--;
    }
	
  d = pw_open (NULL, PW_REMOTE, 0);
  if (d == -1)
    pw_abort ();

  if (argc != 4)
    {
      fprintf (stderr, "usage: %s org infile outfile\n", progname);
      exit (1);
    }

  set_defaults (&template);
  prefix = strdup (argv[1]);
  lowcase (prefix);
  
  if (strlen (prefix) > (nohyphen ? 5 : 4))
    my_abort ("Too long prefix (max %d chars)", (nohyphen ? 5 : 4));
  
  for (i = 0; i < strlen (prefix); i++)
    if (!isalnum (prefix[i]))
      my_abort ("Illegal character \'%c\' (code %d) in prefix",
		isprint (prefix[i]) ? prefix[i] : '?', (unsigned char) prefix[i]);

  template.organization = strdup (prefix);
  upcase (template.organization);

  infile = strdup (argv[2]);
  ifp = fopen (infile, "r");
  if (ifp == NULL)
    my_sysabort ("Can't open infile: %s", infile);

  outfile = strdup (argv[3]);
  umask (077);
  ofp = fopen (outfile, "w");
  if (ofp == NULL)
    my_sysabort ("Can't open outfile: %s", outfile);

  while (fgets (buf, 1024, ifp) != NULL)
    {
      stripline (buf);
      if (commentline (buf))
	continue;
	
      item = itemize(buf,"\t");
      if (item == NULL )
	continue;
	
      if (item[0] == NULL)
	continue;
      fullname = strdup(item[0]);
      /* strdup (buf); */
      pnr = NULL;
      if (item[1] != NULL) {
	pnr = strdup (item[1]);
	if (!pnr_checkpnr(pnr)) {
	  printf ("Bad pnr(%s) for %s\n, skipping!\n", pnr,fullname);
	  continue;
	  
	}
      }

      if(item[2] != NULL) {
	logname = strdup(item[2]);
	printf("logname = %s\n",logname);
	if(pw_getpwnam(logname) != NULL) {
	  fprintf(stderr, "Username %s already exists, skipping\n", logname);
	  continue;
	}
      } else {
	logname = full2log (fullname, prefix, d);
      }

      if (logname == NULL)
	{
	  my_error ("Can't assign login name to the new user");
	  pw_abort ();
	}
	
      uid = pw_firstuid (d, template.uid_min);
      if (uid == -1)
	{
	  my_error ("Can't find an uid for the new user");
	  pw_abort ();
	}

      if (uid > template.uid_max)
	{
	  my_abort ("No more uids in interval [%d, %d]",
		    template.uid_min, template.uid_max);
	}

      sprintf (dir, "/home/%s/%s", prefix, logname);

      u = template;
      u.logname = logname;
      u.fullname = fullname;
      u.uid = uid;
      u.home = dir;

      line = build_pwline (&u);
      pw_create (d, line);

      if (pw_errno != PW_EOK)
	{
	  my_error ("Can't insert new user into password database");
	  pw_abort ();
	}

      if (pnr != NULL) {
	pnr_create(d, pnr,logname);
	if (pw_errno != PW_EOK) {
	  xerrno = errno;
	  pw_delete (d, line);
	  errno = xerrno;
	  my_error ("Can't insert new user into pnr database");
	  pw_abort ();
	}
	  
      }
	
      res = fprintf (ofp, "%s:%d:%s\n", logname, uid, fullname);
      if (res != EOF)
	fflush (ofp);
      if (res == EOF)
	{
	  xerrno = errno;
	  pw_delete (d, line);
	  pnr_delete (d, logname);
	  errno = xerrno;
	  my_sysabort ("Error writing outfile: %s", argv[2]);
	}
	
      fflush (stdout);
	
	
      
      free (line);
      free (logname);
      free (fullname);
      free (pnr);
    }
  
  if (ferror (ifp))
    my_sysabort ("Error while reading infile: %s", infile);
  fclose (ifp);
  
  res = fclose (ofp);
  if (res == EOF)
    {
      xerrno = errno;
      pw_delete (d, line);
      errno = xerrno;
      my_sysabort ("Error writing outfile: %s", argv[2]);
    }
  
  exit (0);
}
