
/* alloc
 *
 */

#include "bool.h"
#include "error.h"

#define NULL 0
extern char *malloc ();

static void (*errhandler) () = NULL;



char *
alloc (amount)
    int amount;
{
    char *new;

    new = malloc (amount);

    if (new != NULL)
	return new;

    if (errhandler != NULL)
	(*errhandler) ();

    abort ("Memory allocation fails");
}

void
alloc_set_errhandler (func)
    void (*func) ();
{
    errhandler = func;
}
