
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include <z/itemize.h>
#include <pw.h>
#include <time.h>

#include "params.h"
#include "user.h"

extern char *full2log ();
extern int errno;

char *progname = "pwkthid";
bool nohyphen = FALSE;

int
main (argc, argv)
    int argc;
    char *argv[];
{
    int res;
    int i;
    int d;
    user template;
    user u;
    char *prefix;
    char *infile;
    char *outfile;
    FILE *ifp;
    FILE *ofp;
    char buf[1024];
    char *fullname;
    char *pnr;
    char *logname;
    char *kthid;
    int uid;
    char dir[1024];
    char *line;
    int xerrno;
    char **item;
    time_t t;
    char *year;
	    
    d = pw_open (NULL, PW_REMOTE, 0);
    if (d == -1)
	pw_abort ();

    if (argc != 3)
    {
	fprintf (stderr, "usage: %s infile outfile\n", progname);
	exit (1);
    }

    set_defaults (&template);

    t = time(NULL);

    strftime(buf, sizeof(buf), "%Y", localtime(&t));

    year = strdup(buf);
    template.organization = strdup (buf);

    infile = strdup (argv[1]);
    ifp = fopen (infile, "r");
    if (ifp == NULL)
	my_sysabort ("Can't open infile: %s", infile);

    outfile = strdup (argv[2]);
    umask (077);
    ofp = fopen (outfile, "w");
    if (ofp == NULL)
	my_sysabort ("Can't open outfile: %s", outfile);

    while (fgets (buf, 1024, ifp) != NULL)
    {
	stripline (buf);
	if (commentline (buf))
	    continue;
	
	item = itemize(buf,"\t");
	if (item == NULL )
	    continue;
	
	if (item[ITEM_FULLNAME] == NULL)
	    continue;
	fullname = strdup(item[ITEM_FULLNAME]);
	if(!fullname)
	    my_sysabort("Out of memory");

	if (item[ITEM_PNR] == NULL) {
	    my_sysabort("Pnr not given for line: \n%s\n", buf);
	}
	pnr = strdup (item[ITEM_PNR]);
	if (!pnr)
	    my_sysabort("Out of memory");
	if (!pnr_checkpnr(pnr)) {
	    printf ("Bad pnr(%s) for %s\n", pnr,fullname);
	}

	if (item[ITEM_KTHID] == NULL) {
	    my_sysabort("KTH-ID not given for line: \n%s\n", buf);
	}
	kthid = strdup (item[ITEM_KTHID]);
	if (!kthid)
	    my_sysabort("Out of memory");

	if(item[ITEM_LOGNAME] == NULL) {
	    my_sysabort("Logname not given for line: \n%s\n", buf);
	}
	logname = strdup(item[ITEM_LOGNAME]);
	if (!logname)
	    my_sysabort("Out of memory");
	
	if(pw_getpwnam(logname) != NULL) {
	    fprintf(stderr, "Username %s already exists, skipping\n", logname);
	    free(fullname);
	    free(logname);
	    free(pnr);
	    free(kthid);
	    continue;
	}
	
	if(item[ITEM_UID] != NULL) {
	    uid = atoi(item[ITEM_UID]);
	    if (!logname)
		my_sysabort("Out of memory");
	    
	    if(pw_getpwuid(uid) != NULL) {
		fprintf(stderr, "Uid %d already exists, skipping\n", uid);
		free(fullname);
		free(logname);
		free(pnr);
		free(kthid);
		continue;
	    } 
	} else {

	    uid = pw_firstuid (d, template.uid_min);
	    if (uid == -1)
	    {
		my_error ("Can't find an uid for the new user");
		pw_abort ();
	    }
	    if (uid > template.uid_max)
	    {
		fprintf (stderr, "No more uids in interval [%d, %d], skipping\n",
			  template.uid_min, template.uid_max);
		free(fullname);
                free(logname);
                free(pnr);
		continue;
	    }
	}

	sprintf (dir, "/home/%s/%s", year, logname);

	u = template;
	u.logname = logname;
	u.fullname = fullname;
	u.uid = uid;
	u.home = dir;
	u.adminfo = kthid;

	line = build_pwline (&u);

	printf("%s\n", line);
	pw_create (d, line);

	if (pw_errno != PW_EOK)
	{
	    my_error ("Can't insert new user into password database");
	    pw_abort ();
	}

	if (pnr != NULL) {
	    pnr_create(d, pnr,logname);
	    if (pw_errno != PW_EOK) {
		xerrno = errno;
		pw_delete (d, line);
		errno = xerrno;
		my_error ("Can't insert new user into pnr database");
		pw_abort ();
	    }
	}
	
	res = fprintf (ofp, "%s:%d:%s\n", logname, uid, fullname);
	if (res != EOF)
	    fflush (ofp);
	if (res == EOF)
	{
	    xerrno = errno;
	    pw_delete (d, line);
	    pnr_delete (d, logname);
	    errno = xerrno;
	    my_sysabort ("Error writing outfile: %s", argv[2]);
	}
	
	fflush (stdout);
      
	free (logname);
	free (fullname);
	free (pnr);
    }
  
    if (ferror (ifp))
	my_sysabort ("Error while reading infile: %s", infile);
    fclose (ifp);
  
    res = fclose (ofp);
    if (res == EOF)
    {
	xerrno = errno;
	pw_delete (d, line);
	errno = xerrno;
	my_sysabort ("Error writing outfile: %s", argv[2]);
    }
  
    exit (0);
}
