#include <stdio.h>
#include <ctype.h>

#include <z/bool.h>
#include <z/error.h>
#include <pw.h>

char *progname = "pwmkhesiod";

void
print_passwddb_entry(line)
    char *line;
{
  static int number = 0;
  pw_data *pwd;
  char *login;
  int uid;

  pwd = pw_string_to_data(line);
  login = pwd->pwv[PW_NAME];
  uid = atoi(pwd->pwv[PW_UID]);
  printf("%s.passwd\tIN\tTXT\t\"%s\"\n", login, line);
  printf("%d.passwd\tIN\tCNAME\t%s.passwd\n", uid, login);
  printf("passwd-%d.passwd\tIN\tCNAME\t%s.passwd\n", number, login);
  number += 1;
}

int print_passwddb(d)
  int d;
{
  pw_foreach (d, print_passwddb_entry);

  if (pw_errno != PW_EOK)
    pw_abort ();
}
    
void
print_aliasesdb_entry(line)
    char *line;
{
  pw_data *pwd;
  char *login, *alias;

  pwd = pw_string_to_data(line);
  login = pwd->pwv[PW_NAME];
  alias = pwd->gcv[GC_MAILFORWARD];
  if (alias[0] == '\0')
    printf("%s.aliases\t%sIN\tTXT\t\"%s@pop\"\n", login,
	   strlen(login) < 8 ? "\t" : "", login);
  else
    printf("%s.aliases\t%sIN\tTXT\t\"%s\"\n", login,
	   strlen(login) < 8 ? "\t" : "", alias);
}

int print_aliasesdb(d)
  int d;
{
  pw_foreach (d, print_aliasesdb_entry);

  if (pw_errno != PW_EOK)
    pw_abort ();
}
    
void
print_aliases_entry(line)
    char *line;
{
  pw_data *pwd;
  char *login, *alias;

  pwd = pw_string_to_data(line);
  login = pwd->pwv[PW_NAME];
  alias = pwd->gcv[GC_MAILFORWARD];
  if (alias[0] == '\0')
    printf("%s:\t%s%s@pop\n", login,
	   strlen(login) < 7 ? "\t" : "", login);
  else
    printf("%s:\t%s%s\n", login,
	   strlen(login) < 7 ? "\t" : "", alias);
}

int print_aliases(d)
  int d;
{
  pw_foreach (d, print_aliases_entry);

  if (pw_errno != PW_EOK)
    pw_abort ();
}
    
void
print_poboxdb_entry(line)
    char *line;
{
  pw_data *pwd;
  char *login, *alias;

  pwd = pw_string_to_data(line);
  login = pwd->pwv[PW_NAME];
  alias = pwd->gcv[GC_MAILFORWARD];
  if (alias[0] == '\0')
    printf("%s.pobox\tIN\tTXT\t\"POP MAIL.E.KTH.SE %s\"\n", login, login);
}

int print_poboxdb(d)
  int d;
{
  pw_foreach (d, print_poboxdb_entry);

  if (pw_errno != PW_EOK)
    pw_abort ();
}
    
main (argc, argv)
    int argc;
    char *argv[];
{
    int d;

    d = pw_args (&argc, &argv);

    if (argc != 2)
    {
	fprintf (stderr,
		 "usage: pwmkhesiod passwd.db|aliases.db|pobox.db|aliases\n");
	exit (1);
    }

    if (strcmp(argv[1], "passwd.db") == 0) print_passwddb(d);
    else if (strcmp(argv[1], "aliases.db") == 0) print_aliasesdb(d);
    else if (strcmp(argv[1], "aliases") == 0) print_aliases(d);
    else if (strcmp(argv[1], "pobox.db") == 0) print_poboxdb(d);
    else {
      fprintf(stderr,
	     "%s unknown. Must be one of: passwd, aliases.\n", argv[1]);
      exit(1);
    }

    exit (0);
}
