#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <string.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include <pw.h>
#include "../../readline/readline.h"
#include <sys/types.h>
#include <netinet/in.h>
#include <krb.h>
#include <krb_db.h>
#include <kadm.h>

extern char *full2log ();

char *progname = "pwuniq";

extern char *strip ();
int
main (argc, argv)
    int argc;
    char *argv[];
{
  
  int res;
  int i;
  int d;
  char *prefix;
  char *infile;
  char *outfile;
  FILE *ifp;
  FILE *ofp;
  char buf[1024];
  char *fullname;
  char *logname;
  int uid;
  char dir[1024];
  char *line;
  int xerrno;
  
  d = pw_open (NULL, PW_REMOTE, 0);
  if (d == -1)
	pw_abort ();

  if (argc != 4)
    {
	  fprintf (stderr, "usage: %s org infile outfile\n", progname);
	  exit (1);
    }
  
  prefix = strdup (argv[1]);
  lowcase (prefix);
  
  infile = strdup (argv[2]);
  ifp = fopen (infile, "r");
  if (ifp == NULL)
	my_sysabort ("Can't open infile: %s", infile);
  
  outfile = strdup (argv[3]);
  umask (077);
  ofp = fopen (outfile, "w");
  if (ofp == NULL)
	my_sysabort ("Can't open outfile: %s", outfile);

  while (fgets (buf, 1024, ifp) != NULL)
    {
	  stripline (buf);
	  if (commentline (buf))
	    continue;
	  
	  fullname = strdup (buf);
	  
	  logname = pw_full2log (d,fullname, prefix); 
/*	  logname = full2log (fullname, prefix, d); */
	  if (logname == NULL)
		{
		  my_error ("Can't assign login name to the new user");
		  pw_abort ();
		}
	  
	  res = fprintf (ofp, "%s %s\n", logname,  fullname);
	  if (res != EOF)
		fflush (ofp);
	  else {
		printf("Error writing file\n");
	exit(1);
	  }
	}
}
